/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.EquivalentInstances;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.InstanceBasedMatching;
import mockit.internal.expectations.PartiallyMockedInstances;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationArguments;
import mockit.internal.state.TestRun;
import mockit.internal.util.GeneratedClasses;

final class PhasedExecutionState {
    @Nonnull
    final List<Expectation> expectations = new ArrayList<Expectation>();
    @Nonnull
    final List<VerifiedExpectation> verifiedExpectations = new ArrayList<VerifiedExpectation>();
    @Nonnull
    final EquivalentInstances equivalentInstances = new EquivalentInstances();
    @Nonnull
    final InstanceBasedMatching instanceBasedMatching = new InstanceBasedMatching();
    @Nullable
    PartiallyMockedInstances partiallyMockedInstances;

    PhasedExecutionState() {
    }

    void addExpectation(@Nonnull Expectation expectation) {
        ExpectedInvocation invocation = expectation.invocation;
        this.forceMatchingOnMockInstanceIfRequired(invocation);
        this.removeMatchingExpectationsCreatedBefore(invocation);
        this.expectations.add(expectation);
    }

    private void forceMatchingOnMockInstanceIfRequired(@Nonnull ExpectedInvocation invocation) {
        if (!invocation.matchInstance && this.isToBeMatchedOnInstance(invocation.instance, invocation.getMethodNameAndDescription())) {
            invocation.matchInstance = true;
        }
    }

    boolean isToBeMatchedOnInstance(@Nullable Object mock, @Nonnull String mockNameAndDesc) {
        if (mock == null || mockNameAndDesc.charAt(0) == '<') {
            return false;
        }
        if (this.instanceBasedMatching.isToBeMatchedOnInstance(mock) || this.partiallyMockedInstances != null && this.partiallyMockedInstances.isToBeMatchedOnInstance(mock)) {
            return true;
        }
        return TestRun.getExecutingTest().isInjectableMock(mock);
    }

    private void removeMatchingExpectationsCreatedBefore(@Nonnull ExpectedInvocation invocation) {
        Expectation previousExpectation = this.findPreviousExpectation(invocation);
        if (previousExpectation != null) {
            this.expectations.remove(previousExpectation);
            invocation.copyDefaultReturnValue(previousExpectation.invocation);
        }
    }

    @Nullable
    private Expectation findPreviousExpectation(@Nonnull ExpectedInvocation newInvocation) {
        int n = this.expectations.size();
        if (n == 0) {
            return null;
        }
        Object mock = newInvocation.instance;
        Boolean matchInstance = newInvocation.matchInstance;
        String mockClassDesc = newInvocation.getClassDesc();
        String mockNameAndDesc = newInvocation.getMethodNameAndDescription();
        boolean isConstructor = newInvocation.isConstructor();
        for (Expectation previous : this.expectations) {
            if (!this.isMatchingInvocation(mock, matchInstance, mockClassDesc, mockNameAndDesc, isConstructor, previous) || !this.isWithMatchingArguments(newInvocation, previous.invocation)) continue;
            return previous;
        }
        return null;
    }

    private boolean isMatchingInvocation(@Nullable Object mock, @Nullable Boolean matchInstance, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, boolean constructorInvocation, @Nonnull Expectation expectation) {
        ExpectedInvocation invocation = expectation.invocation;
        return invocation.isMatch(mock, mockClassDesc, mockNameAndDesc) && PhasedExecutionState.isSameMockedClass(mock, invocation.instance) && (constructorInvocation || mock == null || this.isMatchingInstance(mock, matchInstance, expectation));
    }

    private static boolean isSameMockedClass(@Nullable Object mock1, @Nullable Object mock2) {
        if (mock1 == mock2) {
            return true;
        }
        if (mock1 != null && mock2 != null) {
            Class<?> mockedClass1 = mock1.getClass();
            Class<?> mockedClass2 = GeneratedClasses.getMockedClass(mock2);
            return mockedClass2.isAssignableFrom(mockedClass1) || TestRun.mockFixture().areCapturedClasses(mockedClass1, mockedClass2);
        }
        return false;
    }

    private boolean isWithMatchingArguments(@Nonnull ExpectedInvocation newInvocation, @Nonnull ExpectedInvocation previousInvocation) {
        InvocationArguments newArguments = newInvocation.arguments;
        InvocationArguments previousArguments = previousInvocation.arguments;
        if (newArguments.getMatchers() == null) {
            return previousArguments.isMatch(newArguments.getValues(), this.equivalentInstances.instanceMap);
        }
        return newArguments.hasEquivalentMatchers(previousArguments);
    }

    @Nullable
    Expectation findExpectation(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nonnull Object[] args) {
        boolean isConstructor = mockNameAndDesc.charAt(0) == '<';
        Expectation replayExpectationFound = null;
        int n = this.expectations.size();
        for (int i = 0; i < n; ++i) {
            Expectation expectation = this.expectations.get(i);
            if (replayExpectationFound != null && expectation.recordPhase == null || !this.isMatchingInvocation(mock, null, mockClassDesc, mockNameAndDesc, isConstructor, expectation) || !expectation.invocation.arguments.isMatch(args, this.equivalentInstances.instanceMap)) continue;
            if (expectation.recordPhase == null) {
                replayExpectationFound = expectation;
                continue;
            }
            if (isConstructor) {
                this.equivalentInstances.registerReplacementInstanceIfApplicable(mock, expectation.invocation);
            }
            return expectation;
        }
        return replayExpectationFound;
    }

    private boolean isMatchingInstance(@Nonnull Object invokedInstance, @Nullable Boolean matchInstance, @Nonnull Expectation expectation) {
        ExpectedInvocation invocation = expectation.invocation;
        Object invocationInstance = invocation.instance;
        assert (invocationInstance != null);
        if (this.equivalentInstances.isEquivalentInstance(invocationInstance, invokedInstance)) {
            return true;
        }
        if (TestRun.getExecutingTest().isInjectableMock(invokedInstance) || this.partiallyMockedInstances != null && this.partiallyMockedInstances.isDynamicMockInstanceOrClass(invokedInstance, invocationInstance) || this.equivalentInstances.areNonEquivalentInstances(invocationInstance, invokedInstance)) {
            return false;
        }
        return (matchInstance == null || matchInstance == false) && !invocation.matchInstance && expectation.recordPhase != null && !this.equivalentInstances.replacementMap.containsValue(invocationInstance);
    }
}

