/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.sourceFiles;

import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.dataItems.PerFileDataCoverage;
import mockit.coverage.reporting.OutputFile;
import mockit.coverage.reporting.dataCoverage.DataCoverageOutput;
import mockit.coverage.reporting.lineCoverage.LineCoverageOutput;
import mockit.coverage.reporting.parsing.FileParser;
import mockit.coverage.reporting.parsing.LineElement;
import mockit.coverage.reporting.parsing.LineParser;
import mockit.coverage.reporting.sourceFiles.InputFile;
import mockit.coverage.reporting.sourceFiles.NeutralOutput;

public final class FileCoverageReport {
    @Nonnull
    private final InputFile inputFile;
    @Nonnull
    private final OutputFile output;
    @Nonnull
    private final FileParser fileParser;
    @Nonnull
    private final NeutralOutput neutralOutput;
    @Nonnull
    private final LineCoverageOutput lineCoverage;
    @Nullable
    private final DataCoverageOutput dataCoverage;

    public FileCoverageReport(@Nonnull String outputDir, @Nonnull InputFile inputFile, @Nonnull FileCoverageData fileData, boolean withCallPoints) throws IOException {
        this.inputFile = inputFile;
        this.output = new OutputFile(outputDir, inputFile.filePath);
        this.fileParser = new FileParser();
        this.neutralOutput = new NeutralOutput(this.output);
        this.lineCoverage = new LineCoverageOutput(this.output, fileData.getLineCoverageData(), withCallPoints);
        this.dataCoverage = FileCoverageReport.createDataCoverageOutput(fileData);
    }

    @Nullable
    private static DataCoverageOutput createDataCoverageOutput(@Nonnull FileCoverageData fileData) {
        PerFileDataCoverage dataCoverageInfo = fileData.dataCoverageInfo;
        return dataCoverageInfo.hasFields() ? new DataCoverageOutput(dataCoverageInfo) : null;
    }

    public void generate() throws IOException {
        try {
            this.writeHeader();
            this.writeFormattedSourceLines();
            this.writeFooter();
        }
        finally {
            this.inputFile.close();
            this.output.close();
        }
    }

    private void writeHeader() {
        this.output.writeCommonHeader(this.inputFile.getSourceFileName());
        this.output.println("  <table>");
        this.output.println("    <caption>" + this.inputFile.getSourceFilePath() + "</caption>");
    }

    private void writeFormattedSourceLines() throws IOException {
        String line;
        LineParser lineParser = this.fileParser.lineParser;
        while ((line = this.inputFile.nextLine()) != null) {
            boolean lineWithCodeElements = this.fileParser.parseCurrentLine(line);
            if (lineWithCodeElements && this.dataCoverage != null) {
                this.dataCoverage.writeCoverageInfoIfLineStartsANewFieldDeclaration(this.fileParser);
            }
            if (this.neutralOutput.writeLineWithoutCoverageInfo(lineParser)) continue;
            this.writeOpeningOfNewLine(lineParser.getNumber());
            if (!this.lineCoverage.writeLineWithCoverageInfo(lineParser)) {
                this.writeLineWithoutCoverageInfo(lineParser.getInitialElement());
            }
            this.output.println("    </tr>");
        }
    }

    private void writeOpeningOfNewLine(@Nonnegative int lineNumber) {
        this.output.println("    <tr>");
        this.output.write("      <td>");
        this.output.print(lineNumber);
        this.output.write("</td>");
    }

    private void writeLineWithoutCoverageInfo(@Nonnull LineElement initialElement) {
        this.output.println("<td></td>");
        this.output.write("      <td><pre class='");
        this.output.write(initialElement.isComment() ? "cm'>" : "pp'>");
        this.output.write(initialElement.toString());
        this.output.println("</pre></td>");
    }

    private void writeFooter() {
        this.output.println("  </table>");
        this.output.writeCommonFooter();
    }
}

