/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.classes;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.BootstrapMethodsWriter;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassWriter;
import mockit.asm.constantPool.ClassMemberItem;
import mockit.asm.constantPool.DoubleItem;
import mockit.asm.constantPool.DynamicItem;
import mockit.asm.constantPool.FloatItem;
import mockit.asm.constantPool.IntItem;
import mockit.asm.constantPool.Item;
import mockit.asm.constantPool.LongItem;
import mockit.asm.constantPool.MethodHandleItem;
import mockit.asm.constantPool.NameAndTypeItem;
import mockit.asm.constantPool.StringItem;
import mockit.asm.util.MethodHandle;

final class ConstantPoolCopying {
    @Nonnull
    private final ClassReader source;
    @Nonnull
    private final ClassWriter destination;
    @Nonnull
    private final Item[] newItems;
    @Nonnegative
    private int itemIndex;

    ConstantPoolCopying(@Nonnull ClassReader source, @Nonnull ClassWriter destination) {
        this.source = source;
        this.destination = destination;
        this.newItems = new Item[source.items.length];
    }

    void copyPool(@Nullable BootstrapMethodsWriter bootstrapMethods) {
        if (bootstrapMethods != null) {
            bootstrapMethods.copyBootstrapMethods(this.source, this.newItems);
        }
        int[] items = this.source.items;
        int itemCount = items.length;
        this.itemIndex = 1;
        while (this.itemIndex < itemCount) {
            this.source.codeIndex = items[this.itemIndex] - 1;
            int itemType = this.source.readSignedByte();
            Item newItem = this.copyItem(itemType);
            newItem.setNext(this.newItems);
            ++this.itemIndex;
        }
        int off = items[1] - 1;
        this.destination.getConstantPoolGeneration().copy(this.source.code, off, this.source.header, this.newItems);
    }

    @Nonnull
    private Item copyItem(int itemType) {
        switch (itemType) {
            case 1: {
                return this.copyUTF8Item();
            }
            case 3: {
                return this.copyIntItem();
            }
            case 4: {
                return this.copyFloatItem();
            }
            case 5: {
                return this.copyLongItem();
            }
            case 6: {
                return this.copyDoubleItem();
            }
            case 9: 
            case 10: 
            case 11: {
                return this.copyFieldOrMethodReferenceItem(itemType);
            }
            case 12: {
                return this.copyNameAndTypeItem();
            }
            case 15: {
                return this.copyHandleItem();
            }
            case 17: 
            case 18: {
                return this.copyDynamicItem(itemType);
            }
        }
        return this.copyNameReferenceItem(itemType);
    }

    @Nonnull
    private Item copyIntItem() {
        int itemValue = this.source.readInt();
        IntItem item = new IntItem(this.itemIndex);
        item.setValue(itemValue);
        return item;
    }

    @Nonnull
    private Item copyLongItem() {
        long itemValue = this.source.readLong();
        LongItem item = new LongItem(this.itemIndex);
        item.setValue(itemValue);
        ++this.itemIndex;
        return item;
    }

    @Nonnull
    private Item copyFloatItem() {
        float itemValue = this.source.readFloat();
        FloatItem item = new FloatItem(this.itemIndex);
        item.set(itemValue);
        return item;
    }

    @Nonnull
    private Item copyDoubleItem() {
        double itemValue = this.source.readDouble();
        DoubleItem item = new DoubleItem(this.itemIndex);
        item.set(itemValue);
        ++this.itemIndex;
        return item;
    }

    @Nonnull
    private Item copyUTF8Item() {
        String strVal = this.source.readString(this.itemIndex);
        return new StringItem(this.itemIndex, 1, strVal);
    }

    @Nonnull
    private Item copyNameReferenceItem(int type) {
        String strVal = this.source.readNonnullUTF8();
        return new StringItem(this.itemIndex, type, strVal);
    }

    @Nonnull
    private Item copyNameAndTypeItem() {
        String name = this.source.readNonnullUTF8();
        String type = this.source.readNonnullUTF8();
        NameAndTypeItem item = new NameAndTypeItem(this.itemIndex);
        item.set(name, type);
        return item;
    }

    @Nonnull
    private Item copyFieldOrMethodReferenceItem(int type) {
        String classDesc = this.source.readNonnullClass();
        int nameCodeIndex = this.source.readItem();
        String methodName = this.source.readNonnullUTF8(nameCodeIndex);
        String methodDesc = this.source.readNonnullUTF8(nameCodeIndex + 2);
        ClassMemberItem item = new ClassMemberItem(this.itemIndex);
        item.set(type, classDesc, methodName, methodDesc);
        return item;
    }

    @Nonnull
    private Item copyHandleItem() {
        int tag = this.source.readUnsignedByte();
        int fieldOrMethodRef = this.source.readItem();
        int nameCodeIndex = this.source.readItem(fieldOrMethodRef + 2);
        String classDesc = this.source.readNonnullClass(fieldOrMethodRef);
        String name = this.source.readNonnullUTF8(nameCodeIndex);
        String desc = this.source.readNonnullUTF8(nameCodeIndex + 2);
        MethodHandle handle = new MethodHandle(tag, classDesc, name, desc);
        MethodHandleItem item = new MethodHandleItem(this.itemIndex);
        item.set(handle);
        return item;
    }

    @Nonnull
    private Item copyDynamicItem(int type) {
        int bsmIndex = this.source.readUnsignedShort();
        int nameCodeIndex = this.source.readItem();
        String name = this.source.readNonnullUTF8(nameCodeIndex);
        String desc = this.source.readNonnullUTF8(nameCodeIndex + 2);
        DynamicItem item = new DynamicItem(this.itemIndex);
        item.set(type, name, desc, bsmIndex);
        return item;
    }
}

