/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SplitLocationInfo;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.BaseFileWithLogsSplit;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieVirtualKeyInfo;
import org.apache.hudi.hadoop.realtime.RealtimeBootstrapBaseFileSplit;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;

public class HoodieRealtimeInputFormatUtils
extends HoodieInputFormatUtils {
    private static final Logger LOG = LogManager.getLogger(HoodieRealtimeInputFormatUtils.class);

    public static InputSplit[] getRealtimeSplits(Configuration conf, Stream<FileSplit> fileSplits) throws IOException {
        Map<Path, List<FileSplit>> partitionsToParquetSplits = fileSplits.collect(Collectors.groupingBy(split -> split.getPath().getParent()));
        Map<Path, HoodieTableMetaClient> partitionsToMetaClient = HoodieRealtimeInputFormatUtils.getTableMetaClientByPartitionPath(conf, partitionsToParquetSplits.keySet());
        HashMap<HoodieTableMetaClient, HoodieTableFileSystemView> fsCache = new HashMap<HoodieTableMetaClient, HoodieTableFileSystemView>();
        ArrayList rtSplits = new ArrayList();
        try {
            Option<HoodieVirtualKeyInfo> hoodieVirtualKeyInfo = Option.empty();
            if (partitionsToParquetSplits.size() > 0) {
                HoodieTableMetaClient metaClient = partitionsToMetaClient.get(partitionsToParquetSplits.keySet().iterator().next());
                hoodieVirtualKeyInfo = HoodieRealtimeInputFormatUtils.getHoodieVirtualKeyInfo(metaClient);
            }
            Option<HoodieVirtualKeyInfo> finalHoodieVirtualKeyInfo = hoodieVirtualKeyInfo;
            partitionsToParquetSplits.keySet().forEach(partitionPath -> {
                HoodieTableMetaClient metaClient = (HoodieTableMetaClient)partitionsToMetaClient.get(partitionPath);
                if (!fsCache.containsKey(metaClient)) {
                    HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(conf);
                    HoodieTableFileSystemView fsView = FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)engineContext, (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)HoodieInputFormatUtils.buildMetadataConfig(conf));
                    fsCache.put(metaClient, fsView);
                }
                HoodieTableFileSystemView fsView = (HoodieTableFileSystemView)fsCache.get(metaClient);
                String relPartitionPath = FSUtils.getRelativePartitionPath((Path)new Path(metaClient.getBasePath()), (Path)partitionPath);
                Option latestCompletedInstant = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant();
                Stream latestFileSlices = (Stream)latestCompletedInstant.map(instant -> fsView.getLatestMergedFileSlicesBeforeOrOn(relPartitionPath, instant.getTimestamp())).orElse(Stream.empty());
                Map<String, List<FileSplit>> groupedInputSplits = ((List)partitionsToParquetSplits.get(partitionPath)).stream().collect(Collectors.groupingBy(split -> FSUtils.getFileIdFromFilePath((Path)split.getPath())));
                String maxCommitTime = ((HoodieInstant)metaClient.getActiveTimeline().getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"commit", "rollback", "deltacommit", "replacecommit"})).filterCompletedInstants().lastInstant().get()).getTimestamp();
                latestFileSlices.forEach(fileSlice -> {
                    List dataFileSplits = groupedInputSplits.getOrDefault(fileSlice.getFileId(), new ArrayList());
                    dataFileSplits.forEach(split -> {
                        try {
                            List<HoodieLogFile> logFiles = fileSlice.getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).collect(Collectors.toList());
                            if (split instanceof BootstrapBaseFileSplit) {
                                BootstrapBaseFileSplit eSplit = (BootstrapBaseFileSplit)((Object)((Object)((Object)split)));
                                rtSplits.add(HoodieRealtimeInputFormatUtils.createRealtimeBoostrapBaseFileSplit(eSplit, metaClient.getBasePath(), logFiles, maxCommitTime));
                            } else {
                                rtSplits.add(new HoodieRealtimeFileSplit((FileSplit)split, metaClient.getBasePath(), logFiles, maxCommitTime, finalHoodieVirtualKeyInfo));
                            }
                        }
                        catch (IOException e) {
                            throw new HoodieIOException("Error creating hoodie real time split ", e);
                        }
                    });
                });
            });
        }
        catch (Exception e) {
            throw new HoodieException("Error obtaining data file/log file grouping ", (Throwable)e);
        }
        finally {
            fsCache.forEach((k, view) -> view.close());
        }
        LOG.info((Object)("Returning a total splits of " + rtSplits.size()));
        return rtSplits.toArray(new InputSplit[0]);
    }

    public static InputSplit[] getIncrementalRealtimeSplits(Configuration conf, Stream<FileSplit> fileSplits) throws IOException {
        ArrayList rtSplits = new ArrayList();
        List fileSplitList = fileSplits.collect(Collectors.toList());
        Set<Path> partitionSet = fileSplitList.stream().map(f -> f.getPath().getParent()).collect(Collectors.toSet());
        Map<Path, HoodieTableMetaClient> partitionsToMetaClient = HoodieRealtimeInputFormatUtils.getTableMetaClientByPartitionPath(conf, partitionSet);
        Option<HoodieVirtualKeyInfo> hoodieVirtualKeyInfo = Option.empty();
        if (partitionSet.size() > 0) {
            hoodieVirtualKeyInfo = HoodieRealtimeInputFormatUtils.getHoodieVirtualKeyInfo(partitionsToMetaClient.get(partitionSet.iterator().next()));
        }
        Option<HoodieVirtualKeyInfo> finalHoodieVirtualKeyInfo = hoodieVirtualKeyInfo;
        fileSplitList.stream().forEach(arg_0 -> HoodieRealtimeInputFormatUtils.lambda$getIncrementalRealtimeSplits$8(rtSplits, (Option)finalHoodieVirtualKeyInfo, arg_0));
        LOG.info((Object)("Returning a total splits of " + rtSplits.size()));
        return rtSplits.toArray(new InputSplit[0]);
    }

    public static Option<HoodieVirtualKeyInfo> getHoodieVirtualKeyInfo(HoodieTableMetaClient metaClient) {
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        if (!tableConfig.populateMetaFields()) {
            TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(metaClient);
            try {
                MessageType parquetSchema = tableSchemaResolver.getTableParquetSchema();
                return Option.of((Object)new HoodieVirtualKeyInfo(tableConfig.getRecordKeyFieldProp(), tableConfig.getPartitionFieldProp(), parquetSchema.getFieldIndex(tableConfig.getRecordKeyFieldProp()), parquetSchema.getFieldIndex(tableConfig.getPartitionFieldProp())));
            }
            catch (Exception exception) {
                throw new HoodieException("Fetching table schema failed with exception ", (Throwable)exception);
            }
        }
        return Option.empty();
    }

    public static boolean isIncrementalQuerySplits(List<FileSplit> fileSplits) {
        if (fileSplits == null || fileSplits.size() == 0) {
            return false;
        }
        return fileSplits.stream().anyMatch(s -> {
            if (s instanceof BaseFileWithLogsSplit) {
                BaseFileWithLogsSplit bs = (BaseFileWithLogsSplit)((Object)s);
                return bs.getBelongToIncrementalSplit();
            }
            return s instanceof RealtimeBootstrapBaseFileSplit;
        });
    }

    public static RealtimeBootstrapBaseFileSplit createRealtimeBoostrapBaseFileSplit(BootstrapBaseFileSplit split, String basePath, List<HoodieLogFile> logFiles, String maxInstantTime) {
        try {
            String[] hosts = split.getLocationInfo() != null ? (String[])Arrays.stream(split.getLocationInfo()).filter(x -> !x.isInMemory()).toArray(String[]::new) : new String[]{};
            String[] inMemoryHosts = split.getLocationInfo() != null ? (String[])Arrays.stream(split.getLocationInfo()).filter(SplitLocationInfo::isInMemory).toArray(String[]::new) : new String[]{};
            FileSplit baseSplit = new FileSplit(split.getPath(), split.getStart(), split.getLength(), hosts, inMemoryHosts);
            return new RealtimeBootstrapBaseFileSplit(baseSplit, basePath, logFiles, maxInstantTime, split.getBootstrapFileSplit());
        }
        catch (IOException e) {
            throw new HoodieIOException("Error creating hoodie real time split ", e);
        }
    }

    public static List<Pair<Option<HoodieBaseFile>, List<String>>> groupLogsByBaseFile(Configuration conf, List<Path> partitionPaths) {
        HashSet<Path> partitionSet = new HashSet<Path>(partitionPaths);
        Map<Path, HoodieTableMetaClient> partitionsToMetaClient = HoodieRealtimeInputFormatUtils.getTableMetaClientByPartitionPath(conf, partitionSet);
        ArrayList<Pair<Option<HoodieBaseFile>, List<String>>> baseAndLogsList = new ArrayList<Pair<Option<HoodieBaseFile>, List<String>>>();
        partitionSet.forEach(partitionPath -> {
            HoodieTableMetaClient metaClient = (HoodieTableMetaClient)partitionsToMetaClient.get(partitionPath);
            HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, (HoodieTimeline)metaClient.getActiveTimeline());
            String relPartitionPath = FSUtils.getRelativePartitionPath((Path)new Path(metaClient.getBasePath()), (Path)partitionPath);
            try {
                Option latestCompletedInstant = metaClient.getCommitsAndCompactionTimeline().filterCompletedAndCompactionInstants().lastInstant();
                Stream latestFileSlices = (Stream)latestCompletedInstant.map(instant -> fsView.getLatestMergedFileSlicesBeforeOrOn(relPartitionPath, instant.getTimestamp())).orElse(Stream.empty());
                latestFileSlices.forEach(fileSlice -> {
                    List logFilePaths = fileSlice.getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).map(logFile -> logFile.getPath().toString()).collect(Collectors.toList());
                    baseAndLogsList.add(Pair.of((Object)fileSlice.getBaseFile(), logFilePaths));
                });
            }
            catch (Exception e) {
                throw new HoodieException("Error obtaining data file/log file grouping: " + partitionPath, (Throwable)e);
            }
        });
        return baseAndLogsList;
    }

    private static Configuration addProjectionField(Configuration conf, String fieldName, int fieldIndex) {
        String readColNames = conf.get("hive.io.file.readcolumn.names", "");
        String readColIds = conf.get("hive.io.file.readcolumn.ids", "");
        String readColNamesPrefix = readColNames + ",";
        if (readColNames == null || readColNames.isEmpty()) {
            readColNamesPrefix = "";
        }
        String readColIdsPrefix = readColIds + ",";
        if (readColIds == null || readColIds.isEmpty()) {
            readColIdsPrefix = "";
        }
        if (!readColNames.contains(fieldName)) {
            conf.set("hive.io.file.readcolumn.names", readColNamesPrefix + fieldName);
            conf.set("hive.io.file.readcolumn.ids", readColIdsPrefix + fieldIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Adding extra column " + fieldName + ", to enable log merging cols (%s) ids (%s) ", conf.get("hive.io.file.readcolumn.names"), conf.get("hive.io.file.readcolumn.ids")));
            }
        }
        return conf;
    }

    public static void addRequiredProjectionFields(Configuration configuration, Option<HoodieVirtualKeyInfo> hoodieVirtualKeyInfo) {
        if (!hoodieVirtualKeyInfo.isPresent()) {
            HoodieRealtimeInputFormatUtils.addProjectionField(configuration, "_hoodie_record_key", 2);
            HoodieRealtimeInputFormatUtils.addProjectionField(configuration, "_hoodie_commit_time", 0);
            HoodieRealtimeInputFormatUtils.addProjectionField(configuration, "_hoodie_partition_path", 3);
        } else {
            HoodieVirtualKeyInfo hoodieVirtualKey = (HoodieVirtualKeyInfo)hoodieVirtualKeyInfo.get();
            HoodieRealtimeInputFormatUtils.addProjectionField(configuration, hoodieVirtualKey.getRecordKeyField(), hoodieVirtualKey.getRecordKeyFieldIndex());
            HoodieRealtimeInputFormatUtils.addProjectionField(configuration, hoodieVirtualKey.getPartitionPathField(), hoodieVirtualKey.getPartitionPathFieldIndex());
        }
    }

    public static boolean requiredProjectionFieldsExistInConf(Configuration configuration, Option<HoodieVirtualKeyInfo> hoodieVirtualKeyInfo) {
        String readColNames = configuration.get("hive.io.file.readcolumn.names", "");
        if (!hoodieVirtualKeyInfo.isPresent()) {
            return readColNames.contains("_hoodie_record_key") && readColNames.contains("_hoodie_commit_time") && readColNames.contains("_hoodie_partition_path");
        }
        return readColNames.contains(((HoodieVirtualKeyInfo)hoodieVirtualKeyInfo.get()).getRecordKeyField()) && readColNames.contains(((HoodieVirtualKeyInfo)hoodieVirtualKeyInfo.get()).getPartitionPathField());
    }

    public static boolean canAddProjectionToJobConf(RealtimeSplit realtimeSplit, JobConf jobConf) {
        return jobConf.get("hoodie.read.columns.set") == null || !realtimeSplit.getDeltaLogPaths().isEmpty() && !HoodieRealtimeInputFormatUtils.requiredProjectionFieldsExistInConf((Configuration)jobConf, realtimeSplit.getHoodieVirtualKeyInfo());
    }

    public static void cleanProjectionColumnIds(Configuration conf) {
        String columnIds = conf.get("hive.io.file.readcolumn.ids");
        if (!columnIds.isEmpty() && columnIds.charAt(0) == ',') {
            conf.set("hive.io.file.readcolumn.ids", columnIds.substring(1));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The projection Ids: {" + columnIds + "} start with ','. First comma is removed"));
            }
        }
    }

    private static /* synthetic */ void lambda$getIncrementalRealtimeSplits$8(List rtSplits, Option finalHoodieVirtualKeyInfo, FileSplit s) {
        try {
            if (s instanceof BaseFileWithLogsSplit) {
                BaseFileWithLogsSplit bs = (BaseFileWithLogsSplit)s;
                if (bs.getBelongToIncrementalSplit()) {
                    rtSplits.add(new HoodieRealtimeFileSplit(bs, bs.getBasePath(), bs.getDeltaLogFiles(), bs.getMaxCommitTime(), (Option<HoodieVirtualKeyInfo>)finalHoodieVirtualKeyInfo));
                }
            } else if (s instanceof RealtimeBootstrapBaseFileSplit) {
                rtSplits.add(s);
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Error creating hoodie real time split ", e);
        }
    }
}

