/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.CombineHiveRecordReader;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.IOContextMap;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileInputFormat;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.hive.HoodieCombineRealtimeFileSplit;
import org.apache.hudi.hadoop.hive.HoodieCombineRealtimeHiveSplit;
import org.apache.hudi.hadoop.realtime.HoodieCombineRealtimeRecordReader;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieCombineHiveInputFormat<K extends WritableComparable, V extends Writable>
extends HiveInputFormat<K, V> {
    private static final String CLASS_NAME = HoodieCombineHiveInputFormat.class.getName();
    public static final Logger LOG = LogManager.getLogger((String)CLASS_NAME);
    private static final int MAX_CHECK_NONCOMBINABLE_THREAD_NUM = 50;
    private static final int DEFAULT_NUM_PATH_PER_THREAD = 100;

    protected String getParquetInputFormatClassName() {
        return HoodieParquetInputFormat.class.getName();
    }

    protected String getParquetRealtimeInputFormatClassName() {
        return HoodieParquetRealtimeInputFormat.class.getName();
    }

    protected HoodieCombineFileInputFormatShim createInputFormatShim() {
        return new HoodieCombineFileInputFormatShim();
    }

    /*
     * WARNING - void declaration
     */
    private InputSplit[] getCombineSplits(JobConf job, int numSplits, Map<Path, PartitionDesc> pathToPartitionInfo) throws IOException {
        void var16_18;
        this.init(job);
        LinkedHashMap pathToAliases = this.mrwork.getPathToAliases();
        LinkedHashMap aliasToWork = this.mrwork.getAliasToWork();
        HoodieCombineFileInputFormatShim combine = this.createInputFormatShim();
        if (combine.getInputPathsShim(job).length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<CombineFileSplit> result = new ArrayList<CombineFileSplit>();
        Path[] paths = StringInternUtils.internUriStringsInPathArray((Path[])combine.getInputPathsShim(job));
        ArrayList<Path> inpDirs = new ArrayList<Path>();
        ArrayList<Path> inpFiles = new ArrayList<Path>();
        HashMap<CombinePathInputFormat, CombineFilter> poolMap = new HashMap<CombinePathInputFormat, CombineFilter>();
        HashSet<Path> poolSet = new HashSet<Path>();
        Path[] pathArray = paths;
        int n = pathArray.length;
        boolean bl = false;
        while (var16_18 < n) {
            Path path = pathArray[var16_18];
            PartitionDesc part = HoodieCombineHiveInputFormat.getPartitionFromPath(pathToPartitionInfo, path, IOPrepareCache.get().allocatePartitionDescMap());
            TableDesc tableDesc = part.getTableDesc();
            if (tableDesc != null && tableDesc.isNonNative()) {
                return super.getSplits(job, numSplits);
            }
            Class inputFormatClass = part.getInputFileFormatClass();
            String inputFormatClassName = inputFormatClass.getName();
            InputFormat inputFormat = HoodieCombineHiveInputFormat.getInputFormatFromCache((Class)inputFormatClass, (JobConf)job);
            LOG.info((Object)("Input Format => " + inputFormatClass.getName()));
            if (inputFormatClass.getName().equals(this.getParquetInputFormatClassName())) {
                combine.setHoodieFilter(true);
            } else if (inputFormatClass.getName().equals(this.getParquetRealtimeInputFormatClassName())) {
                LOG.info((Object)"Setting hoodie filter and realtime input format");
                combine.setHoodieFilter(true);
                combine.setRealTime(true);
                if (job.get("partition_columns", "").isEmpty()) {
                    ArrayList partitions = new ArrayList(part.getPartSpec().keySet());
                    if (!partitions.isEmpty()) {
                        String partitionStr = String.join((CharSequence)"/", partitions);
                        LOG.info((Object)("Setting Partitions in jobConf - Partition Keys for Path : " + path + " is :" + partitionStr));
                        job.set("partition_columns", partitionStr);
                    } else {
                        job.set("partition_columns", "");
                    }
                }
            }
            String deserializerClassName = null;
            try {
                deserializerClassName = part.getDeserializer((Configuration)job).getClass().getName();
            }
            catch (Exception partitionStr) {
                // empty catch block
            }
            FileSystem inpFs = path.getFileSystem((Configuration)job);
            if (inputFormat instanceof SymlinkTextInputFormat) {
                InputSplit[] splits = super.getSplits(job, numSplits);
                return splits;
            }
            Path filterPath = path;
            if (!this.mrwork.isMapperCannotSpanPartns()) {
                List opList = HiveFileFormatUtils.doGetWorksFromPath((Map)pathToAliases, (Map)aliasToWork, (Path)filterPath);
                CombinePathInputFormat combinePathInputFormat = new CombinePathInputFormat(opList, inputFormatClassName, deserializerClassName);
                CombineFilter f = (CombineFilter)poolMap.get(combinePathInputFormat);
                if (f == null) {
                    f = new CombineFilter(filterPath);
                    LOG.info((Object)("CombineHiveInputSplit creating pool for " + path + "; using filter path " + filterPath));
                    combine.createPool(job, f);
                    poolMap.put(combinePathInputFormat, f);
                } else {
                    LOG.info((Object)("CombineHiveInputSplit: pool is already created for " + path + "; using filter path " + filterPath));
                    f.addPath(filterPath);
                }
            } else if (!path.getFileSystem((Configuration)job).getFileStatus(path).isDirectory()) {
                filterPath = path.getParent();
                inpFiles.add(path);
                poolSet.add(filterPath);
            } else {
                inpDirs.add(path);
            }
            ++var16_18;
        }
        List<Object> iss = new ArrayList();
        if (!this.mrwork.isMapperCannotSpanPartns()) {
            iss = Arrays.asList(combine.getSplits(job, 1));
        } else {
            for (Path path : inpDirs) {
                this.processPaths(job, combine, iss, path);
            }
            if (inpFiles.size() > 0) {
                for (Path path : poolSet) {
                    combine.createPool(job, new CombineFilter(path));
                }
                this.processPaths(job, combine, iss, inpFiles.toArray(new Path[0]));
            }
        }
        if (this.mrwork.getNameToSplitSample() != null && !this.mrwork.getNameToSplitSample().isEmpty()) {
            iss = this.sampleSplits(iss);
        }
        for (CombineFileSplit combineFileSplit : iss) {
            Object csplit = combine.isRealTime ? (combineFileSplit instanceof HoodieCombineRealtimeHiveSplit ? combineFileSplit : new HoodieCombineRealtimeHiveSplit(job, combineFileSplit, pathToPartitionInfo)) : new CombineHiveInputSplit(job, combineFileSplit, pathToPartitionInfo);
            result.add((CombineFileSplit)csplit);
        }
        LOG.info((Object)("number of splits " + result.size()));
        return (InputSplit[])result.toArray(new CombineHiveInputSplit[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getNonCombinablePathIndices(JobConf job, Path[] paths, int numThreads) throws ExecutionException, InterruptedException {
        LOG.info((Object)("Total number of paths: " + paths.length + ", launching " + numThreads + " threads to check non-combinable ones."));
        int numPathPerThread = (int)Math.ceil((double)paths.length / (double)numThreads);
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        ArrayList<Future<Set<Integer>>> futureList = new ArrayList<Future<Set<Integer>>>(numThreads);
        try {
            for (int i = 0; i < numThreads; ++i) {
                int start = i * numPathPerThread;
                int n = i != numThreads - 1 ? numPathPerThread : paths.length - start;
                futureList.add(executor.submit(new CheckNonCombinablePathCallable(paths, start, n, job)));
            }
            HashSet nonCombinablePathIndices = new HashSet();
            for (Future future : futureList) {
                nonCombinablePathIndices.addAll((Collection)future.get());
            }
            HashSet hashSet = nonCombinablePathIndices;
            return hashSet;
        }
        finally {
            executor.shutdownNow();
        }
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "getSplits");
        this.init(job);
        ArrayList result = new ArrayList();
        Path[] paths = this.getInputPaths(job);
        ArrayList<Path> nonCombinablePaths = new ArrayList<Path>(paths.length / 2);
        ArrayList<Path> combinablePaths = new ArrayList<Path>(paths.length / 2);
        int numThreads = Math.min(50, (int)Math.ceil((double)paths.length / 100.0));
        if (numThreads > 0) {
            try {
                Set<Integer> nonCombinablePathIndices = this.getNonCombinablePathIndices(job, paths, numThreads);
                for (int i = 0; i < paths.length; ++i) {
                    if (nonCombinablePathIndices.contains(i)) {
                        nonCombinablePaths.add(paths[i]);
                        continue;
                    }
                    combinablePaths.add(paths[i]);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error checking non-combinable path", (Throwable)e);
                perfLogger.PerfLogEnd(CLASS_NAME, "getSplits");
                throw new IOException(e);
            }
        }
        String oldPaths = job.get("mapreduce.input.fileinputformat.inputdir");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The received input paths are: [" + oldPaths + "] against the property " + "mapreduce.input.fileinputformat.inputdir"));
        }
        if (nonCombinablePaths.size() > 0) {
            FileInputFormat.setInputPaths((JobConf)job, (Path[])nonCombinablePaths.toArray(new Path[0]));
            InputSplit[] splits = super.getSplits(job, numSplits);
            Collections.addAll(result, splits);
        }
        if (combinablePaths.size() > 0) {
            FileInputFormat.setInputPaths((JobConf)job, (Path[])combinablePaths.toArray(new Path[0]));
            Map pathToPartitionInfo = this.pathToPartitionInfo != null ? this.pathToPartitionInfo : Utilities.getMapWork((Configuration)job).getPathToPartitionInfo();
            InputSplit[] splits = this.getCombineSplits(job, numSplits, pathToPartitionInfo);
            Collections.addAll(result, splits);
        }
        if (oldPaths != null) {
            job.set("mapreduce.input.fileinputformat.inputdir", oldPaths);
        }
        Utilities.clearWorkMapForConf((Configuration)job);
        LOG.info((Object)("Number of all splits " + result.size()));
        perfLogger.PerfLogEnd(CLASS_NAME, "getSplits");
        return result.toArray(new InputSplit[result.size()]);
    }

    private void processPaths(JobConf job, HadoopShims.CombineFileInputFormatShim combine, List<CombineFileSplit> iss, Path ... path) throws IOException {
        JobConf currJob = new JobConf((Configuration)job);
        FileInputFormat.setInputPaths((JobConf)currJob, (Path[])path);
        iss.addAll(Arrays.asList(combine.getSplits(currJob, 1)));
    }

    private static PartitionDesc getPartitionFromPath(Map<Path, PartitionDesc> pathToPartitionInfo, Path dir, Map<Map<Path, PartitionDesc>, Map<Path, PartitionDesc>> cacheMap) throws IOException {
        try {
            Method method;
            Class<?> hiveUtilsClass = Class.forName("org.apache.hadoop.hive.ql.io.HiveFileFormatUtils");
            try {
                method = hiveUtilsClass.getMethod("getPartitionDescFromPathRecursively", Map.class, Path.class, Map.class);
            }
            catch (NoSuchMethodException e) {
                method = hiveUtilsClass.getMethod("getFromPathRecursively", Map.class, Path.class, Map.class);
            }
            return (PartitionDesc)method.invoke(null, pathToPartitionInfo, dir, cacheMap);
        }
        catch (ReflectiveOperationException e) {
            throw new IOException(e);
        }
    }

    Path[] getInputPaths(JobConf job) throws IOException {
        Path[] dirs = FileInputFormat.getInputPaths((JobConf)job);
        if (dirs.length == 0) {
            if (HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                try {
                    List paths = Utilities.getInputPathsTez((JobConf)job, (MapWork)this.mrwork);
                    dirs = paths.toArray(new Path[paths.size()]);
                }
                catch (Exception e) {
                    throw new IOException("Could not create input files", e);
                }
            } else {
                throw new IOException("No input paths specified in job");
            }
        }
        return dirs;
    }

    private List<CombineFileSplit> sampleSplits(List<CombineFileSplit> splits) {
        HashMap nameToSamples = this.mrwork.getNameToSplitSample();
        ArrayList<CombineFileSplit> retLists = new ArrayList<CombineFileSplit>();
        HashMap aliasToSplitList = new HashMap();
        LinkedHashMap pathToAliases = this.mrwork.getPathToAliases();
        LinkedHashMap pathToAliasesNoScheme = this.removeScheme(pathToAliases);
        for (CombineFileSplit combineFileSplit : splits) {
            String alias = null;
            for (Path path : combineFileSplit.getPaths()) {
                boolean schemeless = path.toUri().getScheme() == null;
                List l = HiveFileFormatUtils.doGetAliasesFromPath((Map)(schemeless ? pathToAliasesNoScheme : pathToAliases), (Path)path);
                if (l.size() != 1 || !nameToSamples.containsKey(l.get(0)) || alias != null && !Objects.equals(l.get(0), alias)) {
                    alias = null;
                    break;
                }
                alias = (String)l.get(0);
            }
            if (alias != null) {
                if (!aliasToSplitList.containsKey(alias)) {
                    aliasToSplitList.put(alias, new ArrayList());
                }
                ((ArrayList)aliasToSplitList.get(alias)).add(combineFileSplit);
                continue;
            }
            retLists.add(combineFileSplit);
        }
        block2: for (Map.Entry entry : aliasToSplitList.entrySet()) {
            ArrayList splitList = (ArrayList)entry.getValue();
            long totalSize = 0L;
            for (CombineFileSplit split : splitList) {
                totalSize += split.getLength();
            }
            SplitSample splitSample = (SplitSample)nameToSamples.get(entry.getKey());
            long targetSize = splitSample.getTargetSize(totalSize);
            int startIndex = splitSample.getSeedNum() % splitList.size();
            long size = 0L;
            for (int i = 0; i < splitList.size(); ++i) {
                CombineFileSplit split = (CombineFileSplit)splitList.get((startIndex + i) % splitList.size());
                retLists.add(split);
                long splitgLength = split.getLength();
                if (size + splitgLength >= targetSize) {
                    LOG.info((Object)("Sample alias " + entry.getValue() + " using " + (i + 1) + "splits"));
                    if (size + splitgLength <= targetSize) continue block2;
                    ((HadoopShimsSecure.InputSplitShim)split).shrinkSplit(targetSize - size);
                    continue block2;
                }
                size += splitgLength;
            }
        }
        return retLists;
    }

    Map<Path, ArrayList<String>> removeScheme(Map<Path, ArrayList<String>> pathToAliases) {
        HashMap<Path, ArrayList<String>> result = new HashMap<Path, ArrayList<String>>();
        for (Map.Entry<Path, ArrayList<String>> entry : pathToAliases.entrySet()) {
            Path newKey = Path.getPathWithoutSchemeAndAuthority((Path)entry.getKey());
            StringInternUtils.internUriStringsInPath((Path)newKey);
            result.put(newKey, entry.getValue());
        }
        return result;
    }

    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        Class inputFormatClass;
        if (!(split instanceof CombineHiveInputSplit)) {
            return super.getRecordReader(split, job, reporter);
        }
        CombineHiveInputSplit hsplit = (CombineHiveInputSplit)split;
        String inputFormatClassName = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName);
        }
        this.pushProjectionsAndFilters(job, inputFormatClass, hsplit.getPath(0));
        if (inputFormatClass.getName().equals(this.getParquetRealtimeInputFormatClassName())) {
            HoodieCombineFileInputFormatShim shims = this.createInputFormatShim();
            IOContextMap.get((Configuration)job).setInputPath(((CombineHiveInputSplit)split).getPath(0));
            return shims.getRecordReader(job, ((CombineHiveInputSplit)split).getInputSplitShim(), reporter, CombineHiveRecordReader.class);
        }
        return ShimLoader.getHadoopShims().getCombineFileInputFormat().getRecordReader(job, (CombineFileSplit)split, reporter, CombineHiveRecordReader.class);
    }

    private class CheckNonCombinablePathCallable
    implements Callable<Set<Integer>> {
        private final Path[] paths;
        private final int start;
        private final int length;
        private final JobConf conf;

        public CheckNonCombinablePathCallable(Path[] paths, int start, int length, JobConf conf) {
            this.paths = paths;
            this.start = start;
            this.length = length;
            this.conf = conf;
        }

        @Override
        public Set<Integer> call() throws Exception {
            HashSet<Integer> nonCombinablePathIndices = new HashSet<Integer>();
            for (int i = 0; i < this.length; ++i) {
                PartitionDesc part = HoodieCombineHiveInputFormat.getPartitionFromPath(HoodieCombineHiveInputFormat.this.pathToPartitionInfo, this.paths[i + this.start], IOPrepareCache.get().allocatePartitionDescMap());
                Class inputFormatClass = part.getInputFileFormatClass();
                InputFormat inputFormat = HiveInputFormat.getInputFormatFromCache((Class)inputFormatClass, (JobConf)this.conf);
                if (!(inputFormat instanceof AvoidSplitCombination) || !((AvoidSplitCombination)inputFormat).shouldSkipCombine(this.paths[i + this.start], (Configuration)this.conf)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The path [" + this.paths[i + this.start] + "] is being parked for HiveInputFormat.getSplits"));
                }
                nonCombinablePathIndices.add(i + this.start);
            }
            return nonCombinablePathIndices;
        }
    }

    public static class HoodieCombineFileInputFormatShim<K, V>
    extends CombineFileInputFormat<K, V>
    implements HadoopShims.CombineFileInputFormatShim<K, V> {
        private boolean hoodieFilter = false;
        private boolean isRealTime = false;

        protected HoodieParquetInputFormat createParquetInputFormat() {
            return new HoodieParquetInputFormat();
        }

        protected HoodieParquetRealtimeInputFormat createParquetRealtimeInputFormat() {
            return new HoodieParquetRealtimeInputFormat();
        }

        public Path[] getInputPathsShim(JobConf conf) {
            try {
                return FileInputFormat.getInputPaths((JobConf)conf);
            }
            catch (Exception var3) {
                throw new RuntimeException(var3);
            }
        }

        public void createPool(JobConf conf, PathFilter ... filters) {
            super.createPool(conf, filters);
        }

        public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            throw new IOException("CombineFileInputFormat.getRecordReader not needed.");
        }

        protected List<FileStatus> listStatus(JobContext job) throws IOException {
            ArrayList<FileStatus> result;
            LOG.info((Object)"Listing status in HoodieCombineHiveInputFormat.HoodieCombineFileInputFormatShim");
            if (this.hoodieFilter) {
                HoodieParquetInputFormat input;
                if (this.isRealTime) {
                    LOG.info((Object)"Using HoodieRealtimeInputFormat");
                    input = this.createParquetRealtimeInputFormat();
                } else {
                    LOG.info((Object)"Using HoodieInputFormat");
                    input = this.createParquetInputFormat();
                }
                input.setConf(job.getConfiguration());
                result = new ArrayList<FileStatus>(Arrays.asList(input.listStatus(new JobConf(job.getConfiguration()))));
            } else {
                result = super.listStatus(job);
            }
            result.removeIf(stat -> !stat.isFile());
            return result;
        }

        public CombineFileSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            long minSize = job.getLong("mapreduce.input.fileinputformat.split.minsize", 0L);
            long maxSize = job.getLong("mapreduce.input.fileinputformat.split.maxsize", minSize);
            if (job.getLong("mapreduce.input.fileinputformat.split.minsize.per.node", 0L) == 0L) {
                super.setMinSplitSizeNode(minSize);
            }
            if (job.getLong("mapreduce.input.fileinputformat.split.minsize.per.rack", 0L) == 0L) {
                super.setMinSplitSizeRack(minSize);
            }
            if (job.getLong("mapreduce.input.fileinputformat.split.maxsize", 0L) == 0L) {
                super.setMaxSplitSize(minSize);
            }
            LOG.info((Object)("mapreduce.input.fileinputformat.split.minsize=" + minSize + ", mapreduce.input.fileinputformat.split.maxsize=" + maxSize));
            if (this.isRealTime) {
                InputSplit[] splits;
                job.set("hudi.hive.realtime", "true");
                if (this.hoodieFilter) {
                    HoodieParquetRealtimeInputFormat input = this.createParquetRealtimeInputFormat();
                    input.setConf((Configuration)job);
                    splits = input.getSplits(job, numSplits);
                } else {
                    splits = super.getSplits(job, numSplits);
                }
                ArrayList<HoodieCombineRealtimeFileSplit> combineFileSplits = new ArrayList<HoodieCombineRealtimeFileSplit>();
                HoodieCombineRealtimeFileSplit.Builder builder = new HoodieCombineRealtimeFileSplit.Builder();
                int counter = 0;
                for (int pos = 0; pos < splits.length; ++pos) {
                    if ((long)counter == maxSize - 1L || pos == splits.length - 1) {
                        builder.addSplit((FileSplit)splits[pos]);
                        combineFileSplits.add(builder.build(job));
                        builder = new HoodieCombineRealtimeFileSplit.Builder();
                        counter = 0;
                        continue;
                    }
                    if ((long)counter >= maxSize) continue;
                    ++counter;
                    builder.addSplit((FileSplit)splits[pos]);
                }
                return combineFileSplits.toArray(new CombineFileSplit[combineFileSplits.size()]);
            }
            InputSplit[] splits = super.getSplits(job, numSplits);
            ArrayList<HadoopShimsSecure.InputSplitShim> inputSplitShims = new ArrayList<HadoopShimsSecure.InputSplitShim>();
            for (int pos = 0; pos < splits.length; ++pos) {
                CombineFileSplit split = (CombineFileSplit)splits[pos];
                if (split.getPaths().length <= 0) continue;
                inputSplitShims.add(new HadoopShimsSecure.InputSplitShim(job, split.getPaths(), split.getStartOffsets(), split.getLengths(), split.getLocations()));
            }
            return (CombineFileSplit[])inputSplitShims.toArray(new HadoopShimsSecure.InputSplitShim[inputSplitShims.size()]);
        }

        public HadoopShimsSecure.InputSplitShim getInputSplitShim() {
            return new HadoopShimsSecure.InputSplitShim();
        }

        public RecordReader getRecordReader(JobConf job, CombineFileSplit split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
            this.isRealTime = Boolean.valueOf(job.get("hudi.hive.realtime", "false"));
            if (this.isRealTime) {
                LinkedList<RecordReader> recordReaders = new LinkedList<RecordReader>();
                ValidationUtils.checkArgument((boolean)(split instanceof HoodieCombineRealtimeFileSplit), (String)("Only " + HoodieCombineRealtimeFileSplit.class.getName() + " allowed, found " + split.getClass().getName()));
                for (InputSplit inputSplit : ((HoodieCombineRealtimeFileSplit)split).getRealtimeFileSplits()) {
                    if (split.getPaths().length == 0) continue;
                    FileInputFormat inputFormat = HoodieInputFormatUtils.getInputFormat(split.getPath(0).toString(), true, (Configuration)job);
                    recordReaders.add(inputFormat.getRecordReader(inputSplit, job, reporter));
                }
                return new HoodieCombineRealtimeRecordReader(job, split, recordReaders);
            }
            return new HadoopShimsSecure.CombineFileRecordReader(job, split, reporter, rrClass);
        }

        public void setHoodieFilter(boolean hoodieFilter) {
            this.hoodieFilter = hoodieFilter;
        }

        public void setRealTime(boolean realTime) {
            this.isRealTime = realTime;
        }
    }

    static class CombineFilter
    implements PathFilter {
        private final Set<String> pStrings = new HashSet<String>();

        public CombineFilter(Path p) {
            this.addPath(p);
        }

        public void addPath(Path p) {
            String pString = p.toUri().getPath();
            this.pStrings.add(pString);
        }

        public boolean accept(Path path) {
            boolean find = false;
            while (path != null) {
                if (this.pStrings.contains(path.toUri().getPath())) {
                    find = true;
                    break;
                }
                path = path.getParent();
            }
            return find;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("PathFilter: ");
            for (String pString : this.pStrings) {
                s.append(pString + " ");
            }
            return s.toString();
        }
    }

    private static class CombinePathInputFormat {
        private final List<Operator<? extends OperatorDesc>> opList;
        private final String inputFormatClassName;
        private final String deserializerClassName;

        public CombinePathInputFormat(List<Operator<? extends OperatorDesc>> opList, String inputFormatClassName, String deserializerClassName) {
            this.opList = opList;
            this.inputFormatClassName = inputFormatClassName;
            this.deserializerClassName = deserializerClassName;
        }

        public boolean equals(Object o) {
            if (o instanceof CombinePathInputFormat) {
                CombinePathInputFormat mObj = (CombinePathInputFormat)o;
                return this.opList.equals(mObj.opList) && this.inputFormatClassName.equals(mObj.inputFormatClassName) && (this.deserializerClassName == null ? mObj.deserializerClassName == null : this.deserializerClassName.equals(mObj.deserializerClassName));
            }
            return false;
        }

        public int hashCode() {
            return this.opList == null ? 0 : this.opList.hashCode();
        }
    }

    public static class CombineHiveInputSplit
    extends HadoopShimsSecure.InputSplitShim {
        private String inputFormatClassName;
        protected CombineFileSplit inputSplitShim;
        private Map<Path, PartitionDesc> pathToPartitionInfo;

        public CombineHiveInputSplit() throws IOException {
            this(ShimLoader.getHadoopShims().getCombineFileInputFormat().getInputSplitShim());
        }

        public CombineHiveInputSplit(CombineFileSplit inputSplitShim) throws IOException {
            this(inputSplitShim.getJob(), inputSplitShim);
        }

        public CombineHiveInputSplit(JobConf job, CombineFileSplit inputSplitShim) throws IOException {
            this(job, inputSplitShim, null);
        }

        public CombineHiveInputSplit(JobConf job, CombineFileSplit inputSplitShim, Map<Path, PartitionDesc> pathToPartitionInfo) throws IOException {
            this.inputSplitShim = inputSplitShim;
            this.pathToPartitionInfo = pathToPartitionInfo;
            if (job != null) {
                Path[] ipaths;
                if (this.pathToPartitionInfo == null) {
                    this.pathToPartitionInfo = Utilities.getMapWork((Configuration)job).getPathToPartitionInfo();
                }
                if ((ipaths = inputSplitShim.getPaths()).length > 0) {
                    PartitionDesc part = HoodieCombineHiveInputFormat.getPartitionFromPath(this.pathToPartitionInfo, ipaths[0], IOPrepareCache.get().getPartitionDescMap());
                    this.inputFormatClassName = part.getInputFileFormatClass().getName();
                }
            }
        }

        public CombineFileSplit getInputSplitShim() {
            return this.inputSplitShim;
        }

        public String inputFormatClassName() {
            return this.inputFormatClassName;
        }

        public void setInputFormatClassName(String inputFormatClassName) {
            this.inputFormatClassName = inputFormatClassName;
        }

        public JobConf getJob() {
            return this.inputSplitShim.getJob();
        }

        public long getLength() {
            return this.inputSplitShim.getLength();
        }

        public long[] getStartOffsets() {
            return this.inputSplitShim.getStartOffsets();
        }

        public long[] getLengths() {
            return this.inputSplitShim.getLengths();
        }

        public long getOffset(int i) {
            return this.inputSplitShim.getOffset(i);
        }

        public long getLength(int i) {
            return this.inputSplitShim.getLength(i);
        }

        public int getNumPaths() {
            return this.inputSplitShim.getNumPaths();
        }

        public Path getPath(int i) {
            return this.inputSplitShim.getPath(i);
        }

        public Path[] getPaths() {
            return this.inputSplitShim.getPaths();
        }

        public String[] getLocations() throws IOException {
            return this.inputSplitShim.getLocations();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.inputSplitShim.toString());
            sb.append("InputFormatClass: " + this.inputFormatClassName);
            sb.append("\n");
            return sb.toString();
        }

        public void readFields(DataInput in) throws IOException {
            this.inputFormatClassName = Text.readString((DataInput)in);
            if (HoodieParquetRealtimeInputFormat.class.getName().equals(this.inputFormatClassName)) {
                String inputShimClassName = Text.readString((DataInput)in);
                this.inputSplitShim = (CombineFileSplit)ReflectionUtils.loadClass((String)inputShimClassName);
                this.inputSplitShim.readFields(in);
            } else {
                this.inputSplitShim.readFields(in);
            }
        }

        public void write(DataOutput out) throws IOException {
            if (this.inputFormatClassName == null) {
                if (this.pathToPartitionInfo == null) {
                    this.pathToPartitionInfo = Utilities.getMapWork((Configuration)this.getJob()).getPathToPartitionInfo();
                }
                PartitionDesc part = HoodieCombineHiveInputFormat.getPartitionFromPath(this.pathToPartitionInfo, this.inputSplitShim.getPath(0), IOPrepareCache.get().getPartitionDescMap());
                this.inputFormatClassName = part.getInputFileFormatClass().getName();
            }
            Text.writeString((DataOutput)out, (String)this.inputFormatClassName);
            if (HoodieParquetRealtimeInputFormat.class.getName().equals(this.inputFormatClassName)) {
                Text.writeString((DataOutput)out, (String)this.inputSplitShim.getClass().getName());
            }
            this.inputSplitShim.write(out);
        }
    }

    public static interface AvoidSplitCombination {
        public boolean shouldSkipCombine(Path var1, Configuration var2) throws IOException;
    }
}

