/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ImmutableExponentialHistogramPointData;
import java.util.List;

final class AutoValue_ImmutableExponentialHistogramPointData
extends ImmutableExponentialHistogramPointData {
    private final int scale;
    private final double sum;
    private final long count;
    private final long zeroCount;
    private final ExponentialHistogramBuckets positiveBuckets;
    private final ExponentialHistogramBuckets negativeBuckets;
    private final long startEpochNanos;
    private final long epochNanos;
    private final Attributes attributes;
    private final List<DoubleExemplarData> exemplars;

    AutoValue_ImmutableExponentialHistogramPointData(int scale, double sum, long count, long zeroCount, ExponentialHistogramBuckets positiveBuckets, ExponentialHistogramBuckets negativeBuckets, long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars) {
        this.scale = scale;
        this.sum = sum;
        this.count = count;
        this.zeroCount = zeroCount;
        if (positiveBuckets == null) {
            throw new NullPointerException("Null positiveBuckets");
        }
        this.positiveBuckets = positiveBuckets;
        if (negativeBuckets == null) {
            throw new NullPointerException("Null negativeBuckets");
        }
        this.negativeBuckets = negativeBuckets;
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        if (attributes == null) {
            throw new NullPointerException("Null attributes");
        }
        this.attributes = attributes;
        if (exemplars == null) {
            throw new NullPointerException("Null exemplars");
        }
        this.exemplars = exemplars;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getZeroCount() {
        return this.zeroCount;
    }

    @Override
    public ExponentialHistogramBuckets getPositiveBuckets() {
        return this.positiveBuckets;
    }

    @Override
    public ExponentialHistogramBuckets getNegativeBuckets() {
        return this.negativeBuckets;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public List<DoubleExemplarData> getExemplars() {
        return this.exemplars;
    }

    public String toString() {
        return "ImmutableExponentialHistogramPointData{scale=" + this.scale + ", sum=" + this.sum + ", count=" + this.count + ", zeroCount=" + this.zeroCount + ", positiveBuckets=" + this.positiveBuckets + ", negativeBuckets=" + this.negativeBuckets + ", startEpochNanos=" + this.startEpochNanos + ", epochNanos=" + this.epochNanos + ", attributes=" + this.attributes + ", exemplars=" + this.exemplars + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableExponentialHistogramPointData) {
            ImmutableExponentialHistogramPointData that = (ImmutableExponentialHistogramPointData)o;
            return this.scale == that.getScale() && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(that.getSum()) && this.count == that.getCount() && this.zeroCount == that.getZeroCount() && this.positiveBuckets.equals(that.getPositiveBuckets()) && this.negativeBuckets.equals(that.getNegativeBuckets()) && this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && this.attributes.equals(that.getAttributes()) && this.exemplars.equals(that.getExemplars());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.scale;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.sum) >>> 32 ^ Double.doubleToLongBits(this.sum));
        h$ *= 1000003;
        h$ ^= (int)(this.count >>> 32 ^ this.count);
        h$ *= 1000003;
        h$ ^= (int)(this.zeroCount >>> 32 ^ this.zeroCount);
        h$ *= 1000003;
        h$ ^= this.positiveBuckets.hashCode();
        h$ *= 1000003;
        h$ ^= this.negativeBuckets.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        h$ *= 1000003;
        h$ ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        h$ *= 1000003;
        h$ ^= this.attributes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.exemplars.hashCode();
    }
}

