/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.extended;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.extended.CompoundOperation;
import org.terracotta.statistics.extended.CountOperation;
import org.terracotta.statistics.extended.CountOperationImpl;
import org.terracotta.statistics.extended.ExpiringSampledStatistic;
import org.terracotta.statistics.extended.Result;
import org.terracotta.statistics.extended.ResultImpl;
import org.terracotta.statistics.extended.SampledStatistic;
import org.terracotta.statistics.extended.StatisticType;

public class CompoundOperationImpl<T extends Enum<T>>
implements CompoundOperation<T> {
    private final OperationStatistic<T> source;
    private final Class<T> type;
    private final Map<T, ResultImpl<T>> operations;
    private final ConcurrentMap<Set<T>, ResultImpl<T>> compounds = new ConcurrentHashMap<Set<T>, ResultImpl<T>>();
    private final ConcurrentMap<List<Set<T>>, ExpiringSampledStatistic<Double>> ratios = new ConcurrentHashMap<List<Set<T>>, ExpiringSampledStatistic<Double>>();
    private final ScheduledExecutorService executor;
    private volatile long averagePeriod;
    private volatile TimeUnit averageTimeUnit;
    private volatile int historySize;
    private volatile long historyPeriod;
    private volatile TimeUnit historyTimeUnit;
    private volatile boolean alwaysOn = false;

    public CompoundOperationImpl(OperationStatistic<T> source2, Class<T> type, long averagePeriod, TimeUnit averageTimeUnit, ScheduledExecutorService executor, int historySize, long historyPeriod, TimeUnit historyTimeUnit) {
        this.type = type;
        this.source = source2;
        this.averagePeriod = averagePeriod;
        this.averageTimeUnit = averageTimeUnit;
        this.executor = executor;
        this.historySize = historySize;
        this.historyPeriod = historyPeriod;
        this.historyTimeUnit = historyTimeUnit;
        this.operations = new EnumMap<T, ResultImpl<T>>(type);
        for (Enum result : (Enum[])type.getEnumConstants()) {
            this.operations.put(result, new ResultImpl<Enum>(source2, EnumSet.of(result), averagePeriod, averageTimeUnit, executor, historySize, historyPeriod, historyTimeUnit));
        }
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    @Override
    public Result component(T result) {
        return this.operations.get(result);
    }

    @Override
    public Result compound(EnumSet<T> results) {
        if (results.size() == 1) {
            return this.component((Enum)results.iterator().next());
        }
        EnumSet<T> key = EnumSet.copyOf(results);
        ResultImpl existing = (ResultImpl)this.compounds.get(key);
        if (existing == null) {
            ResultImpl<T> created = new ResultImpl<T>(this.source, key, this.averagePeriod, this.averageTimeUnit, this.executor, this.historySize, this.historyPeriod, this.historyTimeUnit);
            ResultImpl<T> racer = this.compounds.putIfAbsent(key, created);
            if (racer == null) {
                return created;
            }
            return racer;
        }
        return existing;
    }

    @Override
    public CountOperation<T> asCountOperation() {
        return new CountOperationImpl(this);
    }

    @Override
    public SampledStatistic<Double> ratioOf(EnumSet<T> numerator, EnumSet<T> denominator) {
        List<Set> key = Arrays.asList(EnumSet.copyOf(numerator), EnumSet.copyOf(denominator));
        ExpiringSampledStatistic existing = (ExpiringSampledStatistic)this.ratios.get(key);
        if (existing == null) {
            SampledStatistic<Double> denominatorRate;
            final SampledStatistic<Double> numeratorRate = this.compound(numerator).rate();
            ExpiringSampledStatistic<Double> created = new ExpiringSampledStatistic<Double>(new ValueStatistic<Double>(denominatorRate = this.compound(denominator).rate()){
                final /* synthetic */ SampledStatistic val$denominatorRate;
                {
                    this.val$denominatorRate = sampledStatistic2;
                }

                @Override
                public Double value() {
                    return (Double)numeratorRate.value() / (Double)this.val$denominatorRate.value();
                }
            }, this.executor, this.historySize, this.historyPeriod, this.historyTimeUnit, StatisticType.RATIO);
            ExpiringSampledStatistic<Double> racer = this.ratios.putIfAbsent(key, created);
            if (racer == null) {
                return created;
            }
            return racer;
        }
        return existing;
    }

    @Override
    public void setAlwaysOn(boolean enable) {
        this.alwaysOn = enable;
        if (enable) {
            for (ResultImpl<T> resultImpl : this.operations.values()) {
                resultImpl.start();
            }
            for (ResultImpl<Object> resultImpl : this.compounds.values()) {
                resultImpl.start();
            }
            for (ExpiringSampledStatistic expiringSampledStatistic : this.ratios.values()) {
                expiringSampledStatistic.start();
            }
        }
    }

    @Override
    public boolean isAlwaysOn() {
        return this.alwaysOn;
    }

    @Override
    public void setWindow(long time, TimeUnit unit) {
        this.averagePeriod = time;
        this.averageTimeUnit = unit;
        for (ResultImpl<T> resultImpl : this.operations.values()) {
            resultImpl.setWindow(this.averagePeriod, this.averageTimeUnit);
        }
        for (ResultImpl<Object> resultImpl : this.compounds.values()) {
            resultImpl.setWindow(this.averagePeriod, this.averageTimeUnit);
        }
    }

    @Override
    public void setHistory(int samples, long time, TimeUnit unit) {
        this.historySize = samples;
        this.historyPeriod = time;
        this.historyTimeUnit = unit;
        for (ResultImpl<T> resultImpl : this.operations.values()) {
            resultImpl.setHistory(this.historySize, this.historyPeriod, this.historyTimeUnit);
        }
        for (ResultImpl<Object> resultImpl : this.compounds.values()) {
            resultImpl.setHistory(this.historySize, this.historyPeriod, this.historyTimeUnit);
        }
        for (ExpiringSampledStatistic expiringSampledStatistic : this.ratios.values()) {
            expiringSampledStatistic.setHistory(this.historySize, this.historyPeriod, this.historyTimeUnit);
        }
    }

    @Override
    public long getWindowSize(TimeUnit unit) {
        return unit.convert(this.averagePeriod, unit);
    }

    @Override
    public int getHistorySampleSize() {
        return this.historySize;
    }

    @Override
    public long getHistorySampleTime(TimeUnit unit) {
        return unit.convert(this.historySize, unit);
    }

    @Override
    public boolean expire(long expiryTime) {
        if (this.alwaysOn) {
            return false;
        }
        boolean expired = true;
        for (ResultImpl<T> o : this.operations.values()) {
            expired &= o.expire(expiryTime);
        }
        Iterator it = this.compounds.values().iterator();
        while (it.hasNext()) {
            if (!((ResultImpl)it.next()).expire(expiryTime)) continue;
            it.remove();
        }
        it = this.ratios.values().iterator();
        while (it.hasNext()) {
            if (!((ExpiringSampledStatistic)it.next()).expire(expiryTime)) continue;
            it.remove();
        }
        return expired & this.compounds.isEmpty() & this.ratios.isEmpty();
    }
}

