/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.Utf8StringBuffer;

public class UrlEncoded
extends MultiMap {
    public UrlEncoded(UrlEncoded url) {
        super((Map)url);
    }

    public UrlEncoded() {
        super(6);
    }

    public UrlEncoded(String s2) {
        super(6);
        this.decode(s2, "UTF-8");
    }

    public UrlEncoded(String s2, String charset) {
        super(6);
        this.decode(s2, charset);
    }

    public void decode(String query) {
        UrlEncoded.decodeTo(query, this, "UTF-8");
    }

    public void decode(String query, String charset) {
        UrlEncoded.decodeTo(query, this, charset);
    }

    public String encode() {
        return this.encode("UTF-8", false);
    }

    public String encode(String charset) {
        return this.encode(charset, false);
    }

    public synchronized String encode(String charset, boolean equalsForNullValue) {
        return UrlEncoded.encode(this, charset, equalsForNullValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(MultiMap map, String charset, boolean equalsForNullValue) {
        StringBuffer result;
        if (charset == null) {
            charset = "UTF-8";
        }
        StringBuffer stringBuffer = result = new StringBuffer(128);
        synchronized (stringBuffer) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = entry.getKey().toString();
                Object list = entry.getValue();
                int s2 = LazyList.size(list);
                if (s2 == 0) {
                    result.append(UrlEncoded.encodeString(key, charset));
                    if (equalsForNullValue) {
                        result.append('=');
                    }
                } else {
                    for (int i = 0; i < s2; ++i) {
                        if (i > 0) {
                            result.append('&');
                        }
                        Object val = LazyList.get(list, i);
                        result.append(UrlEncoded.encodeString(key, charset));
                        if (val != null) {
                            String str = val.toString();
                            if (str.length() > 0) {
                                result.append('=');
                                result.append(UrlEncoded.encodeString(str, charset));
                                continue;
                            }
                            if (!equalsForNullValue) continue;
                            result.append('=');
                            continue;
                        }
                        if (!equalsForNullValue) continue;
                        result.append('=');
                    }
                }
                if (!iter.hasNext()) continue;
                result.append('&');
            }
            return result.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String content, MultiMap map, String charset) {
        if (charset == null) {
            charset = "UTF-8";
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int mark = -1;
            boolean encoded = false;
            block9: for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                switch (c) {
                    case '&': {
                        int l = i - mark - 1;
                        value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l, charset) : content.substring(mark + 1, i));
                        mark = i;
                        encoded = false;
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        continue block9;
                    }
                    case '=': {
                        if (key != null) continue block9;
                        key = encoded ? UrlEncoded.decodeString(content, mark + 1, i - mark - 1, charset) : content.substring(mark + 1, i);
                        mark = i;
                        encoded = false;
                        continue block9;
                    }
                    case '+': {
                        encoded = true;
                        continue block9;
                    }
                    case '%': {
                        encoded = true;
                    }
                }
            }
            if (key != null) {
                int l = content.length() - mark - 1;
                value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l, charset) : content.substring(mark + 1));
                map.add(key, value);
            } else if (mark < content.length()) {
                key = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                map.add(key, "");
            }
        }
    }

    public static void decodeUtf8To(byte[] raw, int offset, int length, MultiMap map) {
        UrlEncoded.decodeUtf8To(raw, offset, length, map, new Utf8StringBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(byte[] raw, int offset, int length, MultiMap map, Utf8StringBuffer buffer) {
        MultiMap multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int end = offset + length;
            block9: for (int i = offset; i < end; ++i) {
                byte b = raw[i];
                switch ((char)(0xFF & b)) {
                    case '&': {
                        value = buffer.length() == 0 ? "" : buffer.toString();
                        buffer.reset();
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        continue block9;
                    }
                    case '=': {
                        if (key != null) {
                            buffer.append(b);
                            continue block9;
                        }
                        key = buffer.toString();
                        buffer.reset();
                        continue block9;
                    }
                    case '+': {
                        buffer.append((byte)32);
                        continue block9;
                    }
                    case '%': {
                        if (i + 2 >= end) continue block9;
                        buffer.append((byte)((TypeUtil.convertHexDigit(raw[++i]) << 4) + TypeUtil.convertHexDigit(raw[++i])));
                        continue block9;
                    }
                    default: {
                        buffer.append(b);
                    }
                }
            }
            if (key != null) {
                value = buffer.length() == 0 ? "" : buffer.toString();
                buffer.reset();
                map.add(key, value);
            } else if (buffer.length() > 0) {
                map.add(buffer.toString(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode88591To(InputStream in, MultiMap map, int maxLength) throws IOException {
        MultiMap multiMap = map;
        synchronized (multiMap) {
            int b;
            StringBuffer buffer = new StringBuffer();
            String key = null;
            String value = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                switch ((char)b) {
                    case '&': {
                        value = buffer.length() == 0 ? "" : buffer.toString();
                        buffer.setLength(0);
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        break;
                    }
                    case '=': {
                        if (key != null) {
                            buffer.append((char)b);
                            break;
                        }
                        key = buffer.toString();
                        buffer.setLength(0);
                        break;
                    }
                    case '+': {
                        buffer.append(' ');
                        break;
                    }
                    case '%': {
                        int dh = in.read();
                        int dl = in.read();
                        if (dh < 0 || dl < 0) break;
                        buffer.append((char)((TypeUtil.convertHexDigit((byte)dh) << 4) + TypeUtil.convertHexDigit((byte)dl)));
                        break;
                    }
                    default: {
                        buffer.append((char)b);
                    }
                }
                if (maxLength < 0 || ++totalLength <= maxLength) continue;
                throw new IllegalStateException("Form too large");
            }
            if (key != null) {
                value = buffer.length() == 0 ? "" : buffer.toString();
                buffer.setLength(0);
                map.add(key, value);
            } else if (buffer.length() > 0) {
                map.add(buffer.toString(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(InputStream in, MultiMap map, int maxLength) throws IOException {
        MultiMap multiMap = map;
        synchronized (multiMap) {
            int b;
            Utf8StringBuffer buffer = new Utf8StringBuffer();
            String key = null;
            String value = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                switch ((char)b) {
                    case '&': {
                        value = buffer.length() == 0 ? "" : buffer.toString();
                        buffer.reset();
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        break;
                    }
                    case '=': {
                        if (key != null) {
                            buffer.append((byte)b);
                            break;
                        }
                        key = buffer.toString();
                        buffer.reset();
                        break;
                    }
                    case '+': {
                        buffer.append((byte)32);
                        break;
                    }
                    case '%': {
                        int dh = in.read();
                        int dl = in.read();
                        if (dh < 0 || dl < 0) break;
                        buffer.append((byte)((TypeUtil.convertHexDigit((byte)dh) << 4) + TypeUtil.convertHexDigit((byte)dl)));
                        break;
                    }
                    default: {
                        buffer.append((byte)b);
                    }
                }
                if (maxLength < 0 || ++totalLength <= maxLength) continue;
                throw new IllegalStateException("Form too large");
            }
            if (key != null) {
                value = buffer.length() == 0 ? "" : buffer.toString();
                buffer.reset();
                map.add(key, value);
            } else if (buffer.length() > 0) {
                map.add(buffer.toString(), "");
            }
        }
    }

    public static void decodeUtf16To(InputStream in, MultiMap map, int maxLength) throws IOException {
        int c;
        InputStreamReader input = new InputStreamReader(in, "UTF-16");
        StringBuffer buf = new StringBuffer();
        int length = 0;
        if (maxLength < 0) {
            maxLength = Integer.MAX_VALUE;
        }
        while ((c = input.read()) > 0 && length++ < maxLength) {
            buf.append((char)c);
        }
        UrlEncoded.decodeTo(buf.toString(), map, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(InputStream in, MultiMap map, String charset, int maxLength) throws IOException {
        if (charset == null || StringUtil.__ISO_8859_1.equals(charset)) {
            UrlEncoded.decode88591To(in, map, maxLength);
            return;
        }
        if ("UTF-8".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf8To(in, map, maxLength);
            return;
        }
        if ("UTF-16".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf16To(in, map, maxLength);
            return;
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            int c;
            String key = null;
            String value = null;
            byte digit = 0;
            int digits = 0;
            int totalLength = 0;
            ByteArrayOutputStream2 output = new ByteArrayOutputStream2();
            int size = 0;
            while ((c = in.read()) > 0) {
                switch ((char)c) {
                    case '&': {
                        size = output.size();
                        value = size == 0 ? "" : output.toString(charset);
                        output.setCount(0);
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        break;
                    }
                    case '=': {
                        if (key != null) {
                            output.write(c);
                            break;
                        }
                        size = output.size();
                        key = size == 0 ? "" : output.toString(charset);
                        output.setCount(0);
                        break;
                    }
                    case '+': {
                        output.write(32);
                        break;
                    }
                    case '%': {
                        digits = 2;
                        break;
                    }
                    default: {
                        if (digits == 2) {
                            digit = TypeUtil.convertHexDigit((byte)c);
                            digits = 1;
                            break;
                        }
                        if (digits == 1) {
                            output.write((digit << 4) + TypeUtil.convertHexDigit((byte)c));
                            digits = 0;
                            break;
                        }
                        output.write(c);
                    }
                }
                if (maxLength < 0 || ++totalLength <= maxLength) continue;
                throw new IllegalStateException("Form too large");
            }
            size = output.size();
            if (key != null) {
                value = size == 0 ? "" : output.toString(charset);
                output.setCount(0);
                map.add(key, value);
            } else if (size > 0) {
                map.add(output.toString(charset), "");
            }
        }
    }

    public static String decodeString(String encoded, int offset, int length, String charset) {
        if (charset == null || StringUtil.isUTF8(charset)) {
            Utf8StringBuffer buffer = null;
            for (int i = 0; i < length; ++i) {
                char c = encoded.charAt(offset + i);
                if (c < '\u0000' || c > '\u00ff') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        buffer.getStringBuffer().append(encoded, offset, offset + i + 1);
                        continue;
                    }
                    buffer.getStringBuffer().append(c);
                    continue;
                }
                if (c == '+') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        buffer.getStringBuffer().append(encoded, offset, offset + i);
                    }
                    buffer.getStringBuffer().append(' ');
                    continue;
                }
                if (c == '%' && i + 2 < length) {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        buffer.getStringBuffer().append(encoded, offset, offset + i);
                    }
                    while (c == '%' && i + 2 < length) {
                        byte b = (byte)TypeUtil.parseInt(encoded, offset + i + 1, 2, 16);
                        buffer.append(b);
                        if ((i += 3) >= length) continue;
                        c = encoded.charAt(offset + i);
                    }
                    --i;
                    continue;
                }
                if (buffer == null) continue;
                buffer.getStringBuffer().append(c);
            }
            if (buffer == null) {
                if (offset == 0 && encoded.length() == length) {
                    return encoded;
                }
                return encoded.substring(offset, offset + length);
            }
            return buffer.toString();
        }
        StringBuffer buffer = null;
        try {
            for (int i = 0; i < length; ++i) {
                char c = encoded.charAt(offset + i);
                if (c < '\u0000' || c > '\u00ff') {
                    if (buffer == null) {
                        buffer = new StringBuffer(length);
                        buffer.append(encoded, offset, offset + i + 1);
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                if (c == '+') {
                    if (buffer == null) {
                        buffer = new StringBuffer(length);
                        buffer.append(encoded, offset, offset + i);
                    }
                    buffer.append(' ');
                    continue;
                }
                if (c == '%' && i + 2 < length) {
                    if (buffer == null) {
                        buffer = new StringBuffer(length);
                        buffer.append(encoded, offset, offset + i);
                    }
                    byte[] ba = new byte[length];
                    int n = 0;
                    while (c >= '\u0000' && c <= '\u00ff') {
                        if (c == '%') {
                            ba[n++] = (byte)TypeUtil.parseInt(encoded, offset + i + 1, 2, 16);
                            i += 3;
                        } else {
                            ba[n++] = (byte)c;
                            ++i;
                        }
                        if (i >= length) break;
                        c = encoded.charAt(offset + i);
                    }
                    --i;
                    buffer.append(new String(ba, 0, n, charset));
                    continue;
                }
                if (buffer == null) continue;
                buffer.append(c);
            }
            if (buffer == null) {
                if (offset == 0 && encoded.length() == length) {
                    return encoded;
                }
                return encoded.substring(offset, offset + length);
            }
            return buffer.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, "UTF-8");
    }

    public static String encodeString(String string, String charset) {
        if (charset == null) {
            charset = "UTF-8";
        }
        byte[] bytes = null;
        try {
            bytes = string.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            bytes = string.getBytes();
        }
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
                continue;
            }
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) {
                encoded[n++] = b;
                continue;
            }
            noEncode = false;
            encoded[n++] = 37;
            byte nibble = (byte)((b & 0xF0) >> 4);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            nibble = (byte)(b & 0xF);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
        }
        if (noEncode) {
            return string;
        }
        try {
            return new String(encoded, 0, n, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(encoded, 0, n);
        }
    }

    public Object clone() {
        return new UrlEncoded(this);
    }
}

