/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class ServerConfig {
    protected InetSocketAddress clientPortAddress;
    protected String dataDir;
    protected String dataLogDir;
    protected int tickTime = 3000;
    protected int maxClientCnxns;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;

    public void parse(String[] args2) {
        if (args2.length < 2 || args2.length > 4) {
            throw new IllegalArgumentException("Invalid args:" + Arrays.toString(args2));
        }
        this.clientPortAddress = new InetSocketAddress(Integer.parseInt(args2[0]));
        this.dataLogDir = this.dataDir = args2[1];
        if (args2.length == 3) {
            this.tickTime = Integer.parseInt(args2[2]);
        }
        if (args2.length == 4) {
            this.maxClientCnxns = Integer.parseInt(args2[3]);
        }
    }

    public void parse(String path) throws QuorumPeerConfig.ConfigException {
        QuorumPeerConfig config = new QuorumPeerConfig();
        config.parse(path);
        this.readFrom(config);
    }

    public void readFrom(QuorumPeerConfig config) {
        this.clientPortAddress = config.getClientPortAddress();
        this.dataDir = config.getDataDir();
        this.dataLogDir = config.getDataLogDir();
        this.tickTime = config.getTickTime();
        this.maxClientCnxns = config.getMaxClientCnxns();
        this.minSessionTimeout = config.getMinSessionTimeout();
        this.maxSessionTimeout = config.getMaxSessionTimeout();
    }

    public InetSocketAddress getClientPortAddress() {
        return this.clientPortAddress;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getDataLogDir() {
        return this.dataLogDir;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMaxClientCnxns() {
        return this.maxClientCnxns;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }
}

