/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security;

import java.security.SecureRandom;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.security.MasterKeyData;

public class BaseContainerTokenSecretManager
extends SecretManager<ContainerTokenIdentifier> {
    private static Log LOG = LogFactory.getLog(BaseContainerTokenSecretManager.class);
    protected int serialNo = new SecureRandom().nextInt();
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected MasterKeyData currentMasterKey;
    protected final long containerTokenExpiryInterval;

    public BaseContainerTokenSecretManager(Configuration conf) {
        this.containerTokenExpiryInterval = conf.getInt("yarn.resourcemanager.rm.container-allocation.expiry-interval-ms", 600000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MasterKeyData createNewMasterKey() {
        this.writeLock.lock();
        try {
            MasterKeyData masterKeyData = new MasterKeyData(this.serialNo++, this.generateSecret());
            return masterKeyData;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public MasterKey getCurrentKey() {
        this.readLock.lock();
        try {
            MasterKey masterKey = this.currentMasterKey.getMasterKey();
            return masterKey;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] createPassword(ContainerTokenIdentifier identifier) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating password for " + identifier.getContainerID() + " for user " + identifier.getUser() + " to be run on NM " + identifier.getNmHostAddress());
        }
        this.readLock.lock();
        try {
            byte[] byArray = BaseContainerTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.currentMasterKey.getSecretKey());
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrievePassword(ContainerTokenIdentifier identifier) throws SecretManager.InvalidToken {
        this.readLock.lock();
        try {
            byte[] byArray = this.retrievePasswordInternal(identifier, this.currentMasterKey);
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected byte[] retrievePasswordInternal(ContainerTokenIdentifier identifier, MasterKeyData masterKey) throws SecretManager.InvalidToken {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving password for " + identifier.getContainerID() + " for user " + identifier.getUser() + " to be run on NM " + identifier.getNmHostAddress());
        }
        return BaseContainerTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)masterKey.getSecretKey());
    }

    public ContainerTokenIdentifier createIdentifier() {
        return new ContainerTokenIdentifier();
    }
}

