/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.scheduler;

import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;

public class ResourceRequestSetKey
extends SchedulerRequestKey {
    private final Resource resource;
    private final ExecutionType execType;

    public ResourceRequestSetKey(ResourceRequest rr) throws YarnException {
        this(rr.getAllocationRequestId(), rr.getPriority(), rr.getCapability(), rr.getExecutionTypeRequest() == null ? ExecutionType.GUARANTEED : rr.getExecutionTypeRequest().getExecutionType());
        if (rr.getPriority() == null) {
            throw new YarnException("Null priority in RR: " + rr);
        }
        if (rr.getCapability() == null) {
            throw new YarnException("Null resource in RR: " + rr);
        }
    }

    public ResourceRequestSetKey(long allocationRequestId, Priority priority, Resource resource, ExecutionType execType) {
        super(priority, allocationRequestId, null);
        this.resource = resource == null ? Resource.newInstance(0, 0) : resource;
        this.execType = execType == null ? ExecutionType.GUARANTEED : execType;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ExecutionType getExeType() {
        return this.execType;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SchedulerRequestKey)) {
            return false;
        }
        if (!(obj instanceof ResourceRequestSetKey)) {
            return super.equals(obj);
        }
        ResourceRequestSetKey other = (ResourceRequestSetKey)obj;
        return super.equals(other) && this.resource.equals(other.resource) && this.execType.equals((Object)other.execType);
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 37 + this.resource.hashCode()) * 41 + this.execType.hashCode();
    }

    @Override
    public int compareTo(SchedulerRequestKey other) {
        int ret = super.compareTo(other);
        if (ret != 0) {
            return ret;
        }
        if (!(other instanceof ResourceRequestSetKey)) {
            return ret;
        }
        ResourceRequestSetKey otherKey = (ResourceRequestSetKey)other;
        ret = this.resource.compareTo(otherKey.resource);
        if (ret != 0) {
            return ret;
        }
        return this.execType.compareTo(otherKey.execType);
    }

    @Override
    public String toString() {
        return "[id:" + this.getAllocationRequestId() + " p:" + this.getPriority().getPriority() + (this.execType.equals((Object)ExecutionType.GUARANTEED) ? " G" : " O r:" + this.resource + "]");
    }
}

