/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.scheduler;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoteNode;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerAllocator;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpportunisticContainerContext {
    private static final Logger LOG = LoggerFactory.getLogger(OpportunisticContainerContext.class);
    private OpportunisticContainerAllocator.AllocationParams appParams = new OpportunisticContainerAllocator.AllocationParams();
    private OpportunisticContainerAllocator.ContainerIdGenerator containerIdGenerator = new OpportunisticContainerAllocator.ContainerIdGenerator();
    private volatile List<RemoteNode> nodeList = new LinkedList<RemoteNode>();
    private final LinkedHashMap<String, RemoteNode> nodeMap = new LinkedHashMap();
    private final Set<String> blacklist = new HashSet<String>();
    private final TreeMap<SchedulerRequestKey, Map<Resource, OpportunisticContainerAllocator.EnrichedResourceRequest>> outstandingOpReqs = new TreeMap();

    public OpportunisticContainerAllocator.AllocationParams getAppParams() {
        return this.appParams;
    }

    public OpportunisticContainerAllocator.ContainerIdGenerator getContainerIdGenerator() {
        return this.containerIdGenerator;
    }

    public void setContainerIdGenerator(OpportunisticContainerAllocator.ContainerIdGenerator containerIdGenerator) {
        this.containerIdGenerator = containerIdGenerator;
    }

    public Map<String, RemoteNode> getNodeMap() {
        return Collections.unmodifiableMap(this.nodeMap);
    }

    public synchronized void updateNodeList(List<RemoteNode> newNodeList) {
        if (newNodeList != this.nodeList) {
            this.nodeList = newNodeList;
            this.nodeMap.clear();
            for (RemoteNode n : this.nodeList) {
                this.nodeMap.put(n.getNodeId().getHost(), n);
            }
        }
    }

    public void updateAllocationParams(Resource minResource, Resource maxResource, Resource incrResource, int containerTokenExpiryInterval) {
        this.appParams.setMinResource(minResource);
        this.appParams.setMaxResource(maxResource);
        this.appParams.setIncrementResource(incrResource);
        this.appParams.setContainerTokenExpiryInterval(containerTokenExpiryInterval);
    }

    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    public TreeMap<SchedulerRequestKey, Map<Resource, OpportunisticContainerAllocator.EnrichedResourceRequest>> getOutstandingOpReqs() {
        return this.outstandingOpReqs;
    }

    public void addToOutstandingReqs(List<ResourceRequest> resourceAsks) {
        for (ResourceRequest request : resourceAsks) {
            OpportunisticContainerAllocator.EnrichedResourceRequest eReq;
            SchedulerRequestKey schedulerKey = SchedulerRequestKey.create(request);
            Map<Resource, OpportunisticContainerAllocator.EnrichedResourceRequest> reqMap = this.outstandingOpReqs.get(schedulerKey);
            if (reqMap == null) {
                reqMap = new HashMap<Resource, OpportunisticContainerAllocator.EnrichedResourceRequest>();
                this.outstandingOpReqs.put(schedulerKey, reqMap);
            }
            if ((eReq = reqMap.get(request.getCapability())) == null) {
                eReq = new OpportunisticContainerAllocator.EnrichedResourceRequest(request);
                reqMap.put(request.getCapability(), eReq);
            }
            if (ResourceRequest.isAnyLocation(request.getResourceName())) {
                eReq.getRequest().setResourceName("*");
                eReq.getRequest().setNumContainers(request.getNumContainers());
            } else {
                eReq.addLocation(request.getResourceName(), request.getNumContainers());
            }
            if (!ResourceRequest.isAnyLocation(request.getResourceName())) continue;
            LOG.info("# of outstandingOpReqs in ANY (at priority = " + schedulerKey.getPriority() + ", allocationReqId = " + schedulerKey.getAllocationRequestId() + ", with capability = " + request.getCapability() + " ) : " + ", with location = " + request.getResourceName() + " ) : " + ", numContainers = " + eReq.getRequest().getNumContainers());
        }
    }

    public void matchAllocationToOutstandingRequest(Resource capability, List<OpportunisticContainerAllocator.Allocation> allocations) {
        for (OpportunisticContainerAllocator.Allocation allocation : allocations) {
            OpportunisticContainerAllocator.EnrichedResourceRequest err;
            SchedulerRequestKey schedulerKey = SchedulerRequestKey.extractFrom(allocation.getContainer());
            Map<Resource, OpportunisticContainerAllocator.EnrichedResourceRequest> asks = this.outstandingOpReqs.get(schedulerKey);
            if (asks == null || (err = asks.get(capability)) == null) continue;
            int numContainers = err.getRequest().getNumContainers();
            err.getRequest().setNumContainers(--numContainers);
            if (numContainers == 0) {
                asks.remove(capability);
                if (asks.size() != 0) continue;
                this.outstandingOpReqs.remove(schedulerKey);
                continue;
            }
            if (ResourceRequest.isAnyLocation(allocation.getResourceName())) continue;
            err.removeLocation(allocation.getResourceName());
        }
    }
}

