/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class ApplicationHomeSubCluster {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationHomeSubCluster newInstance(ApplicationId appId, SubClusterId homeSubCluster) {
        ApplicationHomeSubCluster appMapping = Records.newRecord(ApplicationHomeSubCluster.class);
        appMapping.setApplicationId(appId);
        appMapping.setHomeSubCluster(homeSubCluster);
        return appMapping;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ApplicationId getApplicationId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationId(ApplicationId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract SubClusterId getHomeSubCluster();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setHomeSubCluster(SubClusterId var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationHomeSubCluster other = (ApplicationHomeSubCluster)obj;
        if (!this.getApplicationId().equals(other.getApplicationId())) {
            return false;
        }
        return this.getHomeSubCluster().equals(other.getHomeSubCluster());
    }

    public int hashCode() {
        return this.getApplicationId().hashCode() * 31 + this.getHomeSubCluster().hashCode();
    }

    public String toString() {
        return "ApplicationHomeSubCluster [getApplicationId()=" + this.getApplicationId() + ", getHomeSubCluster()=" + this.getHomeSubCluster() + "]";
    }
}

