/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import com.zaxxer.hikari.HikariDataSource;
import java.nio.ByteBuffer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreInvalidInputException;
import org.apache.hadoop.yarn.server.federation.store.metrics.FederationStateStoreClientMetrics;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationApplicationHomeSubClusterStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationMembershipStateStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationPolicyStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationStateStoreUtils;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLFederationStateStore
implements FederationStateStore {
    public static final Logger LOG = LoggerFactory.getLogger(SQLFederationStateStore.class);
    private static final String CALL_SP_REGISTER_SUBCLUSTER = "{call sp_registerSubCluster(?, ?, ?, ?, ?, ?, ?, ?, ?)}";
    private static final String CALL_SP_DEREGISTER_SUBCLUSTER = "{call sp_deregisterSubCluster(?, ?, ?)}";
    private static final String CALL_SP_GET_SUBCLUSTER = "{call sp_getSubCluster(?, ?, ?, ?, ?, ?, ?, ?, ?)}";
    private static final String CALL_SP_GET_SUBCLUSTERS = "{call sp_getSubClusters()}";
    private static final String CALL_SP_SUBCLUSTER_HEARTBEAT = "{call sp_subClusterHeartbeat(?, ?, ?, ?)}";
    private static final String CALL_SP_ADD_APPLICATION_HOME_SUBCLUSTER = "{call sp_addApplicationHomeSubCluster(?, ?, ?, ?)}";
    private static final String CALL_SP_UPDATE_APPLICATION_HOME_SUBCLUSTER = "{call sp_updateApplicationHomeSubCluster(?, ?, ?)}";
    private static final String CALL_SP_DELETE_APPLICATION_HOME_SUBCLUSTER = "{call sp_deleteApplicationHomeSubCluster(?, ?)}";
    private static final String CALL_SP_GET_APPLICATION_HOME_SUBCLUSTER = "{call sp_getApplicationHomeSubCluster(?, ?)}";
    private static final String CALL_SP_GET_APPLICATIONS_HOME_SUBCLUSTER = "{call sp_getApplicationsHomeSubCluster()}";
    private static final String CALL_SP_SET_POLICY_CONFIGURATION = "{call sp_setPolicyConfiguration(?, ?, ?, ?)}";
    private static final String CALL_SP_GET_POLICY_CONFIGURATION = "{call sp_getPolicyConfiguration(?, ?, ?)}";
    private static final String CALL_SP_GET_POLICIES_CONFIGURATIONS = "{call sp_getPoliciesConfigurations()}";
    private Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private String userName;
    private String password;
    private String driverClass;
    private String url;
    private int maximumPoolSize;
    private HikariDataSource dataSource = null;
    private final Clock clock = new MonotonicClock();

    @Override
    public void init(Configuration conf) throws YarnException {
        this.driverClass = conf.get("yarn.federation.state-store.sql.jdbc-class", "org.hsqldb.jdbc.JDBCDataSource");
        this.maximumPoolSize = conf.getInt("yarn.federation.state-store.sql.max-connections", 1);
        this.userName = conf.get("yarn.federation.state-store.sql.username");
        this.password = conf.get("yarn.federation.state-store.sql.password");
        this.url = conf.get("yarn.federation.state-store.sql.url");
        try {
            Class.forName(this.driverClass);
        }
        catch (ClassNotFoundException e) {
            FederationStateStoreUtils.logAndThrowException(LOG, "Driver class not found.", e);
        }
        this.dataSource = new HikariDataSource();
        this.dataSource.setDataSourceClassName(this.driverClass);
        FederationStateStoreUtils.setUsername(this.dataSource, this.userName);
        FederationStateStoreUtils.setPassword(this.dataSource, this.password);
        FederationStateStoreUtils.setProperty(this.dataSource, "url", this.url);
        this.dataSource.setMaximumPoolSize(this.maximumPoolSize);
        LOG.info("Initialized connection pool to the Federation StateStore database at address: " + this.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubClusterRegisterResponse registerSubCluster(SubClusterRegisterRequest registerSubClusterRequest) throws YarnException {
        FederationMembershipStateStoreInputValidator.validate(registerSubClusterRequest);
        CallableStatement cstmt = null;
        Connection conn = null;
        SubClusterInfo subClusterInfo = registerSubClusterRequest.getSubClusterInfo();
        SubClusterId subClusterId = subClusterInfo.getSubClusterId();
        try {
            String errMsg;
            conn = this.getConnection();
            cstmt = conn.prepareCall(CALL_SP_REGISTER_SUBCLUSTER);
            cstmt.setString(1, subClusterId.getId());
            cstmt.setString(2, subClusterInfo.getAMRMServiceAddress());
            cstmt.setString(3, subClusterInfo.getClientRMServiceAddress());
            cstmt.setString(4, subClusterInfo.getRMAdminServiceAddress());
            cstmt.setString(5, subClusterInfo.getRMWebServiceAddress());
            cstmt.setString(6, subClusterInfo.getState().toString());
            cstmt.setLong(7, subClusterInfo.getLastStartTime());
            cstmt.setString(8, subClusterInfo.getCapability());
            cstmt.registerOutParameter(9, 4);
            long startTime = this.clock.getTime();
            cstmt.executeUpdate();
            long stopTime = this.clock.getTime();
            if (cstmt.getInt(9) == 0) {
                errMsg = "SubCluster " + subClusterId + " was not registered into the StateStore";
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            if (cstmt.getInt(9) != 1) {
                errMsg = "Wrong behavior during registration of SubCluster " + subClusterId + " into the StateStore";
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            LOG.info("Registered the SubCluster " + subClusterId + " into the StateStore");
            FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
        }
        catch (SQLException e) {
            try {
                FederationStateStoreClientMetrics.failedStateStoreCall();
                FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to register the SubCluster " + subClusterId + " into the StateStore", e);
            }
            catch (Throwable throwable) {
                FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
                throw throwable;
            }
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        }
        FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        return SubClusterRegisterResponse.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubClusterDeregisterResponse deregisterSubCluster(SubClusterDeregisterRequest subClusterDeregisterRequest) throws YarnException {
        FederationMembershipStateStoreInputValidator.validate(subClusterDeregisterRequest);
        CallableStatement cstmt = null;
        Connection conn = null;
        SubClusterId subClusterId = subClusterDeregisterRequest.getSubClusterId();
        SubClusterState state = subClusterDeregisterRequest.getState();
        try {
            String errMsg;
            conn = this.getConnection();
            cstmt = conn.prepareCall(CALL_SP_DEREGISTER_SUBCLUSTER);
            cstmt.setString(1, subClusterId.getId());
            cstmt.setString(2, state.toString());
            cstmt.registerOutParameter(3, 4);
            long startTime = this.clock.getTime();
            cstmt.executeUpdate();
            long stopTime = this.clock.getTime();
            if (cstmt.getInt(3) == 0) {
                errMsg = "SubCluster " + subClusterId + " not found";
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            if (cstmt.getInt(3) != 1) {
                errMsg = "Wrong behavior during deregistration of SubCluster " + subClusterId + " from the StateStore";
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            LOG.info("Deregistered the SubCluster " + subClusterId + " state to " + state.toString());
            FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
        }
        catch (SQLException e) {
            try {
                FederationStateStoreClientMetrics.failedStateStoreCall();
                FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to deregister the sub-cluster " + subClusterId + " state to " + state.toString(), e);
            }
            catch (Throwable throwable) {
                FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
                throw throwable;
            }
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        }
        FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        return SubClusterDeregisterResponse.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubClusterHeartbeatResponse subClusterHeartbeat(SubClusterHeartbeatRequest subClusterHeartbeatRequest) throws YarnException {
        FederationMembershipStateStoreInputValidator.validate(subClusterHeartbeatRequest);
        CallableStatement cstmt = null;
        Connection conn = null;
        SubClusterId subClusterId = subClusterHeartbeatRequest.getSubClusterId();
        SubClusterState state = subClusterHeartbeatRequest.getState();
        try {
            String errMsg;
            conn = this.getConnection();
            cstmt = conn.prepareCall(CALL_SP_SUBCLUSTER_HEARTBEAT);
            cstmt.setString(1, subClusterId.getId());
            cstmt.setString(2, state.toString());
            cstmt.setString(3, subClusterHeartbeatRequest.getCapability());
            cstmt.registerOutParameter(4, 4);
            long startTime = this.clock.getTime();
            cstmt.executeUpdate();
            long stopTime = this.clock.getTime();
            if (cstmt.getInt(4) == 0) {
                errMsg = "SubCluster " + subClusterId.toString() + " does not exist; cannot heartbeat";
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            if (cstmt.getInt(4) != 1) {
                errMsg = "Wrong behavior during the heartbeat of SubCluster " + subClusterId;
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            LOG.info("Heartbeated the StateStore for the specified SubCluster " + subClusterId);
            FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
        }
        catch (SQLException e) {
            try {
                FederationStateStoreClientMetrics.failedStateStoreCall();
                FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to heartbeat the StateStore for the specified SubCluster " + subClusterId, e);
            }
            catch (Throwable throwable) {
                FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
                throw throwable;
            }
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        }
        FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        return SubClusterHeartbeatResponse.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubClusterInfoResponse getSubCluster(GetSubClusterInfoRequest subClusterRequest) throws YarnException {
        SubClusterInfo subClusterInfo;
        Connection conn;
        CallableStatement cstmt;
        block8: {
            String webAppAddress;
            String rmAdminAddress;
            String clientRMAddress;
            String amRMAddress;
            long stopTime;
            long startTime;
            SubClusterId subClusterId;
            block7: {
                FederationMembershipStateStoreInputValidator.validate(subClusterRequest);
                cstmt = null;
                conn = null;
                subClusterInfo = null;
                subClusterId = subClusterRequest.getSubClusterId();
                conn = this.getConnection();
                cstmt = conn.prepareCall(CALL_SP_GET_SUBCLUSTER);
                cstmt.setString(1, subClusterId.getId());
                cstmt.registerOutParameter(2, 12);
                cstmt.registerOutParameter(3, 12);
                cstmt.registerOutParameter(4, 12);
                cstmt.registerOutParameter(5, 12);
                cstmt.registerOutParameter(6, 93);
                cstmt.registerOutParameter(7, 12);
                cstmt.registerOutParameter(8, -5);
                cstmt.registerOutParameter(9, 12);
                startTime = this.clock.getTime();
                cstmt.execute();
                stopTime = this.clock.getTime();
                amRMAddress = cstmt.getString(2);
                clientRMAddress = cstmt.getString(3);
                rmAdminAddress = cstmt.getString(4);
                webAppAddress = cstmt.getString(5);
                if (amRMAddress != null && clientRMAddress != null) break block7;
                LOG.warn("The queried SubCluster: {} does not exist.", (Object)subClusterId);
                GetSubClusterInfoResponse getSubClusterInfoResponse = null;
                FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
                return getSubClusterInfoResponse;
            }
            try {
                Timestamp heartBeatTimeStamp = cstmt.getTimestamp(6, this.utcCalendar);
                long lastHeartBeat = heartBeatTimeStamp != null ? heartBeatTimeStamp.getTime() : 0L;
                SubClusterState state = SubClusterState.fromString(cstmt.getString(7));
                long lastStartTime = cstmt.getLong(8);
                String capability = cstmt.getString(9);
                subClusterInfo = SubClusterInfo.newInstance(subClusterId, amRMAddress, clientRMAddress, rmAdminAddress, webAppAddress, lastHeartBeat, state, lastStartTime, capability);
                FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
                try {
                    FederationMembershipStateStoreInputValidator.checkSubClusterInfo(subClusterInfo);
                }
                catch (FederationStateStoreInvalidInputException e) {
                    String errMsg = "SubCluster " + subClusterId.toString() + " does not exist";
                    FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
                }
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug("Got the information about the specified SubCluster " + subClusterInfo.toString());
            }
            catch (SQLException e) {
                try {
                    FederationStateStoreClientMetrics.failedStateStoreCall();
                    FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to obtain the SubCluster information for " + subClusterId, e);
                }
                catch (Throwable throwable) {
                    FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
                    throw throwable;
                }
                FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
            }
        }
        FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        return GetSubClusterInfoResponse.newInstance(subClusterInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubClustersInfoResponse getSubClusters(GetSubClustersInfoRequest subClustersRequest) throws YarnException {
        CallableStatement cstmt = null;
        Connection conn = null;
        ResultSet rs = null;
        ArrayList<SubClusterInfo> subClusters = new ArrayList<SubClusterInfo>();
        try {
            conn = this.getConnection();
            cstmt = conn.prepareCall(CALL_SP_GET_SUBCLUSTERS);
            long startTime = this.clock.getTime();
            rs = cstmt.executeQuery();
            long stopTime = this.clock.getTime();
            while (rs.next()) {
                String subClusterName = rs.getString(1);
                String amRMAddress = rs.getString(2);
                String clientRMAddress = rs.getString(3);
                String rmAdminAddress = rs.getString(4);
                String webAppAddress = rs.getString(5);
                long lastHeartBeat = rs.getTimestamp(6, this.utcCalendar).getTime();
                SubClusterState state = SubClusterState.fromString(rs.getString(7));
                long lastStartTime = rs.getLong(8);
                String capability = rs.getString(9);
                SubClusterId subClusterId = SubClusterId.newInstance(subClusterName);
                SubClusterInfo subClusterInfo = SubClusterInfo.newInstance(subClusterId, amRMAddress, clientRMAddress, rmAdminAddress, webAppAddress, lastHeartBeat, state, lastStartTime, capability);
                FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
                try {
                    FederationMembershipStateStoreInputValidator.checkSubClusterInfo(subClusterInfo);
                }
                catch (FederationStateStoreInvalidInputException e) {
                    String errMsg = "SubCluster " + subClusterId.toString() + " is not valid";
                    FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
                }
                if (subClustersRequest.getFilterInactiveSubClusters() && !subClusterInfo.getState().isActive()) continue;
                subClusters.add(subClusterInfo);
            }
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn, rs);
        }
        catch (SQLException e) {
            FederationStateStoreClientMetrics.failedStateStoreCall();
            FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to obtain the information for all the SubClusters ", e);
        }
        finally {
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn, rs);
        }
        return GetSubClustersInfoResponse.newInstance(subClusters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddApplicationHomeSubClusterResponse addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest request) throws YarnException {
        String subClusterHome;
        Connection conn;
        CallableStatement cstmt;
        block8: {
            FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
            cstmt = null;
            conn = null;
            subClusterHome = null;
            ApplicationId appId = request.getApplicationHomeSubCluster().getApplicationId();
            SubClusterId subClusterId = request.getApplicationHomeSubCluster().getHomeSubCluster();
            try {
                conn = this.getConnection();
                cstmt = conn.prepareCall(CALL_SP_ADD_APPLICATION_HOME_SUBCLUSTER);
                cstmt.setString(1, appId.toString());
                cstmt.setString(2, subClusterId.getId());
                cstmt.registerOutParameter(3, 12);
                cstmt.registerOutParameter(4, 4);
                long startTime = this.clock.getTime();
                cstmt.executeUpdate();
                long stopTime = this.clock.getTime();
                subClusterHome = cstmt.getString(3);
                SubClusterId subClusterIdHome = SubClusterId.newInstance(subClusterHome);
                FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
                if (subClusterId.equals(subClusterIdHome)) {
                    String errMsg;
                    if (cstmt.getInt(4) == 0) {
                        errMsg = "The application " + appId + " was not insert into the StateStore";
                        FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
                    }
                    if (cstmt.getInt(4) != 1) {
                        errMsg = "Wrong behavior during the insertion of SubCluster " + subClusterId;
                        FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
                    }
                    LOG.info("Insert into the StateStore the application: " + appId + " in SubCluster:  " + subClusterHome);
                    break block8;
                }
                if (cstmt.getInt(4) != 0) {
                    String errMsg = "The application " + appId + " does exist but was overwritten";
                    FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
                }
                LOG.info("Application: " + appId + " already present with SubCluster:  " + subClusterHome);
            }
            catch (SQLException e) {
                try {
                    FederationStateStoreClientMetrics.failedStateStoreCall();
                    FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to insert the newly generated application " + request.getApplicationHomeSubCluster().getApplicationId(), e);
                }
                catch (Throwable throwable) {
                    FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
                    throw throwable;
                }
                FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
            }
        }
        FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        return AddApplicationHomeSubClusterResponse.newInstance(SubClusterId.newInstance(subClusterHome));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationHomeSubClusterResponse updateApplicationHomeSubCluster(UpdateApplicationHomeSubClusterRequest request) throws YarnException {
        FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
        CallableStatement cstmt = null;
        Connection conn = null;
        ApplicationId appId = request.getApplicationHomeSubCluster().getApplicationId();
        SubClusterId subClusterId = request.getApplicationHomeSubCluster().getHomeSubCluster();
        try {
            String errMsg;
            conn = this.getConnection();
            cstmt = conn.prepareCall(CALL_SP_UPDATE_APPLICATION_HOME_SUBCLUSTER);
            cstmt.setString(1, appId.toString());
            cstmt.setString(2, subClusterId.getId());
            cstmt.registerOutParameter(3, 4);
            long startTime = this.clock.getTime();
            cstmt.executeUpdate();
            long stopTime = this.clock.getTime();
            if (cstmt.getInt(3) == 0) {
                errMsg = "Application " + appId + " does not exist";
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            if (cstmt.getInt(3) != 1) {
                errMsg = "Wrong behavior during the update of SubCluster " + subClusterId;
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            LOG.info("Update the SubCluster to {} for application {} in the StateStore", (Object)subClusterId, (Object)appId);
            FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
        }
        catch (SQLException e) {
            try {
                FederationStateStoreClientMetrics.failedStateStoreCall();
                FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to update the application " + request.getApplicationHomeSubCluster().getApplicationId(), e);
            }
            catch (Throwable throwable) {
                FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
                throw throwable;
            }
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        }
        FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        return UpdateApplicationHomeSubClusterResponse.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApplicationHomeSubClusterResponse getApplicationHomeSubCluster(GetApplicationHomeSubClusterRequest request) throws YarnException {
        FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
        CallableStatement cstmt = null;
        Connection conn = null;
        SubClusterId homeRM = null;
        try {
            conn = this.getConnection();
            cstmt = conn.prepareCall(CALL_SP_GET_APPLICATION_HOME_SUBCLUSTER);
            cstmt.setString(1, request.getApplicationId().toString());
            cstmt.registerOutParameter(2, 12);
            long startTime = this.clock.getTime();
            cstmt.execute();
            long stopTime = this.clock.getTime();
            if (cstmt.getString(2) != null) {
                homeRM = SubClusterId.newInstance(cstmt.getString(2));
            } else {
                String errMsg = "Application " + request.getApplicationId() + " does not exist";
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got the information about the specified application  " + request.getApplicationId() + ". The AM is running in " + homeRM);
            }
            FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
        }
        catch (SQLException e) {
            try {
                FederationStateStoreClientMetrics.failedStateStoreCall();
                FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to obtain the application information for the specified application " + request.getApplicationId(), e);
            }
            catch (Throwable throwable) {
                FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
                throw throwable;
            }
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        }
        FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        return GetApplicationHomeSubClusterResponse.newInstance(ApplicationHomeSubCluster.newInstance(request.getApplicationId(), homeRM));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApplicationsHomeSubClusterResponse getApplicationsHomeSubCluster(GetApplicationsHomeSubClusterRequest request) throws YarnException {
        CallableStatement cstmt = null;
        Connection conn = null;
        ResultSet rs = null;
        ArrayList<ApplicationHomeSubCluster> appsHomeSubClusters = new ArrayList<ApplicationHomeSubCluster>();
        try {
            conn = this.getConnection();
            cstmt = conn.prepareCall(CALL_SP_GET_APPLICATIONS_HOME_SUBCLUSTER);
            long startTime = this.clock.getTime();
            rs = cstmt.executeQuery();
            long stopTime = this.clock.getTime();
            while (rs.next()) {
                String applicationId = rs.getString(1);
                String homeSubCluster = rs.getString(2);
                appsHomeSubClusters.add(ApplicationHomeSubCluster.newInstance(ApplicationId.fromString(applicationId), SubClusterId.newInstance(homeSubCluster)));
            }
            FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn, rs);
        }
        catch (SQLException e) {
            FederationStateStoreClientMetrics.failedStateStoreCall();
            FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to obtain the information for all the applications ", e);
        }
        finally {
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn, rs);
        }
        return GetApplicationsHomeSubClusterResponse.newInstance(appsHomeSubClusters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationHomeSubClusterResponse deleteApplicationHomeSubCluster(DeleteApplicationHomeSubClusterRequest request) throws YarnException {
        FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
        CallableStatement cstmt = null;
        Connection conn = null;
        try {
            String errMsg;
            conn = this.getConnection();
            cstmt = conn.prepareCall(CALL_SP_DELETE_APPLICATION_HOME_SUBCLUSTER);
            cstmt.setString(1, request.getApplicationId().toString());
            cstmt.registerOutParameter(2, 4);
            long startTime = this.clock.getTime();
            cstmt.executeUpdate();
            long stopTime = this.clock.getTime();
            if (cstmt.getInt(2) == 0) {
                errMsg = "Application " + request.getApplicationId() + " does not exist";
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            if (cstmt.getInt(2) != 1) {
                errMsg = "Wrong behavior during deleting the application " + request.getApplicationId();
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            LOG.info("Delete from the StateStore the application: {}", (Object)request.getApplicationId());
            FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
        }
        catch (SQLException e) {
            try {
                FederationStateStoreClientMetrics.failedStateStoreCall();
                FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to delete the application " + request.getApplicationId(), e);
            }
            catch (Throwable throwable) {
                FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
                throw throwable;
            }
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        }
        FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        return DeleteApplicationHomeSubClusterResponse.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubClusterPolicyConfigurationResponse getPolicyConfiguration(GetSubClusterPolicyConfigurationRequest request) throws YarnException {
        long stopTime;
        long startTime;
        SubClusterPolicyConfiguration subClusterPolicyConfiguration;
        Connection conn;
        CallableStatement cstmt;
        block7: {
            FederationPolicyStoreInputValidator.validate(request);
            cstmt = null;
            conn = null;
            subClusterPolicyConfiguration = null;
            conn = this.getConnection();
            cstmt = conn.prepareCall(CALL_SP_GET_POLICY_CONFIGURATION);
            cstmt.setString(1, request.getQueue());
            cstmt.registerOutParameter(2, 12);
            cstmt.registerOutParameter(3, -3);
            startTime = this.clock.getTime();
            cstmt.executeUpdate();
            stopTime = this.clock.getTime();
            if (cstmt.getString(2) != null && cstmt.getBytes(3) != null) {
                subClusterPolicyConfiguration = SubClusterPolicyConfiguration.newInstance(request.getQueue(), cstmt.getString(2), ByteBuffer.wrap(cstmt.getBytes(3)));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Selected from StateStore the policy for the queue: " + subClusterPolicyConfiguration.toString());
                }
                break block7;
            }
            LOG.warn("Policy for queue: {} does not exist.", (Object)request.getQueue());
            GetSubClusterPolicyConfigurationResponse getSubClusterPolicyConfigurationResponse = null;
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
            return getSubClusterPolicyConfigurationResponse;
        }
        try {
            FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
        }
        catch (SQLException e) {
            try {
                FederationStateStoreClientMetrics.failedStateStoreCall();
                FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to select the policy for the queue :" + request.getQueue(), e);
            }
            catch (Throwable throwable) {
                FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
                throw throwable;
            }
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        }
        FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        return GetSubClusterPolicyConfigurationResponse.newInstance(subClusterPolicyConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetSubClusterPolicyConfigurationResponse setPolicyConfiguration(SetSubClusterPolicyConfigurationRequest request) throws YarnException {
        FederationPolicyStoreInputValidator.validate(request);
        CallableStatement cstmt = null;
        Connection conn = null;
        SubClusterPolicyConfiguration policyConf = request.getPolicyConfiguration();
        try {
            String errMsg;
            conn = this.getConnection();
            cstmt = conn.prepareCall(CALL_SP_SET_POLICY_CONFIGURATION);
            cstmt.setString(1, policyConf.getQueue());
            cstmt.setString(2, policyConf.getType());
            cstmt.setBytes(3, SQLFederationStateStore.getByteArray(policyConf.getParams()));
            cstmt.registerOutParameter(4, 4);
            long startTime = this.clock.getTime();
            cstmt.executeUpdate();
            long stopTime = this.clock.getTime();
            if (cstmt.getInt(4) == 0) {
                errMsg = "The policy " + policyConf.getQueue() + " was not insert into the StateStore";
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            if (cstmt.getInt(4) != 1) {
                errMsg = "Wrong behavior during insert the policy " + policyConf.getQueue();
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
            LOG.info("Insert into the state store the policy for the queue: " + policyConf.getQueue());
            FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
        }
        catch (SQLException e) {
            try {
                FederationStateStoreClientMetrics.failedStateStoreCall();
                FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to insert the newly generated policy for the queue :" + policyConf.getQueue(), e);
            }
            catch (Throwable throwable) {
                FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
                throw throwable;
            }
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        }
        FederationStateStoreUtils.returnToPool(LOG, cstmt, conn);
        return SetSubClusterPolicyConfigurationResponse.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubClusterPoliciesConfigurationsResponse getPoliciesConfigurations(GetSubClusterPoliciesConfigurationsRequest request) throws YarnException {
        CallableStatement cstmt = null;
        Connection conn = null;
        ResultSet rs = null;
        ArrayList<SubClusterPolicyConfiguration> policyConfigurations = new ArrayList<SubClusterPolicyConfiguration>();
        try {
            conn = this.getConnection();
            cstmt = conn.prepareCall(CALL_SP_GET_POLICIES_CONFIGURATIONS);
            long startTime = this.clock.getTime();
            rs = cstmt.executeQuery();
            long stopTime = this.clock.getTime();
            while (rs.next()) {
                String queue = rs.getString(1);
                String type = rs.getString(2);
                byte[] policyInfo = rs.getBytes(3);
                SubClusterPolicyConfiguration subClusterPolicyConfiguration = SubClusterPolicyConfiguration.newInstance(queue, type, ByteBuffer.wrap(policyInfo));
                policyConfigurations.add(subClusterPolicyConfiguration);
            }
            FederationStateStoreClientMetrics.succeededStateStoreCall(stopTime - startTime);
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn, rs);
        }
        catch (SQLException e) {
            FederationStateStoreClientMetrics.failedStateStoreCall();
            FederationStateStoreUtils.logAndThrowRetriableException(LOG, "Unable to obtain the policy information for all the queues.", e);
        }
        finally {
            FederationStateStoreUtils.returnToPool(LOG, cstmt, conn, rs);
        }
        return GetSubClusterPoliciesConfigurationsResponse.newInstance(policyConfigurations);
    }

    @Override
    public Version getCurrentVersion() {
        throw new NotImplementedException();
    }

    @Override
    public Version loadVersion() {
        throw new NotImplementedException();
    }

    @Override
    public void close() throws Exception {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    private static byte[] getByteArray(ByteBuffer bb) {
        byte[] ba = new byte[bb.limit()];
        bb.get(ba);
        return ba;
    }
}

