/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.AllocateRequestPBImpl;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.DistributedSchedulingAllocateRequest;

public class DistributedSchedulingAllocateRequestPBImpl
extends DistributedSchedulingAllocateRequest {
    private YarnServerCommonServiceProtos.DistributedSchedulingAllocateRequestProto.Builder builder = null;
    private boolean viaProto = false;
    private YarnServerCommonServiceProtos.DistributedSchedulingAllocateRequestProto proto;
    private AllocateRequest allocateRequest;
    private List<Container> containers;

    public DistributedSchedulingAllocateRequestPBImpl() {
        this.builder = YarnServerCommonServiceProtos.DistributedSchedulingAllocateRequestProto.newBuilder();
    }

    public DistributedSchedulingAllocateRequestPBImpl(YarnServerCommonServiceProtos.DistributedSchedulingAllocateRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public AllocateRequest getAllocateRequest() {
        YarnServerCommonServiceProtos.DistributedSchedulingAllocateRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.DistributedSchedulingAllocateRequestProtoOrBuilder distributedSchedulingAllocateRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.allocateRequest != null) {
            return this.allocateRequest;
        }
        if (!p.hasAllocateRequest()) {
            return null;
        }
        this.allocateRequest = this.convertFromProtoFormat(p.getAllocateRequest());
        return this.allocateRequest;
    }

    @Override
    public void setAllocateRequest(AllocateRequest pAllocateRequest) {
        this.maybeInitBuilder();
        if (this.allocateRequest == null) {
            this.builder.clearAllocateRequest();
        }
        this.allocateRequest = pAllocateRequest;
    }

    @Override
    public List<Container> getAllocatedContainers() {
        if (this.containers != null) {
            return this.containers;
        }
        this.initAllocatedContainers();
        return this.containers;
    }

    private void initAllocatedContainers() {
        YarnServerCommonServiceProtos.DistributedSchedulingAllocateRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerProto> list = p.getAllocatedContainersList();
        this.containers = new ArrayList<Container>();
        for (YarnProtos.ContainerProto c : list) {
            this.containers.add(this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void setAllocatedContainers(List<Container> pContainers) {
        this.maybeInitBuilder();
        if (pContainers == null || pContainers.isEmpty()) {
            if (this.containers != null) {
                this.containers.clear();
            }
            this.builder.clearAllocatedContainers();
            return;
        }
        this.containers = new ArrayList<Container>();
        this.containers.addAll(pContainers);
    }

    public YarnServerCommonServiceProtos.DistributedSchedulingAllocateRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerCommonServiceProtos.DistributedSchedulingAllocateRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.containers != null) {
            this.builder.clearAllocatedContainers();
            Iterable<YarnProtos.ContainerProto> iterable = this.getContainerProtoIterable(this.containers);
            this.builder.addAllAllocatedContainers(iterable);
        }
        if (this.allocateRequest != null) {
            this.builder.setAllocateRequest(((AllocateRequestPBImpl)this.allocateRequest).getProto());
        }
    }

    private Iterable<YarnProtos.ContainerProto> getContainerProtoIterable(final List<Container> newContainersList) {
        this.maybeInitBuilder();
        return new Iterable<YarnProtos.ContainerProto>(){

            @Override
            public synchronized Iterator<YarnProtos.ContainerProto> iterator() {
                return new Iterator<YarnProtos.ContainerProto>(){
                    Iterator<Container> iter;
                    {
                        this.iter = newContainersList.iterator();
                    }

                    @Override
                    public synchronized boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public synchronized YarnProtos.ContainerProto next() {
                        return ProtoUtils.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public synchronized void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private ContainerPBImpl convertFromProtoFormat(YarnProtos.ContainerProto p) {
        return new ContainerPBImpl(p);
    }

    private AllocateRequestPBImpl convertFromProtoFormat(YarnServiceProtos.AllocateRequestProto p) {
        return new AllocateRequestPBImpl(p);
    }
}

