/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.protobuf.TextFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.math.LongRange;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetApplicationsRequestPBImpl
extends GetApplicationsRequest {
    YarnServiceProtos.GetApplicationsRequestProto proto = YarnServiceProtos.GetApplicationsRequestProto.getDefaultInstance();
    YarnServiceProtos.GetApplicationsRequestProto.Builder builder = null;
    boolean viaProto = false;
    Set<String> applicationTypes = null;
    EnumSet<YarnApplicationState> applicationStates = null;
    Set<String> users = null;
    Set<String> queues = null;
    long limit = Long.MAX_VALUE;
    LongRange start = null;
    LongRange finish = null;
    private Set<String> applicationTags;
    private ApplicationsRequestScope scope;

    public GetApplicationsRequestPBImpl() {
        this.builder = YarnServiceProtos.GetApplicationsRequestProto.newBuilder();
    }

    public GetApplicationsRequestPBImpl(YarnServiceProtos.GetApplicationsRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.GetApplicationsRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.applicationTypes != null && !this.applicationTypes.isEmpty()) {
            this.builder.clearApplicationTypes();
            this.builder.addAllApplicationTypes(this.applicationTypes);
        }
        if (this.applicationStates != null && !this.applicationStates.isEmpty()) {
            this.builder.clearApplicationStates();
            this.builder.addAllApplicationStates(Iterables.transform(this.applicationStates, new Function<YarnApplicationState, YarnProtos.YarnApplicationStateProto>(){

                @Override
                public YarnProtos.YarnApplicationStateProto apply(YarnApplicationState input) {
                    return ProtoUtils.convertToProtoFormat(input);
                }
            }));
        }
        if (this.applicationTags != null && !this.applicationTags.isEmpty()) {
            this.builder.clearApplicationTags();
            this.builder.addAllApplicationTags(this.applicationTags);
        }
        if (this.scope != null) {
            this.builder.setScope(ProtoUtils.convertToProtoFormat(this.scope));
        }
        if (this.start != null) {
            this.builder.setStartBegin(this.start.getMinimumLong());
            this.builder.setStartEnd(this.start.getMaximumLong());
        }
        if (this.finish != null) {
            this.builder.setFinishBegin(this.finish.getMinimumLong());
            this.builder.setFinishEnd(this.finish.getMaximumLong());
        }
        if (this.limit != Long.MAX_VALUE) {
            this.builder.setLimit(this.limit);
        }
        if (this.users != null && !this.users.isEmpty()) {
            this.builder.clearUsers();
            this.builder.addAllUsers(this.users);
        }
        if (this.queues != null && !this.queues.isEmpty()) {
            this.builder.clearQueues();
            this.builder.addAllQueues(this.queues);
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetApplicationsRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void initApplicationTypes() {
        if (this.applicationTypes != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<String> appTypeList = p.getApplicationTypesList();
        this.applicationTypes = new HashSet<String>();
        this.applicationTypes.addAll(appTypeList);
    }

    private void initApplicationStates() {
        if (this.applicationStates != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.YarnApplicationStateProto> appStatesList = p.getApplicationStatesList();
        this.applicationStates = EnumSet.noneOf(YarnApplicationState.class);
        for (YarnProtos.YarnApplicationStateProto c : appStatesList) {
            this.applicationStates.add(ProtoUtils.convertFromProtoFormat(c));
        }
    }

    private void initUsers() {
        if (this.users != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<String> usersList = p.getUsersList();
        this.users = new HashSet<String>();
        this.users.addAll(usersList);
    }

    private void initQueues() {
        if (this.queues != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<String> queuesList = p.getQueuesList();
        this.queues = new HashSet<String>();
        this.queues.addAll(queuesList);
    }

    @Override
    public Set<String> getApplicationTypes() {
        this.initApplicationTypes();
        return this.applicationTypes;
    }

    @Override
    public void setApplicationTypes(Set<String> applicationTypes) {
        this.maybeInitBuilder();
        if (applicationTypes == null) {
            this.builder.clearApplicationTypes();
        }
        this.applicationTypes = applicationTypes;
    }

    private void initApplicationTags() {
        if (this.applicationTags != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.applicationTags = new HashSet<String>();
        this.applicationTags.addAll(p.getApplicationTagsList());
    }

    @Override
    public Set<String> getApplicationTags() {
        this.initApplicationTags();
        return this.applicationTags;
    }

    @Override
    public void setApplicationTags(Set<String> tags) {
        this.maybeInitBuilder();
        if (tags == null || tags.isEmpty()) {
            this.builder.clearApplicationTags();
            this.applicationTags = null;
            return;
        }
        this.applicationTags = new HashSet<String>();
        for (String tag : tags) {
            this.applicationTags.add(StringUtils.toLowerCase((String)tag));
        }
    }

    @Override
    public EnumSet<YarnApplicationState> getApplicationStates() {
        this.initApplicationStates();
        return this.applicationStates;
    }

    private void initScope() {
        if (this.scope != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.scope = ProtoUtils.convertFromProtoFormat(p.getScope());
    }

    @Override
    public ApplicationsRequestScope getScope() {
        this.initScope();
        return this.scope;
    }

    @Override
    public void setScope(ApplicationsRequestScope scope) {
        this.maybeInitBuilder();
        if (scope == null) {
            this.builder.clearScope();
        }
        this.scope = scope;
    }

    @Override
    public void setApplicationStates(EnumSet<YarnApplicationState> applicationStates) {
        this.maybeInitBuilder();
        if (applicationStates == null) {
            this.builder.clearApplicationStates();
        }
        this.applicationStates = applicationStates;
    }

    @Override
    public void setApplicationStates(Set<String> applicationStates) {
        EnumSet<YarnApplicationState> appStates = null;
        for (YarnApplicationState state : YarnApplicationState.values()) {
            if (!applicationStates.contains(StringUtils.toLowerCase((String)state.name()))) continue;
            if (appStates == null) {
                appStates = EnumSet.of(state);
                continue;
            }
            appStates.add(state);
        }
        this.setApplicationStates(appStates);
    }

    @Override
    public Set<String> getUsers() {
        this.initUsers();
        return this.users;
    }

    @Override
    public void setUsers(Set<String> users) {
        this.maybeInitBuilder();
        if (users == null) {
            this.builder.clearUsers();
        }
        this.users = users;
    }

    @Override
    public Set<String> getQueues() {
        this.initQueues();
        return this.queues;
    }

    @Override
    public void setQueues(Set<String> queues) {
        this.maybeInitBuilder();
        if (queues == null) {
            this.builder.clearQueues();
        }
        this.queues = queues;
    }

    @Override
    public long getLimit() {
        if (this.limit == Long.MAX_VALUE) {
            YarnServiceProtos.GetApplicationsRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
            this.limit = p.hasLimit() ? p.getLimit() : Long.MAX_VALUE;
        }
        return this.limit;
    }

    @Override
    public void setLimit(long limit) {
        this.maybeInitBuilder();
        this.limit = limit;
    }

    @Override
    public LongRange getStartRange() {
        if (this.start == null) {
            YarnServiceProtos.GetApplicationsRequestProtoOrBuilder p;
            YarnServiceProtos.GetApplicationsRequestProtoOrBuilder getApplicationsRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
            if (p.hasStartBegin() || p.hasStartEnd()) {
                long begin = p.hasStartBegin() ? p.getStartBegin() : 0L;
                long end = p.hasStartEnd() ? p.getStartEnd() : Long.MAX_VALUE;
                this.start = new LongRange(begin, end);
            }
        }
        return this.start;
    }

    @Override
    public void setStartRange(LongRange range) {
        this.start = range;
    }

    @Override
    public void setStartRange(long begin, long end) throws IllegalArgumentException {
        if (begin > end) {
            throw new IllegalArgumentException("begin > end in range (begin, end): (" + begin + ", " + end + ")");
        }
        this.start = new LongRange(begin, end);
    }

    @Override
    public LongRange getFinishRange() {
        if (this.finish == null) {
            YarnServiceProtos.GetApplicationsRequestProtoOrBuilder p;
            YarnServiceProtos.GetApplicationsRequestProtoOrBuilder getApplicationsRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
            if (p.hasFinishBegin() || p.hasFinishEnd()) {
                long begin = p.hasFinishBegin() ? p.getFinishBegin() : 0L;
                long end = p.hasFinishEnd() ? p.getFinishEnd() : Long.MAX_VALUE;
                this.finish = new LongRange(begin, end);
            }
        }
        return this.finish;
    }

    @Override
    public void setFinishRange(LongRange range) {
        this.finish = range;
    }

    @Override
    public void setFinishRange(long begin, long end) {
        if (begin > end) {
            throw new IllegalArgumentException("begin > end in range (begin, end): (" + begin + ", " + end + ")");
        }
        this.finish = new LongRange(begin, end);
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetApplicationsRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }
}

