/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.cli;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.api.RegistryOperationsFactory;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.exceptions.AuthenticationFailedException;
import org.apache.hadoop.registry.client.exceptions.InvalidPathnameException;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.exceptions.NoPathPermissionsException;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryCli
extends Configured
implements Tool,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryCli.class);
    protected final PrintStream sysout;
    protected final PrintStream syserr;
    private RegistryOperations registry;
    private static final String LS_USAGE = "ls pathName";
    private static final String RESOLVE_USAGE = "resolve pathName";
    private static final String BIND_USAGE = "bind -inet  -api apiName -p portNumber -h hostName  pathName\nbind -webui uriString -api apiName  pathName\nbind -rest uriString -api apiName  pathName";
    private static final String MKNODE_USAGE = "mknode directoryName";
    private static final String RM_USAGE = "rm pathName";
    private static final String USAGE = "\nls pathName\nresolve pathName\nbind -inet  -api apiName -p portNumber -h hostName  pathName\nbind -webui uriString -api apiName  pathName\nbind -rest uriString -api apiName  pathName\nmknode directoryName\nrm pathName";

    public RegistryCli(PrintStream sysout, PrintStream syserr) {
        Configuration conf = new Configuration();
        super.setConf(conf);
        this.registry = RegistryOperationsFactory.createInstance(conf);
        this.registry.start();
        this.sysout = sysout;
        this.syserr = syserr;
    }

    public RegistryCli(RegistryOperations reg, Configuration conf, PrintStream sysout, PrintStream syserr) {
        super(conf);
        Preconditions.checkArgument(reg != null, "Null registry");
        this.registry = reg;
        this.sysout = sysout;
        this.syserr = syserr;
    }

    public static void main(String[] args2) throws Exception {
        int res = -1;
        try (RegistryCli cli = new RegistryCli(System.out, System.err);){
            res = ToolRunner.run((Tool)cli, (String[])args2);
        }
        catch (Exception e) {
            ExitUtil.terminate((int)res, (Throwable)e);
        }
        ExitUtil.terminate((int)res);
    }

    @Override
    public void close() throws IOException {
        ServiceOperations.stopQuietly((Service)this.registry);
        this.registry = null;
    }

    private int usageError(String err, String usage) {
        this.syserr.println("Error: " + err);
        this.syserr.println("Usage: " + usage);
        return -1;
    }

    private boolean validatePath(String path) {
        if (!path.startsWith("/")) {
            this.syserr.println("Path must start with /; given path was: " + path);
            return false;
        }
        return true;
    }

    public int run(String[] args2) throws Exception {
        Preconditions.checkArgument(this.getConf() != null, "null configuration");
        if (args2.length > 0) {
            switch (args2[0]) {
                case "ls": {
                    return this.ls(args2);
                }
                case "resolve": {
                    return this.resolve(args2);
                }
                case "bind": {
                    return this.bind(args2);
                }
                case "mknode": {
                    return this.mknode(args2);
                }
                case "rm": {
                    return this.rm(args2);
                }
            }
            return this.usageError("Invalid command: " + args2[0], USAGE);
        }
        return this.usageError("No command arg passed.", USAGE);
    }

    public int ls(String[] args2) {
        Options lsOption = new Options();
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(lsOption, args2);
            List<String> argsList = line.getArgList();
            if (argsList.size() != 2) {
                return this.usageError("ls requires exactly one path argument", LS_USAGE);
            }
            if (!this.validatePath(argsList.get(1))) {
                return -1;
            }
            try {
                List<String> children = this.registry.list(argsList.get(1));
                for (String child : children) {
                    this.sysout.println(child);
                }
                return 0;
            }
            catch (Exception e) {
                this.syserr.println(this.analyzeException("ls", e, argsList));
                return -1;
            }
        }
        catch (ParseException exp) {
            return this.usageError("Invalid syntax " + exp, LS_USAGE);
        }
    }

    public int resolve(String[] args2) {
        Options resolveOption = new Options();
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(resolveOption, args2);
            List<String> argsList = line.getArgList();
            if (argsList.size() != 2) {
                return this.usageError("resolve requires exactly one path argument", RESOLVE_USAGE);
            }
            if (!this.validatePath(argsList.get(1))) {
                return -1;
            }
            try {
                ServiceRecord record = this.registry.resolve(argsList.get(1));
                for (Endpoint endpoint : record.external) {
                    this.sysout.println(" Endpoint(ProtocolType=" + endpoint.protocolType + ", Api=" + endpoint.api + ");" + " Addresses(AddressType=" + endpoint.addressType + ") are: ");
                    for (Map<String, String> address : endpoint.addresses) {
                        this.sysout.println("[ ");
                        for (Map.Entry<String, String> entry : address.entrySet()) {
                            this.sysout.print("\t" + entry.getKey() + ":" + entry.getValue());
                        }
                        this.sysout.println("\n]");
                    }
                    this.sysout.println();
                }
                return 0;
            }
            catch (Exception e) {
                this.syserr.println(this.analyzeException("resolve", e, argsList));
                return -1;
            }
        }
        catch (ParseException exp) {
            return this.usageError("Invalid syntax " + exp, RESOLVE_USAGE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int bind(String[] args2) {
        CommandLine line;
        OptionBuilder.withArgName("rest");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("rest Option");
        Option rest = OptionBuilder.create("rest");
        OptionBuilder.withArgName("webui");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("webui Option");
        Option webui = OptionBuilder.create("webui");
        OptionBuilder.withArgName("inet");
        OptionBuilder.withDescription("inet Option");
        Option inet = OptionBuilder.create("inet");
        OptionBuilder.withArgName("port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("port to listen on [9999]");
        Option port = OptionBuilder.create("p");
        OptionBuilder.withArgName("host");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("host name");
        Option host = OptionBuilder.create("h");
        OptionBuilder.withArgName("api");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("api");
        Option apiOpt = OptionBuilder.create("api");
        Options inetOption = new Options();
        inetOption.addOption(inet);
        inetOption.addOption(port);
        inetOption.addOption(host);
        inetOption.addOption(apiOpt);
        Options webuiOpt = new Options();
        webuiOpt.addOption(webui);
        webuiOpt.addOption(apiOpt);
        Options restOpt = new Options();
        restOpt.addOption(rest);
        restOpt.addOption(apiOpt);
        GnuParser parser = new GnuParser();
        ServiceRecord sr = new ServiceRecord();
        if (args2.length <= 1) {
            return this.usageError("Invalid syntax ", BIND_USAGE);
        }
        if (args2[1].equals("-inet")) {
            int portNum;
            try {
                line = parser.parse(inetOption, args2);
            }
            catch (ParseException exp) {
                return this.usageError("Invalid syntax " + exp.getMessage(), BIND_USAGE);
            }
            if (!line.hasOption("inet") || !line.hasOption("p") || !line.hasOption("h") || !line.hasOption("api")) return this.usageError("Missing options: must have host, port and api", BIND_USAGE);
            try {
                portNum = Integer.parseInt(line.getOptionValue("p"));
            }
            catch (NumberFormatException exp) {
                return this.usageError("Invalid Port - int required" + exp.getMessage(), BIND_USAGE);
            }
            String hostName = line.getOptionValue("h");
            String api = line.getOptionValue("api");
            sr.addExternalEndpoint(RegistryTypeUtils.inetAddrEndpoint(api, "hadoop/IPC", hostName, portNum));
        } else if (args2[1].equals("-webui")) {
            URI theUri;
            try {
                line = parser.parse(webuiOpt, args2);
            }
            catch (ParseException exp) {
                return this.usageError("Invalid syntax " + exp.getMessage(), BIND_USAGE);
            }
            if (!line.hasOption("webui") || !line.hasOption("api")) return this.usageError("Missing options: must have value for uri and api", BIND_USAGE);
            try {
                theUri = new URI(line.getOptionValue("webui"));
            }
            catch (URISyntaxException e) {
                return this.usageError("Invalid URI: " + e.getMessage(), BIND_USAGE);
            }
            sr.addExternalEndpoint(RegistryTypeUtils.webEndpoint(line.getOptionValue("api"), theUri));
        } else {
            if (!args2[1].equals("-rest")) return this.usageError("Invalid syntax", BIND_USAGE);
            try {
                line = parser.parse(restOpt, args2);
            }
            catch (ParseException exp) {
                return this.usageError("Invalid syntax " + exp.getMessage(), BIND_USAGE);
            }
            if (!line.hasOption("rest") || !line.hasOption("api")) return this.usageError("Missing options: must have value for uri and api", BIND_USAGE);
            URI theUri = null;
            try {
                theUri = new URI(line.getOptionValue("rest"));
            }
            catch (URISyntaxException e) {
                return this.usageError("Invalid URI: " + e.getMessage(), BIND_USAGE);
            }
            sr.addExternalEndpoint(RegistryTypeUtils.restEndpoint(line.getOptionValue("api"), theUri));
        }
        List<String> argsList = line.getArgList();
        if (argsList.size() != 2) {
            return this.usageError("bind requires exactly one path argument", BIND_USAGE);
        }
        if (!this.validatePath(argsList.get(1))) {
            return -1;
        }
        try {
            this.registry.bind(argsList.get(1), sr, 1);
            return 0;
        }
        catch (Exception e) {
            this.syserr.println(this.analyzeException("bind", e, argsList));
            return -1;
        }
    }

    public int mknode(String[] args2) {
        Options mknodeOption = new Options();
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(mknodeOption, args2);
            List<String> argsList = line.getArgList();
            if (argsList.size() != 2) {
                return this.usageError("mknode requires exactly one path argument", MKNODE_USAGE);
            }
            if (!this.validatePath(argsList.get(1))) {
                return -1;
            }
            try {
                this.registry.mknode(args2[1], false);
                return 0;
            }
            catch (Exception e) {
                this.syserr.println(this.analyzeException("mknode", e, argsList));
                return -1;
            }
        }
        catch (ParseException exp) {
            return this.usageError("Invalid syntax " + exp.toString(), MKNODE_USAGE);
        }
    }

    public int rm(String[] args2) {
        OptionBuilder.withArgName("recursive");
        OptionBuilder.withDescription("delete recursively");
        Option recursive = OptionBuilder.create("r");
        Options rmOption = new Options();
        rmOption.addOption(recursive);
        boolean recursiveOpt = false;
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(rmOption, args2);
            List<String> argsList = line.getArgList();
            if (argsList.size() != 2) {
                return this.usageError("RM requires exactly one path argument", RM_USAGE);
            }
            if (!this.validatePath(argsList.get(1))) {
                return -1;
            }
            try {
                if (line.hasOption("r")) {
                    recursiveOpt = true;
                }
                this.registry.delete(argsList.get(1), recursiveOpt);
                return 0;
            }
            catch (Exception e) {
                this.syserr.println(this.analyzeException("rm", e, argsList));
                return -1;
            }
        }
        catch (ParseException exp) {
            return this.usageError("Invalid syntax " + exp.toString(), RM_USAGE);
        }
    }

    String analyzeException(String operation, Exception e, List<String> argsList) {
        String pathArg;
        String string = pathArg = !argsList.isEmpty() ? argsList.get(1) : "(none)";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Operation {} on path {} failed with exception {}", new Object[]{operation, pathArg, e, e});
        }
        if (e instanceof InvalidPathnameException) {
            return "InvalidPath :" + pathArg + ": " + e;
        }
        if (e instanceof PathNotFoundException) {
            return "Path not found: " + pathArg;
        }
        if (e instanceof NoRecordException) {
            return "No service record at path " + pathArg;
        }
        if (e instanceof AuthenticationFailedException) {
            return "Failed to authenticate to registry : " + e;
        }
        if (e instanceof NoPathPermissionsException) {
            return "No Permission to path: " + pathArg + ": " + e;
        }
        if (e instanceof AccessControlException) {
            return "No Permission to path: " + pathArg + ": " + e;
        }
        if (e instanceof InvalidRecordException) {
            return "Unable to read record at: " + pathArg + ": " + e;
        }
        if (e instanceof IOException) {
            return "IO Exception when accessing path :" + pathArg + ": " + e;
        }
        return "Exception " + e;
    }
}

