/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ReduceTaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.Times;

@XmlRootElement(name="taskAttempt")
@XmlSeeAlso(value={ReduceTaskAttemptInfo.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TaskAttemptInfo {
    protected long startTime;
    protected long finishTime;
    protected long elapsedTime;
    protected float progress;
    protected String id;
    protected String rack;
    protected TaskAttemptState state;
    protected String status;
    protected String nodeHttpAddress;
    protected String diagnostics;
    protected String type;
    protected String assignedContainerId;
    @XmlTransient
    protected ContainerId assignedContainer;

    public TaskAttemptInfo() {
    }

    public TaskAttemptInfo(TaskAttempt ta, Boolean isRunning) {
        this(ta, TaskType.MAP, isRunning);
    }

    public TaskAttemptInfo(TaskAttempt ta, TaskType type, Boolean isRunning) {
        TaskAttemptReport report2 = ta.getReport();
        this.type = type.toString();
        this.id = MRApps.toString(ta.getID());
        this.nodeHttpAddress = ta.getNodeHttpAddress();
        this.startTime = report2.getStartTime();
        this.finishTime = report2.getFinishTime();
        this.assignedContainer = report2.getContainerId();
        if (this.assignedContainer != null) {
            this.assignedContainerId = this.assignedContainer.toString();
        }
        this.progress = report2.getProgress() * 100.0f;
        this.status = report2.getStateString();
        this.state = report2.getTaskAttemptState();
        this.elapsedTime = Times.elapsed(this.startTime, this.finishTime, isRunning);
        if (this.elapsedTime == -1L) {
            this.elapsedTime = 0L;
        }
        this.diagnostics = report2.getDiagnosticInfo();
        this.rack = ta.getNodeRackName();
    }

    public String getAssignedContainerIdStr() {
        return this.assignedContainerId;
    }

    public ContainerId getAssignedContainerId() {
        return this.assignedContainer;
    }

    public String getState() {
        return this.state.toString();
    }

    public String getStatus() {
        return this.status;
    }

    public String getId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public float getProgress() {
        return this.progress;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getNode() {
        return this.nodeHttpAddress;
    }

    public String getRack() {
        return this.rack;
    }

    public String getNote() {
        return this.diagnostics;
    }
}

