/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMParams;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AttemptsPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.CountersPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.InfoPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobConfPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.SingleCounterPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TaskPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TasksPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.AppInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class AppController
extends Controller
implements AMParams {
    private static final Log LOG = LogFactory.getLog(AppController.class);
    private static final Joiner JOINER = Joiner.on("");
    protected final App app;

    protected AppController(App app, Configuration conf, Controller.RequestContext ctx, String title) {
        super(ctx);
        this.app = app;
        this.set("app.id", app.context.getApplicationID().toString());
        this.set("rm.web", JOINER.join(MRWebAppUtil.getYARNWebappScheme(), WebAppUtils.getResolvedRemoteRMWebAppURLWithoutScheme(conf, MRWebAppUtil.getYARNHttpPolicy()), new Object[0]));
    }

    @Inject
    protected AppController(App app, Configuration conf, Controller.RequestContext ctx) {
        this(app, conf, ctx, "am");
    }

    @Override
    public void index() {
        this.setTitle(StringHelper.join("MapReduce Application ", this.$("app.id")));
    }

    public void info() {
        AppInfo info = new AppInfo(this.app, this.app.context);
        this.info("Application Master Overview")._("Application ID:", info.getId())._("Application Name:", info.getName())._("User:", info.getUser())._("Started on:", Times.format(info.getStartTime()))._("Elasped: ", org.apache.hadoop.util.StringUtils.formatTime((long)info.getElapsedTime()));
        this.render(InfoPage.class);
    }

    protected Class<? extends View> jobPage() {
        return JobPage.class;
    }

    public void job() {
        try {
            this.requireJob();
        }
        catch (Exception e) {
            this.renderText(e.getMessage());
            return;
        }
        this.render(this.jobPage());
    }

    protected Class<? extends View> countersPage() {
        return CountersPage.class;
    }

    public void jobCounters() {
        try {
            this.requireJob();
        }
        catch (Exception e) {
            this.renderText(e.getMessage());
            return;
        }
        if (this.app.getJob() != null) {
            this.setTitle(StringHelper.join("Counters for ", this.$("job.id")));
        }
        this.render(this.countersPage());
    }

    public void taskCounters() {
        try {
            this.requireTask();
        }
        catch (Exception e) {
            this.renderText(e.getMessage());
            return;
        }
        if (this.app.getTask() != null) {
            this.setTitle(StringHelper.join("Counters for ", this.$("task.id")));
        }
        this.render(this.countersPage());
    }

    protected Class<? extends View> singleCounterPage() {
        return SingleCounterPage.class;
    }

    public void singleJobCounter() throws IOException {
        try {
            this.requireJob();
        }
        catch (Exception e) {
            this.renderText(e.getMessage());
            return;
        }
        this.set("counter.group", URLDecoder.decode(this.$("counter.group"), "UTF-8"));
        this.set("counter.name", URLDecoder.decode(this.$("counter.name"), "UTF-8"));
        if (this.app.getJob() != null) {
            this.setTitle(StringHelper.join(this.$("counter.group"), " ", this.$("counter.name"), " for ", this.$("job.id")));
        }
        this.render(this.singleCounterPage());
    }

    public void singleTaskCounter() throws IOException {
        try {
            this.requireTask();
        }
        catch (Exception e) {
            this.renderText(e.getMessage());
            return;
        }
        this.set("counter.group", URLDecoder.decode(this.$("counter.group"), "UTF-8"));
        this.set("counter.name", URLDecoder.decode(this.$("counter.name"), "UTF-8"));
        if (this.app.getTask() != null) {
            this.setTitle(StringHelper.join(this.$("counter.group"), " ", this.$("counter.name"), " for ", this.$("task.id")));
        }
        this.render(this.singleCounterPage());
    }

    protected Class<? extends View> tasksPage() {
        return TasksPage.class;
    }

    public void tasks() {
        try {
            this.requireJob();
        }
        catch (Exception e) {
            this.renderText(e.getMessage());
            return;
        }
        if (this.app.getJob() != null) {
            try {
                String tt = this.$("task.type");
                tt = tt.isEmpty() ? "All" : StringUtils.capitalize(org.apache.hadoop.util.StringUtils.toLowerCase((String)MRApps.taskType(tt).toString()));
                this.setTitle(StringHelper.join(tt, " Tasks for ", this.$("job.id")));
            }
            catch (Exception e) {
                LOG.error("Failed to render tasks page with task type : " + this.$("task.type") + " for job id : " + this.$("job.id"), e);
                this.badRequest(e.getMessage());
            }
        }
        this.render(this.tasksPage());
    }

    protected Class<? extends View> taskPage() {
        return TaskPage.class;
    }

    public void task() {
        try {
            this.requireTask();
        }
        catch (Exception e) {
            this.renderText(e.getMessage());
            return;
        }
        if (this.app.getTask() != null) {
            this.setTitle(StringHelper.join("Attempts for ", this.$("task.id")));
        }
        this.render(this.taskPage());
    }

    protected Class<? extends View> attemptsPage() {
        return AttemptsPage.class;
    }

    public void attempts() {
        try {
            this.requireJob();
        }
        catch (Exception e) {
            this.renderText(e.getMessage());
            return;
        }
        if (this.app.getJob() != null) {
            try {
                String taskType = this.$("task.type");
                if (taskType.isEmpty()) {
                    throw new RuntimeException("missing task-type.");
                }
                String attemptState = this.$("attempt.state");
                if (attemptState.isEmpty()) {
                    throw new RuntimeException("missing attempt-state.");
                }
                this.setTitle(StringHelper.join(attemptState, " ", MRApps.taskType(taskType).toString(), " attempts in ", this.$("job.id")));
                this.render(this.attemptsPage());
            }
            catch (Exception e) {
                LOG.error("Failed to render attempts page with task type : " + this.$("task.type") + " for job id : " + this.$("job.id"), e);
                this.badRequest(e.getMessage());
            }
        }
    }

    protected Class<? extends View> confPage() {
        return JobConfPage.class;
    }

    public void conf() {
        try {
            this.requireJob();
        }
        catch (Exception e) {
            this.renderText(e.getMessage());
            return;
        }
        this.render(this.confPage());
    }

    public void downloadConf() {
        try {
            this.requireJob();
        }
        catch (Exception e) {
            this.renderText(e.getMessage());
            return;
        }
        this.writeJobConf();
    }

    private void writeJobConf() {
        String jobId = this.$("job.id");
        assert (!jobId.isEmpty());
        JobId jobID = MRApps.toJobID(this.$("job.id"));
        Job job = this.app.context.getJob(jobID);
        assert (job != null);
        try {
            Configuration jobConf = job.loadConfFile();
            this.response().setContentType("text/xml");
            this.response().setHeader("Content-Disposition", "attachment; filename=" + jobId + ".xml");
            jobConf.writeXml((Writer)this.writer());
        }
        catch (IOException e) {
            LOG.error("Error reading/writing job conf file for job: " + jobId, e);
            this.renderText(e.getMessage());
        }
    }

    void badRequest(String s2) {
        this.setStatus(400);
        String title = "Bad request: ";
        this.setTitle(s2 != null ? StringHelper.join(title, s2) : title);
    }

    void notFound(String s2) {
        this.setStatus(404);
        this.setTitle(StringHelper.join("Not found: ", s2));
    }

    void accessDenied(String s2) {
        this.setStatus(403);
        this.setTitle(StringHelper.join("Access denied: ", s2));
    }

    boolean checkAccess(Job job) {
        String remoteUser = this.request().getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUGI == null || job.checkAccess(callerUGI, JobACL.VIEW_JOB);
    }

    public void requireJob() {
        if (this.$("job.id").isEmpty()) {
            this.badRequest("missing job ID");
            throw new RuntimeException("Bad Request: Missing job ID");
        }
        JobId jobID = MRApps.toJobID(this.$("job.id"));
        this.app.setJob(this.app.context.getJob(jobID));
        if (this.app.getJob() == null) {
            this.notFound(this.$("job.id"));
            throw new RuntimeException("Not Found: " + this.$("job.id"));
        }
        Job job = this.app.context.getJob(jobID);
        if (!this.checkAccess(job)) {
            this.accessDenied("User " + this.request().getRemoteUser() + " does not have " + " permission to view job " + this.$("job.id"));
            throw new RuntimeException("Access denied: User " + this.request().getRemoteUser() + " does not have permission to view job " + this.$("job.id"));
        }
    }

    public void requireTask() {
        if (this.$("task.id").isEmpty()) {
            this.badRequest("missing task ID");
            throw new RuntimeException("missing task ID");
        }
        TaskId taskID = MRApps.toTaskID(this.$("task.id"));
        Job job = this.app.context.getJob(taskID.getJobId());
        this.app.setJob(job);
        if (this.app.getJob() == null) {
            this.notFound(MRApps.toString(taskID.getJobId()));
            throw new RuntimeException("Not Found: " + this.$("job.id"));
        }
        this.app.setTask(this.app.getJob().getTask(taskID));
        if (this.app.getTask() == null) {
            this.notFound(this.$("task.id"));
            throw new RuntimeException("Not Found: " + this.$("task.id"));
        }
        if (!this.checkAccess(job)) {
            this.accessDenied("User " + this.request().getRemoteUser() + " does not have " + " permission to view job " + this.$("job.id"));
            throw new RuntimeException("Access denied: User " + this.request().getRemoteUser() + " does not have permission to view job " + this.$("job.id"));
        }
    }
}

