/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryViewer;
import org.apache.hadoop.mapreduce.jobhistory.HistoryViewerPrinter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class HumanReadableHistoryViewerPrinter
implements HistoryViewerPrinter {
    private JobHistoryParser.JobInfo job;
    private final FastDateFormat dateFormat;
    private boolean printAll;
    private String scheme;
    private static Comparator<JobHistoryParser.TaskAttemptInfo> cMap = new Comparator<JobHistoryParser.TaskAttemptInfo>(){

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo t1, JobHistoryParser.TaskAttemptInfo t2) {
            long l1 = t1.getFinishTime() - t1.getStartTime();
            long l2 = t2.getFinishTime() - t2.getStartTime();
            return Long.compare(l2, l1);
        }
    };
    private static Comparator<JobHistoryParser.TaskAttemptInfo> cShuffle = new Comparator<JobHistoryParser.TaskAttemptInfo>(){

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo t1, JobHistoryParser.TaskAttemptInfo t2) {
            long l1 = t1.getShuffleFinishTime() - t1.getStartTime();
            long l2 = t2.getShuffleFinishTime() - t2.getStartTime();
            return Long.compare(l2, l1);
        }
    };
    private static Comparator<JobHistoryParser.TaskAttemptInfo> cFinishShuffle = new Comparator<JobHistoryParser.TaskAttemptInfo>(){

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo t1, JobHistoryParser.TaskAttemptInfo t2) {
            long l1 = t1.getShuffleFinishTime();
            long l2 = t2.getShuffleFinishTime();
            return Long.compare(l2, l1);
        }
    };
    private static Comparator<JobHistoryParser.TaskAttemptInfo> cFinishMapRed = new Comparator<JobHistoryParser.TaskAttemptInfo>(){

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo t1, JobHistoryParser.TaskAttemptInfo t2) {
            long l1 = t1.getFinishTime();
            long l2 = t2.getFinishTime();
            return Long.compare(l2, l1);
        }
    };
    private static Comparator<JobHistoryParser.TaskAttemptInfo> cReduce = new Comparator<JobHistoryParser.TaskAttemptInfo>(){

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo t1, JobHistoryParser.TaskAttemptInfo t2) {
            long l1 = t1.getFinishTime() - t1.getShuffleFinishTime();
            long l2 = t2.getFinishTime() - t2.getShuffleFinishTime();
            return Long.compare(l2, l1);
        }
    };

    HumanReadableHistoryViewerPrinter(JobHistoryParser.JobInfo job, boolean printAll, String scheme) {
        this(job, printAll, scheme, TimeZone.getDefault());
    }

    HumanReadableHistoryViewerPrinter(JobHistoryParser.JobInfo job, boolean printAll, String scheme, TimeZone tz) {
        this.job = job;
        this.printAll = printAll;
        this.scheme = scheme;
        this.dateFormat = FastDateFormat.getInstance("d-MMM-yyyy HH:mm:ss", tz);
    }

    @Override
    public void print(PrintStream ps) throws IOException {
        this.printJobDetails(ps);
        this.printTaskSummary(ps);
        this.printJobAnalysis(ps);
        this.printTasks(ps, TaskType.JOB_SETUP, TaskStatus.State.FAILED.toString());
        this.printTasks(ps, TaskType.JOB_SETUP, TaskStatus.State.KILLED.toString());
        this.printTasks(ps, TaskType.MAP, TaskStatus.State.FAILED.toString());
        this.printTasks(ps, TaskType.MAP, TaskStatus.State.KILLED.toString());
        this.printTasks(ps, TaskType.REDUCE, TaskStatus.State.FAILED.toString());
        this.printTasks(ps, TaskType.REDUCE, TaskStatus.State.KILLED.toString());
        this.printTasks(ps, TaskType.JOB_CLEANUP, TaskStatus.State.FAILED.toString());
        this.printTasks(ps, TaskType.JOB_CLEANUP, JobStatus.getJobRunState(JobStatus.KILLED));
        if (this.printAll) {
            this.printTasks(ps, TaskType.JOB_SETUP, TaskStatus.State.SUCCEEDED.toString());
            this.printTasks(ps, TaskType.MAP, TaskStatus.State.SUCCEEDED.toString());
            this.printTasks(ps, TaskType.REDUCE, TaskStatus.State.SUCCEEDED.toString());
            this.printTasks(ps, TaskType.JOB_CLEANUP, TaskStatus.State.SUCCEEDED.toString());
            this.printAllTaskAttempts(ps, TaskType.JOB_SETUP);
            this.printAllTaskAttempts(ps, TaskType.MAP);
            this.printAllTaskAttempts(ps, TaskType.REDUCE);
            this.printAllTaskAttempts(ps, TaskType.JOB_CLEANUP);
        }
        HistoryViewer.FilteredJob filter = new HistoryViewer.FilteredJob(this.job, TaskStatus.State.FAILED.toString());
        this.printFailedAttempts(ps, filter);
        filter = new HistoryViewer.FilteredJob(this.job, TaskStatus.State.KILLED.toString());
        this.printFailedAttempts(ps, filter);
    }

    private void printJobDetails(PrintStream ps) {
        StringBuilder jobDetails = new StringBuilder();
        jobDetails.append("\nHadoop job: ").append(this.job.getJobId());
        jobDetails.append("\n=====================================");
        jobDetails.append("\nUser: ").append(this.job.getUsername());
        jobDetails.append("\nJobName: ").append(this.job.getJobname());
        jobDetails.append("\nJobConf: ").append(this.job.getJobConfPath());
        jobDetails.append("\nSubmitted At: ").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)this.job.getSubmitTime(), (long)0L));
        jobDetails.append("\nLaunched At: ").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)this.job.getLaunchTime(), (long)this.job.getSubmitTime()));
        jobDetails.append("\nFinished At: ").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)this.job.getFinishTime(), (long)this.job.getLaunchTime()));
        jobDetails.append("\nStatus: ").append(this.job.getJobStatus() == null ? "Incomplete" : this.job.getJobStatus());
        this.printJobCounters(jobDetails, this.job.getTotalCounters(), this.job.getMapCounters(), this.job.getReduceCounters());
        jobDetails.append("\n");
        jobDetails.append("\n=====================================");
        ps.println(jobDetails);
    }

    private void printJobCounters(StringBuilder buff, Counters totalCounters, Counters mapCounters, Counters reduceCounters) {
        if (totalCounters != null) {
            buff.append("\nCounters: \n\n");
            buff.append(String.format("|%1$-30s|%2$-30s|%3$-10s|%4$-10s|%5$-10s|", "Group Name", "Counter name", "Map Value", "Reduce Value", "Total Value"));
            buff.append("\n---------------------------------------------------------------------------------------");
            for (CounterGroup counterGroup : totalCounters) {
                String groupName = counterGroup.getName();
                CounterGroup totalGroup = (CounterGroup)totalCounters.getGroup(groupName);
                CounterGroup mapGroup = (CounterGroup)mapCounters.getGroup(groupName);
                CounterGroup reduceGroup = (CounterGroup)reduceCounters.getGroup(groupName);
                DecimalFormat decimal = new DecimalFormat();
                for (Counter counter : totalGroup) {
                    String name = counter.getName();
                    String mapValue = decimal.format((Object)mapGroup.findCounter(name).getValue());
                    String reduceValue = decimal.format((Object)reduceGroup.findCounter(name).getValue());
                    String totalValue = decimal.format((Object)counter.getValue());
                    buff.append(String.format("%n|%1$-30s|%2$-30s|%3$-10s|%4$-10s|%5$-10s", totalGroup.getDisplayName(), counter.getDisplayName(), mapValue, reduceValue, totalValue));
                }
            }
        }
    }

    private void printAllTaskAttempts(PrintStream ps, TaskType taskType) {
        Map<TaskID, JobHistoryParser.TaskInfo> tasks = this.job.getAllTasks();
        StringBuilder taskList = new StringBuilder();
        taskList.append("\n").append((Object)taskType);
        taskList.append(" task list for ").append(this.job.getJobId());
        taskList.append("\nTaskId\t\tStartTime");
        if (TaskType.REDUCE.equals((Object)taskType)) {
            taskList.append("\tShuffleFinished\tSortFinished");
        }
        taskList.append("\tFinishTime\tHostName\tError\tTaskLogs");
        taskList.append("\n====================================================");
        ps.println(taskList.toString());
        for (JobHistoryParser.TaskInfo task : tasks.values()) {
            for (JobHistoryParser.TaskAttemptInfo attempt : task.getAllTaskAttempts().values()) {
                if (!taskType.equals((Object)task.getTaskType())) continue;
                taskList.setLength(0);
                taskList.append(attempt.getAttemptId()).append("\t");
                taskList.append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)attempt.getStartTime(), (long)0L)).append("\t");
                if (TaskType.REDUCE.equals((Object)taskType)) {
                    taskList.append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)attempt.getShuffleFinishTime(), (long)attempt.getStartTime()));
                    taskList.append("\t");
                    taskList.append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)attempt.getSortFinishTime(), (long)attempt.getShuffleFinishTime()));
                }
                taskList.append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)attempt.getFinishTime(), (long)attempt.getStartTime()));
                taskList.append("\t");
                taskList.append(attempt.getHostname()).append("\t");
                taskList.append(attempt.getError());
                String taskLogsUrl = HistoryViewer.getTaskLogsUrl(this.scheme, attempt);
                taskList.append(taskLogsUrl != null ? taskLogsUrl : "n/a");
                ps.println(taskList);
            }
        }
    }

    private void printTaskSummary(PrintStream ps) {
        HistoryViewer.SummarizedJob ts = new HistoryViewer.SummarizedJob(this.job);
        StringBuilder taskSummary = new StringBuilder();
        taskSummary.append("\nTask Summary");
        taskSummary.append("\n============================");
        taskSummary.append("\nKind\tTotal\t");
        taskSummary.append("Successful\tFailed\tKilled\tStartTime\tFinishTime");
        taskSummary.append("\n");
        taskSummary.append("\nSetup\t").append(ts.totalSetups);
        taskSummary.append("\t").append(ts.numFinishedSetups);
        taskSummary.append("\t\t").append(ts.numFailedSetups);
        taskSummary.append("\t").append(ts.numKilledSetups);
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)ts.setupStarted, (long)0L));
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)ts.setupFinished, (long)ts.setupStarted));
        taskSummary.append("\nMap\t").append(ts.totalMaps);
        taskSummary.append("\t").append(this.job.getFinishedMaps());
        taskSummary.append("\t\t").append(ts.numFailedMaps);
        taskSummary.append("\t").append(ts.numKilledMaps);
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)ts.mapStarted, (long)0L));
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)ts.mapFinished, (long)ts.mapStarted));
        taskSummary.append("\nReduce\t").append(ts.totalReduces);
        taskSummary.append("\t").append(this.job.getFinishedReduces());
        taskSummary.append("\t\t").append(ts.numFailedReduces);
        taskSummary.append("\t").append(ts.numKilledReduces);
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)ts.reduceStarted, (long)0L));
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)ts.reduceFinished, (long)ts.reduceStarted));
        taskSummary.append("\nCleanup\t").append(ts.totalCleanups);
        taskSummary.append("\t").append(ts.numFinishedCleanups);
        taskSummary.append("\t\t").append(ts.numFailedCleanups);
        taskSummary.append("\t").append(ts.numKilledCleanups);
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)ts.cleanupStarted, (long)0L));
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)ts.cleanupFinished, (long)ts.cleanupStarted));
        taskSummary.append("\n============================\n");
        ps.println(taskSummary);
    }

    private void printJobAnalysis(PrintStream ps) {
        if (this.job.getJobStatus().equals(JobStatus.getJobRunState(JobStatus.SUCCEEDED))) {
            HistoryViewer.AnalyzedJob avg = new HistoryViewer.AnalyzedJob(this.job);
            ps.println("\nAnalysis");
            ps.println("=========");
            this.printAnalysis(ps, avg.getMapTasks(), cMap, "map", avg.getAvgMapTime(), 10);
            this.printLast(ps, avg.getMapTasks(), "map", cFinishMapRed);
            if (avg.getReduceTasks().length > 0) {
                this.printAnalysis(ps, avg.getReduceTasks(), cShuffle, "shuffle", avg.getAvgShuffleTime(), 10);
                this.printLast(ps, avg.getReduceTasks(), "shuffle", cFinishShuffle);
                this.printAnalysis(ps, avg.getReduceTasks(), cReduce, "reduce", avg.getAvgReduceTime(), 10);
                this.printLast(ps, avg.getReduceTasks(), "reduce", cFinishMapRed);
            }
            ps.println("=========");
        } else {
            ps.println("No Analysis available as job did not finish");
        }
    }

    protected void printAnalysis(PrintStream ps, JobHistoryParser.TaskAttemptInfo[] tasks, Comparator<JobHistoryParser.TaskAttemptInfo> cmp, String taskType, long avg, int showTasks) {
        Arrays.sort(tasks, cmp);
        JobHistoryParser.TaskAttemptInfo min2 = tasks[tasks.length - 1];
        StringBuilder details = new StringBuilder();
        details.append("\nTime taken by best performing ");
        details.append(taskType).append(" task ");
        details.append(min2.getAttemptId().getTaskID().toString()).append(": ");
        if ("map".equals(taskType)) {
            details.append(StringUtils.formatTimeDiff((long)min2.getFinishTime(), (long)min2.getStartTime()));
        } else if ("shuffle".equals(taskType)) {
            details.append(StringUtils.formatTimeDiff((long)min2.getShuffleFinishTime(), (long)min2.getStartTime()));
        } else {
            details.append(StringUtils.formatTimeDiff((long)min2.getFinishTime(), (long)min2.getShuffleFinishTime()));
        }
        details.append("\nAverage time taken by ");
        details.append(taskType).append(" tasks: ");
        details.append(StringUtils.formatTimeDiff((long)avg, (long)0L));
        details.append("\nWorse performing ");
        details.append(taskType).append(" tasks: ");
        details.append("\nTaskId\t\tTimetaken");
        ps.println(details);
        for (int i = 0; i < showTasks && i < tasks.length; ++i) {
            details.setLength(0);
            details.append(tasks[i].getAttemptId().getTaskID()).append(" ");
            if ("map".equals(taskType)) {
                details.append(StringUtils.formatTimeDiff((long)tasks[i].getFinishTime(), (long)tasks[i].getStartTime()));
            } else if ("shuffle".equals(taskType)) {
                details.append(StringUtils.formatTimeDiff((long)tasks[i].getShuffleFinishTime(), (long)tasks[i].getStartTime()));
            } else {
                details.append(StringUtils.formatTimeDiff((long)tasks[i].getFinishTime(), (long)tasks[i].getShuffleFinishTime()));
            }
            ps.println(details);
        }
    }

    protected void printLast(PrintStream ps, JobHistoryParser.TaskAttemptInfo[] tasks, String taskType, Comparator<JobHistoryParser.TaskAttemptInfo> cmp) {
        Arrays.sort(tasks, cFinishMapRed);
        JobHistoryParser.TaskAttemptInfo last = tasks[0];
        StringBuilder lastBuf = new StringBuilder();
        lastBuf.append("The last ").append(taskType);
        lastBuf.append(" task ").append(last.getAttemptId().getTaskID());
        Long finishTime = "shuffle".equals(taskType) ? Long.valueOf(last.getShuffleFinishTime()) : Long.valueOf(last.getFinishTime());
        lastBuf.append(" finished at (relative to the Job launch time): ");
        lastBuf.append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)finishTime, (long)this.job.getLaunchTime()));
        ps.println(lastBuf);
    }

    private void printTasks(PrintStream ps, TaskType taskType, String status) {
        Map<TaskID, JobHistoryParser.TaskInfo> tasks = this.job.getAllTasks();
        StringBuilder header = new StringBuilder();
        header.append("\n").append(status).append(" ");
        header.append((Object)taskType).append(" task list for ").append(this.job.getJobId().toString());
        header.append("\nTaskId\t\tStartTime\tFinishTime\tError");
        if (TaskType.MAP.equals((Object)taskType)) {
            header.append("\tInputSplits");
        }
        header.append("\n====================================================");
        StringBuilder taskList = new StringBuilder();
        for (JobHistoryParser.TaskInfo task : tasks.values()) {
            if (!taskType.equals((Object)task.getTaskType()) || !status.equals(task.getTaskStatus()) && !status.equalsIgnoreCase("ALL")) continue;
            taskList.setLength(0);
            taskList.append(task.getTaskId());
            taskList.append("\t").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)task.getStartTime(), (long)0L));
            taskList.append("\t").append(StringUtils.getFormattedTimeWithDiff((FastDateFormat)this.dateFormat, (long)task.getFinishTime(), (long)task.getStartTime()));
            taskList.append("\t").append(task.getError());
            if (TaskType.MAP.equals((Object)taskType)) {
                taskList.append("\t").append(task.getSplitLocations());
            }
            if (taskList == null) continue;
            ps.println(header);
            ps.println(taskList);
        }
    }

    private void printFailedAttempts(PrintStream ps, HistoryViewer.FilteredJob filteredJob) {
        Map<String, Set<TaskID>> badNodes = filteredJob.getFilteredMap();
        StringBuilder attempts = new StringBuilder();
        if (badNodes.size() > 0) {
            attempts.append("\n").append(filteredJob.getFilter());
            attempts.append(" task attempts by nodes");
            attempts.append("\nHostname\tFailedTasks");
            attempts.append("\n===============================");
            ps.println(attempts);
            for (Map.Entry<String, Set<TaskID>> entry : badNodes.entrySet()) {
                String node = entry.getKey();
                Set<TaskID> failedTasks = entry.getValue();
                attempts.setLength(0);
                attempts.append(node).append("\t");
                for (TaskID t : failedTasks) {
                    attempts.append(t).append(", ");
                }
                ps.println(attempts);
            }
        }
    }
}

