/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2.dpp;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

class DppColumns
implements Comparable<DppColumns>,
Serializable {
    public List<Object> columns = new ArrayList<Object>();

    public DppColumns(List<Object> keys2) {
        this.columns = keys2;
    }

    public DppColumns(DppColumns key, List<Integer> indexes) {
        for (int i = 0; i < indexes.size(); ++i) {
            this.columns.add(key.columns.get(indexes.get(i)));
        }
    }

    @Override
    public int compareTo(DppColumns other) {
        Preconditions.checkState(this.columns.size() == other.columns.size());
        int cmp = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            Object columnObj = this.columns.get(i);
            Object otherColumn = other.columns.get(i);
            if (columnObj == null && otherColumn == null) {
                return 0;
            }
            if (columnObj == null || otherColumn == null) {
                if (columnObj == null) {
                    return -1;
                }
                return 1;
            }
            cmp = this.columns.get(i) instanceof Integer ? ((Integer)this.columns.get(i)).compareTo((Integer)other.columns.get(i)) : (this.columns.get(i) instanceof Long ? ((Long)this.columns.get(i)).compareTo((Long)other.columns.get(i)) : (this.columns.get(i) instanceof Boolean ? ((Boolean)this.columns.get(i)).compareTo((Boolean)other.columns.get(i)) : (this.columns.get(i) instanceof Short ? ((Short)this.columns.get(i)).compareTo((Short)other.columns.get(i)) : (this.columns.get(i) instanceof Float ? ((Float)this.columns.get(i)).compareTo((Float)other.columns.get(i)) : (this.columns.get(i) instanceof Double ? ((Double)this.columns.get(i)).compareTo((Double)other.columns.get(i)) : (this.columns.get(i) instanceof Date ? ((Date)this.columns.get(i)).compareTo((Date)other.columns.get(i)) : (this.columns.get(i) instanceof Timestamp ? ((Timestamp)this.columns.get(i)).compareTo((Timestamp)other.columns.get(i)) : ((String)this.columns.get(i)).compareTo((String)other.columns.get(i)))))))));
            if (cmp == 0) continue;
            return cmp;
        }
        return cmp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DppColumns dppColumns = (DppColumns)o;
        return Objects.equals(this.columns, dppColumns.columns);
    }

    public int hashCode() {
        return Objects.hash(this.columns);
    }

    public String toString() {
        return "dppColumns{columns=" + this.columns + '}';
    }
}

