/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(LimitInputStream.class);
    protected final InputStream in;
    protected final int speed;
    protected long bytesReadTotal;
    protected long startTime;
    protected boolean bstart;
    byte[] oneByte = new byte[1];

    public LimitInputStream(InputStream in, int limitspeed) throws IOException {
        if (in == null) {
            throw new IOException("InputStream is null");
        }
        this.speed = limitspeed;
        LOG.debug("LimitinputStream limit speed: {}", (Object)this.speed);
        this.in = in;
        this.bytesReadTotal = 0L;
        this.bstart = false;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long sleepTime = 0L;
        long curTime = 0L;
        int bytesRead = -1;
        IOException ioe = null;
        try {
            block11: {
                long resetTime;
                if (this.speed > 0 && !this.bstart) {
                    this.startTime = System.currentTimeMillis();
                    this.bstart = true;
                }
                if ((resetTime = System.currentTimeMillis()) - this.startTime > 1000L) {
                    this.bytesReadTotal = 0L;
                    this.startTime = resetTime;
                }
                if ((bytesRead = this.in.read(b, off, len)) < 0) break block11;
                this.bytesReadTotal += (long)bytesRead;
                if (this.speed <= 0) break;
                curTime = System.currentTimeMillis();
                sleepTime = this.bytesReadTotal / (long)this.speed * 1000L - (curTime - this.startTime);
                if (sleepTime > 0L) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        LOG.warn("Thread sleep is interrupted");
                    }
                }
                break;
            }
        }
        catch (IOException ex) {
            ioe = ex;
            return (int)ioe;
        }
        finally {
            if (bytesRead == -1 && ioe != null) {
                throw ioe;
            }
            return bytesRead;
        }
    }

    @Override
    public int read() throws IOException {
        return this.read(this.oneByte, 0, this.oneByte.length) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }
}

