/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Codec {
    public static void encodeVarint64(long source2, DataOutput out) throws IOException {
        assert (source2 >= 0L);
        int B2 = 128;
        while (source2 >= (long)B2) {
            out.write((int)(source2 & (long)(B2 - 1) | (long)B2));
            source2 >>= 7;
        }
        out.write((int)(source2 & (long)(B2 - 1)));
    }

    public static long decodeVarint64(DataInput in) throws IOException {
        long result = 0L;
        int shift = 0;
        int B2 = 128;
        while (true) {
            int oneByte;
            boolean isEnd = ((oneByte = in.readUnsignedByte()) & B2) == 0;
            result |= (long)(oneByte & B2 - 1) << shift * 7;
            if (isEnd) break;
            ++shift;
        }
        return result;
    }
}

