/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.teaopenapi;

import com.aliyun.gateway.spi.models.AttributeMap;
import com.aliyun.gateway.spi.models.InterceptorContext;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyun.tea.interceptor.InterceptorChain;
import com.aliyun.tea.interceptor.RequestInterceptor;
import com.aliyun.tea.interceptor.ResponseInterceptor;
import com.aliyun.tea.interceptor.RuntimeOptionsInterceptor;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teaopenapi.models.OpenApiRequest;
import com.aliyun.teaopenapi.models.Params;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import java.util.Map;

public class Client {
    private static final InterceptorChain interceptorChain = InterceptorChain.create();
    public String _endpoint;
    public String _regionId;
    public String _protocol;
    public String _method;
    public String _userAgent;
    public String _endpointRule;
    public Map<String, String> _endpointMap;
    public String _suffix;
    public Integer _readTimeout;
    public Integer _connectTimeout;
    public String _httpProxy;
    public String _httpsProxy;
    public String _socks5Proxy;
    public String _socks5NetWork;
    public String _noProxy;
    public String _network;
    public String _productId;
    public Integer _maxIdleConns;
    public String _endpointType;
    public String _openPlatformEndpoint;
    public com.aliyun.credentials.Client _credential;
    public String _signatureVersion;
    public String _signatureAlgorithm;
    public Map<String, String> _headers;
    public com.aliyun.gateway.spi.Client _spi;

    public Client(Config config) throws Exception {
        if (Common.isUnset(TeaModel.buildMap(config))) {
            throw new TeaException(TeaConverter.buildMap(new TeaPair("code", "ParameterMissing"), new TeaPair("message", "'config' can not be unset")));
        }
        if (!Common.empty(config.accessKeyId) && !Common.empty(config.accessKeySecret)) {
            config.type = !Common.empty(config.securityToken) ? "sts" : "access_key";
            com.aliyun.credentials.models.Config credentialConfig = com.aliyun.credentials.models.Config.build(TeaConverter.buildMap(new TeaPair("accessKeyId", config.accessKeyId), new TeaPair("type", config.type), new TeaPair("accessKeySecret", config.accessKeySecret), new TeaPair("securityToken", config.securityToken)));
            this._credential = new com.aliyun.credentials.Client(credentialConfig);
        } else if (!Common.isUnset(config.credential)) {
            this._credential = config.credential;
        }
        this._endpoint = config.endpoint;
        this._endpointType = config.endpointType;
        this._network = config.network;
        this._suffix = config.suffix;
        this._protocol = config.protocol;
        this._method = config.method;
        this._regionId = config.regionId;
        this._userAgent = config.userAgent;
        this._readTimeout = config.readTimeout;
        this._connectTimeout = config.connectTimeout;
        this._httpProxy = config.httpProxy;
        this._httpsProxy = config.httpsProxy;
        this._noProxy = config.noProxy;
        this._socks5Proxy = config.socks5Proxy;
        this._socks5NetWork = config.socks5NetWork;
        this._maxIdleConns = config.maxIdleConns;
        this._signatureVersion = config.signatureVersion;
        this._signatureAlgorithm = config.signatureAlgorithm;
    }

    public Map<String, ?> doRPCRequest(String action, String version, String protocol, String method, String authType, String bodyType, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams(request, "request");
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("timeouted", "retry"), new TeaPair("readTimeout", Common.defaultNumber(runtime.readTimeout, this._readTimeout)), new TeaPair("connectTimeout", Common.defaultNumber(runtime.connectTimeout, this._connectTimeout)), new TeaPair("httpProxy", Common.defaultString(runtime.httpProxy, this._httpProxy)), new TeaPair("httpsProxy", Common.defaultString(runtime.httpsProxy, this._httpsProxy)), new TeaPair("noProxy", Common.defaultString(runtime.noProxy, this._noProxy)), new TeaPair("socks5Proxy", Common.defaultString(runtime.socks5Proxy, this._socks5Proxy)), new TeaPair("socks5NetWork", Common.defaultString(runtime.socks5NetWork, this._socks5NetWork)), new TeaPair("maxIdleConns", Common.defaultNumber(runtime.maxIdleConns, this._maxIdleConns)), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("retryable", runtime.autoretry), new TeaPair("maxAttempts", Common.defaultNumber(runtime.maxAttempts, 3)))), new TeaPair("backoff", TeaConverter.buildMap(new TeaPair("policy", Common.defaultString(runtime.backoffPolicy, "no")), new TeaPair("period", Common.defaultNumber(runtime.backoffPeriod, 1)))), new TeaPair("ignoreSSL", runtime.ignoreSSL));
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        TeaResponse _lastResponse = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                Map<String, Object> err;
                TeaResponse response_;
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString(this._protocol, protocol);
                request_.method = method;
                request_.pathname = "/";
                request_.query = TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("Action", action), new TeaPair("Format", "json"), new TeaPair("Version", version), new TeaPair("Timestamp", com.aliyun.openapiutil.Client.getTimestamp()), new TeaPair("SignatureNonce", Common.getNonce())), request.query);
                Map<String, String> headers = this.getRpcHeaders();
                request_.headers = Common.isUnset(headers) ? TeaConverter.buildMap(new TeaPair("host", this._endpoint), new TeaPair("x-acs-version", version), new TeaPair("x-acs-action", action), new TeaPair("user-agent", this.getUserAgent())) : TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("host", this._endpoint), new TeaPair("x-acs-version", version), new TeaPair("x-acs-action", action), new TeaPair("user-agent", this.getUserAgent())), headers);
                if (!Common.isUnset(request.body)) {
                    Map<String, Object> m = Common.assertAsMap(request.body);
                    Map<String, Object> tmp = Common.anyifyMapValue(com.aliyun.openapiutil.Client.query(m));
                    request_.body = Tea.toReadable(Common.toFormString(tmp));
                    request_.headers.put("content-type", "application/x-www-form-urlencoded");
                }
                if (!Common.equalString(authType, "Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    String accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!Common.empty(securityToken)) {
                        request_.query.put("SecurityToken", securityToken);
                    }
                    request_.query.put("SignatureMethod", "HMAC-SHA1");
                    request_.query.put("SignatureVersion", "1.0");
                    request_.query.put("AccessKeyId", accessKeyId);
                    Map<String, Object> t = null;
                    if (!Common.isUnset(request.body)) {
                        t = Common.assertAsMap(request.body);
                    }
                    Map<String, String> signedParam = TeaConverter.merge(String.class, request_.query, com.aliyun.openapiutil.Client.query(t));
                    request_.query.put("Signature", com.aliyun.openapiutil.Client.getRPCSignature(signedParam, request_.method, accessKeySecret));
                }
                _lastRequest = request_;
                _lastResponse = response_ = Tea.doAction(request_, runtime_, interceptorChain);
                if (Common.is4xx(response_.statusCode) || Common.is5xx(response_.statusCode)) {
                    Object _res = Common.readAsJSON(response_.body);
                    err = Common.assertAsMap(_res);
                    Object requestId = Client.defaultAny(err.get("RequestId"), err.get("requestId"));
                    throw new TeaException(TeaConverter.buildMap(new TeaPair("code", "" + Client.defaultAny(err.get("Code"), err.get("code")) + ""), new TeaPair("message", "code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + requestId + ""), new TeaPair("data", err)));
                }
                if (Common.equalString(bodyType, "binary")) {
                    Map resp = TeaConverter.buildMap(new TeaPair("body", response_.body), new TeaPair("headers", response_.headers));
                    err = resp;
                    return err;
                }
                if (Common.equalString(bodyType, "byte")) {
                    byte[] byt = Common.readAsBytes(response_.body);
                    err = TeaConverter.buildMap(new TeaPair("body", byt), new TeaPair("headers", response_.headers));
                    return err;
                }
                if (Common.equalString(bodyType, "string")) {
                    String str = Common.readAsString(response_.body);
                    err = TeaConverter.buildMap(new TeaPair("body", str), new TeaPair("headers", response_.headers));
                    return err;
                }
                if (Common.equalString(bodyType, "json")) {
                    Object obj = Common.readAsJSON(response_.body);
                    Map<String, Object> res = Common.assertAsMap(obj);
                    Map map = TeaConverter.buildMap(new TeaPair("body", res), new TeaPair("headers", response_.headers));
                    return map;
                }
                if (Common.equalString(bodyType, "array")) {
                    Object arr = Common.readAsJSON(response_.body);
                    Map map = TeaConverter.buildMap(new TeaPair("body", arr), new TeaPair("headers", response_.headers));
                    return map;
                }
                Map map = TeaConverter.buildMap(new TeaPair("headers", response_.headers));
                return map;
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
            finally {
                if (Common.isUnset(_lastResponse) || Common.isUnset(_lastResponse.response) || Common.isUnset(_lastResponse.response.body())) continue;
                _lastResponse.response.close();
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public Map<String, ?> doROARequest(String action, String version, String protocol, String method, String authType, String pathname, String bodyType, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams(request, "request");
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("timeouted", "retry"), new TeaPair("readTimeout", Common.defaultNumber(runtime.readTimeout, this._readTimeout)), new TeaPair("connectTimeout", Common.defaultNumber(runtime.connectTimeout, this._connectTimeout)), new TeaPair("httpProxy", Common.defaultString(runtime.httpProxy, this._httpProxy)), new TeaPair("httpsProxy", Common.defaultString(runtime.httpsProxy, this._httpsProxy)), new TeaPair("noProxy", Common.defaultString(runtime.noProxy, this._noProxy)), new TeaPair("socks5Proxy", Common.defaultString(runtime.socks5Proxy, this._socks5Proxy)), new TeaPair("socks5NetWork", Common.defaultString(runtime.socks5NetWork, this._socks5NetWork)), new TeaPair("maxIdleConns", Common.defaultNumber(runtime.maxIdleConns, this._maxIdleConns)), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("retryable", runtime.autoretry), new TeaPair("maxAttempts", Common.defaultNumber(runtime.maxAttempts, 3)))), new TeaPair("backoff", TeaConverter.buildMap(new TeaPair("policy", Common.defaultString(runtime.backoffPolicy, "no")), new TeaPair("period", Common.defaultNumber(runtime.backoffPeriod, 1)))), new TeaPair("ignoreSSL", runtime.ignoreSSL));
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        TeaResponse _lastResponse = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                Map<String, Object> err;
                TeaResponse response_;
                Object accessKeySecret;
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString(this._protocol, protocol);
                request_.method = method;
                request_.pathname = pathname;
                request_.headers = TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("date", Common.getDateUTCString()), new TeaPair("host", this._endpoint), new TeaPair("accept", "application/json"), new TeaPair("x-acs-signature-nonce", Common.getNonce()), new TeaPair("x-acs-signature-method", "HMAC-SHA1"), new TeaPair("x-acs-signature-version", "1.0"), new TeaPair("x-acs-version", version), new TeaPair("x-acs-action", action), new TeaPair("user-agent", Common.getUserAgent(this._userAgent))), request.headers);
                if (!Common.isUnset(request.body)) {
                    request_.body = Tea.toReadable(Common.toJSONString(request.body));
                    request_.headers.put("content-type", "application/json; charset=utf-8");
                }
                if (!Common.isUnset(request.query)) {
                    request_.query = request.query;
                }
                if (!Common.equalString(authType, "Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!Common.empty(securityToken)) {
                        request_.headers.put("x-acs-accesskey-id", accessKeyId);
                        request_.headers.put("x-acs-security-token", securityToken);
                    }
                    String stringToSign = com.aliyun.openapiutil.Client.getStringToSign(request_);
                    request_.headers.put("authorization", "acs " + accessKeyId + ":" + com.aliyun.openapiutil.Client.getROASignature(stringToSign, (String)accessKeySecret) + "");
                }
                _lastRequest = request_;
                _lastResponse = response_ = Tea.doAction(request_, runtime_, interceptorChain);
                if (Common.equalNumber(response_.statusCode, 204)) {
                    accessKeySecret = TeaConverter.buildMap(new TeaPair("headers", response_.headers));
                    return accessKeySecret;
                }
                if (Common.is4xx(response_.statusCode) || Common.is5xx(response_.statusCode)) {
                    Object _res = Common.readAsJSON(response_.body);
                    err = Common.assertAsMap(_res);
                    Object requestId = Client.defaultAny(err.get("RequestId"), err.get("requestId"));
                    requestId = Client.defaultAny(requestId, err.get("requestid"));
                    throw new TeaException(TeaConverter.buildMap(new TeaPair("code", "" + Client.defaultAny(err.get("Code"), err.get("code")) + ""), new TeaPair("message", "code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + requestId + ""), new TeaPair("data", err)));
                }
                if (Common.equalString(bodyType, "binary")) {
                    Map resp = TeaConverter.buildMap(new TeaPair("body", response_.body), new TeaPair("headers", response_.headers));
                    err = resp;
                    return err;
                }
                if (Common.equalString(bodyType, "byte")) {
                    byte[] byt = Common.readAsBytes(response_.body);
                    err = TeaConverter.buildMap(new TeaPair("body", byt), new TeaPair("headers", response_.headers));
                    return err;
                }
                if (Common.equalString(bodyType, "string")) {
                    String str = Common.readAsString(response_.body);
                    err = TeaConverter.buildMap(new TeaPair("body", str), new TeaPair("headers", response_.headers));
                    return err;
                }
                if (Common.equalString(bodyType, "json")) {
                    Object obj = Common.readAsJSON(response_.body);
                    Map<String, Object> res = Common.assertAsMap(obj);
                    Map map = TeaConverter.buildMap(new TeaPair("body", res), new TeaPair("headers", response_.headers));
                    return map;
                }
                if (Common.equalString(bodyType, "array")) {
                    Object arr = Common.readAsJSON(response_.body);
                    Map map = TeaConverter.buildMap(new TeaPair("body", arr), new TeaPair("headers", response_.headers));
                    return map;
                }
                Map map = TeaConverter.buildMap(new TeaPair("headers", response_.headers));
                return map;
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
            finally {
                if (Common.isUnset(_lastResponse) || Common.isUnset(_lastResponse.response) || Common.isUnset(_lastResponse.response.body())) continue;
                _lastResponse.response.close();
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public Map<String, ?> doROARequestWithForm(String action, String version, String protocol, String method, String authType, String pathname, String bodyType, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams(request, "request");
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("timeouted", "retry"), new TeaPair("readTimeout", Common.defaultNumber(runtime.readTimeout, this._readTimeout)), new TeaPair("connectTimeout", Common.defaultNumber(runtime.connectTimeout, this._connectTimeout)), new TeaPair("httpProxy", Common.defaultString(runtime.httpProxy, this._httpProxy)), new TeaPair("httpsProxy", Common.defaultString(runtime.httpsProxy, this._httpsProxy)), new TeaPair("noProxy", Common.defaultString(runtime.noProxy, this._noProxy)), new TeaPair("socks5Proxy", Common.defaultString(runtime.socks5Proxy, this._socks5Proxy)), new TeaPair("socks5NetWork", Common.defaultString(runtime.socks5NetWork, this._socks5NetWork)), new TeaPair("maxIdleConns", Common.defaultNumber(runtime.maxIdleConns, this._maxIdleConns)), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("retryable", runtime.autoretry), new TeaPair("maxAttempts", Common.defaultNumber(runtime.maxAttempts, 3)))), new TeaPair("backoff", TeaConverter.buildMap(new TeaPair("policy", Common.defaultString(runtime.backoffPolicy, "no")), new TeaPair("period", Common.defaultNumber(runtime.backoffPeriod, 1)))), new TeaPair("ignoreSSL", runtime.ignoreSSL));
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        TeaResponse _lastResponse = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                Map<String, Object> err;
                TeaResponse response_;
                Object accessKeySecret;
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString(this._protocol, protocol);
                request_.method = method;
                request_.pathname = pathname;
                request_.headers = TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("date", Common.getDateUTCString()), new TeaPair("host", this._endpoint), new TeaPair("accept", "application/json"), new TeaPair("x-acs-signature-nonce", Common.getNonce()), new TeaPair("x-acs-signature-method", "HMAC-SHA1"), new TeaPair("x-acs-signature-version", "1.0"), new TeaPair("x-acs-version", version), new TeaPair("x-acs-action", action), new TeaPair("user-agent", Common.getUserAgent(this._userAgent))), request.headers);
                if (!Common.isUnset(request.body)) {
                    Map<String, Object> m = Common.assertAsMap(request.body);
                    request_.body = Tea.toReadable(com.aliyun.openapiutil.Client.toForm(m));
                    request_.headers.put("content-type", "application/x-www-form-urlencoded");
                }
                if (!Common.isUnset(request.query)) {
                    request_.query = request.query;
                }
                if (!Common.equalString(authType, "Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!Common.empty(securityToken)) {
                        request_.headers.put("x-acs-accesskey-id", accessKeyId);
                        request_.headers.put("x-acs-security-token", securityToken);
                    }
                    String stringToSign = com.aliyun.openapiutil.Client.getStringToSign(request_);
                    request_.headers.put("authorization", "acs " + accessKeyId + ":" + com.aliyun.openapiutil.Client.getROASignature(stringToSign, (String)accessKeySecret) + "");
                }
                _lastRequest = request_;
                _lastResponse = response_ = Tea.doAction(request_, runtime_, interceptorChain);
                if (Common.equalNumber(response_.statusCode, 204)) {
                    accessKeySecret = TeaConverter.buildMap(new TeaPair("headers", response_.headers));
                    return accessKeySecret;
                }
                if (Common.is4xx(response_.statusCode) || Common.is5xx(response_.statusCode)) {
                    Object _res = Common.readAsJSON(response_.body);
                    err = Common.assertAsMap(_res);
                    throw new TeaException(TeaConverter.buildMap(new TeaPair("code", "" + Client.defaultAny(err.get("Code"), err.get("code")) + ""), new TeaPair("message", "code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + Client.defaultAny(err.get("RequestId"), err.get("requestId")) + ""), new TeaPair("data", err)));
                }
                if (Common.equalString(bodyType, "binary")) {
                    Map resp = TeaConverter.buildMap(new TeaPair("body", response_.body), new TeaPair("headers", response_.headers));
                    err = resp;
                    return err;
                }
                if (Common.equalString(bodyType, "byte")) {
                    byte[] byt = Common.readAsBytes(response_.body);
                    err = TeaConverter.buildMap(new TeaPair("body", byt), new TeaPair("headers", response_.headers));
                    return err;
                }
                if (Common.equalString(bodyType, "string")) {
                    String str = Common.readAsString(response_.body);
                    err = TeaConverter.buildMap(new TeaPair("body", str), new TeaPair("headers", response_.headers));
                    return err;
                }
                if (Common.equalString(bodyType, "json")) {
                    Object obj = Common.readAsJSON(response_.body);
                    Map<String, Object> res = Common.assertAsMap(obj);
                    Map map = TeaConverter.buildMap(new TeaPair("body", res), new TeaPair("headers", response_.headers));
                    return map;
                }
                if (Common.equalString(bodyType, "array")) {
                    Object arr = Common.readAsJSON(response_.body);
                    Map map = TeaConverter.buildMap(new TeaPair("body", arr), new TeaPair("headers", response_.headers));
                    return map;
                }
                Map map = TeaConverter.buildMap(new TeaPair("headers", response_.headers));
                return map;
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
            finally {
                if (Common.isUnset(_lastResponse) || Common.isUnset(_lastResponse.response) || Common.isUnset(_lastResponse.response.body())) continue;
                _lastResponse.response.close();
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public Map<String, ?> doRequest(Params params, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams(params, "params");
        TeaModel.validateParams(request, "request");
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("timeouted", "retry"), new TeaPair("readTimeout", Common.defaultNumber(runtime.readTimeout, this._readTimeout)), new TeaPair("connectTimeout", Common.defaultNumber(runtime.connectTimeout, this._connectTimeout)), new TeaPair("httpProxy", Common.defaultString(runtime.httpProxy, this._httpProxy)), new TeaPair("httpsProxy", Common.defaultString(runtime.httpsProxy, this._httpsProxy)), new TeaPair("noProxy", Common.defaultString(runtime.noProxy, this._noProxy)), new TeaPair("socks5Proxy", Common.defaultString(runtime.socks5Proxy, this._socks5Proxy)), new TeaPair("socks5NetWork", Common.defaultString(runtime.socks5NetWork, this._socks5NetWork)), new TeaPair("maxIdleConns", Common.defaultNumber(runtime.maxIdleConns, this._maxIdleConns)), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("retryable", runtime.autoretry), new TeaPair("maxAttempts", Common.defaultNumber(runtime.maxAttempts, 3)))), new TeaPair("backoff", TeaConverter.buildMap(new TeaPair("policy", Common.defaultString(runtime.backoffPolicy, "no")), new TeaPair("period", Common.defaultNumber(runtime.backoffPeriod, 1)))), new TeaPair("ignoreSSL", runtime.ignoreSSL));
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        TeaResponse _lastResponse = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                Map<String, Object> err;
                TeaResponse response_;
                Map<String, String> headers;
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString(this._protocol, params.protocol);
                request_.method = params.method;
                request_.pathname = params.pathname;
                request_.query = request.query;
                request_.headers = TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("host", this._endpoint), new TeaPair("x-acs-version", params.version), new TeaPair("x-acs-action", params.action), new TeaPair("user-agent", this.getUserAgent()), new TeaPair("x-acs-date", com.aliyun.openapiutil.Client.getTimestamp()), new TeaPair("x-acs-signature-nonce", Common.getNonce()), new TeaPair("accept", "application/json")), request.headers);
                if (Common.equalString(params.style, "RPC") && !Common.isUnset(headers = this.getRpcHeaders())) {
                    request_.headers = TeaConverter.merge(String.class, request_.headers, headers);
                }
                String signatureAlgorithm = Common.defaultString(this._signatureAlgorithm, "ACS3-HMAC-SHA256");
                String hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode(com.aliyun.openapiutil.Client.hash(Common.toBytes(""), signatureAlgorithm));
                if (!Common.isUnset(request.stream)) {
                    byte[] tmp = Common.readAsBytes(request.stream);
                    hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode(com.aliyun.openapiutil.Client.hash(tmp, signatureAlgorithm));
                    request_.body = Tea.toReadable(tmp);
                    request_.headers.put("content-type", "application/octet-stream");
                } else if (!Common.isUnset(request.body)) {
                    if (Common.equalString(params.reqBodyType, "json")) {
                        String jsonObj = Common.toJSONString(request.body);
                        hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode(com.aliyun.openapiutil.Client.hash(Common.toBytes(jsonObj), signatureAlgorithm));
                        request_.body = Tea.toReadable(jsonObj);
                        request_.headers.put("content-type", "application/json; charset=utf-8");
                    } else {
                        Map<String, Object> m = Common.assertAsMap(request.body);
                        String formObj = com.aliyun.openapiutil.Client.toForm(m);
                        hashedRequestPayload = com.aliyun.openapiutil.Client.hexEncode(com.aliyun.openapiutil.Client.hash(Common.toBytes(formObj), signatureAlgorithm));
                        request_.body = Tea.toReadable(formObj);
                        request_.headers.put("content-type", "application/x-www-form-urlencoded");
                    }
                }
                request_.headers.put("x-acs-content-sha256", hashedRequestPayload);
                if (!Common.equalString(params.authType, "Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    String accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!Common.empty(securityToken)) {
                        request_.headers.put("x-acs-accesskey-id", accessKeyId);
                        request_.headers.put("x-acs-security-token", securityToken);
                    }
                    request_.headers.put("Authorization", com.aliyun.openapiutil.Client.getAuthorization(request_, signatureAlgorithm, hashedRequestPayload, accessKeyId, accessKeySecret));
                }
                _lastRequest = request_;
                _lastResponse = response_ = Tea.doAction(request_, runtime_, interceptorChain);
                if (Common.is4xx(response_.statusCode) || Common.is5xx(response_.statusCode)) {
                    Object _res = Common.readAsJSON(response_.body);
                    err = Common.assertAsMap(_res);
                    throw new TeaException(TeaConverter.buildMap(new TeaPair("code", "" + Client.defaultAny(err.get("Code"), err.get("code")) + ""), new TeaPair("message", "code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " request id: " + Client.defaultAny(err.get("RequestId"), err.get("requestId")) + ""), new TeaPair("data", err)));
                }
                if (Common.equalString(params.bodyType, "binary")) {
                    Map resp = TeaConverter.buildMap(new TeaPair("body", response_.body), new TeaPair("headers", response_.headers));
                    err = resp;
                    return err;
                }
                if (Common.equalString(params.bodyType, "byte")) {
                    byte[] byt = Common.readAsBytes(response_.body);
                    err = TeaConverter.buildMap(new TeaPair("body", byt), new TeaPair("headers", response_.headers));
                    return err;
                }
                if (Common.equalString(params.bodyType, "string")) {
                    String str = Common.readAsString(response_.body);
                    err = TeaConverter.buildMap(new TeaPair("body", str), new TeaPair("headers", response_.headers));
                    return err;
                }
                if (Common.equalString(params.bodyType, "json")) {
                    Object obj = Common.readAsJSON(response_.body);
                    Map<String, Object> res = Common.assertAsMap(obj);
                    Map map = TeaConverter.buildMap(new TeaPair("body", res), new TeaPair("headers", response_.headers));
                    return map;
                }
                if (Common.equalString(params.bodyType, "array")) {
                    Object arr = Common.readAsJSON(response_.body);
                    Map map = TeaConverter.buildMap(new TeaPair("body", arr), new TeaPair("headers", response_.headers));
                    return map;
                }
                Map map = TeaConverter.buildMap(new TeaPair("headers", response_.headers));
                return map;
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
            finally {
                if (Common.isUnset(_lastResponse) || Common.isUnset(_lastResponse.response) || Common.isUnset(_lastResponse.response.body())) continue;
                _lastResponse.response.close();
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public Map<String, ?> execute(Params params, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        TeaModel.validateParams(params, "params");
        TeaModel.validateParams(request, "request");
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("timeouted", "retry"), new TeaPair("readTimeout", Common.defaultNumber(runtime.readTimeout, this._readTimeout)), new TeaPair("connectTimeout", Common.defaultNumber(runtime.connectTimeout, this._connectTimeout)), new TeaPair("httpProxy", Common.defaultString(runtime.httpProxy, this._httpProxy)), new TeaPair("httpsProxy", Common.defaultString(runtime.httpsProxy, this._httpsProxy)), new TeaPair("noProxy", Common.defaultString(runtime.noProxy, this._noProxy)), new TeaPair("socks5Proxy", Common.defaultString(runtime.socks5Proxy, this._socks5Proxy)), new TeaPair("socks5NetWork", Common.defaultString(runtime.socks5NetWork, this._socks5NetWork)), new TeaPair("maxIdleConns", Common.defaultNumber(runtime.maxIdleConns, this._maxIdleConns)), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("retryable", runtime.autoretry), new TeaPair("maxAttempts", Common.defaultNumber(runtime.maxAttempts, 3)))), new TeaPair("backoff", TeaConverter.buildMap(new TeaPair("policy", Common.defaultString(runtime.backoffPolicy, "no")), new TeaPair("period", Common.defaultNumber(runtime.backoffPeriod, 1)))), new TeaPair("ignoreSSL", runtime.ignoreSSL));
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                InterceptorContext.InterceptorContextResponse responseContext;
                TeaRequest request_ = new TeaRequest();
                Map<String, String> headers = this.getRpcHeaders();
                InterceptorContext.InterceptorContextRequest requestContext = InterceptorContext.InterceptorContextRequest.build(TeaConverter.buildMap(new TeaPair("headers", TeaConverter.merge(String.class, request.headers, headers)), new TeaPair("query", request.query), new TeaPair("body", request.body), new TeaPair("stream", request.stream), new TeaPair("hostMap", request.hostMap), new TeaPair("pathname", params.pathname), new TeaPair("productId", this._productId), new TeaPair("action", params.action), new TeaPair("version", params.version), new TeaPair("protocol", Common.defaultString(this._protocol, params.protocol)), new TeaPair("method", Common.defaultString(this._method, params.method)), new TeaPair("authType", params.authType), new TeaPair("bodyType", params.bodyType), new TeaPair("reqBodyType", params.reqBodyType), new TeaPair("style", params.style), new TeaPair("credential", this._credential), new TeaPair("signatureVersion", this._signatureVersion), new TeaPair("signatureAlgorithm", this._signatureAlgorithm), new TeaPair("userAgent", this.getUserAgent())));
                InterceptorContext.InterceptorContextConfiguration configurationContext = InterceptorContext.InterceptorContextConfiguration.build(TeaConverter.buildMap(new TeaPair("regionId", this._regionId), new TeaPair("endpoint", this._endpoint), new TeaPair("endpointRule", this._endpointRule), new TeaPair("endpointMap", this._endpointMap), new TeaPair("endpointType", this._endpointType), new TeaPair("network", this._network), new TeaPair("suffix", this._suffix)));
                InterceptorContext interceptorContext = InterceptorContext.build(TeaConverter.buildMap(new TeaPair("request", requestContext), new TeaPair("configuration", configurationContext)));
                AttributeMap attributeMap = new AttributeMap();
                this._spi.modifyConfiguration(interceptorContext, attributeMap);
                this._spi.modifyRequest(interceptorContext, attributeMap);
                request_.protocol = interceptorContext.request.protocol;
                request_.method = interceptorContext.request.method;
                request_.pathname = interceptorContext.request.pathname;
                request_.query = interceptorContext.request.query;
                request_.body = interceptorContext.request.stream;
                request_.headers = interceptorContext.request.headers;
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_, interceptorChain);
                interceptorContext.response = responseContext = InterceptorContext.InterceptorContextResponse.build(TeaConverter.buildMap(new TeaPair("statusCode", response_.statusCode), new TeaPair("headers", response_.headers), new TeaPair("body", response_.body)));
                this._spi.modifyResponse(interceptorContext, attributeMap);
                return TeaConverter.buildMap(new TeaPair("headers", interceptorContext.response.headers), new TeaPair("body", interceptorContext.response.deserializedBody));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public void addRuntimeOptionsInterceptor(RuntimeOptionsInterceptor interceptor) {
        interceptorChain.addRuntimeOptionsInterceptor(interceptor);
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        interceptorChain.addRequestInterceptor(interceptor);
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        interceptorChain.addResponseInterceptor(interceptor);
    }

    public Map<String, ?> callApi(Params params, OpenApiRequest request, RuntimeOptions runtime) throws Exception {
        if (Common.isUnset(TeaModel.buildMap(params))) {
            throw new TeaException(TeaConverter.buildMap(new TeaPair("code", "ParameterMissing"), new TeaPair("message", "'params' can not be unset")));
        }
        if (Common.isUnset(this._signatureAlgorithm) || !Common.equalString(this._signatureAlgorithm, "v2")) {
            return this.doRequest(params, request, runtime);
        }
        if (Common.equalString(params.style, "ROA") && Common.equalString(params.reqBodyType, "json")) {
            return this.doROARequest(params.action, params.version, params.protocol, params.method, params.authType, params.pathname, params.bodyType, request, runtime);
        }
        if (Common.equalString(params.style, "ROA")) {
            return this.doROARequestWithForm(params.action, params.version, params.protocol, params.method, params.authType, params.pathname, params.bodyType, request, runtime);
        }
        return this.doRPCRequest(params.action, params.version, params.protocol, params.method, params.authType, params.bodyType, request, runtime);
    }

    public String getUserAgent() throws Exception {
        String userAgent = Common.getUserAgent(this._userAgent);
        return userAgent;
    }

    public String getAccessKeyId() throws Exception {
        if (Common.isUnset(this._credential)) {
            return "";
        }
        String accessKeyId = this._credential.getAccessKeyId();
        return accessKeyId;
    }

    public String getAccessKeySecret() throws Exception {
        if (Common.isUnset(this._credential)) {
            return "";
        }
        String secret = this._credential.getAccessKeySecret();
        return secret;
    }

    public String getSecurityToken() throws Exception {
        if (Common.isUnset(this._credential)) {
            return "";
        }
        String token = this._credential.getSecurityToken();
        return token;
    }

    public static Object defaultAny(Object inputValue, Object defaultValue) throws Exception {
        if (Common.isUnset(inputValue)) {
            return defaultValue;
        }
        return inputValue;
    }

    public void checkConfig(Config config) throws Exception {
        if (Common.empty(this._endpointRule) && Common.empty(config.endpoint)) {
            throw new TeaException(TeaConverter.buildMap(new TeaPair("code", "ParameterMissing"), new TeaPair("message", "'config.endpoint' can not be empty")));
        }
    }

    public void setRpcHeaders(Map<String, String> headers) throws Exception {
        this._headers = headers;
    }

    public Map<String, String> getRpcHeaders() throws Exception {
        Map<String, String> headers = this._headers;
        this._headers = null;
        return headers;
    }
}

