/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake20200710.external.com.sun.xml.bind.v2.runtime.reflect.opt;

import com.aliyun.datalake20200710.external.com.sun.xml.bind.Util;
import com.aliyun.datalake20200710.external.com.sun.xml.bind.v2.bytecode.ClassTailor;
import com.aliyun.datalake20200710.external.com.sun.xml.bind.v2.runtime.reflect.opt.Injector;
import com.aliyun.datalake20200710.external.com.sun.xml.bind.v2.runtime.reflect.opt.SecureLoader;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class AccessorInjector {
    private static final Logger logger = Util.getClassLogger();
    protected static final boolean noOptimize;
    private static final ClassLoader CLASS_LOADER;

    AccessorInjector() {
    }

    public static Class<?> prepare(Class beanClass, String templateClassName, String newClassName, String ... replacements) {
        if (noOptimize) {
            return null;
        }
        try {
            ClassLoader cl = SecureLoader.getClassClassLoader(beanClass);
            if (cl == null) {
                return null;
            }
            Class c = Injector.find(cl, newClassName);
            if (c == null) {
                byte[] image = AccessorInjector.tailor(templateClassName, newClassName, replacements);
                if (image == null) {
                    return null;
                }
                c = Injector.inject(cl, newClassName, image);
                if (c == null) {
                    Injector.find(cl, newClassName);
                }
            }
            return c;
        }
        catch (SecurityException e) {
            logger.log(Level.INFO, "Unable to create an optimized TransducedAccessor ", e);
            return null;
        }
    }

    private static byte[] tailor(String templateClassName, String newClassName, String ... replacements) {
        InputStream resource = CLASS_LOADER != null ? CLASS_LOADER.getResourceAsStream(templateClassName + ".class") : ClassLoader.getSystemResourceAsStream(templateClassName + ".class");
        if (resource == null) {
            return null;
        }
        return ClassTailor.tailor(resource, templateClassName, newClassName, replacements);
    }

    static {
        boolean bl = noOptimize = Util.getSystemProperty(ClassTailor.class.getName() + ".noOptimize") != null;
        if (noOptimize) {
            logger.info("The optimized code generation is disabled");
        }
        CLASS_LOADER = SecureLoader.getClassClassLoader(AccessorInjector.class);
    }
}

