/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common.util;

import com.aliyun.datalake.metastore.common.entity.StsTokenInfo;
import com.aliyun.datalake20200710.external.okhttp3.Call;
import com.aliyun.datalake20200710.external.okhttp3.OkHttpClient;
import com.aliyun.datalake20200710.external.okhttp3.Request;
import com.aliyun.datalake20200710.external.okhttp3.Response;
import com.google.gson.Gson;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CupidAkUtils {
    private static final Logger logger = LoggerFactory.getLogger(CupidAkUtils.class);
    private static final int SC_OK = 200;
    private static final Gson GSON = new Gson();
    private static final String STS_TOKEN_REQ_URL_FORMAT = "http://localhost:10011/sts-token-info?user_id=%s&role=%s";

    private static String httpGet(String url) {
        OkHttpClient httpClient = new OkHttpClient();
        try {
            Request request = new Request.Builder().url(url).get().build();
            Call call = httpClient.newCall(request);
            Response response = call.execute();
            if (response.code() == 200) {
                return response.body().string();
            }
        }
        catch (Exception ex) {
            logger.warn(String.format("httpGet url: %s failed.", url), (Throwable)ex);
        }
        return null;
    }

    public static StsTokenInfo fetchStsToken(String userId, String role) {
        String url = String.format(STS_TOKEN_REQ_URL_FORMAT, userId, role);
        String stsTokenRes = CupidAkUtils.httpGet(url);
        assert (stsTokenRes != null);
        Map kvMap = (Map)GSON.fromJson(stsTokenRes, Map.class);
        String accessKeyId = (String)kvMap.get("AccessKeyId");
        String accessKeySecret = (String)kvMap.get("AccessKeySecret");
        String securityToken = (String)kvMap.get("SecurityToken");
        assert (accessKeyId != null && accessKeySecret != null && securityToken != null);
        return new StsTokenInfo(accessKeyId, accessKeySecret, securityToken);
    }
}

