/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common.functional;

import com.aliyun.datalake.metastore.common.functional.ThrowingConsumer;
import com.aliyun.datalake.metastore.common.functional.ThrowingFunction;
import com.aliyun.datalake.metastore.common.functional.ThrowingRunnable;
import com.aliyun.datalake.metastore.common.util.ProxyLogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionalUtils {
    private static final Logger logger = LoggerFactory.getLogger(FunctionalUtils.class);

    public static <E extends Exception, T> void run(T client, Optional<T> optional, boolean isAllowFailure, ThrowingConsumer<T, E> consumer, String clientType, String actionName, Object ... parameters) throws E {
        FunctionalUtils.consumerWrapper(client, consumer, clientType, actionName, parameters);
        if (optional.isPresent()) {
            FunctionalUtils.run(() -> consumer.accept(optional.get()), isAllowFailure, clientType, actionName, parameters);
        }
    }

    public static <E extends Exception, T, R> R call(T client, Optional<T> optional, boolean isAllowFailure, ThrowingFunction<T, R, E> consumer, String clientType, String actionName, Object ... parameters) throws E {
        R result = FunctionalUtils.functionWrapper(client, consumer, clientType, actionName, parameters);
        if (optional.isPresent()) {
            FunctionalUtils.run(() -> consumer.apply(optional.get()), isAllowFailure, clientType, actionName, parameters);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception, T, R> R functionWrapper(T client, ThrowingFunction<T, R, E> consumer, String clientType, String actionName, Object ... parameters) throws E {
        long startTime = System.currentTimeMillis();
        try {
            R r = consumer.apply(client);
            return r;
        }
        finally {
            long endTime = System.currentTimeMillis();
            ProxyLogUtils.printLog(() -> logger.info("{}.meta.{}, cost:{}ms, parameters: {}", new Object[]{clientType, actionName, endTime - startTime, ProxyLogUtils.getActionParametersString(actionName, parameters)}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception, T> void consumerWrapper(T client, ThrowingConsumer<T, E> consumer, String clientType, String actionName, Object ... parameters) throws E {
        long startTime = System.currentTimeMillis();
        try {
            consumer.accept(client);
        }
        finally {
            long endTime = System.currentTimeMillis();
            ProxyLogUtils.printLog(() -> logger.info("{}.meta.{}, cost:{}ms, parameters: {}", new Object[]{clientType, actionName, endTime - startTime, ProxyLogUtils.getActionParametersString(actionName, parameters)}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> void run(ThrowingRunnable<E> r, boolean isAllowFailure, String firstClientType, String actionName, Object ... parameters) throws E {
        String clientType = "dlf".equalsIgnoreCase(firstClientType) ? "hive" : "dlf";
        long startTime = System.currentTimeMillis();
        try {
            r.run();
        }
        catch (Exception e) {
            FunctionalUtils.collectLogs(e, actionName, parameters);
            if (!isAllowFailure) {
                throw e;
            }
        }
        finally {
            long endTime = System.currentTimeMillis();
            ProxyLogUtils.printLog(() -> logger.info("{}.meta.{}, cost:{}ms", new Object[]{clientType, actionName, endTime - startTime}));
        }
    }

    public static <E extends Exception, T> void batchedRunnable(List<T> list, int batchSize, ThrowingFunction<List<T>, Void, E> consumer, ExecutorService executorService) throws Exception {
        int n;
        ArrayList<Future<Void>> partitionFutures = new ArrayList<Future<Void>>();
        int fromIndex = 0;
        boolean bl = false;
        while (n < list.size()) {
            n = Math.min(fromIndex + batchSize, list.size());
            List<T> subBatch = list.subList(fromIndex, n);
            partitionFutures.add(executorService.submit(() -> (Void)consumer.apply(subBatch)));
            fromIndex = n;
        }
        for (Future future : partitionFutures) {
            future.get();
        }
    }

    public static <E extends Exception, T, R extends List> void batchedCall(List<T> list, R resultList, int batchSize, ThrowingFunction<List<T>, R, E> function, ExecutorService executorService) throws Exception {
        int n;
        ArrayList<Future<List>> partitionFutures = new ArrayList<Future<List>>();
        int fromIndex = 0;
        boolean bl = false;
        while (n < list.size()) {
            n = Math.min(fromIndex + batchSize, list.size());
            List<T> subBatch = list.subList(fromIndex, n);
            partitionFutures.add(executorService.submit(() -> (List)function.apply(subBatch)));
            fromIndex = n;
        }
        for (Future future : partitionFutures) {
            List batchResult = (List)future.get();
            if (batchResult == null || resultList == null) continue;
            resultList.addAll(batchResult);
        }
    }

    public static void collectLogs(Exception e, String actionName, Object ... parameters) {
        ProxyLogUtils.writeLog(e, actionName, parameters);
    }
}

