/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common.api;

import com.aliyun.datalake.metastore.common.api.AbstractBaseApi;
import com.aliyun.datalake.metastore.common.entity.PaginatedResult;
import com.aliyun.datalake.metastore.common.entity.ResultModel;
import com.aliyun.datalake.metastore.common.functional.ThrowingBiFunction;
import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake20200710.Client;
import com.aliyun.datalake20200710.models.CreateDatabaseRequest;
import com.aliyun.datalake20200710.models.CreateDatabaseResponse;
import com.aliyun.datalake20200710.models.CreateDatabaseResponseBody;
import com.aliyun.datalake20200710.models.Database;
import com.aliyun.datalake20200710.models.DatabaseInput;
import com.aliyun.datalake20200710.models.DeleteDatabaseRequest;
import com.aliyun.datalake20200710.models.DeleteDatabaseResponse;
import com.aliyun.datalake20200710.models.DeleteDatabaseResponseBody;
import com.aliyun.datalake20200710.models.GetDatabaseRequest;
import com.aliyun.datalake20200710.models.GetDatabaseResponse;
import com.aliyun.datalake20200710.models.GetDatabaseResponseBody;
import com.aliyun.datalake20200710.models.ListDatabasesRequest;
import com.aliyun.datalake20200710.models.ListDatabasesResponse;
import com.aliyun.datalake20200710.models.ListDatabasesResponseBody;
import com.aliyun.datalake20200710.models.PrincipalPrivilegeSet;
import com.aliyun.datalake20200710.models.UpdateDatabaseRequest;
import com.aliyun.datalake20200710.models.UpdateDatabaseResponse;
import com.aliyun.datalake20200710.models.UpdateDatabaseResponseBody;
import com.aliyun.teautil.models.RuntimeOptions;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DatabaseApi
extends AbstractBaseApi {
    public DatabaseApi(Client client) {
        super(client);
    }

    public ResultModel<Database> getDatabase(String catalogId, String databaseName) throws Exception {
        return this.call(() -> {
            GetDatabaseRequest query = new GetDatabaseRequest();
            query.catalogId = catalogId;
            query.name = databaseName;
            GetDatabaseResponseBody response = ((GetDatabaseResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, GetDatabaseResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getDatabase$0(com.aliyun.datalake20200710.models.GetDatabaseRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/GetDatabaseResponse;)((DatabaseApi)this, (GetDatabaseRequest)query))).body;
            return new ResultModel<Database>(response.success, response.code, response.message, response.requestId, response.database);
        });
    }

    public ResultModel<Void> createDatabase(String catalogId, String databaseName, String description, String locationUri, Map<String, String> parameters, String ownerName, String ownerType, PrincipalPrivilegeSet privileges) throws Exception {
        return this.call(() -> {
            CreateDatabaseRequest request = new CreateDatabaseRequest();
            request.catalogId = catalogId;
            DatabaseInput input = new DatabaseInput();
            input.description = description;
            input.locationUri = locationUri;
            input.parameters = parameters;
            input.name = databaseName;
            input.ownerName = ownerName;
            input.ownerType = ownerType;
            input.privileges = privileges;
            request.databaseInput = input;
            CreateDatabaseResponseBody response = ((CreateDatabaseResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, CreateDatabaseResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$createDatabase$2(com.aliyun.datalake20200710.models.CreateDatabaseRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/CreateDatabaseResponse;)((DatabaseApi)this, (CreateDatabaseRequest)request))).body;
            return new ResultModel(response.success, response.code, response.message, response.requestId);
        });
    }

    public ResultModel<List<String>> listAllDatabases(String catalogId) throws Exception {
        return this.call(() -> {
            ListDatabasesRequest request = new ListDatabasesRequest();
            request.catalogId = catalogId;
            request.pageSize = -1;
            request.nextPageToken = "";
            request.namePattern = ".*";
            ListDatabasesResponseBody response = ((ListDatabasesResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, ListDatabasesResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$listAllDatabases$4(com.aliyun.datalake20200710.models.ListDatabasesRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/ListDatabasesResponse;)((DatabaseApi)this, (ListDatabasesRequest)request))).body;
            List data = null;
            if (response.success.booleanValue()) {
                List databases = response.databases;
                data = databases.stream().map(database -> database.name).collect(Collectors.toList());
            }
            return new ResultModel(response.success, response.code, response.message, response.requestId, data);
        });
    }

    public ResultModel<PaginatedResult<Database>> listDatabases(String catalogId, String databasePattern, int pageSize, String nextPageToken) throws Exception {
        return this.call(() -> {
            ListDatabasesRequest request = new ListDatabasesRequest();
            request.catalogId = catalogId;
            request.namePattern = DataLakeUtil.wrapperPatternString(databasePattern);
            request.pageSize = pageSize;
            request.nextPageToken = DataLakeUtil.wrapperNullString(nextPageToken);
            ListDatabasesResponseBody response = ((ListDatabasesResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, ListDatabasesResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$listDatabases$7(com.aliyun.datalake20200710.models.ListDatabasesRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/ListDatabasesResponse;)((DatabaseApi)this, (ListDatabasesRequest)request))).body;
            PaginatedResult result = new PaginatedResult(response.databases, DataLakeUtil.wrapperNullString(response.nextPageToken));
            return new ResultModel(response.success, response.code, response.message, response.requestId, result);
        });
    }

    public ResultModel<Void> updateDatabase(String catalogId, String databaseName, Database database) throws Exception {
        return this.call(() -> {
            UpdateDatabaseRequest request = new UpdateDatabaseRequest();
            request.catalogId = catalogId;
            request.name = databaseName;
            DatabaseInput input = new DatabaseInput();
            input.name = database.name;
            input.description = database.description;
            input.locationUri = database.locationUri;
            input.parameters = database.parameters;
            input.ownerName = database.ownerName;
            input.ownerType = database.ownerType;
            input.privileges = database.privileges;
            request.databaseInput = input;
            UpdateDatabaseResponseBody response = ((UpdateDatabaseResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, UpdateDatabaseResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateDatabase$9(com.aliyun.datalake20200710.models.UpdateDatabaseRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/UpdateDatabaseResponse;)((DatabaseApi)this, (UpdateDatabaseRequest)request))).body;
            return new ResultModel(response.success, response.code, response.message, response.requestId);
        });
    }

    public ResultModel<Void> deleteDatabase(String catalogId, String databaseName, Boolean cascade) throws Exception {
        return this.call(() -> {
            DeleteDatabaseRequest request = new DeleteDatabaseRequest();
            request.catalogId = catalogId;
            request.name = databaseName;
            request.cascade = cascade;
            DeleteDatabaseResponseBody response = ((DeleteDatabaseResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, DeleteDatabaseResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$deleteDatabase$11(com.aliyun.datalake20200710.models.DeleteDatabaseRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/DeleteDatabaseResponse;)((DatabaseApi)this, (DeleteDatabaseRequest)request))).body;
            return new ResultModel(response.success, response.code, response.message, response.requestId);
        });
    }

    private /* synthetic */ DeleteDatabaseResponse lambda$deleteDatabase$11(DeleteDatabaseRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.deleteDatabaseWithOptions(request, h, r);
    }

    private /* synthetic */ UpdateDatabaseResponse lambda$updateDatabase$9(UpdateDatabaseRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.updateDatabaseWithOptions(request, h, r);
    }

    private /* synthetic */ ListDatabasesResponse lambda$listDatabases$7(ListDatabasesRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.listDatabasesWithOptions(request, h, r);
    }

    private /* synthetic */ ListDatabasesResponse lambda$listAllDatabases$4(ListDatabasesRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.listDatabasesWithOptions(request, h, r);
    }

    private /* synthetic */ CreateDatabaseResponse lambda$createDatabase$2(CreateDatabaseRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.createDatabaseWithOptions(request, h, r);
    }

    private /* synthetic */ GetDatabaseResponse lambda$getDatabase$0(GetDatabaseRequest query, Map h, RuntimeOptions r) throws Exception {
        return this.client.getDatabaseWithOptions(query, h, r);
    }
}

