/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common.api;

import com.aliyun.datalake.metastore.common.entity.BatchResultModel;
import com.aliyun.datalake.metastore.common.entity.ResultModel;
import com.aliyun.datalake.metastore.common.functional.ThrowingBiFunction;
import com.aliyun.datalake20200710.Client;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.teautil.models.RuntimeOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class AbstractBaseApi {
    protected final Client client;

    public AbstractBaseApi(Client client) {
        this.client = client;
    }

    public <M, V extends ResultModel<M>> ResultModel<M> call(Callable<V> c) throws Exception {
        try {
            return (ResultModel)((Object)c.call());
        }
        catch (TeaException e) {
            Map data = e.getData();
            if (data != null && data.get("Code") != null) {
                return (ResultModel)TeaModel.toModel((Map)data, new ResultModel());
            }
            throw e;
        }
    }

    public <M, V extends BatchResultModel<M>> V batchCall(Callable<V> c, V v) throws Exception {
        try {
            return (V)((Object)((BatchResultModel)((Object)c.call())));
        }
        catch (TeaException e) {
            Map data = e.getData();
            if (data != null && data.get("Code") != null) {
                return (V)((Object)((BatchResultModel)TeaModel.toModel((Map)data, v)));
            }
            throw e;
        }
    }

    public <R extends TeaModel, E extends Exception> TeaModel callWithOptions(ThrowingBiFunction<Map<String, String>, RuntimeOptions, R, E> calls) throws Exception {
        return this.callWithOptions(calls, null, null);
    }

    public <R extends TeaModel, E extends Exception> TeaModel callWithOptions(ThrowingBiFunction<Map<String, String>, RuntimeOptions, R, E> calls, Map<String, String> headers, RuntimeOptions runtime) throws Exception {
        if (runtime == null) {
            runtime = new RuntimeOptions();
        }
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("datalake-metastore-client-version", "0.2.14");
        return (TeaModel)calls.apply(headers, runtime);
    }
}

