/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common;

import com.aliyun.datalake20200710.external.okhttp3.Call;
import com.aliyun.datalake20200710.external.okhttp3.OkHttpClient;
import com.aliyun.datalake20200710.external.okhttp3.Request;
import com.aliyun.datalake20200710.external.okhttp3.Response;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.okhttp.ClientHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STSHelper {
    private static final Logger logger = LoggerFactory.getLogger(STSHelper.class);
    public static final String STS_REGION = "Region";
    public static final String STS_ACCESS_KEY_ID = "AccessKeyId";
    public static final String STS_ACCESS_KEY_SECRET = "AccessKeySecret";
    public static final String STS_TOKEN = "SecurityToken";
    public static final ConcurrentHashMap<String, OkHttpClient> clients = new ConcurrentHashMap();
    public static Map<String, Object> clientRuntimeOptions = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)30000), new TeaPair("connectTimeout", (Object)30000), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)false), new TeaPair("maxAttempts", (Object)3)})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)"no"), new TeaPair("period", (Object)1)})), new TeaPair("ignoreSSL", (Object)true)});
    private static volatile Long lastVersion = 0L;
    private static volatile Properties stsToken = new Properties();
    private static volatile boolean tokenRefresherInit = false;
    private static ScheduledExecutorService scheduledExecutorService = null;
    private static final int refreshStsTimes = 60000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initSTSHelper(boolean isNewStsMode) {
        if (tokenRefresherInit) return;
        Class<STSHelper> clazz = STSHelper.class;
        synchronized (STSHelper.class) {
            if (tokenRefresherInit) return;
            scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("dlf-token-refresher-%d").setDaemon(true).build());
            scheduledExecutorService.scheduleWithFixedDelay(() -> {
                try {
                    STSHelper.getLatestSTSToken(true, isNewStsMode);
                }
                catch (Exception exception) {
                    logger.info(exception.getMessage(), (Throwable)exception);
                }
            }, 0L, 60000L, TimeUnit.MILLISECONDS);
            tokenRefresherInit = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getLatestSTSToken(boolean force, boolean isNewStsMode) throws Exception {
        Long currentVersion = System.currentTimeMillis();
        if (!force && currentVersion - lastVersion <= 60000L) {
            return stsToken;
        }
        Class<STSHelper> clazz = STSHelper.class;
        synchronized (STSHelper.class) {
            if (force || currentVersion - lastVersion > 60000L) {
                stsToken = STSHelper.getEMRSTSToken(isNewStsMode);
                lastVersion = currentVersion;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return stsToken;
        }
    }

    public static Properties getEMRSTSToken(boolean isNewStsMode) throws Exception {
        logger.debug("dlf: use {} mode to fetch sts token", (Object)(isNewStsMode ? "new" : "old"));
        if (isNewStsMode) {
            return STSHelper.getEMRSTSTokenNew();
        }
        return STSHelper.getEMRSTSTokenOld();
    }

    public static Call buildCall(OkHttpClient httpClient, String url) {
        Request request = new Request.Builder().url(url).get().build();
        return httpClient.newCall(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response getResponse(OkHttpClient httpClient, String url) throws Exception {
        Response response = null;
        long startTime = System.currentTimeMillis();
        try {
            response = STSHelper.retryGetResponse(httpClient, url, 0, 3);
        }
        finally {
            logger.info("sts request for url:{}, cost:{}ms", (Object)url, (Object)(System.currentTimeMillis() - startTime));
        }
        return response;
    }

    public static Response retryGetResponse(OkHttpClient httpClient, String url, int curTimes, int maxTimes) throws Exception {
        Response response = null;
        try {
            Call call = STSHelper.buildCall(httpClient, url);
            response = call.execute();
            STSHelper.checkResponse(response);
        }
        catch (Exception e) {
            if (response != null) {
                response.close();
            }
            if (++curTimes < maxTimes) {
                logger.info("retry get ststoken for times:{}", (Object)curTimes);
                return STSHelper.retryGetResponse(httpClient, url, curTimes, maxTimes);
            }
            logger.error("can't get ststoken afer retry:{} times, due to {}", new Object[]{maxTimes, e.getMessage(), e});
            throw e;
        }
        return response;
    }

    public static void checkResponse(Response response) throws IOException {
        if (!response.isSuccessful()) {
            throw new IOException(response.toString());
        }
    }

    public static Properties getEMRSTSTokenNew() throws Exception {
        Properties result = new Properties();
        OkHttpClient httpClient = STSHelper.getOkHttpClient("100.100.100.200", 80, clientRuntimeOptions);
        String role = "";
        Response response = STSHelper.getResponse(httpClient, "http://100.100.100.200/latest/meta-data/Ram/security-credentials/");
        role = response.body().string();
        response = STSHelper.getResponse(httpClient, "http://100.100.100.200/latest/meta-data/Ram/security-credentials/" + role);
        String tokens = response.body().string();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(tokens);
        result.put(STS_ACCESS_KEY_ID, root.get(STS_ACCESS_KEY_ID).asText());
        result.put(STS_ACCESS_KEY_SECRET, root.get(STS_ACCESS_KEY_SECRET).asText());
        result.put(STS_TOKEN, root.get(STS_TOKEN).asText());
        response = STSHelper.getResponse(httpClient, "http://100.100.100.200/latest/meta-data/region-id");
        result.put(STS_REGION, response.body().string());
        return result;
    }

    public static Properties getEMRSTSTokenOld() throws Exception {
        Properties result = new Properties();
        OkHttpClient httpClient = STSHelper.getOkHttpClient("localhost", 10011, clientRuntimeOptions);
        Response response = STSHelper.getResponse(httpClient, "http://localhost:10011/cluster-region");
        result.put(STS_REGION, response.body().string());
        response = STSHelper.getResponse(httpClient, "http://localhost:10011/role-access-key-id");
        result.put(STS_ACCESS_KEY_ID, response.body().string());
        response = STSHelper.getResponse(httpClient, "http://localhost:10011/role-access-key-secret");
        result.put(STS_ACCESS_KEY_SECRET, response.body().string());
        response = STSHelper.getResponse(httpClient, "http://localhost:10011/role-security-token");
        result.put(STS_TOKEN, response.body().string());
        return result;
    }

    public static Properties getEMRSTSToken(String uid, String role) throws Exception {
        Properties result = new Properties();
        OkHttpClient httpClient = new OkHttpClient();
        Response response = STSHelper.getResponse(httpClient, "http://localhost:10011/cluster-region");
        result.put(STS_REGION, response.body().string());
        response = STSHelper.getResponse(httpClient, String.format("http://localhost:10011/dlf-ak-info?user_id=%s&role=%s", uid, role));
        String resp = response.body().string();
        ObjectMapper mapper = new ObjectMapper();
        Map kv = (Map)mapper.readValue(resp, Map.class);
        result.putAll((Map<?, ?>)kv);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getOkHttpClient(String host, int port, Map<String, Object> map) throws Exception {
        String key;
        if (null == map.get("httpProxy") && null == map.get("httpsProxy")) {
            key = ClientHelper.getClientKey((String)host, (int)port);
        } else {
            Object urlString = null == map.get("httpProxy") ? map.get("httpsProxy") : map.get("httpProxy");
            URL url = new URL(String.valueOf(urlString));
            key = ClientHelper.getClientKey((String)url.getHost(), (int)url.getPort());
        }
        OkHttpClient client = clients.get(key);
        if (null != client) return client;
        Class<STSHelper> clazz = STSHelper.class;
        synchronized (STSHelper.class) {
            client = clients.get(key);
            if (client != null) return client;
            client = ClientHelper.creatClient(map);
            clients.put(key, client);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return client;
        }
    }
}

