/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common;

import com.aliyun.datalake.metastore.common.Action;
import com.aliyun.datalake.metastore.common.Constant;
import com.aliyun.datalake.metastore.common.DataLakeClient;
import com.aliyun.datalake.metastore.common.DataLakeConfig;
import com.aliyun.datalake.metastore.common.DefaultExecutorServiceFactory;
import com.aliyun.datalake.metastore.common.IDataLakeMetaStore;
import com.aliyun.datalake.metastore.common.RetryableException;
import com.aliyun.datalake.metastore.common.STSHelper;
import com.aliyun.datalake.metastore.common.api.DataLakeAPIException;
import com.aliyun.datalake.metastore.common.entity.PaginatedResult;
import com.aliyun.datalake.metastore.common.entity.ResultModel;
import com.aliyun.datalake.metastore.common.entity.StsTokenInfo;
import com.aliyun.datalake.metastore.common.functional.FunctionalUtils;
import com.aliyun.datalake.metastore.common.util.CupidAkUtils;
import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake20200710.models.ColumnStatisticsObj;
import com.aliyun.datalake20200710.models.Database;
import com.aliyun.datalake20200710.models.Function;
import com.aliyun.datalake20200710.models.FunctionInput;
import com.aliyun.datalake20200710.models.LockObj;
import com.aliyun.datalake20200710.models.LockStatus;
import com.aliyun.datalake20200710.models.Partition;
import com.aliyun.datalake20200710.models.PartitionInput;
import com.aliyun.datalake20200710.models.PrincipalPrivilegeSet;
import com.aliyun.datalake20200710.models.Table;
import com.aliyun.datalake20200710.models.TableInput;
import com.aliyun.datalake20200710.models.TaskStatus;
import com.aliyun.datalake20200710.models.UpdateTablePartitionColumnStatisticsRequest;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataLakeMetaStore
implements IDataLakeMetaStore {
    private static final String EMPTY_TOKEN = "";
    private final Logger logger = LoggerFactory.getLogger(DefaultDataLakeMetaStore.class);
    private final Set<Action> notNeedRetryActions = new HashSet<Action>(){
        {
            this.add(Action.LOCK);
        }
    };
    private DataLakeClient dataLakeClient;
    private Config dataLakeClientConfig;
    private Properties extendedConfig;
    private ExecutorService executorService;
    private int batchSize;
    private int tableColStatsPageSize;

    public DefaultDataLakeMetaStore(Config conf, Properties extendedConfig, ExecutorService service) throws Exception {
        this.dataLakeClientConfig = conf;
        this.extendedConfig = extendedConfig;
        this.executorService = service == null ? new DefaultExecutorServiceFactory().getExecutorService(5) : service;
        this.batchSize = Integer.parseInt(extendedConfig.getProperty("dlf.catalog.accurate.batchSize"));
        this.tableColStatsPageSize = Integer.parseInt(extendedConfig.getProperty("dlf.catalog.client.table.col.stats.pageSize"));
        this.reInitDataLakeClient(conf, extendedConfig, false);
    }

    private <M, V extends ResultModel<M>> M call(Callable<V> c, Action action) throws Exception {
        V result;
        try {
            result = this.retryWhenGetException(c, 1, action);
            this.logger.debug("Action: {}, RequestId: {}, Code: {}", new Object[]{action, ((ResultModel)((Object)result)).requestId, ((ResultModel)((Object)result)).code});
        }
        catch (Exception e) {
            this.logger.error("Action failed: " + action.name() + ", msg: " + e.getMessage(), (Throwable)e);
            throw new Exception(e.getMessage(), e);
        }
        if (result != null && ((ResultModel)((Object)result)).success) {
            return (M)((ResultModel)((Object)result)).data;
        }
        throw new DataLakeAPIException((ResultModel<?>)((Object)result), action);
    }

    private <V extends ResultModel> V retryWhenGetException(Callable<V> c, int numTries, Action action) throws Exception {
        try {
            ResultModel v = (ResultModel)((Object)c.call());
            if (v != null && !v.success && Constant.RETRYABLE_ERROR_CODE.contains(v.code)) {
                throw new RetryableException(v.code, v.message, v.requestId);
            }
            return (V)((Object)v);
        }
        catch (RetryableException | TeaException e) {
            if (numTries <= 3 && this.isNeedRetry(action)) {
                this.logger.info(String.format("Exception got: [%s], now retry.", e.getMessage()));
                if (e instanceof RetryableException && Constant.TOKEN_RELATED_ERROR_CODE.contains(((RetryableException)e).getErrorCode())) {
                    this.logger.info("Token error occurs, now re-apply the token and re-init the client.");
                    this.reInitDataLakeClient(this.dataLakeClientConfig, this.extendedConfig, true);
                }
                try {
                    Thread.sleep((long)(Math.random() * Math.pow(2.0, numTries)));
                }
                catch (InterruptedException ie) {
                    this.logger.info("client unavailable of service");
                }
                return this.retryWhenGetException(c, numTries + 1, action);
            }
            throw e;
        }
    }

    public boolean isNeedRetry(Action action) {
        return !this.notNeedRetryActions.contains((Object)action);
    }

    private void reInitDataLakeClient(Config conf, Properties extendedConfig, boolean force) throws Exception {
        try {
            String accessKeyId = null;
            String accessKeySecret = null;
            String regionId = null;
            String stsToken = null;
            DataLakeConfig.AKMode akMode = DataLakeConfig.AKMode.valueOf(extendedConfig.getProperty("dlf.catalog.akMode"));
            if (akMode == DataLakeConfig.AKMode.MANUAL) {
                accessKeyId = conf.getAccessKeyId();
                accessKeySecret = conf.getAccessKeySecret();
                regionId = conf.getRegionId();
                stsToken = conf.getSecurityToken();
            } else {
                String role;
                if (akMode == DataLakeConfig.AKMode.EMR_AUTO) {
                    try {
                        boolean isNewStsMode = Boolean.parseBoolean(extendedConfig.getProperty("dlf.catalog.sts.isNewMode"));
                        STSHelper.initSTSHelper(isNewStsMode);
                        Properties props = STSHelper.getLatestSTSToken(force, isNewStsMode);
                        accessKeyId = props.getProperty("AccessKeyId");
                        accessKeySecret = props.getProperty("AccessKeySecret");
                        regionId = props.getProperty("Region");
                        stsToken = props.getProperty("SecurityToken");
                    }
                    catch (IOException e) {
                        String message = String.format("Cannot obtain STS token from EMR meta-service. Note that AK-Mode[%s] can only used in EMR clusters, otherwise you should config the %s and %s explicitly.", new Object[]{akMode, "dlf.catalog.accessKeyId", "dlf.catalog.accessKeySecret"});
                        throw new Exception(message + e.getMessage(), e);
                    }
                }
                if (akMode == DataLakeConfig.AKMode.CUPID) {
                    try {
                        String uid = extendedConfig.getProperty("dlf.catalog.uid");
                        if (uid == null) {
                            throw new Exception("User id not found in  conf, cannot get ak from cupid.");
                        }
                        role = extendedConfig.getProperty("dlf.catalog.role");
                        if (role == null) {
                            throw new Exception("Role not found in  conf, cannot get ak from cupid.");
                        }
                        regionId = conf.getRegionId();
                        if (regionId == null) {
                            throw new Exception("dlf.catalog.region can not be empty.");
                        }
                        StsTokenInfo stsTokenInfo = CupidAkUtils.fetchStsToken(uid, role);
                        accessKeyId = stsTokenInfo.accessKeyId;
                        accessKeySecret = stsTokenInfo.accessKeySecret;
                        stsToken = stsTokenInfo.stsToken;
                    }
                    catch (Exception ex) {
                        String message = String.format("Cannot obtain STS token from CUPID Env with %s. Note that AK-Mode[%s] can only used in MaxCompute clusters, otherwise you should config the %s and %s explicitly.", new Object[]{ex.getMessage(), akMode, "dlf.catalog.accessKeyId", "dlf.catalog.accessKeySecret"});
                        throw new Exception(message, ex);
                    }
                }
                String uid = extendedConfig.getProperty("dlf.catalog.uid");
                if (uid == null) {
                    throw new Exception("User id not found in  conf, cannot get ak from cupid.");
                }
                role = extendedConfig.getProperty("dlf.catalog.role");
                if (role == null) {
                    throw new Exception("Role not found in  conf, cannot get ak from cupid.");
                }
                try {
                    Properties props = STSHelper.getEMRSTSToken(uid, role);
                    accessKeyId = props.getProperty("AccessKeyId");
                    accessKeySecret = props.getProperty("AccessKeySecret");
                    regionId = props.getProperty("Region");
                    stsToken = props.getProperty("SecurityToken");
                }
                catch (IOException e) {
                    String message = String.format("Cannot obtain STS token from EMR meta-service. Note that AK-Mode[%s] can only used in Data Lake Formation, otherwise you should config the %s and %s explicitly.", "dlf.catalog.akMode", "dlf.catalog.accessKeyId", "dlf.catalog.accessKeySecret");
                    String additionalMessage = e.getMessage();
                    throw new Exception(message + String.format(". Additional Message: uid=%s, role=%s", uid, role) + additionalMessage, e);
                }
            }
            String endpoint = conf.getEndpoint();
            if (endpoint == null) {
                throw new Exception("Empty endpoint, pls set dlf.catalog.endpoint or dlf.catalog.region explicitly.");
            }
            Config config = new Config();
            config.accessKeyId = accessKeyId;
            config.accessKeySecret = accessKeySecret;
            config.endpoint = endpoint;
            config.regionId = regionId;
            config.securityToken = stsToken;
            config.readTimeout = conf.getReadTimeout();
            config.connectTimeout = conf.getConnectTimeout();
            this.dataLakeClient = new DataLakeClient(config);
        }
        catch (Exception e) {
            throw new Exception("Initialize DlfMetaStoreClient failed: " + e.getMessage(), e);
        }
    }

    @Override
    public void createDatabase(String catalogId, Database database) throws Exception {
        this.call(() -> this.dataLakeClient.getDatabaseApi().createDatabase(catalogId, database.getName(), database.getDescription(), database.getLocationUri(), database.getParameters(), database.getOwnerName(), database.getOwnerType(), database.getPrivileges()), Action.CREATE_DATABASE);
    }

    @Override
    public void createDatabase(String catalogId, String dbName, String description, String location, Map<String, String> parameters, String ownerName, String ownerType, PrincipalPrivilegeSet principalPrivilegeSet) throws Exception {
        this.call(() -> this.dataLakeClient.getDatabaseApi().createDatabase(catalogId, dbName, description, location, parameters, ownerName, ownerType, principalPrivilegeSet), Action.CREATE_DATABASE);
    }

    @Override
    public Database getDatabase(String catalogId, String dbName) throws Exception {
        Database database = (Database)this.call(() -> this.dataLakeClient.getDatabaseApi().getDatabase(catalogId, dbName), Action.GET_DATABASE);
        return database;
    }

    @Override
    public List<String> getDatabases(String catalogId, String pattern, int pageSize) throws Exception {
        ArrayList<String> dbNames = new ArrayList<String>();
        String nextToken = EMPTY_TOKEN;
        do {
            String nextTok = nextToken;
            PaginatedResult result = (PaginatedResult)this.call(() -> this.dataLakeClient.getDatabaseApi().listDatabases(catalogId, pattern, pageSize, nextTok), Action.GET_DATABASES);
            nextToken = result.getNextPageToken();
            dbNames.addAll(result.getData().stream().map(db -> db.name).collect(Collectors.toList()));
        } while (!nextToken.equals(EMPTY_TOKEN));
        return dbNames;
    }

    @Override
    public void alterDatabase(String catalogId, String dbName, Database database) throws Exception {
        this.call(() -> this.dataLakeClient.getDatabaseApi().updateDatabase(catalogId, dbName, database), Action.ALTER_DATABASE);
    }

    @Override
    public void dropDatabase(String catalogId, String dbName, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws Exception {
        this.call(() -> this.dataLakeClient.getDatabaseApi().deleteDatabase(catalogId, dbName, cascade), Action.DROP_DATABASE);
    }

    @Override
    public void createTable(String catalogId, TableInput tbl) throws Exception {
        this.call(() -> this.dataLakeClient.getTableApi().createTable(catalogId, tbl.databaseName, tbl), Action.CREATE_TABLE);
    }

    @Override
    public Table getTable(String catalogId, String dbName, String tableName) throws Exception {
        Table result = (Table)this.call(() -> this.dataLakeClient.getTableApi().getTable(catalogId, dbName, tableName), Action.GET_TABLE);
        return result;
    }

    @Override
    public List<String> getTables(String catalogId, String dbname, String tablePattern, int pageSize, String tableType) throws Exception {
        ArrayList<String> tables = new ArrayList<String>();
        String nextToken = EMPTY_TOKEN;
        do {
            String nextTok = nextToken;
            PaginatedResult result = (PaginatedResult)this.call(() -> this.dataLakeClient.getTableApi().getTables(catalogId, dbname, tablePattern, pageSize, nextTok, tableType), Action.GET_TABLES);
            nextToken = result.getNextPageToken();
            tables.addAll(result.getData());
        } while (!nextToken.equals(EMPTY_TOKEN));
        return tables;
    }

    @Override
    public List<Table> getTableObjects(String catalogId, String dbname, String tablePattern, int pageSize, String tableType) throws Exception {
        ArrayList<Table> tables = new ArrayList<Table>();
        String nextToken = EMPTY_TOKEN;
        do {
            String nextTok = nextToken;
            PaginatedResult result = (PaginatedResult)this.call(() -> this.dataLakeClient.getTableApi().getTableObjects(catalogId, dbname, tablePattern, pageSize, nextTok, tableType), Action.GET_TABLES);
            nextToken = result.getNextPageToken();
            tables.addAll(result.getData());
        } while (!nextToken.equals(EMPTY_TOKEN));
        return tables;
    }

    @Override
    public List<Table> getTableObjects(String catalogId, String dbname, List<String> tableNames) throws Exception {
        List tables = (List)this.call(() -> this.dataLakeClient.getTableApi().getTableObjects(catalogId, dbname, tableNames), Action.GET_TABLES);
        return tables;
    }

    @Override
    public void alterTable(String catalogId, String dbName, String oldTableName, TableInput newTable) throws Exception {
        this.alterTable(catalogId, dbName, oldTableName, newTable, false, false);
    }

    @Override
    public void alterTable(String catalogId, String dbName, String oldTableName, TableInput newTable, boolean cascade, boolean isAsync) throws Exception {
        String taskId = (String)this.call(() -> this.dataLakeClient.getTableApi().updateTable(catalogId, dbName, newTable, cascade, isAsync), Action.ALTER_TABLE);
        this.logger.info("alterTable taskId: {}, isAsync: {}, dbName: {}, tblName: {}, cascade: {}", new Object[]{taskId, isAsync, dbName, oldTableName, cascade});
        this.checkAsyncTaskStatus(catalogId, isAsync, taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAsyncTaskStatus(String catalogId, boolean isAsync, String taskId) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            if (isAsync) {
                if (taskId == null) {
                    throw new Exception("task isAsync, but cant' get taskId.");
                }
                TaskStatus resultCode = new TaskStatus();
                Long totalWaitTime = 600000L;
                Long waitPeriod = 100L;
                Long waitTime = 0L;
                while (!Thread.currentThread().isInterrupted() && waitTime <= totalWaitTime) {
                    resultCode = this.getCheckRenameTaskStatus(catalogId, taskId);
                    this.logger.info("taskId: {}, statusCode: {}, costTime: {}", new Object[]{taskId, resultCode.getStatus(), waitTime});
                    if (!"Running".equals(resultCode.getStatus())) break;
                    waitTime = waitTime + waitPeriod;
                    try {
                        Thread.sleep(waitPeriod);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!"Success".equals(resultCode.getStatus())) {
                    throw new Exception("taskId: " + taskId + " failed: " + resultCode.getMessage());
                }
            }
        }
        finally {
            this.logger.info("taskId: {}, costTime: {}ms", (Object)taskId, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    @Override
    public void dropTable(String catalogId, String dbName, String tableName, boolean deleteData) throws Exception {
        this.call(() -> this.dataLakeClient.getTableApi().deleteTable(catalogId, dbName, tableName), Action.DROP_TABLE);
    }

    @Override
    public void doRenameTableInMs(String catalogId, String dbName, String oldTableName, TableInput newTable, Boolean isAsync) throws Exception {
        if (newTable.getDatabaseName() == null) {
            newTable.setDatabaseName(dbName);
        }
        String taskId = (String)this.call(() -> this.dataLakeClient.getTableApi().renameTable(catalogId, dbName, oldTableName, newTable, isAsync), Action.RENAME_TABLE);
        this.logger.info("renameTable taskId: {}, isAsync: {}, from: {}.{} to {}.{}, location:{}", new Object[]{taskId, isAsync, dbName, oldTableName, newTable.databaseName, newTable.tableName, newTable.sd != null ? newTable.sd.location : null});
        this.checkAsyncTaskStatus(catalogId, isAsync, taskId);
    }

    public TaskStatus getCheckRenameTaskStatus(String catalogId, String taskId) throws Exception {
        return (TaskStatus)this.call(() -> this.dataLakeClient.getTableApi().getRenameStatus(catalogId, taskId), Action.RENAME_CHECK_STATUS);
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String catalogId, String dbName, String tableName, List<String> columnNames) throws Exception {
        ArrayList<ColumnStatisticsObj> result = new ArrayList<ColumnStatisticsObj>(columnNames.size());
        FunctionalUtils.batchedCall(columnNames, result, this.tableColStatsPageSize, batchedInput -> (List)this.call(() -> this.dataLakeClient.getTableApi().getTableColumnStatistics(catalogId, dbName, tableName, (List<String>)batchedInput), Action.GET_TABLE_COLUMN_STATISTICS), this.executorService);
        return result;
    }

    @Override
    public boolean updateTableColumnStatistics(UpdateTablePartitionColumnStatisticsRequest columnStatistics) throws Exception {
        return (Boolean)this.call(() -> this.dataLakeClient.getTableApi().updateTableColumnStatistics(columnStatistics), Action.UPDATE_TABLE_COLUMN_STATISTICS);
    }

    @Override
    public boolean deleteTableColumnStatistics(String catalogId, String dbName, String tableName, List<String> colNames) throws Exception {
        return (Boolean)this.call(() -> this.dataLakeClient.getTableApi().deleteTableColumnStatistics(catalogId, dbName, tableName, colNames), Action.DELETE_TABLE_COLUMN_STATISTICS);
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws Exception {
        return (Map)this.call(() -> this.dataLakeClient.getPartitionApi().getPartitionColumnStatistics(catalogId, dbName, tableName, partitionNames, columnNames), Action.GET_PARTITION_COLUMN_STATISTICS);
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> batchGetPartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws Exception {
        return (Map)this.call(() -> this.dataLakeClient.getPartitionApi().batchGetPartitionColumnStatistics(catalogId, dbName, tableName, partitionNames, columnNames), Action.GET_PARTITION_COLUMN_STATISTICS);
    }

    @Override
    public boolean updatePartitionColumnStatistics(UpdateTablePartitionColumnStatisticsRequest columnStatistics) throws Exception {
        return (Boolean)this.call(() -> this.dataLakeClient.getPartitionApi().updatePartitionColumnStatistics(columnStatistics), Action.UPDATE_PARTITION_COLUMN_STATISTICS);
    }

    @Override
    public boolean deletePartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partNames, List<String> colNames) throws Exception {
        return (Boolean)this.call(() -> this.dataLakeClient.getPartitionApi().deletePartitionColumnStatistics(catalogId, dbName, tableName, partNames, colNames), Action.DELETE_PARTITION_COLUMN_STATISTICS);
    }

    private <T, U> T iteratePartitions(IDataLakeMetaStore.PartitionsFetcher<U> partitionsFetcher, IDataLakeMetaStore.PartitionVisitor<T, U> resultConverter, int totalNum, int pageSize) throws Exception {
        PaginatedResult<U> pageResult;
        String nextToken = EMPTY_TOKEN;
        int iteratedCount = 0;
        do {
            if (totalNum > 0) {
                int n = pageSize = totalNum - iteratedCount > pageSize ? pageSize : totalNum - iteratedCount;
            }
            if ((pageResult = partitionsFetcher.apply(pageSize, nextToken)).getData() == null || pageResult.getData().size() <= 0) continue;
            resultConverter.accept(pageResult.getData());
            if (totalNum > 0 && (iteratedCount += pageResult.getData().size()) >= totalNum) break;
        } while (!(nextToken = pageResult.getNextPageToken()).equals(EMPTY_TOKEN));
        return resultConverter.getResult();
    }

    @Override
    public Partition addPartition(String catalogId, String dbName, String tableName, PartitionInput partitions, boolean ifNotExist, boolean needResult) throws Exception {
        Partition result = (Partition)this.call(() -> this.dataLakeClient.getPartitionApi().createPartition(catalogId, dbName, tableName, partitions, ifNotExist, needResult), Action.CREATE_PARTITIONS);
        return result;
    }

    @Override
    public List<Partition> addPartitions(String catalogId, String dbName, String tableName, List<PartitionInput> partitions, boolean ifNotExist, boolean needResult) throws Exception {
        ArrayList<Partition> result = needResult ? new ArrayList<Partition>(partitions.size()) : new ArrayList();
        try {
            FunctionalUtils.batchedCall(partitions, result, this.batchSize, batchedInput -> (List)this.call(() -> this.dataLakeClient.getPartitionApi().batchCreatePartitions(catalogId, dbName, tableName, (List<PartitionInput>)batchedInput, ifNotExist, needResult), Action.CREATE_PARTITIONS), this.executorService);
        }
        catch (Exception exception) {
            Throwable cause = exception.getCause();
            if (cause != null && cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw exception;
        }
        return result;
    }

    @Override
    public void alterPartitions(String catalogId, String dbName, String tblName, List<PartitionInput> partitions) throws Exception {
        try {
            FunctionalUtils.batchedRunnable(partitions, this.batchSize, batchedInput -> (Void)this.call(() -> this.dataLakeClient.getPartitionApi().batchUpdatePartitions(catalogId, dbName, tblName, (List<PartitionInput>)batchedInput), Action.ALTER_PARTITIONS), this.executorService);
        }
        catch (Exception exception) {
            Throwable cause = exception.getCause();
            if (cause != null && cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw exception;
        }
    }

    @Override
    public <T> T listPartitionsByExpr(String catalogId, String dbName, String tblName, byte[] expr, String defaultPartName, int max, String filter, int pageSizeIn, IDataLakeMetaStore.PartitionVisitor<T, Partition> resultConverter) throws Exception {
        return this.iteratePartitions((pageSize, nextPageToken) -> (PaginatedResult)this.call(() -> this.dataLakeClient.getPartitionApi().listPartitionsByFilter(catalogId, dbName, tblName, filter, pageSize, nextPageToken, true), Action.GET_PARTITIONS), resultConverter, max, pageSizeIn);
    }

    @Override
    public void doDropPartitions(String catalogId, String dbName, String tableName, List<List<String>> partValuesList, boolean ifExist) throws Exception {
        try {
            FunctionalUtils.batchedRunnable(partValuesList, this.batchSize, batchedInput -> (Void)this.call(() -> this.dataLakeClient.getPartitionApi().batchDeletePartitions(catalogId, dbName, tableName, (List<List<String>>)batchedInput, ifExist), Action.DROP_PARTITIONS), this.executorService);
        }
        catch (Exception exception) {
            Throwable cause = exception.getCause();
            if (cause != null && cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw exception;
        }
    }

    @Override
    public void doDropPartition(String catalogId, String dbName, String tableName, List<String> partValuesList, boolean ifExist) throws Exception {
        this.call(() -> this.dataLakeClient.getPartitionApi().deletePartition(catalogId, dbName, tableName, partValuesList, ifExist), Action.DROP_PARTITIONS);
    }

    @Override
    public Partition getPartition(String catalogId, String databaseName, String tableName, List<String> parValues) throws Exception {
        Partition partition = (Partition)this.call(() -> this.dataLakeClient.getPartitionApi().getPartition(catalogId, databaseName, tableName, parValues), Action.GET_PARTITION);
        return partition;
    }

    @Override
    public List<Partition> getPartitionsByValues(String catalogId, String databaseName, String tableName, List<List<String>> partValuesList) throws Exception {
        ArrayList<Partition> result = new ArrayList<Partition>(partValuesList.size());
        try {
            FunctionalUtils.batchedCall(partValuesList, result, this.batchSize, batchedInput -> (List)this.call(() -> this.dataLakeClient.getPartitionApi().batchGetPartitions(catalogId, databaseName, tableName, (List<List<String>>)batchedInput, true), Action.GET_PARTITIONS), this.executorService);
        }
        catch (Exception exception) {
            Throwable cause = exception.getCause();
            if (cause != null && cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw exception;
        }
        return result;
    }

    @Override
    public void renamePartitionInCatalog(String catalogId, String dbName, String tbName, List<String> partitionValues, PartitionInput newPartition) throws Exception {
        this.call(() -> this.dataLakeClient.getPartitionApi().renamePartition(catalogId, dbName, tbName, partitionValues, newPartition), Action.ALTER_PARTITION);
    }

    @Override
    public List<String> listPartitionNames(String catalogId, String dbName, String tblName, List<String> partialPartValues, int max, int pageSizeIn) throws Exception {
        IDataLakeMetaStore.PartitionNameVisitor resultConverter = new IDataLakeMetaStore.PartitionNameVisitor();
        return this.iteratePartitions((pageSize, nextPageToken) -> (PaginatedResult)this.call(() -> this.dataLakeClient.getPartitionApi().listPartitionNames(catalogId, dbName, tblName, partialPartValues, pageSize, nextPageToken), Action.LIST_PARTITIONS_NAMES), resultConverter, max, pageSizeIn);
    }

    @Override
    public int getNumPartitionsByFilter(String catalogId, String dbName, String tblName, String filter, int pageSizeIn) throws Exception {
        return this.iteratePartitions((pageSize, nextPageToken) -> (PaginatedResult)this.call(() -> this.dataLakeClient.getPartitionApi().listPartitionsByFilter(catalogId, dbName, tblName, filter, pageSize, nextPageToken, true), Action.GET_PARTITIONS), new IDataLakeMetaStore.PartitionCountVisitor(), -1, pageSizeIn);
    }

    @Override
    public <T> T listPartitionsInternal(String catalogId, String databaseName, String tableName, List<String> values, String filter, int max, int pageSizeIn, IDataLakeMetaStore.PartitionVisitor<T, Partition> resultConverter) throws Exception {
        IDataLakeMetaStore.PartitionsFetcher partitionsFetcher = DataLakeUtil.isNotBlank(filter) ? (pageSize, nextPageToken) -> (PaginatedResult)this.call(() -> this.dataLakeClient.getPartitionApi().listPartitionsByFilter(catalogId, databaseName, tableName, filter, pageSize, nextPageToken, true), Action.GET_PARTITIONS) : (pageSize, nextPageToken) -> (PaginatedResult)this.call(() -> this.dataLakeClient.getPartitionApi().listPartitions(catalogId, databaseName, tableName, values, pageSize, nextPageToken, true), Action.GET_PARTITIONS);
        return this.iteratePartitions(partitionsFetcher, resultConverter, max, pageSizeIn);
    }

    @Override
    public <T> T listPartitions(String catalogId, String databaseName, String tableName, int max, int pageSizeIn, IDataLakeMetaStore.PartitionVisitor<T, Partition> resultConverter) throws Exception {
        IDataLakeMetaStore.PartitionsFetcher partitionsFetcher = (pageSize, nextPageToken) -> (PaginatedResult)this.call(() -> this.dataLakeClient.getPartitionApi().listPartitions(catalogId, databaseName, tableName, new ArrayList<String>(), pageSize, nextPageToken, true), Action.GET_PARTITIONS);
        return this.iteratePartitions(partitionsFetcher, resultConverter, max, pageSizeIn);
    }

    @Override
    public List<Partition> listPartitionsByFilter(String catalogId, String databaseName, String tableName, String filter, int pageSizeIn) throws Exception {
        PaginatedResult result;
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        String nextToken = EMPTY_TOKEN;
        do {
            String nextTok = nextToken;
            result = (PaginatedResult)this.call(() -> this.dataLakeClient.getPartitionApi().listPartitionsByFilter(catalogId, databaseName, tableName, filter, pageSizeIn, nextTok, true), Action.GET_PARTITIONS);
            partitions.addAll(result.getData());
        } while (!(nextToken = result.getNextPageToken()).equals(EMPTY_TOKEN));
        return partitions;
    }

    @Override
    public void createFunction(String catalogId, FunctionInput function, String dbName) throws Exception {
        this.call(() -> this.dataLakeClient.getFunctionApi().createFunction(catalogId, dbName, function), Action.CREATE_FUNCTION);
    }

    @Override
    public Function getFunction(String catalogId, String dbName, String functionName) throws Exception {
        Function result = (Function)this.call(() -> this.dataLakeClient.getFunctionApi().getFunction(catalogId, dbName, functionName), Action.GET_FUNCTION);
        return result;
    }

    @Override
    public List<String> getFunctions(String catalogId, String dbName, String pattern, int pageSize) throws Exception {
        PaginatedResult result;
        String nextToken = EMPTY_TOKEN;
        ArrayList<String> functionNames = new ArrayList<String>();
        do {
            String nextTok = nextToken;
            result = (PaginatedResult)this.call(() -> this.dataLakeClient.getFunctionApi().listFunctionNames(catalogId, dbName, pattern, pageSize, nextTok), Action.GET_FUNCTIONS);
            functionNames.addAll(result.getData());
        } while (!(nextToken = result.getNextPageToken()).equals(EMPTY_TOKEN));
        return functionNames;
    }

    @Override
    public List<Function> getFunctionObjects(String catalogId, String dbName, String pattern, int pageSize) throws Exception {
        PaginatedResult result;
        String nextToken = EMPTY_TOKEN;
        ArrayList<Function> functions = new ArrayList<Function>();
        do {
            String nextTok = nextToken;
            result = (PaginatedResult)this.call(() -> this.dataLakeClient.getFunctionApi().listFunctions(catalogId, dbName, pattern, pageSize, nextTok), Action.GET_FUNCTIONS);
            functions.addAll(result.getData());
        } while (!(nextToken = result.getNextPageToken()).equals(EMPTY_TOKEN));
        return functions;
    }

    @Override
    public void alterFunction(String catalogId, String dbName, String functionName, FunctionInput function) throws Exception {
        this.call(() -> this.dataLakeClient.getFunctionApi().updateFunction(catalogId, dbName, functionName, function), Action.ALTER_FUNCTION);
    }

    @Override
    public void dropFunction(String catalogId, String dbName, String functionName) throws Exception {
        this.call(() -> this.dataLakeClient.getFunctionApi().deleteFunction(catalogId, dbName, functionName), Action.DROP_FUNCTION);
    }

    @Override
    public List<Partition> getNonSubDirectoryPartitionLocations(String catalogId, String dbName, String tableName, int pageSize) throws Exception {
        PaginatedResult paginatedResult;
        String nextToken = EMPTY_TOKEN;
        ArrayList<Partition> results = new ArrayList<Partition>();
        do {
            String nextTok = nextToken;
            paginatedResult = (PaginatedResult)this.call(() -> this.dataLakeClient.getPartitionApi().listPartitions(catalogId, dbName, tableName, Lists.newArrayList(), pageSize, nextTok, true), Action.GET_PARTITIONS);
            results.addAll(paginatedResult.getData());
        } while (!(nextToken = paginatedResult.getNextPageToken()).equals(EMPTY_TOKEN));
        return results;
    }

    @Override
    public LockStatus lock(List<LockObj> lockObjList) throws Exception {
        return (LockStatus)this.call(() -> this.dataLakeClient.getTableApi().lock(lockObjList), Action.LOCK);
    }

    @Override
    public Boolean unLock(Long lockId) throws Exception {
        return (Boolean)this.call(() -> this.dataLakeClient.getTableApi().unLock(lockId), Action.UNLOCK);
    }

    @Override
    public LockStatus getLock(Long lockId) throws Exception {
        return (LockStatus)this.call(() -> this.dataLakeClient.getTableApi().getLock(lockId), Action.GET_LOCK);
    }

    @Override
    public Boolean refreshLock(Long lockId) throws Exception {
        return (Boolean)this.call(() -> this.dataLakeClient.getTableApi().refreshLock(lockId), Action.REFRESH_LOCK);
    }
}

