/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common;

import com.aliyun.datalake.metastore.common.api.DatabaseApi;
import com.aliyun.datalake.metastore.common.api.FunctionApi;
import com.aliyun.datalake.metastore.common.api.PartitionApi;
import com.aliyun.datalake.metastore.common.api.TableApi;
import com.aliyun.datalake20200710.Client;
import com.aliyun.teaopenapi.models.Config;

public class DataLakeClient {
    private final Client client;
    private final DatabaseApi databaseApi;
    private final TableApi tableApi;
    private final FunctionApi functionApi;
    private final PartitionApi partitionApi;

    public DataLakeClient(String regionId, String accessKeyId, String accessKeySecret, String endpoint) throws Exception {
        this(regionId, accessKeyId, accessKeySecret, endpoint, accessKeySecret);
    }

    public DataLakeClient(Config config) throws Exception {
        this.client = new Client(config);
        this.databaseApi = new DatabaseApi(this.client);
        this.tableApi = new TableApi(this.client);
        this.functionApi = new FunctionApi(this.client);
        this.partitionApi = new PartitionApi(this.client);
    }

    public DataLakeClient(String regionId, String accessKeyId, String accessKeySecret, String endpoint, String securityToken) throws Exception {
        Config config = new Config();
        config.accessKeyId = accessKeyId;
        config.accessKeySecret = accessKeySecret;
        config.endpoint = endpoint;
        config.regionId = regionId;
        config.securityToken = securityToken;
        this.client = new Client(config);
        this.databaseApi = new DatabaseApi(this.client);
        this.tableApi = new TableApi(this.client);
        this.functionApi = new FunctionApi(this.client);
        this.partitionApi = new PartitionApi(this.client);
    }

    public DatabaseApi getDatabaseApi() {
        return this.databaseApi;
    }

    public TableApi getTableApi() {
        return this.tableApi;
    }

    public FunctionApi getFunctionApi() {
        return this.functionApi;
    }

    public PartitionApi getPartitionApi() {
        return this.partitionApi;
    }
}

