/* The following code was generated by JFlex 1.4.3 on 12/4/22 5:08 AM */

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// This file is copied from
// https://github.com/cloudera/Impala/blob/v0.7refresh/fe/src/main/jflex/sql-scanner.flex
// and modified by Doris

package org.apache.doris.analysis;

import java_cup.runtime.Symbol;
import java.io.StringWriter;
import java.lang.Integer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

import org.apache.doris.analysis.SqlParserSymbols;
import org.apache.doris.common.util.SqlUtils;
import org.apache.doris.qe.SqlModeHelper;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 12/4/22 5:08 AM from the specification file
 * <tt>/root/doris/fe/fe-core/src/main/jflex/sql_scanner.flex</tt>
 */
public final class SqlScanner implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int EOLHINT = 2;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1, 1
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\6\1\3\1\2\1\0\1\3\1\1\16\6\4\0\1\22\1\41"+
    "\1\14\1\0\1\5\1\35\1\7\1\12\1\27\1\30\1\24\1\20"+
    "\1\25\1\21\1\16\1\23\12\15\1\31\1\32\1\42\1\40\1\43"+
    "\1\0\1\26\4\5\1\17\25\5\1\33\1\13\1\34\1\36\1\5"+
    "\1\11\4\5\1\17\25\5\1\0\1\10\1\0\1\37\41\6\2\0"+
    "\4\5\4\0\1\5\2\0\1\6\7\0\1\5\4\0\1\5\5\0"+
    "\27\5\1\0\37\5\1\0\u01ca\5\4\0\14\5\16\0\5\5\7\0"+
    "\1\5\1\0\1\5\21\0\160\6\5\5\1\0\2\5\2\0\4\5"+
    "\10\0\1\5\1\0\3\5\1\0\1\5\1\0\24\5\1\0\123\5"+
    "\1\0\213\5\1\0\5\6\2\0\236\5\11\0\46\5\2\0\1\5"+
    "\7\0\47\5\7\0\1\5\1\0\55\6\1\0\1\6\1\0\2\6"+
    "\1\0\2\6\1\0\1\6\10\0\33\5\5\0\3\5\15\0\5\6"+
    "\6\0\1\5\4\0\13\6\5\0\53\5\25\6\12\4\4\0\2\5"+
    "\1\6\143\5\1\0\1\5\10\6\1\0\6\6\2\5\2\6\1\0"+
    "\4\6\2\5\12\4\3\5\2\0\1\5\17\0\1\6\1\5\1\6"+
    "\36\5\33\6\2\0\131\5\13\6\1\5\16\0\12\4\41\5\11\6"+
    "\2\5\4\0\1\5\5\0\26\5\4\6\1\5\11\6\1\5\3\6"+
    "\1\5\5\6\22\0\31\5\3\6\104\0\1\5\1\0\13\5\67\0"+
    "\33\6\1\0\4\6\66\5\3\6\1\5\22\6\1\5\7\6\12\5"+
    "\2\6\2\0\12\4\1\0\7\5\1\0\7\5\1\0\3\6\1\0"+
    "\10\5\2\0\2\5\2\0\26\5\1\0\7\5\1\0\1\5\3\0"+
    "\4\5\2\0\1\6\1\5\7\6\2\0\2\6\2\0\3\6\1\5"+
    "\10\0\1\6\4\0\2\5\1\0\3\5\2\6\2\0\12\4\4\5"+
    "\7\0\1\5\5\0\3\6\1\0\6\5\4\0\2\5\2\0\26\5"+
    "\1\0\7\5\1\0\2\5\1\0\2\5\1\0\2\5\2\0\1\6"+
    "\1\0\5\6\4\0\2\6\2\0\3\6\3\0\1\6\7\0\4\5"+
    "\1\0\1\5\7\0\12\4\2\6\3\5\1\6\13\0\3\6\1\0"+
    "\11\5\1\0\3\5\1\0\26\5\1\0\7\5\1\0\2\5\1\0"+
    "\5\5\2\0\1\6\1\5\10\6\1\0\3\6\1\0\3\6\2\0"+
    "\1\5\17\0\2\5\2\6\2\0\12\4\1\0\1\5\17\0\3\6"+
    "\1\0\10\5\2\0\2\5\2\0\26\5\1\0\7\5\1\0\2\5"+
    "\1\0\5\5\2\0\1\6\1\5\7\6\2\0\2\6\2\0\3\6"+
    "\10\0\2\6\4\0\2\5\1\0\3\5\2\6\2\0\12\4\1\0"+
    "\1\5\20\0\1\6\1\5\1\0\6\5\3\0\3\5\1\0\4\5"+
    "\3\0\2\5\1\0\1\5\1\0\2\5\3\0\2\5\3\0\3\5"+
    "\3\0\14\5\4\0\5\6\3\0\3\6\1\0\4\6\2\0\1\5"+
    "\6\0\1\6\16\0\12\4\11\0\1\5\7\0\3\6\1\0\10\5"+
    "\1\0\3\5\1\0\27\5\1\0\12\5\1\0\5\5\3\0\1\5"+
    "\7\6\1\0\3\6\1\0\4\6\7\0\2\6\1\0\2\5\6\0"+
    "\2\5\2\6\2\0\12\4\22\0\2\6\1\0\10\5\1\0\3\5"+
    "\1\0\27\5\1\0\12\5\1\0\5\5\2\0\1\6\1\5\7\6"+
    "\1\0\3\6\1\0\4\6\7\0\2\6\7\0\1\5\1\0\2\5"+
    "\2\6\2\0\12\4\1\0\2\5\17\0\2\6\1\0\10\5\1\0"+
    "\3\5\1\0\51\5\2\0\1\5\7\6\1\0\3\6\1\0\4\6"+
    "\1\5\10\0\1\6\10\0\2\5\2\6\2\0\12\4\12\0\6\5"+
    "\2\0\2\6\1\0\22\5\3\0\30\5\1\0\11\5\1\0\1\5"+
    "\2\0\7\5\3\0\1\6\4\0\6\6\1\0\1\6\1\0\10\6"+
    "\22\0\2\6\15\0\60\5\1\6\2\5\7\6\4\0\10\5\10\6"+
    "\1\0\12\4\47\0\2\5\1\0\1\5\2\0\2\5\1\0\1\5"+
    "\2\0\1\5\6\0\4\5\1\0\7\5\1\0\3\5\1\0\1\5"+
    "\1\0\1\5\2\0\2\5\1\0\4\5\1\6\2\5\6\6\1\0"+
    "\2\6\1\5\2\0\5\5\1\0\1\5\1\0\6\6\2\0\12\4"+
    "\2\0\4\5\40\0\1\5\27\0\2\6\6\0\12\4\13\0\1\6"+
    "\1\0\1\6\1\0\1\6\4\0\2\6\10\5\1\0\44\5\4\0"+
    "\24\6\1\0\2\6\5\5\13\6\1\0\44\6\11\0\1\6\71\0"+
    "\53\5\24\6\1\5\12\4\6\0\6\5\4\6\4\5\3\6\1\5"+
    "\3\6\2\5\7\6\3\5\4\6\15\5\14\6\1\5\1\6\12\4"+
    "\4\6\2\0\46\5\1\0\1\5\5\0\1\5\2\0\53\5\1\0"+
    "\u014d\5\1\0\4\5\2\0\7\5\1\0\1\5\1\0\4\5\2\0"+
    "\51\5\1\0\4\5\2\0\41\5\1\0\4\5\2\0\7\5\1\0"+
    "\1\5\1\0\4\5\2\0\17\5\1\0\71\5\1\0\4\5\2\0"+
    "\103\5\2\0\3\6\40\0\20\5\20\0\125\5\14\0\u026c\5\2\0"+
    "\21\5\1\0\32\5\5\0\113\5\3\0\3\5\17\0\15\5\1\0"+
    "\4\5\3\6\13\0\22\5\3\6\13\0\22\5\2\6\14\0\15\5"+
    "\1\0\3\5\1\0\2\6\14\0\64\5\40\6\3\0\1\5\3\0"+
    "\2\5\1\6\2\0\12\4\41\0\3\6\2\0\12\4\6\0\130\5"+
    "\10\0\51\5\1\6\1\5\5\0\106\5\12\0\35\5\3\0\14\6"+
    "\4\0\14\6\12\0\12\4\36\5\2\0\5\5\13\0\54\5\4\0"+
    "\21\6\7\5\2\6\6\0\12\4\46\0\27\5\5\6\4\0\65\5"+
    "\12\6\1\0\35\6\2\0\1\6\12\4\6\0\12\4\15\0\1\5"+
    "\130\0\5\6\57\5\21\6\7\5\4\0\12\4\21\0\11\6\14\0"+
    "\3\6\36\5\15\6\2\5\12\4\54\5\16\6\14\0\44\5\24\6"+
    "\10\0\12\4\3\0\3\5\12\4\44\5\122\0\3\6\1\0\25\6"+
    "\4\5\1\6\4\5\3\6\2\5\11\0\300\5\47\6\25\0\4\6"+
    "\u0116\5\2\0\6\5\2\0\46\5\2\0\6\5\2\0\10\5\1\0"+
    "\1\5\1\0\1\5\1\0\1\5\1\0\37\5\2\0\65\5\1\0"+
    "\7\5\1\0\1\5\3\0\3\5\1\0\7\5\3\0\4\5\2\0"+
    "\6\5\4\0\15\5\5\0\3\5\1\0\7\5\16\0\5\6\32\0"+
    "\5\6\20\0\2\5\23\0\1\5\13\0\5\6\5\0\6\6\1\0"+
    "\1\5\15\0\1\5\20\0\15\5\3\0\33\5\25\0\15\6\4\0"+
    "\1\6\3\0\14\6\21\0\1\5\4\0\1\5\2\0\12\5\1\0"+
    "\1\5\3\0\5\5\6\0\1\5\1\0\1\5\1\0\1\5\1\0"+
    "\4\5\1\0\13\5\2\0\4\5\5\0\5\5\4\0\1\5\21\0"+
    "\51\5\u0a77\0\57\5\1\0\57\5\1\0\205\5\6\0\4\5\3\6"+
    "\2\5\14\0\46\5\1\0\1\5\5\0\1\5\2\0\70\5\7\0"+
    "\1\5\17\0\1\6\27\5\11\0\7\5\1\0\7\5\1\0\7\5"+
    "\1\0\7\5\1\0\7\5\1\0\7\5\1\0\7\5\1\0\7\5"+
    "\1\0\40\6\57\0\1\5\u01d5\0\3\5\31\0\11\5\6\6\1\0"+
    "\5\5\2\0\5\5\4\0\126\5\2\0\2\6\2\0\3\5\1\0"+
    "\132\5\1\0\4\5\5\0\51\5\3\0\136\5\21\0\33\5\65\0"+
    "\20\5\u0200\0\u19b6\5\112\0\u51cd\5\63\0\u048d\5\103\0\56\5\2\0"+
    "\u010d\5\3\0\20\5\12\4\2\5\24\0\57\5\1\6\4\0\12\6"+
    "\1\0\31\5\7\0\1\6\120\5\2\6\45\0\11\5\2\0\147\5"+
    "\2\0\4\5\1\0\4\5\14\0\13\5\115\0\12\5\1\6\3\5"+
    "\1\6\4\5\1\6\27\5\5\6\20\0\1\5\7\0\64\5\14\0"+
    "\2\6\62\5\21\6\13\0\12\4\6\0\22\6\6\5\3\0\1\5"+
    "\4\0\12\4\34\5\10\6\2\0\27\5\15\6\14\0\35\5\3\0"+
    "\4\6\57\5\16\6\16\0\1\5\12\4\46\0\51\5\16\6\11\0"+
    "\3\5\1\6\10\5\2\6\2\0\12\4\6\0\27\5\3\0\1\5"+
    "\1\6\4\0\60\5\1\6\1\5\3\6\2\5\2\6\5\5\2\6"+
    "\1\5\1\6\1\5\30\0\3\5\2\0\13\5\5\6\2\0\3\5"+
    "\2\6\12\0\6\5\2\0\6\5\2\0\6\5\11\0\7\5\1\0"+
    "\7\5\221\0\43\5\10\6\1\0\2\6\2\0\12\4\6\0\u2ba4\5"+
    "\14\0\27\5\4\0\61\5\u2104\0\u016e\5\2\0\152\5\46\0\7\5"+
    "\14\0\5\5\5\0\1\5\1\6\12\5\1\0\15\5\1\0\5\5"+
    "\1\0\1\5\1\0\2\5\1\0\2\5\1\0\154\5\41\0\u016b\5"+
    "\22\0\100\5\2\0\66\5\50\0\15\5\3\0\20\6\20\0\7\6"+
    "\14\0\2\5\30\0\3\5\31\0\1\5\6\0\5\5\1\0\207\5"+
    "\2\0\1\6\4\0\1\5\13\0\12\4\7\0\32\5\4\0\1\5"+
    "\1\0\32\5\13\0\131\5\3\0\6\5\2\0\6\5\2\0\6\5"+
    "\2\0\3\5\3\0\2\5\3\0\2\5\22\0\3\6\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\2\1\1\2\1\3\1\4\1\5\3\6\1\2"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\2\33\1\3\1\0\1\34"+
    "\1\0\1\35\3\0\1\36\1\37\1\3\1\0\1\1"+
    "\1\0\1\40\1\41\2\0\1\42\1\1\1\43\1\0"+
    "\1\44\1\0\1\37\2\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[61];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\44\0\110\0\154\0\220\0\264\0\330\0\374"+
    "\0\u0120\0\u0144\0\u0168\0\u018c\0\u01b0\0\154\0\u01d4\0\u01f8"+
    "\0\u021c\0\154\0\154\0\154\0\154\0\u0240\0\154\0\154"+
    "\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154"+
    "\0\u0264\0\154\0\154\0\u0120\0\u0288\0\u0144\0\u02ac\0\u02d0"+
    "\0\u0168\0\u02f4\0\u0318\0\u033c\0\u0360\0\u0384\0\u03a8\0\u03cc"+
    "\0\154\0\154\0\u03f0\0\u0414\0\154\0\u0438\0\154\0\u045c"+
    "\0\u0480\0\u04a4\0\u0414\0\u0480\0\u04c8";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[61];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\0\1\3\2\4\1\5\1\6\1\0\1\7\1\10"+
    "\1\11\1\12\1\0\1\13\1\14\1\15\1\6\1\16"+
    "\1\17\1\4\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\0\1\41\1\42\1\4\1\5"+
    "\1\6\1\0\1\7\1\10\1\11\1\12\1\0\1\13"+
    "\1\14\1\15\1\6\1\16\1\17\1\4\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\2\0"+
    "\1\4\111\0\1\5\1\6\7\0\1\5\1\0\1\6"+
    "\30\0\3\6\6\0\1\6\1\0\1\6\33\0\1\43"+
    "\44\0\1\43\33\0\11\44\1\45\32\44\12\46\1\47"+
    "\1\50\30\46\13\51\1\52\1\53\27\51\4\0\1\5"+
    "\1\6\7\0\1\14\1\54\1\55\41\0\1\54\1\56"+
    "\46\0\1\57\46\0\1\60\42\0\1\61\60\0\1\62"+
    "\5\0\1\42\52\0\1\44\44\0\1\46\31\0\2\46"+
    "\1\0\41\46\2\51\1\0\41\51\14\0\1\51\44\0"+
    "\1\54\1\0\1\63\30\0\3\6\6\0\1\6\1\0"+
    "\1\6\2\64\40\0\1\65\25\0\1\66\1\3\1\4"+
    "\15\66\1\67\1\66\1\57\21\66\20\70\1\71\1\70"+
    "\1\60\1\70\1\72\17\70\15\0\1\73\2\0\2\64"+
    "\37\0\1\73\26\0\1\66\1\3\1\4\41\66\24\70"+
    "\1\72\17\70\1\74\2\70\21\74\1\75\17\74\23\70"+
    "\1\4\1\72\17\70\1\74\2\70\20\74\1\0\1\75"+
    "\17\74";

  private static int [] zzUnpackTrans() {
    int [] result = new int[1260];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\1\1\11\11\1\1\11\3\1\4\11\1\1"+
    "\12\11\1\1\2\11\1\0\1\1\1\0\1\1\3\0"+
    "\3\1\1\0\1\1\1\0\2\11\2\0\1\11\1\1"+
    "\1\11\1\0\1\1\1\0\1\1\2\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[61];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    // Help to judge a integer-literal is bigger than LARGEINT_MAX
    // NOTE: the 'longMin' is not '-2^63' here, to make sure the return value functions
    // like 'long abs(long)' is same with the type of arguments, which is valid.
    private static final BigInteger LONG_MAX = new BigInteger("9223372036854775807"); // 2^63 - 1

    private static final BigInteger LARGEINT_MAX_ABS = new BigInteger("170141183460469231731687303715884105728"); // 2^127

    // This param will affect the tokens returned by scanner.
    // For example:
    // In PIPES_AS_CONCAT_MODE(0x0002), scanner will return token with id as KW_PIPE instead of KW_OR when '||' is scanned.
    private long sql_mode;

    /**
       * Creates a new scanner to chain-call the generated constructor.
       * There is also a java.io.InputStream version of this constructor.
       * If you use this constructor, sql_mode will be set to 0 (default)
       *
       * @param   in  the java.io.Reader to read input from.
       */
    public SqlScanner(java.io.Reader in) {
      this(in, 0L);
    }

    /**
       * Creates a new scanner chain-call the generated constructor.
       * There is also java.io.Reader version of this constructor.
       * If you use this constructor, sql_mode will be set to 0 (default)
       *
       * @param   in  the java.io.Inputstream to read input from.
       */
    public SqlScanner(java.io.InputStream in) {
      this(in, 0L);
    }

    // map from keyword string to token id
    // we use a linked hash map because the insertion order is important.
    // for example, we want "and" to come after "&&" to make sure error reporting
    // uses "and" as a display name and not "&&"
    private static final Map<String, Integer> keywordMap = new LinkedHashMap<String, Integer>();
    static {
        keywordMap.put("&&", new Integer(SqlParserSymbols.KW_AND));
        keywordMap.put("||", new Integer(SqlParserSymbols.KW_PIPE));
        keywordMap.put("account_lock", new Integer(SqlParserSymbols.KW_ACCOUNT_LOCK));
        keywordMap.put("account_unlock", new Integer(SqlParserSymbols.KW_ACCOUNT_UNLOCK));
        keywordMap.put("add", new Integer(SqlParserSymbols.KW_ADD));
        keywordMap.put("admin", new Integer(SqlParserSymbols.KW_ADMIN));
        keywordMap.put("after", new Integer(SqlParserSymbols.KW_AFTER));
        keywordMap.put("aggregate", new Integer(SqlParserSymbols.KW_AGGREGATE));
        keywordMap.put("alias", new Integer(SqlParserSymbols.KW_ALIAS));
        keywordMap.put("all", new Integer(SqlParserSymbols.KW_ALL));
        keywordMap.put("alter", new Integer(SqlParserSymbols.KW_ALTER));
        keywordMap.put("and", new Integer(SqlParserSymbols.KW_AND));
        keywordMap.put("analyze", new Integer(SqlParserSymbols.KW_ANALYZE));
        keywordMap.put("anti", new Integer(SqlParserSymbols.KW_ANTI));
        keywordMap.put("append", new Integer(SqlParserSymbols.KW_APPEND));
        keywordMap.put("array", new Integer(SqlParserSymbols.KW_ARRAY));
        keywordMap.put("as", new Integer(SqlParserSymbols.KW_AS));
        keywordMap.put("asc", new Integer(SqlParserSymbols.KW_ASC));
        keywordMap.put("authors", new Integer(SqlParserSymbols.KW_AUTHORS));
        keywordMap.put("backend", new Integer(SqlParserSymbols.KW_BACKEND));
        keywordMap.put("backends", new Integer(SqlParserSymbols.KW_BACKENDS));
        keywordMap.put("backup", new Integer(SqlParserSymbols.KW_BACKUP));
        keywordMap.put("begin", new Integer(SqlParserSymbols.KW_BEGIN));
        keywordMap.put("between", new Integer(SqlParserSymbols.KW_BETWEEN));
        keywordMap.put("bigint", new Integer(SqlParserSymbols.KW_BIGINT));
        keywordMap.put("bin", new Integer(SqlParserSymbols.KW_BIN));
        keywordMap.put("binlog", new Integer(SqlParserSymbols.KW_BINLOG));
        keywordMap.put("bitmap", new Integer(SqlParserSymbols.KW_BITMAP));
        keywordMap.put("inverted", new Integer(SqlParserSymbols.KW_INVERTED));
        keywordMap.put("bitmap_union", new Integer(SqlParserSymbols.KW_BITMAP_UNION));
        keywordMap.put("blob", new Integer(SqlParserSymbols.KW_BLOB));
        keywordMap.put("boolean", new Integer(SqlParserSymbols.KW_BOOLEAN));
        keywordMap.put("broker", new Integer(SqlParserSymbols.KW_BROKER));
        keywordMap.put("buckets", new Integer(SqlParserSymbols.KW_BUCKETS));
        keywordMap.put("build", new Integer(SqlParserSymbols.KW_BUILD));
        keywordMap.put("builtin", new Integer(SqlParserSymbols.KW_BUILTIN));
        keywordMap.put("by", new Integer(SqlParserSymbols.KW_BY));
        keywordMap.put("cancel", new Integer(SqlParserSymbols.KW_CANCEL));
        keywordMap.put("case", new Integer(SqlParserSymbols.KW_CASE));
        keywordMap.put("cast", new Integer(SqlParserSymbols.KW_CAST));
        keywordMap.put("catalog", new Integer(SqlParserSymbols.KW_CATALOG));
        keywordMap.put("catalogs", new Integer(SqlParserSymbols.KW_CATALOGS));
        keywordMap.put("chain", new Integer(SqlParserSymbols.KW_CHAIN));
        keywordMap.put("char", new Integer(SqlParserSymbols.KW_CHAR));
        keywordMap.put("character", new Integer(SqlParserSymbols.KW_CHAR));
        keywordMap.put("charset", new Integer(SqlParserSymbols.KW_CHARSET));
        keywordMap.put("check", new Integer(SqlParserSymbols.KW_CHECK));
        keywordMap.put("clean", new Integer(SqlParserSymbols.KW_CLEAN));
        keywordMap.put("cluster", new Integer(SqlParserSymbols.KW_CLUSTER));
        keywordMap.put("clusters", new Integer(SqlParserSymbols.KW_CLUSTERS));
        keywordMap.put("collate", new Integer(SqlParserSymbols.KW_COLLATE));
        keywordMap.put("collation", new Integer(SqlParserSymbols.KW_COLLATION));
        keywordMap.put("column", new Integer(SqlParserSymbols.KW_COLUMN));
        keywordMap.put("columns", new Integer(SqlParserSymbols.KW_COLUMNS));
        keywordMap.put("comment", new Integer(SqlParserSymbols.KW_COMMENT));
        keywordMap.put("commit", new Integer(SqlParserSymbols.KW_COMMIT));
        keywordMap.put("committed", new Integer(SqlParserSymbols.KW_COMMITTED));
        keywordMap.put("compact", new Integer(SqlParserSymbols.KW_COMPACT));
        keywordMap.put("complete", new Integer(SqlParserSymbols.KW_COMPLETE));
        keywordMap.put("config", new Integer(SqlParserSymbols.KW_CONFIG));
        keywordMap.put("connection", new Integer(SqlParserSymbols.KW_CONNECTION));
        keywordMap.put("connection_id", new Integer(SqlParserSymbols.KW_CONNECTION_ID));
        keywordMap.put("consistent", new Integer(SqlParserSymbols.KW_CONSISTENT));
        keywordMap.put("convert", new Integer(SqlParserSymbols.KW_CONVERT));
        keywordMap.put("copy", new Integer(SqlParserSymbols.KW_COPY));
        keywordMap.put("count", new Integer(SqlParserSymbols.KW_COUNT));
        keywordMap.put("create", new Integer(SqlParserSymbols.KW_CREATE));
        keywordMap.put("creation", new Integer(SqlParserSymbols.KW_CREATION));
        keywordMap.put("cross", new Integer(SqlParserSymbols.KW_CROSS));
        keywordMap.put("cube", new Integer(SqlParserSymbols.KW_CUBE));
        keywordMap.put("current", new Integer(SqlParserSymbols.KW_CURRENT));
        keywordMap.put("current_timestamp", new Integer(SqlParserSymbols.KW_CURRENT_TIMESTAMP));
        keywordMap.put("current_user", new Integer(SqlParserSymbols.KW_CURRENT_USER));
        keywordMap.put("data", new Integer(SqlParserSymbols.KW_DATA));
        keywordMap.put("database", new Integer(SqlParserSymbols.KW_DATABASE));
        keywordMap.put("databases", new Integer(SqlParserSymbols.KW_DATABASES));
        keywordMap.put("date", new Integer(SqlParserSymbols.KW_DATE));
        keywordMap.put("datev2", new Integer(SqlParserSymbols.KW_DATEV2));
        keywordMap.put("datetime", new Integer(SqlParserSymbols.KW_DATETIME));
        keywordMap.put("datetimev2", new Integer(SqlParserSymbols.KW_DATETIMEV2));
        keywordMap.put("time", new Integer(SqlParserSymbols.KW_TIME));
        keywordMap.put("day", new Integer(SqlParserSymbols.KW_DAY));
        keywordMap.put("decimal", new Integer(SqlParserSymbols.KW_DECIMAL));
        keywordMap.put("decimalv3", new Integer(SqlParserSymbols.KW_DECIMALV3));
        keywordMap.put("decommission", new Integer(SqlParserSymbols.KW_DECOMMISSION));
        keywordMap.put("default", new Integer(SqlParserSymbols.KW_DEFAULT));
        keywordMap.put("deferred", new Integer(SqlParserSymbols.KW_DEFERRED));
        keywordMap.put("delete", new Integer(SqlParserSymbols.KW_DELETE));
        keywordMap.put("demand", new Integer(SqlParserSymbols.KW_DEMAND));
        keywordMap.put("desc", new Integer(SqlParserSymbols.KW_DESC));
        keywordMap.put("describe", new Integer(SqlParserSymbols.KW_DESCRIBE));
        keywordMap.put("diagnose", new Integer(SqlParserSymbols.KW_DIAGNOSE));
        keywordMap.put("disk", new Integer(SqlParserSymbols.KW_DISK));
        keywordMap.put("distinct", new Integer(SqlParserSymbols.KW_DISTINCT));
        keywordMap.put("distinctpc", new Integer(SqlParserSymbols.KW_DISTINCTPC));
        keywordMap.put("distinctpc", new Integer(SqlParserSymbols.KW_DISTINCTPC));
        keywordMap.put("distinctpcsa", new Integer(SqlParserSymbols.KW_DISTINCTPCSA));
        keywordMap.put("distinctpcsa", new Integer(SqlParserSymbols.KW_DISTINCTPCSA));
        keywordMap.put("distributed", new Integer(SqlParserSymbols.KW_DISTRIBUTED));
        keywordMap.put("distribution", new Integer(SqlParserSymbols.KW_DISTRIBUTION));
        keywordMap.put("div", new Integer(SqlParserSymbols.KW_DIV));
        keywordMap.put("double", new Integer(SqlParserSymbols.KW_DOUBLE));
        keywordMap.put("drop", new Integer(SqlParserSymbols.KW_DROP));
        keywordMap.put("dropp", new Integer(SqlParserSymbols.KW_DROPP));
        keywordMap.put("duplicate", new Integer(SqlParserSymbols.KW_DUPLICATE));
        keywordMap.put("dynamic", new Integer(SqlParserSymbols.KW_DYNAMIC));
        keywordMap.put("else", new Integer(SqlParserSymbols.KW_ELSE));
        keywordMap.put("enable", new Integer(SqlParserSymbols.KW_ENABLE));
        keywordMap.put("encryptkey", new Integer(SqlParserSymbols.KW_ENCRYPTKEY));
        keywordMap.put("encryptkeys", new Integer(SqlParserSymbols.KW_ENCRYPTKEYS));
        keywordMap.put("end", new Integer(SqlParserSymbols.KW_END));
        keywordMap.put("engine", new Integer(SqlParserSymbols.KW_ENGINE));
        keywordMap.put("engines", new Integer(SqlParserSymbols.KW_ENGINES));
        keywordMap.put("enter", new Integer(SqlParserSymbols.KW_ENTER));
        keywordMap.put("errors", new Integer(SqlParserSymbols.KW_ERRORS));
        keywordMap.put("events", new Integer(SqlParserSymbols.KW_EVENTS));
        keywordMap.put("except", new Integer(SqlParserSymbols.KW_EXCEPT));
        keywordMap.put("exclude", new Integer(SqlParserSymbols.KW_EXCLUDE));
        keywordMap.put("exists", new Integer(SqlParserSymbols.KW_EXISTS));
        keywordMap.put("explain", new Integer(SqlParserSymbols.KW_DESCRIBE));
        keywordMap.put("export", new Integer(SqlParserSymbols.KW_EXPORT));
        keywordMap.put("extended", new Integer(SqlParserSymbols.KW_EXTENDED));
        keywordMap.put("external", new Integer(SqlParserSymbols.KW_EXTERNAL));
        keywordMap.put("extract", new Integer(SqlParserSymbols.KW_EXTRACT));
        keywordMap.put("false", new Integer(SqlParserSymbols.KW_FALSE));
        keywordMap.put("fast", new Integer(SqlParserSymbols.KW_FAST));
        keywordMap.put("failed_login_attempts", new Integer(SqlParserSymbols.KW_FAILED_LOGIN_ATTEMPTS));
        keywordMap.put("feature", new Integer(SqlParserSymbols.KW_FEATURE));
        keywordMap.put("fields", new Integer(SqlParserSymbols.KW_FIELDS));
        keywordMap.put("file", new Integer(SqlParserSymbols.KW_FILE));
        keywordMap.put("filter", new Integer(SqlParserSymbols.KW_FILTER));
        keywordMap.put("first", new Integer(SqlParserSymbols.KW_FIRST));
        keywordMap.put("float", new Integer(SqlParserSymbols.KW_FLOAT));
        keywordMap.put("follower", new Integer(SqlParserSymbols.KW_FOLLOWER));
        keywordMap.put("following", new Integer(SqlParserSymbols.KW_FOLLOWING));
        keywordMap.put("for", new Integer(SqlParserSymbols.KW_FOR));
        keywordMap.put("force", new Integer(SqlParserSymbols.KW_FORCE));
        keywordMap.put("format", new Integer(SqlParserSymbols.KW_FORMAT));
        keywordMap.put("free", new Integer(SqlParserSymbols.KW_FREE));
        keywordMap.put("from", new Integer(SqlParserSymbols.KW_FROM));
        keywordMap.put("frontend", new Integer(SqlParserSymbols.KW_FRONTEND));
        keywordMap.put("frontends", new Integer(SqlParserSymbols.KW_FRONTENDS));
        keywordMap.put("full", new Integer(SqlParserSymbols.KW_FULL));
        keywordMap.put("function", new Integer(SqlParserSymbols.KW_FUNCTION));
        keywordMap.put("functions", new Integer(SqlParserSymbols.KW_FUNCTIONS));
        keywordMap.put("global", new Integer(SqlParserSymbols.KW_GLOBAL));
        keywordMap.put("grant", new Integer(SqlParserSymbols.KW_GRANT));
        keywordMap.put("grants", new Integer(SqlParserSymbols.KW_GRANTS));
        keywordMap.put("graph", new Integer(SqlParserSymbols.KW_GRAPH));
        keywordMap.put("group", new Integer(SqlParserSymbols.KW_GROUP));
        keywordMap.put("grouping", new Integer(SqlParserSymbols.KW_GROUPING));
        keywordMap.put("hash", new Integer(SqlParserSymbols.KW_HASH));
        keywordMap.put("having", new Integer(SqlParserSymbols.KW_HAVING));
        keywordMap.put("hdfs", new Integer(SqlParserSymbols.KW_HDFS));
        keywordMap.put("help", new Integer(SqlParserSymbols.KW_HELP));
        keywordMap.put("hll", new Integer(SqlParserSymbols.KW_HLL));
        keywordMap.put("hll_union", new Integer(SqlParserSymbols.KW_HLL_UNION));
        keywordMap.put("hour", new Integer(SqlParserSymbols.KW_HOUR));
        keywordMap.put("hub", new Integer(SqlParserSymbols.KW_HUB));
        keywordMap.put("identified", new Integer(SqlParserSymbols.KW_IDENTIFIED));
        keywordMap.put("if", new Integer(SqlParserSymbols.KW_IF));
        keywordMap.put("immediate", new Integer(SqlParserSymbols.KW_IMMEDIATE));
        keywordMap.put("in", new Integer(SqlParserSymbols.KW_IN));
        keywordMap.put("index", new Integer(SqlParserSymbols.KW_INDEX));
        keywordMap.put("indexes", new Integer(SqlParserSymbols.KW_INDEXES));
        keywordMap.put("infile", new Integer(SqlParserSymbols.KW_INFILE));
        keywordMap.put("inner", new Integer(SqlParserSymbols.KW_INNER));
        keywordMap.put("inner", new Integer(SqlParserSymbols.KW_INNER));
        keywordMap.put("insert", new Integer(SqlParserSymbols.KW_INSERT));
        keywordMap.put("install", new Integer(SqlParserSymbols.KW_INSTALL));
        keywordMap.put("int", new Integer(SqlParserSymbols.KW_INT));
        keywordMap.put("integer", new Integer(SqlParserSymbols.KW_INT));
        keywordMap.put("intermediate", new Integer(SqlParserSymbols.KW_INTERMEDIATE));
        keywordMap.put("intersect", new Integer(SqlParserSymbols.KW_INTERSECT));
        keywordMap.put("interval", new Integer(SqlParserSymbols.KW_INTERVAL));
        keywordMap.put("into", new Integer(SqlParserSymbols.KW_INTO));
        keywordMap.put("is", new Integer(SqlParserSymbols.KW_IS));
        keywordMap.put("isnull", new Integer(SqlParserSymbols.KW_ISNULL));
        keywordMap.put("isolation", new Integer(SqlParserSymbols.KW_ISOLATION));
        keywordMap.put("job", new Integer(SqlParserSymbols.KW_JOB));
        keywordMap.put("join", new Integer(SqlParserSymbols.KW_JOIN));
        keywordMap.put("jsonb", new Integer(SqlParserSymbols.KW_JSONB));
        keywordMap.put("key", new Integer(SqlParserSymbols.KW_KEY));
        keywordMap.put("keys", new Integer(SqlParserSymbols.KW_KEYS));
        keywordMap.put("kill", new Integer(SqlParserSymbols.KW_KILL));
        keywordMap.put("label", new Integer(SqlParserSymbols.KW_LABEL));
        keywordMap.put("largeint", new Integer(SqlParserSymbols.KW_LARGEINT));
        keywordMap.put("last", new Integer(SqlParserSymbols.KW_LAST));
        keywordMap.put("lateral", new Integer(SqlParserSymbols.KW_LATERAL));
        keywordMap.put("ldap_admin_password", new Integer(SqlParserSymbols.KW_LDAP_ADMIN_PASSWORD));
        keywordMap.put("left", new Integer(SqlParserSymbols.KW_LEFT));
        keywordMap.put("less", new Integer(SqlParserSymbols.KW_LESS));
        keywordMap.put("level", new Integer(SqlParserSymbols.KW_LEVEL));
        keywordMap.put("like", new Integer(SqlParserSymbols.KW_LIKE));
        keywordMap.put("limit", new Integer(SqlParserSymbols.KW_LIMIT));
        keywordMap.put("link", new Integer(SqlParserSymbols.KW_LINK));
        keywordMap.put("list", new Integer(SqlParserSymbols.KW_LIST));
        keywordMap.put("load", new Integer(SqlParserSymbols.KW_LOAD));
        keywordMap.put("local", new Integer(SqlParserSymbols.KW_LOCAL));
        keywordMap.put("location", new Integer(SqlParserSymbols.KW_LOCATION));
        keywordMap.put("lock", new Integer(SqlParserSymbols.KW_LOCK));
        keywordMap.put("low_priority", new Integer(SqlParserSymbols.KW_LOW_PRIORITY));
        keywordMap.put("map", new Integer(SqlParserSymbols.KW_MAP));
        keywordMap.put("materialized", new Integer(SqlParserSymbols.KW_MATERIALIZED));
        keywordMap.put("max", new Integer(SqlParserSymbols.KW_MAX));
        keywordMap.put("maxvalue", new Integer(SqlParserSymbols.KW_MAX_VALUE));
        keywordMap.put("merge", new Integer(SqlParserSymbols.KW_MERGE));
        keywordMap.put("migrate", new Integer(SqlParserSymbols.KW_MIGRATE));
        keywordMap.put("migrations", new Integer(SqlParserSymbols.KW_MIGRATIONS));
        keywordMap.put("min", new Integer(SqlParserSymbols.KW_MIN));
        keywordMap.put("minus", new Integer(SqlParserSymbols.KW_MINUS));
        keywordMap.put("minute", new Integer(SqlParserSymbols.KW_MINUTE));
        keywordMap.put("modify", new Integer(SqlParserSymbols.KW_MODIFY));
        keywordMap.put("month", new Integer(SqlParserSymbols.KW_MONTH));
        keywordMap.put("name", new Integer(SqlParserSymbols.KW_NAME));
        keywordMap.put("names", new Integer(SqlParserSymbols.KW_NAMES));
        keywordMap.put("natural", new Integer(SqlParserSymbols.KW_NATURAL));
        keywordMap.put("negative", new Integer(SqlParserSymbols.KW_NEGATIVE));
        keywordMap.put("never", new Integer(SqlParserSymbols.KW_NEVER));
        keywordMap.put("next", new Integer(SqlParserSymbols.KW_NEXT));
        keywordMap.put("no", new Integer(SqlParserSymbols.KW_NO));
        keywordMap.put("not", new Integer(SqlParserSymbols.KW_NOT));
        keywordMap.put("null", new Integer(SqlParserSymbols.KW_NULL));
        keywordMap.put("nulls", new Integer(SqlParserSymbols.KW_NULLS));
        keywordMap.put("observer", new Integer(SqlParserSymbols.KW_OBSERVER));
        keywordMap.put("offset", new Integer(SqlParserSymbols.KW_OFFSET));
        keywordMap.put("on", new Integer(SqlParserSymbols.KW_ON));
        keywordMap.put("only", new Integer(SqlParserSymbols.KW_ONLY));
        keywordMap.put("open", new Integer(SqlParserSymbols.KW_OPEN));
        keywordMap.put("or", new Integer(SqlParserSymbols.KW_OR));
        keywordMap.put("order", new Integer(SqlParserSymbols.KW_ORDER));
        keywordMap.put("outer", new Integer(SqlParserSymbols.KW_OUTER));
        keywordMap.put("outfile", new Integer(SqlParserSymbols.KW_OUTFILE));
        keywordMap.put("over", new Integer(SqlParserSymbols.KW_OVER));
        keywordMap.put("parameter", new Integer(SqlParserSymbols.KW_PARAMETER));
        keywordMap.put("partition", new Integer(SqlParserSymbols.KW_PARTITION));
        keywordMap.put("partitions", new Integer(SqlParserSymbols.KW_PARTITIONS));
        keywordMap.put("password", new Integer(SqlParserSymbols.KW_PASSWORD));
        keywordMap.put("password_expire", new Integer(SqlParserSymbols.KW_PASSWORD_EXPIRE));
        keywordMap.put("password_history", new Integer(SqlParserSymbols.KW_PASSWORD_HISTORY));
        keywordMap.put("password_reuse", new Integer(SqlParserSymbols.KW_PASSWORD_REUSE));
        keywordMap.put("password_lock_time", new Integer(SqlParserSymbols.KW_PASSWORD_LOCK_TIME));
        keywordMap.put("path", new Integer(SqlParserSymbols.KW_PATH));
        keywordMap.put("pause", new Integer(SqlParserSymbols.KW_PAUSE));
        keywordMap.put("plugin", new Integer(SqlParserSymbols.KW_PLUGIN));
        keywordMap.put("plugins", new Integer(SqlParserSymbols.KW_PLUGINS));
        keywordMap.put("policy", new Integer(SqlParserSymbols.KW_POLICY));
        keywordMap.put("preceding", new Integer(SqlParserSymbols.KW_PRECEDING));
        keywordMap.put("percent", new Integer(SqlParserSymbols.KW_PERCENT));
        keywordMap.put("proc", new Integer(SqlParserSymbols.KW_PROC));
        keywordMap.put("procedure", new Integer(SqlParserSymbols.KW_PROCEDURE));
        keywordMap.put("processlist", new Integer(SqlParserSymbols.KW_PROCESSLIST));
        keywordMap.put("profile", new Integer(SqlParserSymbols.KW_PROFILE));
        keywordMap.put("properties", new Integer(SqlParserSymbols.KW_PROPERTIES));
        keywordMap.put("property", new Integer(SqlParserSymbols.KW_PROPERTY));
        keywordMap.put("quantile_state", new Integer(SqlParserSymbols.KW_QUANTILE_STATE));
        keywordMap.put("quantile_union", new Integer(SqlParserSymbols.KW_QUANTILE_UNION));
        keywordMap.put("query", new Integer(SqlParserSymbols.KW_QUERY));
        keywordMap.put("quota", new Integer(SqlParserSymbols.KW_QUOTA));
        keywordMap.put("random", new Integer(SqlParserSymbols.KW_RANDOM));
        keywordMap.put("range", new Integer(SqlParserSymbols.KW_RANGE));
        keywordMap.put("range", new Integer(SqlParserSymbols.KW_RANGE));
        keywordMap.put("read", new Integer(SqlParserSymbols.KW_READ));
        keywordMap.put("real", new Integer(SqlParserSymbols.KW_DOUBLE));
        keywordMap.put("rebalance", new Integer(SqlParserSymbols.KW_REBALANCE));
        keywordMap.put("recover", new Integer(SqlParserSymbols.KW_RECOVER));
        keywordMap.put("recycle", new Integer(SqlParserSymbols.KW_RECYCLE));
        keywordMap.put("refresh", new Integer(SqlParserSymbols.KW_REFRESH));
        keywordMap.put("regexp", new Integer(SqlParserSymbols.KW_REGEXP));
        keywordMap.put("release", new Integer(SqlParserSymbols.KW_RELEASE));
        keywordMap.put("rename", new Integer(SqlParserSymbols.KW_RENAME));
        keywordMap.put("repair", new Integer(SqlParserSymbols.KW_REPAIR));
        keywordMap.put("repeatable", new Integer(SqlParserSymbols.KW_REPEATABLE));
        keywordMap.put("replace", new Integer(SqlParserSymbols.KW_REPLACE));
        keywordMap.put("replace_if_not_null", new Integer(SqlParserSymbols.KW_REPLACE_IF_NOT_NULL));
        keywordMap.put("replica", new Integer(SqlParserSymbols.KW_REPLICA));
        keywordMap.put("repositories", new Integer(SqlParserSymbols.KW_REPOSITORIES));
        keywordMap.put("repository", new Integer(SqlParserSymbols.KW_REPOSITORY));
        keywordMap.put("resource", new Integer(SqlParserSymbols.KW_RESOURCE));
        keywordMap.put("resources", new Integer(SqlParserSymbols.KW_RESOURCES));
        keywordMap.put("restore", new Integer(SqlParserSymbols.KW_RESTORE));
        keywordMap.put("resume", new Integer(SqlParserSymbols.KW_RESUME));
        keywordMap.put("returns", new Integer(SqlParserSymbols.KW_RETURNS));
        keywordMap.put("revoke", new Integer(SqlParserSymbols.KW_REVOKE));
        keywordMap.put("right", new Integer(SqlParserSymbols.KW_RIGHT));
        keywordMap.put("rlike", new Integer(SqlParserSymbols.KW_REGEXP));
        keywordMap.put("role", new Integer(SqlParserSymbols.KW_ROLE));
        keywordMap.put("roles", new Integer(SqlParserSymbols.KW_ROLES));
        keywordMap.put("rollback", new Integer(SqlParserSymbols.KW_ROLLBACK));
        keywordMap.put("rollup", new Integer(SqlParserSymbols.KW_ROLLUP));
        keywordMap.put("routine", new Integer(SqlParserSymbols.KW_ROUTINE));
        keywordMap.put("row", new Integer(SqlParserSymbols.KW_ROW));
        keywordMap.put("rows", new Integer(SqlParserSymbols.KW_ROWS));
        keywordMap.put("s3", new Integer(SqlParserSymbols.KW_S3));
        keywordMap.put("schema", new Integer(SqlParserSymbols.KW_SCHEMA));
        keywordMap.put("schemas", new Integer(SqlParserSymbols.KW_SCHEMAS));
        keywordMap.put("second", new Integer(SqlParserSymbols.KW_SECOND));
        keywordMap.put("select", new Integer(SqlParserSymbols.KW_SELECT));
        keywordMap.put("semi", new Integer(SqlParserSymbols.KW_SEMI));
        keywordMap.put("serializable", new Integer(SqlParserSymbols.KW_SERIALIZABLE));
        keywordMap.put("session", new Integer(SqlParserSymbols.KW_SESSION));
        keywordMap.put("set", new Integer(SqlParserSymbols.KW_SET));
        keywordMap.put("sets", new Integer(SqlParserSymbols.KW_SETS));
        keywordMap.put("show", new Integer(SqlParserSymbols.KW_SHOW));
        keywordMap.put("signed", new Integer(SqlParserSymbols.KW_SIGNED));
        keywordMap.put("skew", new Integer(SqlParserSymbols.KW_SKEW));
        keywordMap.put("smallint", new Integer(SqlParserSymbols.KW_SMALLINT));
        keywordMap.put("snapshot", new Integer(SqlParserSymbols.KW_SNAPSHOT));
        keywordMap.put("soname", new Integer(SqlParserSymbols.KW_SONAME));
        keywordMap.put("split", new Integer(SqlParserSymbols.KW_SPLIT));
        keywordMap.put("sql_block_rule", new Integer(SqlParserSymbols.KW_SQL_BLOCK_RULE));
        keywordMap.put("start", new Integer(SqlParserSymbols.KW_START));
        keywordMap.put("stats", new Integer(SqlParserSymbols.KW_STATS));
        keywordMap.put("status", new Integer(SqlParserSymbols.KW_STATUS));
        keywordMap.put("stop", new Integer(SqlParserSymbols.KW_STOP));
        keywordMap.put("storage", new Integer(SqlParserSymbols.KW_STORAGE));
        keywordMap.put("stream", new Integer(SqlParserSymbols.KW_STREAM));
        keywordMap.put("string", new Integer(SqlParserSymbols.KW_STRING));
        keywordMap.put("struct", new Integer(SqlParserSymbols.KW_STRUCT));
        keywordMap.put("sum", new Integer(SqlParserSymbols.KW_SUM));
        keywordMap.put("superuser", new Integer(SqlParserSymbols.KW_SUPERUSER));
        keywordMap.put("switch", new Integer(SqlParserSymbols.KW_SWITCH));
        keywordMap.put("sync", new Integer(SqlParserSymbols.KW_SYNC));
        keywordMap.put("system", new Integer(SqlParserSymbols.KW_SYSTEM));
        keywordMap.put("table", new Integer(SqlParserSymbols.KW_TABLE));
        keywordMap.put("tables", new Integer(SqlParserSymbols.KW_TABLES));
        keywordMap.put("tablesample", new Integer(SqlParserSymbols.KW_TABLESAMPLE));
        keywordMap.put("tablet", new Integer(SqlParserSymbols.KW_TABLET));
        keywordMap.put("tablets", new Integer(SqlParserSymbols.KW_TABLETS));
        keywordMap.put("task", new Integer(SqlParserSymbols.KW_TASK));
        keywordMap.put("temporary", new Integer(SqlParserSymbols.KW_TEMPORARY));
        keywordMap.put("terminated", new Integer(SqlParserSymbols.KW_TERMINATED));
        keywordMap.put("text", new Integer(SqlParserSymbols.KW_TEXT));
        keywordMap.put("than", new Integer(SqlParserSymbols.KW_THAN));
        keywordMap.put("then", new Integer(SqlParserSymbols.KW_THEN));
        keywordMap.put("time", new Integer(SqlParserSymbols.KW_TIME));
        keywordMap.put("timestamp", new Integer(SqlParserSymbols.KW_TIMESTAMP));
        keywordMap.put("tinyint", new Integer(SqlParserSymbols.KW_TINYINT));
        keywordMap.put("to", new Integer(SqlParserSymbols.KW_TO));
        keywordMap.put("transaction", new Integer(SqlParserSymbols.KW_TRANSACTION));
        keywordMap.put("trash", new Integer(SqlParserSymbols.KW_TRASH));
        keywordMap.put("triggers", new Integer(SqlParserSymbols.KW_TRIGGERS));
        keywordMap.put("trim", new Integer(SqlParserSymbols.KW_TRIM));
        keywordMap.put("true", new Integer(SqlParserSymbols.KW_TRUE));
        keywordMap.put("truncate", new Integer(SqlParserSymbols.KW_TRUNCATE));
        keywordMap.put("type", new Integer(SqlParserSymbols.KW_TYPE));
        keywordMap.put("types", new Integer(SqlParserSymbols.KW_TYPES));
        keywordMap.put("unbounded", new Integer(SqlParserSymbols.KW_UNBOUNDED));
        keywordMap.put("uncommitted", new Integer(SqlParserSymbols.KW_UNCOMMITTED));
        keywordMap.put("uninstall", new Integer(SqlParserSymbols.KW_UNINSTALL));
        keywordMap.put("union", new Integer(SqlParserSymbols.KW_UNION));
        keywordMap.put("unique", new Integer(SqlParserSymbols.KW_UNIQUE));
        keywordMap.put("unlock", new Integer(SqlParserSymbols.KW_UNLOCK));
        keywordMap.put("unsigned", new Integer(SqlParserSymbols.KW_UNSIGNED));
        keywordMap.put("update", new Integer(SqlParserSymbols.KW_UPDATE));
        keywordMap.put("use", new Integer(SqlParserSymbols.KW_USE));
        keywordMap.put("user", new Integer(SqlParserSymbols.KW_USER));
        keywordMap.put("using", new Integer(SqlParserSymbols.KW_USING));
        keywordMap.put("value", new Integer(SqlParserSymbols.KW_VALUE));
        keywordMap.put("values", new Integer(SqlParserSymbols.KW_VALUES));
        keywordMap.put("varchar", new Integer(SqlParserSymbols.KW_VARCHAR));
        keywordMap.put("variables", new Integer(SqlParserSymbols.KW_VARIABLES));
        keywordMap.put("verbose", new Integer(SqlParserSymbols.KW_VERBOSE));
        keywordMap.put("view", new Integer(SqlParserSymbols.KW_VIEW));
        keywordMap.put("warnings", new Integer(SqlParserSymbols.KW_WARNINGS));
        keywordMap.put("week", new Integer(SqlParserSymbols.KW_WEEK));
        keywordMap.put("when", new Integer(SqlParserSymbols.KW_WHEN));
        keywordMap.put("where", new Integer(SqlParserSymbols.KW_WHERE));
        keywordMap.put("whitelist", new Integer(SqlParserSymbols.KW_WHITELIST));
        keywordMap.put("whitelist", new Integer(SqlParserSymbols.KW_WHITELIST));
        keywordMap.put("with", new Integer(SqlParserSymbols.KW_WITH));
        keywordMap.put("work", new Integer(SqlParserSymbols.KW_WORK));
        keywordMap.put("write", new Integer(SqlParserSymbols.KW_WRITE));
        keywordMap.put("year", new Integer(SqlParserSymbols.KW_YEAR));
        keywordMap.put("mtmv", new Integer(SqlParserSymbols.KW_MTMV));
   }
    
  // map from token id to token description
  public static final Map<Integer, String> tokenIdMap =
      new HashMap<Integer, String>();
  static {
    Iterator<Map.Entry<String, Integer>> it = keywordMap.entrySet().iterator();
    while (it.hasNext()) {
      Map.Entry<String, Integer> pairs = (Map.Entry<String, Integer>) it.next();
      tokenIdMap.put(pairs.getValue(), pairs.getKey().toUpperCase());
    }

    // add non-keyword tokens
    tokenIdMap.put(new Integer(SqlParserSymbols.IDENT), "IDENTIFIER");
    tokenIdMap.put(new Integer(SqlParserSymbols.COMMA), "COMMA");
    tokenIdMap.put(new Integer(SqlParserSymbols.BITNOT), "~");
    tokenIdMap.put(new Integer(SqlParserSymbols.LPAREN), "(");
    tokenIdMap.put(new Integer(SqlParserSymbols.RPAREN), ")");
    tokenIdMap.put(new Integer(SqlParserSymbols.LBRACKET), "[");
    tokenIdMap.put(new Integer(SqlParserSymbols.RBRACKET), "]");
    tokenIdMap.put(new Integer(SqlParserSymbols.COLON), ":");
    tokenIdMap.put(new Integer(SqlParserSymbols.SEMICOLON), ";");
    tokenIdMap.put(new Integer(SqlParserSymbols.FLOATINGPOINT_LITERAL),
        "FLOATING POINT LITERAL");
    tokenIdMap.put(new Integer(SqlParserSymbols.INTEGER_LITERAL), "INTEGER LITERAL");
    tokenIdMap.put(new Integer(SqlParserSymbols.LARGE_INTEGER_LITERAL), "INTEGER LITERAL");
    tokenIdMap.put(new Integer(SqlParserSymbols.DECIMAL_LITERAL), "DECIMAL LITERAL");
    tokenIdMap.put(new Integer(SqlParserSymbols.NOT), "!");
    tokenIdMap.put(new Integer(SqlParserSymbols.LESSTHAN), "<");
    tokenIdMap.put(new Integer(SqlParserSymbols.GREATERTHAN), ">");
    tokenIdMap.put(new Integer(SqlParserSymbols.UNMATCHED_STRING_LITERAL),
        "UNMATCHED STRING LITERAL");
    tokenIdMap.put(new Integer(SqlParserSymbols.MOD), "%");
    tokenIdMap.put(new Integer(SqlParserSymbols.ADD), "+");
    tokenIdMap.put(new Integer(SqlParserSymbols.DIVIDE), "/");
    tokenIdMap.put(new Integer(SqlParserSymbols.EQUAL), "=");
    tokenIdMap.put(new Integer(SqlParserSymbols.STAR), "*");
    tokenIdMap.put(new Integer(SqlParserSymbols.AT), "@");
    tokenIdMap.put(new Integer(SqlParserSymbols.BITOR), "|");
    tokenIdMap.put(new Integer(SqlParserSymbols.DOTDOTDOT), "...");
    tokenIdMap.put(new Integer(SqlParserSymbols.DOT), ".");
    tokenIdMap.put(new Integer(SqlParserSymbols.STRING_LITERAL), "STRING LITERAL");
    tokenIdMap.put(new Integer(SqlParserSymbols.EOF), "EOF");
    tokenIdMap.put(new Integer(SqlParserSymbols.SUBTRACT), "-");
    tokenIdMap.put(new Integer(SqlParserSymbols.BITAND), "&");
    tokenIdMap.put(new Integer(SqlParserSymbols.error), "ERROR");
    tokenIdMap.put(new Integer(SqlParserSymbols.BITXOR), "^");
    tokenIdMap.put(new Integer(SqlParserSymbols.NUMERIC_OVERFLOW), "NUMERIC OVERFLOW");
  }

  public static boolean isKeyword(Integer tokenId) {
    String token = tokenIdMap.get(tokenId);
    return keywordMap.containsKey(token);
    /* return keywordMap.containsKey(token.toLowerCase()); */
  }

  public static boolean isKeyword(String str) {
	    return keywordMap.containsKey(str.toLowerCase());
  }

  private Symbol newToken(int id, Object value) {
    return new Symbol(id, yyline+1, yycolumn+1, value);
  }

  private static String escapeBackSlash(String str) {
      StringWriter writer = new StringWriter();
      int strLen = str.length();
      for (int i = 0; i < strLen; ++i) {
          char c = str.charAt(i);
          if (c == '\\' && (i + 1) < strLen) {
              switch (str.charAt(i + 1)) {
              case 'n':
                  writer.append('\n');
                  break;
              case 't':
                  writer.append('\t');
                  break;
              case 'r':
                  writer.append('\r');
                  break;
              case 'b':
                  writer.append('\b');
                  break;
              case '0':
                  writer.append('\0'); // Ascii null
                  break;
              case 'Z': // ^Z must be escaped on Win32
                  writer.append('\032');
                  break;
              case '_':
              case '%':
                  writer.append('\\'); // remember prefix for wildcard
                  /* Fall through */
              default:
                  writer.append(str.charAt(i + 1));
                  break;
              }
              i++;
          } else {
              writer.append(c);
          }
      }

      return writer.toString();
  }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public SqlScanner(java.io.Reader in, Long sql_mode) {
      this.sql_mode = sql_mode;
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public SqlScanner(java.io.InputStream in, Long sql_mode) {
    this(new java.io.InputStreamReader(in), sql_mode);
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2218) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 1: 
          { /* ignore */
          }
        case 37: break;
        case 27: 
          { yybegin(YYINITIAL);
  return newToken(SqlParserSymbols.COMMENTED_PLAN_HINT_END, null);
          }
        case 38: break;
        case 7: 
          { return newToken(SqlParserSymbols.DOT, null);
          }
        case 39: break;
        case 9: 
          { return newToken(SqlParserSymbols.SUBTRACT, null);
          }
        case 40: break;
        case 33: 
          { return newToken(SqlParserSymbols.SET_VAR, null);
          }
        case 41: break;
        case 10: 
          { return newToken(SqlParserSymbols.DIVIDE, null);
          }
        case 42: break;
        case 11: 
          { return newToken(SqlParserSymbols.STAR, null);
          }
        case 43: break;
        case 12: 
          { return newToken(SqlParserSymbols.COMMA, null);
          }
        case 44: break;
        case 13: 
          { return newToken(SqlParserSymbols.AT, null);
          }
        case 45: break;
        case 20: 
          { return newToken(SqlParserSymbols.MOD, null);
          }
        case 46: break;
        case 36: 
          { return newToken(SqlParserSymbols.COMMENTED_PLAN_HINT_START, null);
          }
        case 47: break;
        case 6: 
          { return newToken(SqlParserSymbols.UNMATCHED_STRING_LITERAL, null);
          }
        case 48: break;
        case 23: 
          { return newToken(SqlParserSymbols.EQUAL, null);
          }
        case 49: break;
        case 22: 
          { return newToken(SqlParserSymbols.BITNOT, null);
          }
        case 50: break;
        case 35: 
          { yybegin(EOLHINT);
  return newToken(SqlParserSymbols.COMMENTED_PLAN_HINT_START, null);
          }
        case 51: break;
        case 25: 
          { return newToken(SqlParserSymbols.LESSTHAN, null);
          }
        case 52: break;
        case 24: 
          { return newToken(SqlParserSymbols.NOT, null);
          }
        case 53: break;
        case 14: 
          { return newToken(SqlParserSymbols.LPAREN, null);
          }
        case 54: break;
        case 19: 
          { return newToken(SqlParserSymbols.RBRACKET, null);
          }
        case 55: break;
        case 34: 
          { return newToken(SqlParserSymbols.DOTDOTDOT, null);
          }
        case 56: break;
        case 26: 
          { return newToken(SqlParserSymbols.GREATERTHAN, null);
          }
        case 57: break;
        case 8: 
          { return newToken(SqlParserSymbols.ADD, null);
          }
        case 58: break;
        case 16: 
          { return newToken(SqlParserSymbols.COLON, null);
          }
        case 59: break;
        case 29: 
          { return newToken(SqlParserSymbols.STRING_LITERAL,
      escapeBackSlash(yytext().substring(1, yytext().length()-1)).replaceAll("''", "'"));
          }
        case 60: break;
        case 4: 
          { return newToken(SqlParserSymbols.BITAND, null);
          }
        case 61: break;
        case 31: 
          { BigDecimal decimal_val;
  try {
    decimal_val = new BigDecimal(yytext());
  } catch (NumberFormatException e) {
    return newToken(SqlParserSymbols.NUMERIC_OVERFLOW, yytext());
  }

  return newToken(SqlParserSymbols.DECIMAL_LITERAL, decimal_val);
          }
        case 62: break;
        case 18: 
          { return newToken(SqlParserSymbols.LBRACKET, null);
          }
        case 63: break;
        case 2: 
          { BigInteger val = null;
    try {
        val = new BigInteger(yytext());
    } catch (NumberFormatException e) {
        return newToken(SqlParserSymbols.NUMERIC_OVERFLOW, yytext());
    }

    // Note: val is positive, because we do not recognize minus charactor in 'IntegerLiteral'
    // -2^63 will be recognize as largeint(__int128)
    if (val.compareTo(LONG_MAX) <= 0) {
        return newToken(SqlParserSymbols.INTEGER_LITERAL, val.longValue());
    }
    if (val.compareTo(LARGEINT_MAX_ABS) <= 0) {
        return newToken(SqlParserSymbols.LARGE_INTEGER_LITERAL, val.toString());
    }
    return newToken(SqlParserSymbols.NUMERIC_OVERFLOW, yytext());
          }
        case 64: break;
        case 32: 
          { return newToken(SqlParserSymbols.COMMENTED_PLAN_HINT_END, null);
          }
        case 65: break;
        case 28: 
          { // Remove the quotes
    String trimmedIdent = yytext().substring(1, yytext().length() - 1);
    return newToken(SqlParserSymbols.IDENT, SqlUtils.escapeUnquote(trimmedIdent));
          }
        case 66: break;
        case 15: 
          { return newToken(SqlParserSymbols.RPAREN, null);
          }
        case 67: break;
        case 5: 
          { return newToken(SqlParserSymbols.BITOR, null);
          }
        case 68: break;
        case 21: 
          { return newToken(SqlParserSymbols.BITXOR, null);
          }
        case 69: break;
        case 30: 
          { return newToken(SqlParserSymbols.STRING_LITERAL,
      escapeBackSlash(yytext().substring(1, yytext().length()-1)).replaceAll("\"\"", "\""));
          }
        case 70: break;
        case 17: 
          { return newToken(SqlParserSymbols.SEMICOLON, null);
          }
        case 71: break;
        case 3: 
          { String text = yytext();
  Integer kw_id = keywordMap.get(text.toLowerCase());
  /* Integer kw_id = keywordMap.get(text); */
  if (kw_id != null) {
    // if MODE_PIPES_AS_CONCAT is not active, treat '||' symbol as same as 'or' symbol
    if ((kw_id == SqlParserSymbols.KW_PIPE) &&
      ((this.sql_mode & SqlModeHelper.MODE_PIPES_AS_CONCAT) == 0)) {
      return newToken(SqlParserSymbols.KW_OR, text);
    }
    return newToken(kw_id.intValue(), text);
  } else {
    return newToken(SqlParserSymbols.IDENT, text);
  }
          }
        case 72: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {     return newToken(SqlParserSymbols.EOF, null);
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
