/*
 * Copyright (c) 1998, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.javadoc.internal.doclets.formats.html;

import org.checkerframework.dataflow.qual.Pure;
import jdk.javadoc.internal.doclets.formats.html.markup.Head;
import jdk.javadoc.internal.doclets.formats.html.markup.TableHeader;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor9;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.lang.model.util.SimpleTypeVisitor9;
import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AttributeTree.ValueKind;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTree.Kind;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.IndexTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.SummaryTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.util.SimpleDocTreeVisitor;
import jdk.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import jdk.javadoc.internal.doclets.formats.html.markup.DocType;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlDocument;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.Links;
import jdk.javadoc.internal.doclets.formats.html.markup.RawHtml;
import jdk.javadoc.internal.doclets.formats.html.markup.Script;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.AnnotationTypeWriter;
import jdk.javadoc.internal.doclets.toolkit.ClassWriter;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.Messages;
import jdk.javadoc.internal.doclets.toolkit.PackageSummaryWriter;
import jdk.javadoc.internal.doclets.toolkit.Resources;
import jdk.javadoc.internal.doclets.toolkit.taglets.DocRootTaglet;
import jdk.javadoc.internal.doclets.toolkit.taglets.TagletWriter;
import jdk.javadoc.internal.doclets.toolkit.util.CommentHelper;
import jdk.javadoc.internal.doclets.toolkit.util.DocFile;
import jdk.javadoc.internal.doclets.toolkit.util.DocFileIOException;
import jdk.javadoc.internal.doclets.toolkit.util.DocLink;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletConstants;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberTable;
import static com.sun.source.doctree.DocTree.Kind.*;
import static jdk.javadoc.internal.doclets.toolkit.util.CommentHelper.SPACER;

public class HtmlDocletWriter {

    public final DocPath pathToRoot;

    public final DocPath path;

    public final DocPath filename;

    public final HtmlConfiguration configuration;

    protected final Utils utils;

    protected final Contents contents;

    protected final Messages messages;

    protected final Resources resources;

    protected final Links links;

    protected final DocPaths docPaths;

    protected boolean printedAnnotationHeading;

    protected boolean printedAnnotationFieldHeading;

    protected String winTitle;

    protected Script mainBodyScript;

    public HtmlDocletWriter(HtmlConfiguration configuration, DocPath path) {
    }

    public String replaceDocRootDir(String htmlstr);

    public Content getAllClassesLinkScript(String id);

    protected void addTagsInfo(Element e, Content htmltree);

    protected boolean hasSerializationOverviewTags(VariableElement field);

    public TagletWriter getTagletWriterInstance(boolean isFirstSentence);

    public Content getTargetPackageLink(PackageElement pkg, String target, Content label);

    public Content getTargetModulePackageLink(PackageElement pkg, String target, Content label, ModuleElement mdle);

    public Content getTargetModuleLink(String target, Content label, ModuleElement mdle);

    public void printHtmlDocument(List<String> metakeywords, boolean includeScript, Content body) throws DocFileIOException;

    public String getWindowTitle(String title);

    public Content getUserHeaderFooter(boolean header);

    public void addTop(Content htmlTree);

    public void addBottom(Content htmlTree);

    protected Content getNavLinkMainTree(String label);

    public Content getTableCaption(Content title);

    public Content getPackageName(PackageElement packageElement);

    public Content getPackageLabel(CharSequence packageName);

    protected DocPath pathString(TypeElement te, DocPath name);

    protected DocPath pathString(PackageElement packageElement, DocPath name);

    public String getPackageAnchorName(PackageElement packageElement);

    public Content getPackageLink(PackageElement packageElement, CharSequence label);

    public Content getPackageLink(PackageElement packageElement);

    public Content getPackageLink(PackageElement packageElement, Content label);

    public Content getModuleLink(ModuleElement mdle, Content label);

    public Content interfaceName(TypeElement typeElement, boolean qual);

    public void addSrcLink(Element element, Content label, Content htmltree);

    public Content getLink(LinkInfoImpl linkInfo);

    public Content getTypeParameterLinks(LinkInfoImpl linkInfo);

    public Content getCrossClassLink(String qualifiedClassName, String refMemName, Content label, boolean strong, boolean code);

    @Pure
    public boolean isClassLinkable(TypeElement typeElement);

    public DocLink getCrossPackageLink(String pkgName);

    public DocLink getCrossModuleLink(String mdleName);

    public Content getQualifiedClassLink(LinkInfoImpl.Kind context, Element element);

    public void addPreQualifiedClassLink(LinkInfoImpl.Kind context, TypeElement typeElement, Content contentTree);

    public Content getPreQualifiedClassLink(LinkInfoImpl.Kind context, TypeElement typeElement, boolean isStrong);

    public void addPreQualifiedClassLink(LinkInfoImpl.Kind context, TypeElement typeElement, boolean isStrong, Content contentTree);

    public String getEnclosingPackageName(TypeElement te);

    public void addPreQualifiedStrongClassLink(LinkInfoImpl.Kind context, TypeElement typeElement, Content contentTree);

    public Content getDocLink(LinkInfoImpl.Kind context, Element element, CharSequence label);

    public Content getDocLink(LinkInfoImpl.Kind context, Element element, CharSequence label, boolean strong);

    public Content getDocLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element element, CharSequence label, boolean strong);

    public Content getDocLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element element, Content label, boolean strong);

    public Content getDocLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element element, CharSequence label, boolean strong, boolean isProperty);

    public Content getDocLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element element, Content label, boolean strong, boolean isProperty);

    public Content getDocLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element element, Content label);

    public String getAnchor(ExecutableElement executableElement);

    public String getAnchor(ExecutableElement executableElement, boolean isProperty);

    public String anchorName(Element member);

    public Content seeTagToContent(Element element, DocTree see);

    public void addInlineComment(Element element, DocTree tag, Content htmltree);

    public Content getDeprecatedPhrase(Element e);

    public void addInlineDeprecatedComment(Element e, DocTree tag, Content htmltree);

    public void addSummaryComment(Element element, Content htmltree);

    public void addSummaryComment(Element element, List<? extends DocTree> firstSentenceTags, Content htmltree);

    public void addSummaryDeprecatedComment(Element element, DocTree tag, Content htmltree);

    public void addInlineComment(Element element, Content htmltree);

    boolean ignoreNonInlineTag(DocTree dtree);

    boolean isAllWhiteSpace(String body);

    public Content commentTagsToContent(DocTree holderTag, Element element, List<? extends DocTree> tags, boolean isFirstSentence);

    @Pure
    public boolean isCoreClass(TypeElement typeElement);

    public void addAnnotationInfo(PackageElement packageElement, Content htmltree);

    public void addReceiverAnnotationInfo(ExecutableElement method, List<AnnotationMirror> descList, Content htmltree);

    public void addReceiverAnnotationInfo(ExecutableElement method, TypeMirror rcvrTypeMirror, List<? extends AnnotationMirror> annotationMirrors, Content htmltree);

    public void addAnnotationInfo(Element element, Content htmltree);

    public boolean addAnnotationInfo(int indent, Element element, VariableElement param, Content tree);

    public List<Content> getAnnotations(int indent, List<? extends AnnotationMirror> descList, boolean linkBreak, boolean isJava5DeclarationLocation);

    protected TableHeader getPackageTableHeader();

    protected Script getWinTitleScript();

    public HtmlTree getBody(boolean includeScript, String title);

    Script getMainBodyScript();
}
