/*
 * Copyright (c) 1997, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.tools.javadoc.main;

import org.checkerframework.dataflow.qual.Pure;
import com.sun.javadoc.*;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symbol.ClassSymbol;
import com.sun.tools.javac.code.Symbol.CompletionFailure;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Type.ArrayType;
import com.sun.tools.javac.code.Type.ClassType;
import com.sun.tools.javac.code.Type.TypeVar;
import com.sun.tools.javac.util.List;
import static com.sun.tools.javac.code.TypeTag.ARRAY;

@Deprecated()
@SuppressWarnings("removal")
public class TypeMaker {

    public static com.sun.javadoc.Type getType(DocEnv env, Type t);

    public static com.sun.javadoc.Type getType(DocEnv env, Type t, boolean errorToClassDoc);

    public static com.sun.javadoc.Type getType(DocEnv env, Type t, boolean errToClassDoc, boolean considerAnnotations);

    public static com.sun.javadoc.Type[] getTypes(DocEnv env, List<Type> ts);

    public static com.sun.javadoc.Type[] getTypes(DocEnv env, List<Type> ts, com.sun.javadoc.Type[] res);

    public static String getTypeName(Type t, boolean full);

    static String getTypeString(DocEnv env, Type t, boolean full);

    static String typeParametersString(DocEnv env, Symbol sym, boolean full);

    static String typeArgumentsString(DocEnv env, ClassType cl, boolean full);

    private static class ArrayTypeImpl implements com.sun.javadoc.Type {

        public com.sun.javadoc.Type getElementType();

        public String dimension();

        public String typeName();

        public String qualifiedTypeName();

        public String simpleTypeName();

        public ClassDoc asClassDoc();

        public ParameterizedType asParameterizedType();

        public TypeVariable asTypeVariable();

        public WildcardType asWildcardType();

        public AnnotatedType asAnnotatedType();

        public AnnotationTypeDoc asAnnotationTypeDoc();

        @Pure
        public boolean isPrimitive();

        @Override
        public String toString();
    }
}
