/*
 * reserved comment block
 * DO NOT REMOVE OR ALTER!
 */
package org.jcp.xml.dsig.internal.dom;

import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import java.security.Key;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.w3c.dom.Element;

abstract class AbstractDOMSignatureMethod extends BaseStructure implements SignatureMethod {

    abstract boolean verify(Key key, DOMSignedInfo si, byte[] sig, XMLValidateContext context) throws InvalidKeyException, SignatureException, XMLSignatureException;

    abstract byte[] sign(Key key, DOMSignedInfo si, XMLSignContext context) throws InvalidKeyException, XMLSignatureException;

    abstract String getJCAAlgorithm();

    abstract Type getAlgorithmType();

    public void marshal(XmlWriter xwriter, String dsPrefix) throws MarshalException;

    void marshalParams(XmlWriter xwriter, String paramsPrefix) throws MarshalException;

    SignatureMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException;

    void checkParams(SignatureMethodParameterSpec params) throws InvalidAlgorithmParameterException;

    @Override
    @Pure
    @EnsuresNonNullIf(expression = "#1", result = true)
    public boolean equals(@Nullable Object o);

    @Override
    public int hashCode();

    boolean paramsEqual(AlgorithmParameterSpec spec);
}
