/*
 * Copyright (c) 1996, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.sql;

import org.checkerframework.checker.interning.qual.UsesObjectEquals;
import org.checkerframework.framework.qual.AnnotatedFor;

@AnnotatedFor({ "interning" })
@UsesObjectEquals
public class Types {

    public final static int BIT;

    public final static int TINYINT;

    public final static int SMALLINT;

    public final static int INTEGER;

    public final static int BIGINT;

    public final static int FLOAT;

    public final static int REAL;

    public final static int DOUBLE;

    public final static int NUMERIC;

    public final static int DECIMAL;

    public final static int CHAR;

    public final static int VARCHAR;

    public final static int LONGVARCHAR;

    public final static int DATE;

    public final static int TIME;

    public final static int TIMESTAMP;

    public final static int BINARY;

    public final static int VARBINARY;

    public final static int LONGVARBINARY;

    public final static int NULL;

    public final static int OTHER;

    public final static int JAVA_OBJECT;

    public final static int DISTINCT;

    public final static int STRUCT;

    public final static int ARRAY;

    public final static int BLOB;

    public final static int CLOB;

    public final static int REF;

    public final static int DATALINK;

    public final static int BOOLEAN;

    public final static int ROWID;

    public static final int NCHAR;

    public static final int NVARCHAR;

    public static final int LONGNVARCHAR;

    public static final int NCLOB;

    public static final int SQLXML;

    public static final int REF_CURSOR;

    public static final int TIME_WITH_TIMEZONE;

    public static final int TIMESTAMP_WITH_TIMEZONE;
}
