// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.load.sync;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncDataConsumer extends SyncLifeCycle {
    private static Logger logger = LogManager.getLogger(SyncDataConsumer.class);

    protected boolean debug;

    public SyncDataConsumer(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void start() {
        super.start();
        logger.info("executor has been started. debug: {}", debug);
    }

    public void beginForTxn() {
    }

    public void abortForTxn(String reason) {
    }

    public void commitForTxn() {
    }

    @Override
    public void process() {
    }
}