---
{
    "title": "bitmap_has_all",
    "language": "en"
}
---

<!-- 
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# bitmap_has_all
## description
### Syntax

`B00LEAN BITMAP_HAS_ALL(BITMAP lhs, BITMAP rhs)`

Returns true if the first bitmap contains all the elements of the second bitmap.
Returns true if the second bitmap contains an empty element.

## example

```
mysql> select bitmap_has_all(bitmap_from_string("0, 1, 2"), bitmap_from_string("1, 2")) cnt;
+------+
| cnt  |
+------+
|    1 |
+------+

mysql> select bitmap_has_all(bitmap_empty(), bitmap_from_string("1, 2")) cnt;
+------+
| cnt  |
+------+
|    0 |
+------+
```

## keyword

    BITMAP_HAS_ALL,BITMAP
