// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.catalog;

/**
 * Define different auth type for external table such as hive/iceberg,
 * so that BE could call secured under fileStorageSystem (enable kerberos)
 */
public enum AuthType {
    SIMPLE(0, "simple"),
    KERBEROS(1, "kerberos");

    private int code;
    private String desc;

    AuthType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isSupportedAuthType(String authType) {
        for (AuthType auth : values()) {
            if (auth.getDesc().equals(authType)) {
                return true;
            }
        }
        return false;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
