/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.broker.hdfs;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.doris.broker.hdfs.BrokerConfig;
import org.apache.doris.broker.hdfs.BrokerException;
import org.apache.doris.broker.hdfs.BrokerFileSystem;
import org.apache.doris.thrift.TBrokerFD;
import org.apache.doris.thrift.TBrokerOperationStatusCode;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.log4j.Logger;

public class ClientContextManager {
    private static Logger logger = Logger.getLogger((String)ClientContextManager.class.getName());
    private ScheduledExecutorService executorService;
    private ConcurrentHashMap<String, ClientResourceContext> clientContexts;
    private ConcurrentHashMap<TBrokerFD, String> fdToClientMap;
    private int clientExpirationSeconds = BrokerConfig.client_expire_seconds;

    public ClientContextManager(ScheduledExecutorService executorService) {
        this.clientContexts = new ConcurrentHashMap();
        this.fdToClientMap = new ConcurrentHashMap();
        this.executorService = executorService;
        this.executorService.schedule(new CheckClientExpirationTask(), 0L, TimeUnit.SECONDS);
    }

    public void onPing(String clientId) {
        if (!this.clientContexts.containsKey(clientId)) {
            this.clientContexts.putIfAbsent(clientId, new ClientResourceContext(clientId));
        }
        ClientResourceContext clientContext = this.clientContexts.get(clientId);
        clientContext.updateLastPingTime();
    }

    public synchronized void putNewOutputStream(String clientId, TBrokerFD fd, FSDataOutputStream fsDataOutputStream, BrokerFileSystem brokerFileSystem) {
        if (!this.clientContexts.containsKey(clientId)) {
            this.clientContexts.putIfAbsent(clientId, new ClientResourceContext(clientId));
        }
        ClientResourceContext clientContext = this.clientContexts.get(clientId);
        clientContext.putOutputStream(fd, fsDataOutputStream, brokerFileSystem);
        this.fdToClientMap.putIfAbsent(fd, clientId);
    }

    public synchronized void putNewInputStream(String clientId, TBrokerFD fd, FSDataInputStream fsDataInputStream, BrokerFileSystem brokerFileSystem) {
        if (!this.clientContexts.containsKey(clientId)) {
            this.clientContexts.putIfAbsent(clientId, new ClientResourceContext(clientId));
        }
        ClientResourceContext clientContext = this.clientContexts.get(clientId);
        clientContext.putInputStream(fd, fsDataInputStream, brokerFileSystem);
        this.fdToClientMap.putIfAbsent(fd, clientId);
    }

    public synchronized FSDataInputStream getFsDataInputStream(TBrokerFD fd) {
        String clientId = this.fdToClientMap.get(fd);
        if (clientId == null) {
            throw new BrokerException(TBrokerOperationStatusCode.TARGET_STORAGE_SERVICE_ERROR, "the fd is not owned by client {}", clientId);
        }
        ClientResourceContext clientContext = this.clientContexts.get(clientId);
        FSDataInputStream fsDataInputStream = clientContext.getInputStream(fd);
        return fsDataInputStream;
    }

    public synchronized FSDataOutputStream getFsDataOutputStream(TBrokerFD fd) {
        String clientId = this.fdToClientMap.get(fd);
        if (clientId == null) {
            throw new BrokerException(TBrokerOperationStatusCode.TARGET_STORAGE_SERVICE_ERROR, "the fd is not owned by client {}", clientId);
        }
        ClientResourceContext clientContext = this.clientContexts.get(clientId);
        FSDataOutputStream fsDataOutputStream = clientContext.getOutputStream(fd);
        return fsDataOutputStream;
    }

    public synchronized void removeInputStream(TBrokerFD fd) {
        String clientId = this.fdToClientMap.remove(fd);
        if (clientId == null) {
            return;
        }
        ClientResourceContext clientContext = this.clientContexts.get(clientId);
        BrokerInputStream brokerInputStream = (BrokerInputStream)clientContext.inputStreams.remove(fd);
        try {
            if (brokerInputStream != null) {
                brokerInputStream.inputStream.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"errors while close file data input stream", (Throwable)e);
        }
    }

    public synchronized void removeOutputStream(TBrokerFD fd) {
        String clientId = this.fdToClientMap.remove(fd);
        if (clientId == null) {
            return;
        }
        ClientResourceContext clientContext = this.clientContexts.get(clientId);
        BrokerOutputStream brokerOutputStream = (BrokerOutputStream)clientContext.outputStreams.remove(fd);
        try {
            if (brokerOutputStream != null) {
                brokerOutputStream.outputStream.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"errors while close file data output stream", (Throwable)e);
        }
    }

    static class ClientResourceContext {
        private String clientId;
        private ConcurrentHashMap<TBrokerFD, BrokerInputStream> inputStreams;
        private ConcurrentHashMap<TBrokerFD, BrokerOutputStream> outputStreams;
        private long lastPingTimestamp;

        public ClientResourceContext(String clientId) {
            this.clientId = clientId;
            this.inputStreams = new ConcurrentHashMap();
            this.outputStreams = new ConcurrentHashMap();
            this.lastPingTimestamp = System.currentTimeMillis();
        }

        public void putInputStream(TBrokerFD fd, FSDataInputStream inputStream, BrokerFileSystem fileSystem) {
            this.inputStreams.putIfAbsent(fd, new BrokerInputStream(inputStream, fileSystem));
        }

        public void putOutputStream(TBrokerFD fd, FSDataOutputStream outputStream, BrokerFileSystem fileSystem) {
            this.outputStreams.putIfAbsent(fd, new BrokerOutputStream(outputStream, fileSystem));
        }

        public FSDataInputStream getInputStream(TBrokerFD fd) {
            BrokerInputStream brokerInputStream = this.inputStreams.get(fd);
            if (brokerInputStream != null) {
                return brokerInputStream.getInputStream();
            }
            return null;
        }

        public FSDataOutputStream getOutputStream(TBrokerFD fd) {
            BrokerOutputStream brokerOutputStream = this.outputStreams.get(fd);
            if (brokerOutputStream != null) {
                return brokerOutputStream.getOutputStream();
            }
            return null;
        }

        public void updateLastPingTime() {
            this.lastPingTimestamp = System.currentTimeMillis();
            for (BrokerInputStream brokerInputStream : this.inputStreams.values()) {
                brokerInputStream.updateLastUpdateAccessTime();
            }
            for (BrokerOutputStream brokerOutputStream : this.outputStreams.values()) {
                brokerOutputStream.updateLastUpdateAccessTime();
            }
        }
    }

    private static class BrokerInputStream {
        private final FSDataInputStream inputStream;
        private final BrokerFileSystem brokerFileSystem;

        public BrokerInputStream(FSDataInputStream inputStream, BrokerFileSystem brokerFileSystem) {
            this.inputStream = inputStream;
            this.brokerFileSystem = brokerFileSystem;
            this.brokerFileSystem.updateLastUpdateAccessTime();
        }

        public FSDataInputStream getInputStream() {
            this.brokerFileSystem.updateLastUpdateAccessTime();
            return this.inputStream;
        }

        public void updateLastUpdateAccessTime() {
            this.brokerFileSystem.updateLastUpdateAccessTime();
        }
    }

    private static class BrokerOutputStream {
        private final FSDataOutputStream outputStream;
        private final BrokerFileSystem brokerFileSystem;

        public BrokerOutputStream(FSDataOutputStream outputStream, BrokerFileSystem brokerFileSystem) {
            this.outputStream = outputStream;
            this.brokerFileSystem = brokerFileSystem;
            this.brokerFileSystem.updateLastUpdateAccessTime();
        }

        public FSDataOutputStream getOutputStream() {
            this.brokerFileSystem.updateLastUpdateAccessTime();
            return this.outputStream;
        }

        public void updateLastUpdateAccessTime() {
            this.brokerFileSystem.updateLastUpdateAccessTime();
        }
    }

    class CheckClientExpirationTask
    implements Runnable {
        CheckClientExpirationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (ClientResourceContext clientContext : ClientContextManager.this.clientContexts.values()) {
                    if (System.currentTimeMillis() - clientContext.lastPingTimestamp <= (long)(ClientContextManager.this.clientExpirationSeconds * 1000)) continue;
                    for (TBrokerFD fd : clientContext.inputStreams.keySet()) {
                        ClientContextManager.this.removeInputStream(fd);
                    }
                    for (TBrokerFD fd : clientContext.outputStreams.keySet()) {
                        ClientContextManager.this.removeOutputStream(fd);
                    }
                    ClientContextManager.this.clientContexts.remove(clientContext.clientId);
                    logger.info((Object)("client [" + clientContext.clientId + "] is expired, remove it from contexts. last ping time is " + clientContext.lastPingTimestamp));
                }
            }
            finally {
                ClientContextManager.this.executorService.schedule(this, 60L, TimeUnit.SECONDS);
            }
        }
    }
}

