/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.broker.hdfs;

import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.doris.broker.hdfs.FileSystemIdentity;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Logger;

public class BrokerFileSystem {
    private static Logger logger = Logger.getLogger((String)BrokerFileSystem.class.getName());
    private ReentrantLock lock;
    private FileSystemIdentity identity;
    private FileSystem dfsFileSystem;
    private long lastAccessTimestamp;
    private UUID fileSystemId;

    public BrokerFileSystem(FileSystemIdentity identity) {
        this.identity = identity;
        this.lock = new ReentrantLock();
        this.dfsFileSystem = null;
        this.lastAccessTimestamp = System.currentTimeMillis();
        this.fileSystemId = UUID.randomUUID();
    }

    public synchronized void setFileSystem(FileSystem fileSystem) {
        this.dfsFileSystem = fileSystem;
        this.lastAccessTimestamp = System.currentTimeMillis();
    }

    public void closeFileSystem() {
        block8: {
            this.lock.lock();
            try {
                if (this.dfsFileSystem == null) break block8;
                try {
                    this.dfsFileSystem.close();
                }
                catch (Exception e) {
                    logger.error((Object)"errors while close file system", (Throwable)e);
                }
                finally {
                    this.dfsFileSystem = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public FileSystem getDFSFileSystem() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        return this.dfsFileSystem;
    }

    public void updateLastUpdateAccessTime() {
        this.lastAccessTimestamp = System.currentTimeMillis();
    }

    public FileSystemIdentity getIdentity() {
        return this.identity;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public boolean isExpired(long expirationIntervalSecs) {
        return System.currentTimeMillis() - this.lastAccessTimestamp > expirationIntervalSecs * 1000L;
    }

    public String toString() {
        return "BrokerFileSystem [identity=" + this.identity + ", dfsFileSystem=" + this.dfsFileSystem + ", fileSystemId=" + this.fileSystemId + "]";
    }
}

