/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.broker.hdfs;

import org.apache.doris.common.LoggerMessageFormat;
import org.apache.doris.thrift.TBrokerOperationStatus;
import org.apache.doris.thrift.TBrokerOperationStatusCode;

public class BrokerException
extends RuntimeException {
    private static final long serialVersionUID = 6745484176667787474L;
    public final TBrokerOperationStatusCode errorCode;

    public BrokerException(TBrokerOperationStatusCode errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public BrokerException(TBrokerOperationStatusCode errorCode, String msg, Object ... args) {
        super(LoggerMessageFormat.format(msg, args));
        this.errorCode = errorCode;
    }

    public BrokerException(TBrokerOperationStatusCode errorCode, Throwable cause, String msg, Object ... args) {
        super(LoggerMessageFormat.format(msg, args), cause);
        this.errorCode = errorCode;
    }

    public TBrokerOperationStatus generateFailedOperationStatus() {
        TBrokerOperationStatus errorStatus = new TBrokerOperationStatus(this.errorCode);
        errorStatus.setMessage(super.getMessage() + ", cause by: " + (this.getCause() != null ? this.getCause().getMessage() : "null"));
        return errorStatus;
    }
}

