/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.ReplicaAccessorBuilder;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.util.ByteArrayManager;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsClientConf {
    private static final Logger LOG = LoggerFactory.getLogger(DfsClientConf.class);
    private final int hdfsTimeout;
    private final int maxFailoverAttempts;
    private final int maxRetryAttempts;
    private final int failoverSleepBaseMillis;
    private final int failoverSleepMaxMillis;
    private final int maxBlockAcquireFailures;
    private final int datanodeSocketWriteTimeout;
    private final int ioBufferSize;
    private final Options.ChecksumOpt defaultChecksumOpt;
    private final int writePacketSize;
    private final int writeMaxPackets;
    private final ByteArrayManager.Conf writeByteArrayManagerConf;
    private final int socketTimeout;
    private final int socketSendBufferSize;
    private final long excludedNodesCacheExpiry;
    private final int timeWindow;
    private final int numCachedConnRetry;
    private final int numBlockWriteRetry;
    private final int numBlockWriteLocateFollowingRetry;
    private final int blockWriteLocateFollowingInitialDelayMs;
    private final long defaultBlockSize;
    private final long prefetchSize;
    private final short defaultReplication;
    private final String taskId;
    private final FsPermission uMask;
    private final boolean connectToDnViaHostname;
    private final boolean hdfsBlocksMetadataEnabled;
    private final int fileBlockStorageLocationsNumThreads;
    private final int fileBlockStorageLocationsTimeoutMs;
    private final int retryTimesForGetLastBlockLength;
    private final int retryIntervalForGetLastBlockLength;
    private final long datanodeRestartTimeout;
    private final long slowIoWarningThresholdMs;
    private final ShortCircuitConf shortCircuitConf;
    private final long hedgedReadThresholdMillis;
    private final int hedgedReadThreadpoolSize;
    private final List<Class<? extends ReplicaAccessorBuilder>> replicaAccessorBuilderClasses;
    private final boolean dataTransferTcpNoDelay;

    public DfsClientConf(Configuration conf) {
        this.hdfsTimeout = Client.getRpcTimeout((Configuration)conf);
        this.maxRetryAttempts = conf.getInt("dfs.client.retry.max.attempts", 10);
        this.timeWindow = conf.getInt("dfs.client.retry.window.base", 3000);
        this.retryTimesForGetLastBlockLength = conf.getInt("dfs.client.retry.times.get-last-block-length", 3);
        this.retryIntervalForGetLastBlockLength = conf.getInt("dfs.client.retry.interval-ms.get-last-block-length", 4000);
        this.maxFailoverAttempts = conf.getInt("dfs.client.failover.max.attempts", 15);
        this.failoverSleepBaseMillis = conf.getInt("dfs.client.failover.sleep.base.millis", 500);
        this.failoverSleepMaxMillis = conf.getInt("dfs.client.failover.sleep.max.millis", 15000);
        this.maxBlockAcquireFailures = conf.getInt("dfs.client.max.block.acquire.failures", 3);
        this.datanodeSocketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        this.ioBufferSize = conf.getInt("io.file.buffer.size", 4096);
        this.defaultChecksumOpt = DfsClientConf.getChecksumOptFromConf(conf);
        this.dataTransferTcpNoDelay = conf.getBoolean("dfs.data.transfer.client.tcpnodelay", true);
        this.socketTimeout = conf.getInt("dfs.client.socket-timeout", 60000);
        this.socketSendBufferSize = conf.getInt("dfs.client.socket.send.buffer.size", 131072);
        this.writePacketSize = conf.getInt("dfs.client-write-packet-size", 65536);
        this.writeMaxPackets = conf.getInt("dfs.client.write.max-packets-in-flight", 80);
        boolean byteArrayManagerEnabled = conf.getBoolean("dfs.client.write.byte-array-manager.enabled", false);
        if (!byteArrayManagerEnabled) {
            this.writeByteArrayManagerConf = null;
        } else {
            int countThreshold = conf.getInt("dfs.client.write.byte-array-manager.count-threshold", 128);
            int countLimit = conf.getInt("dfs.client.write.byte-array-manager.count-limit", 2048);
            long countResetTimePeriodMs = conf.getLong("dfs.client.write.byte-array-manager.count-reset-time-period-ms", 10000L);
            this.writeByteArrayManagerConf = new ByteArrayManager.Conf(countThreshold, countLimit, countResetTimePeriodMs);
        }
        this.defaultBlockSize = conf.getLongBytes("dfs.blocksize", 0x8000000L);
        this.defaultReplication = (short)conf.getInt("dfs.replication", 3);
        this.taskId = conf.get("mapreduce.task.attempt.id", "NONMAPREDUCE");
        this.excludedNodesCacheExpiry = conf.getLong("dfs.client.write.exclude.nodes.cache.expiry.interval.millis", 600000L);
        this.prefetchSize = conf.getLong("dfs.client.read.prefetch.size", 10L * this.defaultBlockSize);
        this.numCachedConnRetry = conf.getInt("dfs.client.cached.conn.retry", 3);
        this.numBlockWriteRetry = conf.getInt("dfs.client.block.write.retries", 3);
        this.numBlockWriteLocateFollowingRetry = conf.getInt("dfs.client.block.write.locateFollowingBlock.retries", 5);
        this.blockWriteLocateFollowingInitialDelayMs = conf.getInt("dfs.client.block.write.locateFollowingBlock.initial.delay.ms", 400);
        this.uMask = FsPermission.getUMask((Configuration)conf);
        this.connectToDnViaHostname = conf.getBoolean("dfs.client.use.datanode.hostname", false);
        this.hdfsBlocksMetadataEnabled = conf.getBoolean("dfs.datanode.hdfs-blocks-metadata.enabled", false);
        this.fileBlockStorageLocationsNumThreads = conf.getInt("dfs.client.file-block-storage-locations.num-threads", 10);
        this.fileBlockStorageLocationsTimeoutMs = conf.getInt("dfs.client.file-block-storage-locations.timeout.millis", 1000);
        this.datanodeRestartTimeout = conf.getLong("dfs.client.datanode-restart.timeout", 30L) * 1000L;
        this.slowIoWarningThresholdMs = conf.getLong("dfs.client.slow.io.warning.threshold.ms", 30000L);
        this.shortCircuitConf = new ShortCircuitConf(conf);
        this.hedgedReadThresholdMillis = conf.getLong("dfs.client.hedged.read.threshold.millis", 500L);
        this.hedgedReadThreadpoolSize = conf.getInt("dfs.client.hedged.read.threadpool.size", 0);
        this.replicaAccessorBuilderClasses = this.loadReplicaAccessorBuilderClasses(conf);
    }

    private List<Class<? extends ReplicaAccessorBuilder>> loadReplicaAccessorBuilderClasses(Configuration conf) {
        String[] classNames = conf.getTrimmedStrings("dfs.client.replica.accessor.builder.classes");
        if (classNames.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Class<? extends ReplicaAccessorBuilder>> classes = new ArrayList<Class<? extends ReplicaAccessorBuilder>>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String className : classNames) {
            try {
                Class<?> cls = classLoader.loadClass(className);
                classes.add(cls);
            }
            catch (Throwable t) {
                LOG.warn("Unable to load " + className, t);
            }
        }
        return classes;
    }

    private static DataChecksum.Type getChecksumType(Configuration conf) {
        String checksum = conf.get("dfs.checksum.type", "CRC32C");
        try {
            return DataChecksum.Type.valueOf((String)checksum);
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Bad checksum type: {}. Using default {}", (Object)checksum, (Object)"CRC32C");
            return DataChecksum.Type.valueOf((String)"CRC32C");
        }
    }

    public static Options.ChecksumOpt getChecksumOptFromConf(Configuration conf) {
        DataChecksum.Type type = DfsClientConf.getChecksumType(conf);
        int bytesPerChecksum = conf.getInt("dfs.bytes-per-checksum", 512);
        return new Options.ChecksumOpt(type, bytesPerChecksum);
    }

    public DataChecksum createChecksum(Options.ChecksumOpt userOpt) {
        Options.ChecksumOpt opt = Options.ChecksumOpt.processChecksumOpt((Options.ChecksumOpt)this.defaultChecksumOpt, (Options.ChecksumOpt)userOpt);
        DataChecksum dataChecksum = DataChecksum.newDataChecksum((DataChecksum.Type)opt.getChecksumType(), (int)opt.getBytesPerChecksum());
        if (dataChecksum == null) {
            throw new HadoopIllegalArgumentException("Invalid checksum type: userOpt=" + userOpt + ", default=" + this.defaultChecksumOpt + ", effective=null");
        }
        return dataChecksum;
    }

    @VisibleForTesting
    public int getBlockWriteLocateFollowingInitialDelayMs() {
        return this.blockWriteLocateFollowingInitialDelayMs;
    }

    public int getHdfsTimeout() {
        return this.hdfsTimeout;
    }

    public int getMaxFailoverAttempts() {
        return this.maxFailoverAttempts;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public int getFailoverSleepBaseMillis() {
        return this.failoverSleepBaseMillis;
    }

    public int getFailoverSleepMaxMillis() {
        return this.failoverSleepMaxMillis;
    }

    public int getMaxBlockAcquireFailures() {
        return this.maxBlockAcquireFailures;
    }

    public int getDatanodeSocketWriteTimeout() {
        return this.datanodeSocketWriteTimeout;
    }

    public int getIoBufferSize() {
        return this.ioBufferSize;
    }

    public Options.ChecksumOpt getDefaultChecksumOpt() {
        return this.defaultChecksumOpt;
    }

    public int getWritePacketSize() {
        return this.writePacketSize;
    }

    public int getWriteMaxPackets() {
        return this.writeMaxPackets;
    }

    public ByteArrayManager.Conf getWriteByteArrayManagerConf() {
        return this.writeByteArrayManagerConf;
    }

    public boolean getDataTransferTcpNoDelay() {
        return this.dataTransferTcpNoDelay;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getSocketSendBufferSize() {
        return this.socketSendBufferSize;
    }

    public long getExcludedNodesCacheExpiry() {
        return this.excludedNodesCacheExpiry;
    }

    public int getTimeWindow() {
        return this.timeWindow;
    }

    public int getNumCachedConnRetry() {
        return this.numCachedConnRetry;
    }

    public int getNumBlockWriteRetry() {
        return this.numBlockWriteRetry;
    }

    public int getNumBlockWriteLocateFollowingRetry() {
        return this.numBlockWriteLocateFollowingRetry;
    }

    public long getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public long getPrefetchSize() {
        return this.prefetchSize;
    }

    public short getDefaultReplication() {
        return this.defaultReplication;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public FsPermission getUMask() {
        return this.uMask;
    }

    public boolean isConnectToDnViaHostname() {
        return this.connectToDnViaHostname;
    }

    public boolean isHdfsBlocksMetadataEnabled() {
        return this.hdfsBlocksMetadataEnabled;
    }

    public int getFileBlockStorageLocationsNumThreads() {
        return this.fileBlockStorageLocationsNumThreads;
    }

    public int getFileBlockStorageLocationsTimeoutMs() {
        return this.fileBlockStorageLocationsTimeoutMs;
    }

    public int getRetryTimesForGetLastBlockLength() {
        return this.retryTimesForGetLastBlockLength;
    }

    public int getRetryIntervalForGetLastBlockLength() {
        return this.retryIntervalForGetLastBlockLength;
    }

    public long getDatanodeRestartTimeout() {
        return this.datanodeRestartTimeout;
    }

    public long getSlowIoWarningThresholdMs() {
        return this.slowIoWarningThresholdMs;
    }

    public long getHedgedReadThresholdMillis() {
        return this.hedgedReadThresholdMillis;
    }

    public int getHedgedReadThreadpoolSize() {
        return this.hedgedReadThreadpoolSize;
    }

    public List<Class<? extends ReplicaAccessorBuilder>> getReplicaAccessorBuilderClasses() {
        return this.replicaAccessorBuilderClasses;
    }

    public ShortCircuitConf getShortCircuitConf() {
        return this.shortCircuitConf;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    public static class ShortCircuitConf {
        private static final Logger LOG = DfsClientConf.access$000();
        private final int socketCacheCapacity;
        private final long socketCacheExpiry;
        private final boolean useLegacyBlockReader;
        private final boolean useLegacyBlockReaderLocal;
        private final String domainSocketPath;
        private final boolean skipShortCircuitChecksums;
        private final int shortCircuitBufferSize;
        private final boolean shortCircuitLocalReads;
        private final boolean domainSocketDataTraffic;
        private final int shortCircuitStreamsCacheSize;
        private final long shortCircuitStreamsCacheExpiryMs;
        private final int shortCircuitSharedMemoryWatcherInterruptCheckMs;
        private final boolean shortCircuitMmapEnabled;
        private final int shortCircuitMmapCacheSize;
        private final long shortCircuitMmapCacheExpiryMs;
        private final long shortCircuitMmapCacheRetryTimeout;
        private final long shortCircuitCacheStaleThresholdMs;
        private final long keyProviderCacheExpiryMs;

        public ShortCircuitConf(Configuration conf) {
            this.socketCacheCapacity = conf.getInt("dfs.client.socketcache.capacity", 16);
            this.socketCacheExpiry = conf.getLong("dfs.client.socketcache.expiryMsec", 3000L);
            this.useLegacyBlockReader = conf.getBoolean("dfs.client.use.legacy.blockreader", false);
            this.useLegacyBlockReaderLocal = conf.getBoolean("dfs.client.use.legacy.blockreader.local", false);
            this.shortCircuitLocalReads = conf.getBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false);
            this.domainSocketDataTraffic = conf.getBoolean("dfs.client.domain.socket.data.traffic", false);
            this.domainSocketPath = conf.getTrimmed("dfs.domain.socket.path", "");
            LOG.debug("dfs.client.use.legacy.blockreader.local = {}", (Object)this.useLegacyBlockReaderLocal);
            LOG.debug(HdfsClientConfigKeys.Read.ShortCircuit.KEY + " = {}", (Object)this.shortCircuitLocalReads);
            LOG.debug("dfs.client.domain.socket.data.traffic = {}", (Object)this.domainSocketDataTraffic);
            LOG.debug("dfs.domain.socket.path = {}", (Object)this.domainSocketPath);
            this.skipShortCircuitChecksums = conf.getBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
            this.shortCircuitBufferSize = conf.getInt("dfs.client.read.shortcircuit.buffer.size", 0x100000);
            this.shortCircuitStreamsCacheSize = conf.getInt("dfs.client.read.shortcircuit.streams.cache.size", 256);
            this.shortCircuitStreamsCacheExpiryMs = conf.getLong("dfs.client.read.shortcircuit.streams.cache.expiry.ms", 300000L);
            this.shortCircuitMmapEnabled = conf.getBoolean("dfs.client.mmap.enabled", true);
            this.shortCircuitMmapCacheSize = conf.getInt("dfs.client.mmap.cache.size", 256);
            this.shortCircuitMmapCacheExpiryMs = conf.getLong("dfs.client.mmap.cache.timeout.ms", 3600000L);
            this.shortCircuitMmapCacheRetryTimeout = conf.getLong("dfs.client.mmap.retry.timeout.ms", 300000L);
            this.shortCircuitCacheStaleThresholdMs = conf.getLong("dfs.client.read.short.circuit.replica.stale.threshold.ms", 1800000L);
            this.shortCircuitSharedMemoryWatcherInterruptCheckMs = conf.getInt("dfs.short.circuit.shared.memory.watcher.interrupt.check.ms", 60000);
            this.keyProviderCacheExpiryMs = conf.getLong("dfs.client.key.provider.cache.expiry", HdfsClientConfigKeys.DFS_CLIENT_KEY_PROVIDER_CACHE_EXPIRY_DEFAULT);
        }

        public int getSocketCacheCapacity() {
            return this.socketCacheCapacity;
        }

        public long getSocketCacheExpiry() {
            return this.socketCacheExpiry;
        }

        public boolean isUseLegacyBlockReaderLocal() {
            return this.useLegacyBlockReaderLocal;
        }

        public String getDomainSocketPath() {
            return this.domainSocketPath;
        }

        public boolean isShortCircuitLocalReads() {
            return this.shortCircuitLocalReads;
        }

        public boolean isDomainSocketDataTraffic() {
            return this.domainSocketDataTraffic;
        }

        public boolean isUseLegacyBlockReader() {
            return this.useLegacyBlockReader;
        }

        public boolean isSkipShortCircuitChecksums() {
            return this.skipShortCircuitChecksums;
        }

        public int getShortCircuitBufferSize() {
            return this.shortCircuitBufferSize;
        }

        public int getShortCircuitStreamsCacheSize() {
            return this.shortCircuitStreamsCacheSize;
        }

        public long getShortCircuitStreamsCacheExpiryMs() {
            return this.shortCircuitStreamsCacheExpiryMs;
        }

        public int getShortCircuitSharedMemoryWatcherInterruptCheckMs() {
            return this.shortCircuitSharedMemoryWatcherInterruptCheckMs;
        }

        public boolean isShortCircuitMmapEnabled() {
            return this.shortCircuitMmapEnabled;
        }

        public int getShortCircuitMmapCacheSize() {
            return this.shortCircuitMmapCacheSize;
        }

        public long getShortCircuitMmapCacheExpiryMs() {
            return this.shortCircuitMmapCacheExpiryMs;
        }

        public long getShortCircuitMmapCacheRetryTimeout() {
            return this.shortCircuitMmapCacheRetryTimeout;
        }

        public long getShortCircuitCacheStaleThresholdMs() {
            return this.shortCircuitCacheStaleThresholdMs;
        }

        public long getKeyProviderCacheExpiryMs() {
            return this.keyProviderCacheExpiryMs;
        }

        public String confAsString() {
            return "shortCircuitStreamsCacheSize = " + this.shortCircuitStreamsCacheSize + ", shortCircuitStreamsCacheExpiryMs = " + this.shortCircuitStreamsCacheExpiryMs + ", shortCircuitMmapCacheSize = " + this.shortCircuitMmapCacheSize + ", shortCircuitMmapCacheExpiryMs = " + this.shortCircuitMmapCacheExpiryMs + ", shortCircuitMmapCacheRetryTimeout = " + this.shortCircuitMmapCacheRetryTimeout + ", shortCircuitCacheStaleThresholdMs = " + this.shortCircuitCacheStaleThresholdMs + ", socketCacheCapacity = " + this.socketCacheCapacity + ", socketCacheExpiry = " + this.socketCacheExpiry + ", shortCircuitLocalReads = " + this.shortCircuitLocalReads + ", useLegacyBlockReaderLocal = " + this.useLegacyBlockReaderLocal + ", domainSocketDataTraffic = " + this.domainSocketDataTraffic + ", shortCircuitSharedMemoryWatcherInterruptCheckMs = " + this.shortCircuitSharedMemoryWatcherInterruptCheckMs + ", keyProviderCacheExpiryMs = " + this.keyProviderCacheExpiryMs;
        }
    }
}

