/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import java.io.Serializable;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.RDDDataDistribution;
import org.apache.spark.status.api.v1.RDDPartitionInfo;
import org.apache.spark.status.api.v1.RDDStorageInfo;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.storage.BlockPagedTable;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u00194Qa\u0002\u0005\u0001\u0015IA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\t9\u0001\u0011\t\u0011)A\u0005;!)1\u0005\u0001C\u0001I!)\u0011\u0006\u0001C\u0001U!)1\n\u0001C\u0005\u0019\")!\f\u0001C\u00057\n9!\u000b\u0012#QC\u001e,'BA\u0005\u000b\u0003\u001d\u0019Ho\u001c:bO\u0016T!a\u0003\u0007\u0002\u0005UL'BA\u0007\u000f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0016\u001b\u0005Q\u0011B\u0001\f\u000b\u0005%9VMY+J!\u0006<W-\u0001\u0004qCJ,g\u000e^\u0002\u0001!\t!\"$\u0003\u0002\u001c\u0015\tQ1\u000b]1sWVKE+\u00192\u0002\u000bM$xN]3\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001b\u0011AB:uCR,8/\u0003\u0002#?\tq\u0011\t\u001d9Ti\u0006$Xo]*u_J,\u0017A\u0002\u001fj]&$h\bF\u0002&O!\u0002\"A\n\u0001\u000e\u0003!AQaF\u0002A\u0002eAQ\u0001H\u0002A\u0002u\taA]3oI\u0016\u0014HCA\u0016@!\rac'\u000f\b\u0003[Mr!AL\u0019\u000e\u0003=R!\u0001\r\r\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b6\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AM\u0005\u0003oa\u00121aU3r\u0015\t!T\u0007\u0005\u0002;{5\t1H\u0003\u0002=k\u0005\u0019\u00010\u001c7\n\u0005yZ$\u0001\u0002(pI\u0016DQ\u0001\u0011\u0003A\u0002\u0005\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002C\u00136\t1I\u0003\u0002E\u000b\u0006!\u0001\u000e\u001e;q\u0015\t1u)A\u0004tKJ4H.\u001a;\u000b\u0003!\u000bQA[1wCbL!AS\"\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f^\u0001\ro>\u00148.\u001a:IK\u0006$WM]\u000b\u0002\u001bB\u0019a*\u0015*\u000e\u0003=S!\u0001U\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00028\u001fB\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0005Y\u0006twMC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&AB*ue&tw-A\u0005x_J\\WM\u001d*poR\u00111\u0006\u0018\u0005\u0006;\u001a\u0001\rAX\u0001\u0007o>\u00148.\u001a:\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017A\u0001<2\u0015\t\u0019w$A\u0002ba&L!!\u001a1\u0003'I#E\tR1uC\u0012K7\u000f\u001e:jEV$\u0018n\u001c8")
public class RDDPage
extends WebUIPage {
    private final SparkUITab parent;
    private final AppStatusStore store;

    @Override
    public Seq<Node> render(HttpServletRequest request) {
        Elem elem;
        RDDStorageInfo rDDStorageInfo;
        String parameterId = UIUtils$.MODULE$.stripXSS(request.getParameter("id"));
        Predef$.MODULE$.require(parameterId != null && new StringOps(Predef$.MODULE$.augmentString(parameterId)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Missing id parameter");
        String parameterBlockPage = UIUtils$.MODULE$.stripXSS(request.getParameter("block.page"));
        String parameterBlockSortColumn = UIUtils$.MODULE$.stripXSS(request.getParameter("block.sort"));
        String parameterBlockSortDesc = UIUtils$.MODULE$.stripXSS(request.getParameter("block.desc"));
        String parameterBlockPageSize = UIUtils$.MODULE$.stripXSS(request.getParameter("block.pageSize"));
        String parameterBlockPrevPageSize = UIUtils$.MODULE$.stripXSS(request.getParameter("block.prevPageSize"));
        int blockPage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterBlockPage).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)RDDPage.$anonfun$render$2(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
        String blockSortColumn = (String)Option$.MODULE$.apply((Object)parameterBlockSortColumn).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Block Name");
        boolean blockSortDesc = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)parameterBlockSortDesc).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RDDPage.$anonfun$render$5(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        int blockPageSize = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterBlockPageSize).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)RDDPage.$anonfun$render$7(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 100));
        int blockPrevPageSize = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterBlockPrevPageSize).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)RDDPage.$anonfun$render$9(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> blockPageSize));
        int rddId = new StringOps(Predef$.MODULE$.augmentString(parameterId)).toInt();
        try {
            rDDStorageInfo = this.store.rdd(rddId);
        }
        catch (NoSuchElementException noSuchElementException) {
            return UIUtils$.MODULE$.headerSparkPage(request, "RDD Not Found", (Function0<Seq<Node>>)(Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty(), this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7(), UIUtils$.MODULE$.headerSparkPage$default$8());
        }
        RDDStorageInfo rddStorageInfo = rDDStorageInfo;
        Seq<String> x$12 = this.workerHeader();
        Function1 & Serializable & scala.Serializable x$22 = (Function1 & Serializable & scala.Serializable)worker -> this.workerRow((RDDDataDistribution)worker);
        Seq x$32 = (Seq)rddStorageInfo.dataDistribution().get();
        Some x$42 = new Some((Object)"rdd-storage-by-worker-table");
        boolean x$52 = UIUtils$.MODULE$.listingTable$default$4();
        Seq<String> x$62 = UIUtils$.MODULE$.listingTable$default$6();
        boolean x$7 = UIUtils$.MODULE$.listingTable$default$7();
        boolean x$8 = UIUtils$.MODULE$.listingTable$default$8();
        Seq<Node> workerTable = UIUtils$.MODULE$.listingTable(x$12, x$22, x$32, x$52, (Option<String>)x$42, x$62, x$7, x$8);
        int page = blockPageSize <= blockPrevPageSize ? blockPage : 1;
        try {
            BlockPagedTable _blockTable = new BlockPagedTable(new StringBuilder(17).append(UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3())).append("/storage/rdd/?id=").append(rddId).toString(), (Seq<RDDPartitionInfo>)((Seq)rddStorageInfo.partitions().get()), blockPageSize, blockSortColumn, blockSortDesc, this.store.executorList(true));
            elem = _blockTable.table(page);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException;
            if (!bl) {
                throw throwable;
            }
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)throwable2.getMessage());
            Elem elem2 = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            elem = elem2;
        }
        Elem blockTableHTML = elem;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("\n              |$(function() {\n              |  if (/.*&block.sort=.*$/.test(location.search)) {\n              |    var topOffset = $(\"#blocks-section\").offset().top;\n              |    $(\"html,body\").animate({scrollTop: topOffset}, 200);\n              |  }\n              |});\n            ")).stripMargin()));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem jsForScrollingDownToBlockTable = new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        NodeBuffer $buf2 = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("row-fluid"), (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("span12"), (MetaData)$md2);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Storage Level:"));
        $buf6.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n              "));
        $buf6.$amp$plus((Object)rddStorageInfo.storageLevel());
        $buf6.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Cached Partitions:"));
        $buf8.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf8.$amp$plus((Object)new Text("\n              "));
        $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)rddStorageInfo.numCachedPartitions()));
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("Total Partitions:"));
        $buf10.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf10.$amp$plus((Object)new Text("\n              "));
        $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)rddStorageInfo.numPartitions()));
        $buf10.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("Memory Size:"));
        $buf12.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
        $buf12.$amp$plus((Object)new Text("\n              "));
        $buf12.$amp$plus((Object)Utils$.MODULE$.bytesToString(rddStorageInfo.memoryUsed()));
        $buf12.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("Disk Size:"));
        $buf14.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15));
        $buf14.$amp$plus((Object)new Text("\n              "));
        $buf14.$amp$plus((Object)Utils$.MODULE$.bytesToString(rddStorageInfo.diskUsed()));
        $buf14.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("row-fluid"), (MetaData)$md4);
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("span12"), (MetaData)$md5);
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text("\n            Data Distribution on "));
        $buf18.$amp$plus(rddStorageInfo.dataDistribution().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        $buf18.$amp$plus((Object)new Text("\n            Executors\n          "));
        $buf17.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18));
        $buf17.$amp$plus((Object)new Text("\n          "));
        $buf17.$amp$plus(workerTable);
        $buf17.$amp$plus((Object)new Text("\n        "));
        $buf16.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17));
        $buf16.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
        NodeBuffer $buf19 = new NodeBuffer();
        $buf19.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("blocks-section"), (MetaData)$md6);
        NodeBuffer $buf20 = new NodeBuffer();
        $buf20.$amp$plus((Object)new Text("\n          "));
        $buf20.$amp$plus(rddStorageInfo.partitions().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        $buf20.$amp$plus((Object)new Text(" Partitions\n        "));
        $buf19.$amp$plus((Object)new Elem(null, "h4", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf20));
        $buf19.$amp$plus((Object)new Text("\n        "));
        $buf19.$amp$plus(blockTableHTML.$plus$plus((GenTraversableOnce)jsForScrollingDownToBlockTable, Seq$.MODULE$.canBuildFrom()));
        $buf19.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf19));
        NodeBuffer content = $buf2;
        return UIUtils$.MODULE$.headerSparkPage(request, new StringBuilder(21).append("RDD Storage Info for ").append(rddStorageInfo.name()).toString(), (Function0<Seq<Node>>)(Function0 & Serializable & scala.Serializable)() -> content, this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7(), UIUtils$.MODULE$.headerSparkPage$default$8());
    }

    private Seq<String> workerHeader() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Host", "On Heap Memory Usage", "Off Heap Memory Usage", "Disk Usage"}));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> workerRow(RDDDataDistribution worker) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)worker.address());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)worker.onHeapMemoryUsed().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L))));
        $buf3.$amp$plus((Object)new Text("\n        ("));
        $buf3.$amp$plus((Object)Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)worker.onHeapMemoryRemaining().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L))));
        $buf3.$amp$plus((Object)new Text(" Remaining)\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)worker.offHeapMemoryUsed().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L))));
        $buf4.$amp$plus((Object)new Text("\n        ("));
        $buf4.$amp$plus((Object)Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)worker.offHeapMemoryRemaining().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L))));
        $buf4.$amp$plus((Object)new Text(" Remaining)\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)Utils$.MODULE$.bytesToString(worker.diskUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    public static final /* synthetic */ int $anonfun$render$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$render$5(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$render$7(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ int $anonfun$render$9(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public RDDPage(SparkUITab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("rdd");
    }
}

