/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import java.io.Serializable;
import java.net.URLEncoder;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.RDDPartitionInfo;
import org.apache.spark.ui.PagedTable;
import org.apache.spark.ui.storage.BlockDataSource;
import org.apache.spark.ui.storage.BlockTableRowData;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!B\n\u0015\u0001Yq\u0002\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011i\u0002!\u0011!Q\u0001\nmB\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005_!A1\u000b\u0001B\u0001B\u0003%A\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u00159\u0007\u0001\"\u0011g\u0011\u0015A\u0007\u0001\"\u0011g\u0011\u0015I\u0007\u0001\"\u0011g\u0011\u0015Q\u0007\u0001\"\u0011g\u0011\u001dY\u0007A1A\u0005B1Da\u0001\u001d\u0001!\u0002\u0013i\u0007\"B9\u0001\t\u0003\u0012\b\"B;\u0001\t\u00032\u0007\"\u0002<\u0001\t\u0003:\bBB@\u0001\t\u0003\n\tAA\bCY>\u001c7\u000eU1hK\u0012$\u0016M\u00197f\u0015\t)b#A\u0004ti>\u0014\u0018mZ3\u000b\u0005]A\u0012AA;j\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7c\u0001\u0001 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u00042AJ\u0014*\u001b\u00051\u0012B\u0001\u0015\u0017\u0005)\u0001\u0016mZ3e)\u0006\u0014G.\u001a\t\u0003U-j\u0011\u0001F\u0005\u0003YQ\u0011\u0011C\u00117pG.$\u0016M\u00197f%><H)\u0019;b\u0003!\u0011\u0017m]3QCRD7\u0001\u0001\t\u0003a]r!!M\u001b\u0011\u0005I\nS\"A\u001a\u000b\u0005Qr\u0013A\u0002\u001fs_>$h(\u0003\u00027C\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1\u0014%A\u0007sI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004y\u0005#eBA\u001f@\u001d\t\u0011d(C\u0001#\u0013\t\u0001\u0015%A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001b%aA*fc*\u0011\u0001)\t\t\u0003\u000b2k\u0011A\u0012\u0006\u0003\u000f\"\u000b!A^\u0019\u000b\u0005%S\u0015aA1qS*\u00111\nG\u0001\u0007gR\fG/^:\n\u000553%\u0001\u0005*E\tB\u000b'\u000f^5uS>t\u0017J\u001c4p\u0003!\u0001\u0018mZ3TSj,\u0007C\u0001\u0011Q\u0013\t\t\u0016EA\u0002J]R\f!b]8si\u000e{G.^7o\u0003\u0011!Wm]2\u0011\u0005\u0001*\u0016B\u0001,\"\u0005\u001d\u0011un\u001c7fC:\f\u0011#\u001a=fGV$xN]*v[6\f'/[3t!\ra\u0014)\u0017\t\u0003\u000bjK!a\u0017$\u0003\u001f\u0015CXmY;u_J\u001cV/\\7bef\fa\u0001P5oSRtDc\u00020`A\u0006\u00147\r\u001a\t\u0003U\u0001AQ!L\u0004A\u0002=BQAO\u0004A\u0002mBQAT\u0004A\u0002=CQAU\u0004A\u0002=BQaU\u0004A\u0002QCQaV\u0004A\u0002a\u000bq\u0001^1cY\u0016LE-F\u00010\u00035!\u0018M\u00197f\u0007N\u001c8\t\\1tg\u0006\t\u0002/Y4f'&TXMR8s[\u001aKW\r\u001c3\u0002+A\u0014XM\u001e)bO\u0016\u001c\u0016N_3G_Jlg)[3mI\u0006\u0019\u0002/Y4f\u001dVl'-\u001a:G_Jlg)[3mI\u0006QA-\u0019;b'>,(oY3\u0016\u00035\u0004\"A\u000b8\n\u0005=$\"a\u0004\"m_\u000e\\G)\u0019;b'>,(oY3\u0002\u0017\u0011\fG/Y*pkJ\u001cW\rI\u0001\ta\u0006<W\rT5oWR\u0011qf\u001d\u0005\u0006i>\u0001\raT\u0001\u0005a\u0006<W-\u0001\th_\n+H\u000f^8o\r>\u0014X\u000eU1uQ\u00069\u0001.Z1eKJ\u001cX#\u0001=\u0011\u0007q\n\u0015\u0010\u0005\u0002{{6\t1P\u0003\u0002}C\u0005\u0019\u00010\u001c7\n\u0005y\\(\u0001\u0002(pI\u0016\f1A]8x)\rA\u00181\u0001\u0005\u0007\u0003\u000b\u0011\u0002\u0019A\u0015\u0002\u000b\tdwnY6")
public class BlockPagedTable
implements PagedTable<BlockTableRowData> {
    private final String basePath;
    private final int pageSize;
    private final String sortColumn;
    private final boolean desc;
    private final BlockDataSource dataSource;

    @Override
    public Seq<Node> table(int page) {
        return PagedTable.table$(this, page);
    }

    @Override
    public Seq<Node> pageNavigation(int page, int pageSize, int totalPages) {
        return PagedTable.pageNavigation$(this, page, pageSize, totalPages);
    }

    @Override
    public String tableId() {
        return "rdd-storage-by-block-table";
    }

    @Override
    public String tableCssClass() {
        return "table table-bordered table-condensed table-striped table-head-clickable";
    }

    @Override
    public String pageSizeFormField() {
        return "block.pageSize";
    }

    @Override
    public String prevPageSizeFormField() {
        return "block.prevPageSize";
    }

    @Override
    public String pageNumberFormField() {
        return "block.page";
    }

    public BlockDataSource dataSource() {
        return this.dataSource;
    }

    @Override
    public String pageLink(int page) {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn, "UTF-8");
        return new StringBuilder(28).append(this.basePath).append("&").append(this.pageNumberFormField()).append("=").append(page).append("&block.sort=").append(encodedSortColumn).append("&block.desc=").append(this.desc).append("&").append(this.pageSizeFormField()).append("=").append(this.pageSize).toString();
    }

    @Override
    public String goButtonFormPath() {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn, "UTF-8");
        return new StringBuilder(24).append(this.basePath).append("&block.sort=").append(encodedSortColumn).append("&block.desc=").append(this.desc).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Node> headers() {
        void var3_3;
        Seq blockHeaders = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Block Name", "Storage Level", "Size in Memory", "Size on Disk", "Executors"}));
        if (!blockHeaders.contains((Object)this.sortColumn)) {
            throw new IllegalArgumentException(new StringBuilder(16).append("Unknown column: ").append(this.sortColumn).toString());
        }
        Seq headerRow = (Seq)blockHeaders.map((Function1 & Serializable & scala.Serializable)header -> {
            Elem elem;
            String string = header;
            String string2 = $this.sortColumn;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Unparsed headerLink = Unparsed$.MODULE$.apply(new StringBuilder(40).append($this.basePath).append("&block.sort=").append(URLEncoder.encode(header, "UTF-8")).append("&block.desc=").append(!$this.desc).append("&block.pageSize=").append($this.pageSize).toString());
                String arrow = $this.desc ? "&#x25BE;" : "&#x25B4;";
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("href", (Seq)headerLink, (MetaData)$md);
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n              "));
                $buf2.$amp$plus(header);
                $buf2.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new EntityRef("nbsp"));
                $buf3.$amp$plus((Object)Unparsed$.MODULE$.apply(arrow));
                $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                $buf2.$amp$plus((Object)new Text("\n            "));
                $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n          "));
                Elem elem2 = new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                elem = elem2;
            } else {
                Unparsed headerLink = Unparsed$.MODULE$.apply(new StringBuilder(28).append($this.basePath).append("&block.sort=").append(URLEncoder.encode(header, "UTF-8")).append("&block.pageSize=").append($this.pageSize).toString());
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("href", (Seq)headerLink, (MetaData)$md);
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus((Object)new Text("\n              "));
                $buf4.$amp$plus(header);
                $buf4.$amp$plus((Object)new Text("\n            "));
                $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                $buf.$amp$plus((Object)new Text("\n          "));
                Elem elem3 = new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                elem = elem3;
            }
            return elem;
        }, Seq$.MODULE$.canBuildFrom());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)headerRow);
        return new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Node> row(BlockTableRowData block) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)block.blockName());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)block.storageLevel());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)Utils$.MODULE$.bytesToString(block.memoryUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)Utils$.MODULE$.bytesToString(block.diskUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)block.executors());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    public BlockPagedTable(String basePath, Seq<RDDPartitionInfo> rddPartitions, int pageSize, String sortColumn, boolean desc, Seq<ExecutorSummary> executorSummaries) {
        this.basePath = basePath;
        this.pageSize = pageSize;
        this.sortColumn = sortColumn;
        this.desc = desc;
        PagedTable.$init$(this);
        this.dataSource = new BlockDataSource(rddPartitions, pageSize, sortColumn, desc, (Map<String, String>)((TraversableOnce)executorSummaries.map((Function1 & Serializable & scala.Serializable)ex -> new Tuple2((Object)ex.id(), (Object)ex.hostPort()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }
}

