/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.ExecutorExitCode$;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.storage.UnrecognizedBlockId;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=b!B\f\u0019\u0001i\u0001\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011M\u0002!\u0011!Q\u0001\nQBQa\u000e\u0001\u0005\u0002aB\u0001\"\u0010\u0001C\u0002\u0013\u0005!D\u0010\u0005\u0007\u0005\u0002\u0001\u000b\u0011B \t\u0011\r\u0003!\u0019!C\u00015\u0011Ca\u0001\u0015\u0001!\u0002\u0013)\u0005bB)\u0001\u0005\u0004%IA\u0015\u0005\u0007)\u0002\u0001\u000b\u0011B*\t\u000fU\u0003!\u0019!C\u0005-\"1q\u000b\u0001Q\u0001\n\u0005BQ\u0001\u0017\u0001\u0005\u0002eCQ\u0001\u0017\u0001\u0005\u0002\u001dDQ!\u001c\u0001\u0005\u00029DQ\u0001\u001d\u0001\u0005\u0002EDQa\u001f\u0001\u0005\u0002qDQA \u0001\u0005\u0002}Dq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u001a\u0001!I!a\u0007\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"!A\u00111\u0005\u0001\u0005\u0002i\t)\u0003C\u0004\u0002.\u0001!I!!\n\u0003!\u0011K7o\u001b\"m_\u000e\\W*\u00198bO\u0016\u0014(BA\r\u001b\u0003\u001d\u0019Ho\u001c:bO\u0016T!a\u0007\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005uq\u0012AB1qC\u000eDWMC\u0001 \u0003\ry'oZ\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)W5\t\u0011F\u0003\u0002+5\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002-S\t9Aj\\4hS:<\u0017\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u00021c5\t!$\u0003\u000235\tI1\u000b]1sW\u000e{gNZ\u0001\u0012I\u0016dW\r^3GS2,7o\u00148Ti>\u0004\bC\u0001\u00126\u0013\t14EA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\rI4\b\u0010\t\u0003u\u0001i\u0011\u0001\u0007\u0005\u0006[\r\u0001\ra\f\u0005\u0006g\r\u0001\r\u0001N\u0001\u0013gV\u0014G)\u001b:t!\u0016\u0014Hj\\2bY\u0012K'/F\u0001@!\t\u0011\u0003)\u0003\u0002BG\t\u0019\u0011J\u001c;\u0002'M,(\rR5sgB+'\u000fT8dC2$\u0015N\u001d\u0011\u0002\u00131|7-\u00197ESJ\u001cX#A#\u0011\u0007\t2\u0005*\u0003\u0002HG\t)\u0011I\u001d:bsB\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\u0003S>T\u0011!T\u0001\u0005U\u00064\u0018-\u0003\u0002P\u0015\n!a)\u001b7f\u0003)awnY1m\t&\u00148\u000fI\u0001\bgV\u0014G)\u001b:t+\u0005\u0019\u0006c\u0001\u0012G\u000b\u0006A1/\u001e2ESJ\u001c\b%\u0001\u0007tQV$Hm\\<o\u0011>|7.F\u0001\"\u00035\u0019\b.\u001e;e_^t\u0007j\\8lA\u00059q-\u001a;GS2,GC\u0001%[\u0011\u0015YF\u00021\u0001]\u0003!1\u0017\u000e\\3oC6,\u0007CA/e\u001d\tq&\r\u0005\u0002`G5\t\u0001M\u0003\u0002b]\u00051AH]8pizJ!aY\u0012\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003G\u000e\"\"\u0001\u00135\t\u000b%l\u0001\u0019\u00016\u0002\u000f\tdwnY6JIB\u0011!h[\u0005\u0003Yb\u0011qA\u00117pG.LE-A\u0007d_:$\u0018-\u001b8t\u00052|7m\u001b\u000b\u0003i=DQ!\u001b\bA\u0002)\f1bZ3u\u00032dg)\u001b7fgR\t!\u000fE\u0002tq\"s!\u0001\u001e<\u000f\u0005}+\u0018\"\u0001\u0013\n\u0005]\u001c\u0013a\u00029bG.\fw-Z\u0005\u0003sj\u00141aU3r\u0015\t98%\u0001\u0007hKR\fE\u000e\u001c\"m_\u000e\\7\u000fF\u0001~!\r\u0019\bP[\u0001\u0015GJ,\u0017\r^3UK6\u0004Hj\\2bY\ncwnY6\u0015\u0005\u0005\u0005\u0001C\u0002\u0012\u0002\u0004\u0005\u001d\u0001*C\u0002\u0002\u0006\r\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001\u001e\u0002\n%\u0019\u00111\u0002\r\u0003!Q+W\u000e\u001d'pG\u0006d'\t\\8dW&#\u0017AF2sK\u0006$X\rV3naNCWO\u001a4mK\ncwnY6\u0015\u0005\u0005E\u0001C\u0002\u0012\u0002\u0004\u0005M\u0001\nE\u0002;\u0003+I1!a\u0006\u0019\u0005I!V-\u001c9TQV4g\r\\3CY>\u001c7.\u00133\u0002\u001f\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c#jeN$2!RA\u000f\u0011\u0015i3\u00031\u00010\u0003=\tG\rZ*ikR$wn\u001e8I_>\\G#A\u0011\u0002\tM$x\u000e\u001d\u000b\u0003\u0003O\u00012AIA\u0015\u0013\r\tYc\t\u0002\u0005+:LG/\u0001\u0004e_N#x\u000e\u001d")
public class DiskBlockManager
implements Logging {
    private final boolean deleteFilesOnStop;
    private final int subDirsPerLocalDir;
    private final File[] localDirs;
    private final File[][] subDirs;
    private final Object shutdownHook;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int subDirsPerLocalDir() {
        return this.subDirsPerLocalDir;
    }

    public File[] localDirs() {
        return this.localDirs;
    }

    private File[][] subDirs() {
        return this.subDirs;
    }

    private Object shutdownHook() {
        return this.shutdownHook;
    }

    public File getFile(String filename) {
        File file;
        int hash = Utils$.MODULE$.nonNegativeHash(filename);
        int dirId = hash % this.localDirs().length;
        int subDirId = hash / this.localDirs().length % this.subDirsPerLocalDir();
        File[] fileArray = this.subDirs()[dirId];
        synchronized (fileArray) {
            File file2;
            File old = this.subDirs()[dirId][subDirId];
            if (old != null) {
                file2 = old;
            } else {
                File newDir = new File(this.localDirs()[dirId], new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)subDirId)})));
                if (!newDir.exists() && !newDir.mkdir()) {
                    throw new IOException(new StringBuilder(31).append("Failed to create local dir in ").append(newDir).append(".").toString());
                }
                this.subDirs()[dirId][subDirId] = newDir;
                file2 = newDir;
            }
            file = file2;
        }
        File subDir = file;
        return new File(subDir, filename);
    }

    public File getFile(BlockId blockId) {
        return this.getFile(blockId.name());
    }

    public boolean containsBlock(BlockId blockId) {
        return this.getFile(blockId.name()).exists();
    }

    public Seq<File> getAllFiles() {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.subDirs())).flatMap((Function1 & Serializable & scala.Serializable)dir -> new ArrayOps.ofRef(DiskBlockManager.$anonfun$getAllFiles$1(dir)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DiskBlockManager.$anonfun$getAllFiles$2(x$1))))).flatMap((Function1 & Serializable & scala.Serializable)dir -> {
            File[] files = dir.listFiles();
            return files != null ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)) : (SeqLike)Seq$.MODULE$.empty();
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<BlockId> getAllBlocks() {
        return (Seq)this.getAllFiles().flatMap((Function1 & Serializable & scala.Serializable)f -> {
            Iterable iterable;
            try {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)BlockId$.MODULE$.apply(f.getName())));
            }
            catch (UnrecognizedBlockId unrecognizedBlockId) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Tuple2<TempLocalBlockId, File> createTempLocalBlock() {
        TempLocalBlockId blockId = new TempLocalBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempLocalBlockId(UUID.randomUUID());
        }
        return new Tuple2((Object)blockId, (Object)this.getFile(blockId));
    }

    public Tuple2<TempShuffleBlockId, File> createTempShuffleBlock() {
        TempShuffleBlockId blockId = new TempShuffleBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempShuffleBlockId(UUID.randomUUID());
        }
        return new Tuple2((Object)blockId, (Object)this.getFile(blockId));
    }

    private File[] createLocalDirs(SparkConf conf) {
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.getConfiguredLocalDirs(conf))).flatMap((Function1 & Serializable & scala.Serializable)rootDir -> {
            Iterable iterable;
            try {
                File localDir = Utils$.MODULE$.createDirectory((String)rootDir, "blockmgr");
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Created local directory at ").append(localDir).toString());
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)localDir));
            }
            catch (IOException e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Failed to create local dir in ").append((String)rootDir).append(". Ignoring this directory.").toString(), e);
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    private Object addShutdownHook() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Adding shutdown hook");
        return ShutdownHookManager$.MODULE$.addShutdownHook(ShutdownHookManager$.MODULE$.TEMP_DIR_SHUTDOWN_PRIORITY() + 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown hook called");
            this.doStop();
        });
    }

    public void stop() {
        Boolean bl;
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.MODULE$.removeShutdownHook(this.shutdownHook()));
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while removing shutdown hook.", e);
            bl = BoxedUnit.UNIT;
        }
        this.doStop();
    }

    private void doStop() {
        block0: {
            if (!this.deleteFilesOnStop) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).foreach((Function1 & Serializable & scala.Serializable)localDir -> {
                DiskBlockManager.$anonfun$doStop$1(this, localDir);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ Object[] $anonfun$getAllFiles$1(File[] dir) {
        File[] fileArray = dir;
        synchronized (dir) {
            File[] fileArray2 = (File[])dir.clone();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Predef$.MODULE$.refArrayOps((Object[])fileArray2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAllFiles$2(File x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ void $anonfun$doStop$1(DiskBlockManager $this, File localDir) {
        block3: {
            if (!localDir.isDirectory() || !localDir.exists()) break block3;
            try {
                if (!ShutdownHookManager$.MODULE$.hasRootAsShutdownDeleteDir(localDir)) {
                    Utils$.MODULE$.deleteRecursively(localDir);
                }
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Exception while deleting local spark dir: ").append(localDir).toString(), e);
            }
        }
    }

    public DiskBlockManager(SparkConf conf, boolean deleteFilesOnStop) {
        this.deleteFilesOnStop = deleteFilesOnStop;
        Logging.$init$(this);
        this.subDirsPerLocalDir = conf.getInt("spark.diskStore.subDirectories", 64);
        this.localDirs = this.createLocalDirs(conf);
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).isEmpty()) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to create any local dir.");
            System.exit(ExecutorExitCode$.MODULE$.DISK_STORE_FAILED_TO_CREATE_DIR());
        }
        this.subDirs = (File[][])Array$.MODULE$.fill(this.localDirs().length, (Function0 & Serializable & scala.Serializable)() -> new File[this.subDirsPerLocalDir()], ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(File.class)));
        this.shutdownHook = this.addShutdownHook();
    }
}

