/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.collection.Set;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%d!B\u0011#\u0001\u0011R\u0003\u0002C\u001c\u0001\u0005\u000b\u0007I\u0011A\u001d\t\u0011y\u0002!\u0011!Q\u0001\niB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0007\u0002\u0011)\u0019!C\u0001\t\"AQ\t\u0001B\u0001B\u0003%\u0001\t\u0003\u0005G\u0001\t\u0015\r\u0011\"\u0001E\u0011!9\u0005A!A!\u0002\u0013\u0001\u0005\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011A%\t\u0011A\u0003!\u0011!Q\u0001\n)CQ!\u0015\u0001\u0005\u0002ICq!\u0017\u0001C\u0002\u0013\u0005A\t\u0003\u0004[\u0001\u0001\u0006I\u0001\u0011\u0005\b7\u0002\u0001\r\u0011\"\u0003E\u0011\u001da\u0006\u00011A\u0005\nuCaa\u0019\u0001!B\u0013\u0001\u0005b\u00023\u0001\u0001\u0004%I\u0001\u0012\u0005\bK\u0002\u0001\r\u0011\"\u0003g\u0011\u0019A\u0007\u0001)Q\u0005\u0001\"9\u0011\u000e\u0001b\u0001\n\u0013Q\u0007BB=\u0001A\u0003%1\u000eC\u0004{\u0001\t\u0007I\u0011B>\t\u000f\u0005%\u0001\u0001)A\u0005y\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAa!a\u000f\u0001\t\u0003!\u0005BBA\u001f\u0001\u0011\u0005A\t\u0003\u0004\u0002@\u0001!\tA\u001b\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\ti\u0005\u0001C!\u0003\u001fBq!a\u001a\u0001\t\u0003\tYB\u0001\tCY>\u001c7.T1oC\u001e,'/\u00138g_*\u00111\u0005J\u0001\bgR|'/Y4f\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7c\u0001\u0001,cA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0013\u0002\u0011%tG/\u001a:oC2L!AN\u001a\u0003\u000f1{wmZ5oO\u0006q!\r\\8dW6\u000bg.Y4fe&#7\u0001A\u000b\u0002uA\u00111\bP\u0007\u0002E%\u0011QH\t\u0002\u000f\u00052|7m['b]\u0006<WM]%e\u0003=\u0011Gn\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012\u0004\u0013A\u0002;j[\u0016l5\u000f\u0005\u0002-\u0003&\u0011!)\f\u0002\u0005\u0019>tw-\u0001\u0007nCb|e\u000eS3ba6+W.F\u0001A\u00035i\u0017\r_(o\u0011\u0016\f\u0007/T3nA\u0005iQ.\u0019=PM\u001aDU-\u00199NK6\fa\"\\1y\u001f\u001a4\u0007*Z1q\u001b\u0016l\u0007%A\u0007tY\u00064X-\u00128ea>Lg\u000e^\u000b\u0002\u0015B\u00111JT\u0007\u0002\u0019*\u0011Q\nJ\u0001\u0004eB\u001c\u0017BA(M\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a\fab\u001d7bm\u0016,e\u000e\u001a9pS:$\b%\u0001\u0004=S:LGO\u0010\u000b\u0007'R+fk\u0016-\u0011\u0005m\u0002\u0001\"B\u001c\u000b\u0001\u0004Q\u0004\"B \u000b\u0001\u0004\u0001\u0005\"B\"\u000b\u0001\u0004\u0001\u0005\"\u0002$\u000b\u0001\u0004\u0001\u0005\"\u0002%\u000b\u0001\u0004Q\u0015AB7bq6+W.A\u0004nCblU-\u001c\u0011\u0002\u0017}c\u0017m\u001d;TK\u0016tWj]\u0001\u0010?2\f7\u000f^*fK:l5o\u0018\u0013fcR\u0011a,\u0019\t\u0003Y}K!\u0001Y\u0017\u0003\tUs\u0017\u000e\u001e\u0005\bE:\t\t\u00111\u0001A\u0003\rAH%M\u0001\r?2\f7\u000f^*fK:l5\u000fI\u0001\u000e?J,W.Y5oS:<W*Z7\u0002#}\u0013X-\\1j]&tw-T3n?\u0012*\u0017\u000f\u0006\u0002_O\"9!-EA\u0001\u0002\u0004\u0001\u0015AD0sK6\f\u0017N\\5oO6+W\u000eI\u0001\b?\ndwnY6t+\u0005Y\u0007\u0003\u00027rgZl\u0011!\u001c\u0006\u0003]>\fA!\u001e;jY*\t\u0001/\u0001\u0003kCZ\f\u0017B\u0001:n\u0005\u001dA\u0015m\u001d5NCB\u0004\"a\u000f;\n\u0005U\u0014#a\u0002\"m_\u000e\\\u0017\n\u001a\t\u0003w]L!\u0001\u001f\u0012\u0003\u0017\tcwnY6Ti\u0006$Xo]\u0001\t?\ndwnY6tA\u0005iqlY1dQ\u0016$'\t\\8dWN,\u0012\u0001 \t\u0005{\u0006\u00151/D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019!L\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0004}\n9\u0001*Y:i'\u0016$\u0018AD0dC\u000eDW\r\u001a\"m_\u000e\\7\u000fI\u0001\nO\u0016$8\u000b^1ukN$B!a\u0004\u0002\u0016A!A&!\u0005w\u0013\r\t\u0019\"\f\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005]q\u00031\u0001t\u0003\u001d\u0011Gn\\2l\u0013\u0012\f\u0001#\u001e9eCR,G*Y:u'\u0016,g.T:\u0015\u0003y\u000bq\"\u001e9eCR,'\t\\8dW&sgm\u001c\u000b\n=\u0006\u0005\u00121EA\u0017\u0003cAa!a\u0006\u001a\u0001\u0004\u0019\bbBA\u00133\u0001\u0007\u0011qE\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u0004w\u0005%\u0012bAA\u0016E\ta1\u000b^8sC\u001e,G*\u001a<fY\"1\u0011qF\rA\u0002\u0001\u000bq!\\3n'&TX\r\u0003\u0004\u00024e\u0001\r\u0001Q\u0001\tI&\u001c8nU5{K\u0006Y!/Z7pm\u0016\u0014En\\2l)\rq\u0016\u0011\b\u0005\u0007\u0003/Q\u0002\u0019A:\u0002\u0019I,W.Y5oS:<W*Z7\u0002\u00151\f7\u000f^*fK:l5/\u0001\u0004cY>\u001c7n]\u0001\rG\u0006\u001c\u0007.\u001a3CY>\u001c7n]\u000b\u0003\u0003\u000b\u0002R!a\u0012\u0002JMl!!!\u0001\n\t\u0005-\u0013\u0011\u0001\u0002\u0004'\u0016$\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0003\u0003BA*\u0003CrA!!\u0016\u0002^A\u0019\u0011qK\u0017\u000e\u0005\u0005e#bAA.q\u00051AH]8pizJ1!a\u0018.\u0003\u0019\u0001&/\u001a3fM&!\u00111MA3\u0005\u0019\u0019FO]5oO*\u0019\u0011qL\u0017\u0002\u000b\rdW-\u0019:")
public class BlockManagerInfo
implements Logging {
    private final BlockManagerId blockManagerId;
    private final long timeMs;
    private final long maxOnHeapMem;
    private final long maxOffHeapMem;
    private final RpcEndpointRef slaveEndpoint;
    private final long maxMem;
    private long _lastSeenMs;
    private long _remainingMem;
    private final HashMap<BlockId, BlockStatus> _blocks;
    private final HashSet<BlockId> _cachedBlocks;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public BlockManagerId blockManagerId() {
        return this.blockManagerId;
    }

    public long maxOnHeapMem() {
        return this.maxOnHeapMem;
    }

    public long maxOffHeapMem() {
        return this.maxOffHeapMem;
    }

    public RpcEndpointRef slaveEndpoint() {
        return this.slaveEndpoint;
    }

    public long maxMem() {
        return this.maxMem;
    }

    private long _lastSeenMs() {
        return this._lastSeenMs;
    }

    private void _lastSeenMs_$eq(long x$1) {
        this._lastSeenMs = x$1;
    }

    private long _remainingMem() {
        return this._remainingMem;
    }

    private void _remainingMem_$eq(long x$1) {
        this._remainingMem = x$1;
    }

    private HashMap<BlockId, BlockStatus> _blocks() {
        return this._blocks;
    }

    private HashSet<BlockId> _cachedBlocks() {
        return this._cachedBlocks;
    }

    public Option<BlockStatus> getStatus(BlockId blockId) {
        return Option$.MODULE$.apply((Object)this._blocks().get(blockId));
    }

    public void updateLastSeenMs() {
        this._lastSeenMs_$eq(System.currentTimeMillis());
    }

    public void updateBlockInfo(BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        block11: {
            StorageLevel originalLevel;
            LongRef originalDiskSize;
            LongRef originalMemSize;
            boolean blockExists;
            block10: {
                this.updateLastSeenMs();
                blockExists = this._blocks().containsKey(blockId);
                originalMemSize = LongRef.create((long)0L);
                originalDiskSize = LongRef.create((long)0L);
                originalLevel = StorageLevel$.MODULE$.NONE();
                if (blockExists) {
                    BlockStatus blockStatus = this._blocks().get(blockId);
                    originalLevel = blockStatus.storageLevel();
                    originalMemSize.elem = blockStatus.memSize();
                    originalDiskSize.elem = blockStatus.diskSize();
                    if (originalLevel.useMemory()) {
                        this._remainingMem_$eq(this._remainingMem() + originalMemSize.elem);
                    }
                }
                if (!storageLevel.isValid()) break block10;
                BlockStatus blockStatus = null;
                if (storageLevel.useMemory()) {
                    blockStatus = new BlockStatus(storageLevel, memSize, 0L);
                    this._blocks().put(blockId, blockStatus);
                    this._remainingMem_$eq(this._remainingMem() - memSize);
                    if (blockExists) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Updated ").append(blockId).append(" in memory on ").append(this.blockManagerId().hostPort()).append(" (current size: ").append(Utils$.MODULE$.bytesToString(memSize)).append(",").append(" original size: ").append(Utils$.MODULE$.bytesToString(originalMemSize$1.elem)).append(",").append(" free: ").append(Utils$.MODULE$.bytesToString(this._remainingMem())).append(")").toString());
                    } else {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Added ").append(blockId).append(" in memory on ").append(this.blockManagerId().hostPort()).append(" (size: ").append(Utils$.MODULE$.bytesToString(memSize)).append(",").append(" free: ").append(Utils$.MODULE$.bytesToString(this._remainingMem())).append(")").toString());
                    }
                }
                if (storageLevel.useDisk()) {
                    blockStatus = new BlockStatus(storageLevel, 0L, diskSize);
                    this._blocks().put(blockId, blockStatus);
                    if (blockExists) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Updated ").append(blockId).append(" on disk on ").append(this.blockManagerId().hostPort()).append(" (current size: ").append(Utils$.MODULE$.bytesToString(diskSize)).append(",").append(" original size: ").append(Utils$.MODULE$.bytesToString(originalDiskSize$1.elem)).append(")").toString());
                    } else {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Added ").append(blockId).append(" on disk on ").append(this.blockManagerId().hostPort()).append(" (size: ").append(Utils$.MODULE$.bytesToString(diskSize)).append(")").toString());
                    }
                }
                if (blockId.isBroadcast() || !blockStatus.isCached()) break block11;
                this._cachedBlocks().$plus$eq((Object)blockId);
                break block11;
            }
            if (!blockExists) break block11;
            this._blocks().remove(blockId);
            this._cachedBlocks().$minus$eq((Object)blockId);
            if (originalLevel.useMemory()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Removed ").append(blockId).append(" on ").append(this.blockManagerId().hostPort()).append(" in memory").append(" (size: ").append(Utils$.MODULE$.bytesToString(originalMemSize$1.elem)).append(",").append(" free: ").append(Utils$.MODULE$.bytesToString(this._remainingMem())).append(")").toString());
            }
            if (originalLevel.useDisk()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Removed ").append(blockId).append(" on ").append(this.blockManagerId().hostPort()).append(" on disk").append(" (size: ").append(Utils$.MODULE$.bytesToString(originalDiskSize$1.elem)).append(")").toString());
            }
        }
    }

    public void removeBlock(BlockId blockId) {
        Object object;
        if (this._blocks().containsKey(blockId)) {
            this._remainingMem_$eq(this._remainingMem() + this._blocks().get(blockId).memSize());
            object = this._blocks().remove(blockId);
        } else {
            object = BoxedUnit.UNIT;
        }
        this._cachedBlocks().$minus$eq((Object)blockId);
    }

    public long remainingMem() {
        return this._remainingMem();
    }

    public long lastSeenMs() {
        return this._lastSeenMs();
    }

    public HashMap<BlockId, BlockStatus> blocks() {
        return this._blocks();
    }

    public Set<BlockId> cachedBlocks() {
        return this._cachedBlocks();
    }

    public String toString() {
        return new StringBuilder(18).append("BlockManagerInfo ").append(this.timeMs).append(" ").append(this._remainingMem()).toString();
    }

    public void clear() {
        this._blocks().clear();
    }

    public BlockManagerInfo(BlockManagerId blockManagerId, long timeMs, long maxOnHeapMem, long maxOffHeapMem, RpcEndpointRef slaveEndpoint) {
        this.blockManagerId = blockManagerId;
        this.timeMs = timeMs;
        this.maxOnHeapMem = maxOnHeapMem;
        this.maxOffHeapMem = maxOffHeapMem;
        this.slaveEndpoint = slaveEndpoint;
        Logging.$init$(this);
        this.maxMem = maxOnHeapMem + maxOffHeapMem;
        this._lastSeenMs = timeMs;
        this._remainingMem = this.maxMem();
        this._blocks = new HashMap();
        this._cachedBlocks = new HashSet();
    }
}

