/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1;

import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.BadParameterException;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.status.api.v1.TaskSorting;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.ui.SparkUI;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005]e!B\u0004\t\u0001!!\u0002\"B\u0010\u0001\t\u0003\t\u0003\"B\u0012\u0001\t\u0003!\u0003\"\u0002*\u0001\t\u0003\u0019\u0006\"\u0002:\u0001\t\u0003\u0019\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003{\u0001A\u0011AA \u00059\u0019F/Y4fgJ+7o\\;sG\u0016T!!\u0003\u0006\u0002\u0005Y\f$BA\u0006\r\u0003\r\t\u0007/\u001b\u0006\u0003\u001b9\taa\u001d;biV\u001c(BA\b\u0011\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039ui\u0011\u0001C\u0005\u0003=!\u0011qBQ1tK\u0006\u0003\bOU3t_V\u00148-Z\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!\u0005\u0005\u0002\u001d\u0001\u0005I1\u000f^1hK2K7\u000f\u001e\u000b\u0003KQ\u00022A\n\u00182\u001d\t9CF\u0004\u0002)W5\t\u0011F\u0003\u0002+A\u00051AH]8pizJ\u0011\u0001G\u0005\u0003[]\tq\u0001]1dW\u0006<W-\u0003\u00020a\t\u00191+Z9\u000b\u00055:\u0002C\u0001\u000f3\u0013\t\u0019\u0004BA\u0005Ti\u0006<W\rR1uC\")QG\u0001a\u0001m\u0005A1\u000f^1ukN,7\u000fE\u00028yyj\u0011\u0001\u000f\u0006\u0003si\nA!\u001e;jY*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u0011a\u0015n\u001d;\u0011\u0005qy\u0014B\u0001!\t\u0005-\u0019F/Y4f'R\fG/^:)\tQ\u0012E*\u0014\t\u0003\u0007*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b!A]:\u000b\u0005\u001dC\u0015AA<t\u0015\u0005I\u0015!\u00026bm\u0006D\u0018BA&E\u0005)\tV/\u001a:z!\u0006\u0014\u0018-\\\u0001\u0006m\u0006dW/Z\u0011\u0002\u001b!\u0012!a\u0014\t\u0003\u0007BK!!\u0015#\u0003\u0007\u001d+E+A\u0005ti\u0006<W\rR1uCR\u0019Q\u0005\u00160\t\u000bU\u001b\u0001\u0019\u0001,\u0002\u000fM$\u0018mZ3JIB\u0011acV\u0005\u00031^\u00111!\u00138uQ\u0011!&\fT/\u0011\u0005\r[\u0016B\u0001/E\u0005%\u0001\u0016\r\u001e5QCJ\fW.I\u0001V\u0011\u0015y6\u00011\u0001a\u0003\u001d!W\r^1jYN\u0004\"AF1\n\u0005\t<\"a\u0002\"p_2,\u0017M\u001c\u0015\u0005=\u0012du\r\u0005\u0002DK&\u0011a\r\u0012\u0002\r\t\u00164\u0017-\u001e7u-\u0006dW/Z\u0011\u0002Q\u0006!AO];fQ\u0011q&\t\u00146\"\u0003}CCa\u00017M_B\u00111)\\\u0005\u0003]\u0012\u0013A\u0001U1uQ\u0006\n\u0001/\u0001\b|gR\fw-Z%eu\u0001bFmK?)\u0005\ry\u0015AD8oK\u0006#H/Z7qi\u0012\u000bG/\u0019\u000b\u0005cQ4(\u0010C\u0003V\t\u0001\u0007a\u000b\u000b\u0003u52k\u0006\"B<\u0005\u0001\u00041\u0016AD:uC\u001e,\u0017\t\u001e;f[B$\u0018\n\u001a\u0015\u0005mjc\u00150I\u0001x\u0011\u0015yF\u00011\u0001aQ\u0011QH\rT4)\ti\u0014EJ\u001b\u0015\u0005\t1de0I\u0001\u0000\u0003\u0011Z8\u000f^1hK&#'\b\t/eWu|3p\u001d;bO\u0016\fE\u000f^3naRLEM\u000f\u0011]I.j\bF\u0001\u0003P\u0003-!\u0018m]6Tk6l\u0017M]=\u0015\u0011\u0005\u001d\u0011QBA\t\u0003+\u00012\u0001HA\u0005\u0013\r\tY\u0001\u0003\u0002\u0018)\u0006\u001c8.T3ue&\u001cG)[:ue&\u0014W\u000f^5p]NDQ!V\u0003A\u0002YCS!!\u0004[\u0019vCQa^\u0003A\u0002YCS!!\u0005[\u0019fDq!a\u0006\u0006\u0001\u0004\tI\"\u0001\brk\u0006tG/\u001b7f'R\u0014\u0018N\\4\u0011\t\u0005m\u00111\u0005\b\u0005\u0003;\ty\u0002\u0005\u0002)/%\u0019\u0011\u0011E\f\u0002\rA\u0013X\rZ3g\u0013\u0011\t)#a\n\u0003\rM#(/\u001b8h\u0015\r\t\tc\u0006\u0015\u0007\u0003+\u0011E*a\u000b\"\u0005\u00055\u0012!C9vC:$\u0018\u000e\\3tQ\u0019\t)\u0002\u001a'\u00022\u0005\u0012\u00111G\u0001\u0018a9\u0002T\u0007\f\u0019/eUb\u0003GL\u001b-a9:T\u0007\f\u0019/sUBS!\u00027M\u0003o\t#!!\u000f\u0002am\u001cH/Y4f\u0013\u0012T\u0004\u0005\u00183,{>Z8\u000f^1hK\u0006#H/Z7qi&#'\b\t/eWu|C/Y:l'VlW.\u0019:zQ\t)q*\u0001\u0005uCN\\G*[:u)1\t\t%!\u0013\u0002N\u0005E\u0013qLA7!\u00111c&a\u0011\u0011\u0007q\t)%C\u0002\u0002H!\u0011\u0001\u0002V1tW\u0012\u000bG/\u0019\u0005\u0006+\u001a\u0001\rA\u0016\u0015\u0006\u0003\u0013RF*\u0018\u0005\u0006o\u001a\u0001\rA\u0016\u0015\u0006\u0003\u001bRF*\u001f\u0005\u0007\u0003'2\u0001\u0019\u0001,\u0002\r=4gm]3uQ\u0019\t\tF\u0011'\u0002X\u0005\u0012\u00111\u000b\u0015\u0007\u0003#\"G*a\u0017\"\u0005\u0005u\u0013!\u0001\u0019\t\r\u0005\u0005d\u00011\u0001W\u0003\u0019aWM\\4uQ\"2\u0011q\f\"M\u0003K\n#!!\u0019)\r\u0005}C\rTA5C\t\tY'\u0001\u00023a!9\u0011q\u000e\u0004A\u0002\u0005E\u0014AB:peR\u0014\u0015\u0010E\u0002\u001d\u0003gJ1!!\u001e\t\u0005-!\u0016m]6T_J$\u0018N\\4)\r\u00055$\tTA=C\t\ty\u0007\u000b\u0004\u0002n\u0011d\u0015QP\u0011\u0003\u0003\u007f\n!!\u0013#)\u000b\u0019aG*a!\"\u0005\u0005\u0015\u0015!L>ti\u0006<W-\u00133;Aq#7&`\u0018|gR\fw-Z!ui\u0016l\u0007\u000f^%eu\u0001bFmK?0i\u0006\u001c8\u000eT5ti\"\u0012aa\u0014\u0015\u0007\u0001\u0005-E*!%\u0011\u0007\r\u000bi)C\u0002\u0002\u0010\u0012\u0013\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0003\u0003'\u000b#!!&\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007")
public class StagesResource
implements BaseAppResource {
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public <T> T withUI(Function1<SparkUI, T> fn) {
        return (T)BaseAppResource.withUI$(this, fn);
    }

    @Override
    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$(this);
    }

    @Override
    public String appId() {
        return this.appId;
    }

    @Override
    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    @Override
    public String attemptId() {
        return this.attemptId;
    }

    @Override
    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @GET
    public Seq<StageData> stageList(@QueryParam(value="status") List<StageStatus> statuses) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$1 -> x$1.store().stageList(statuses));
    }

    @GET
    @Path(value="{stageId: \\d+}")
    public Seq<StageData> stageData(@PathParam(value="stageId") int stageId, @QueryParam(value="details") @DefaultValue(value="true") boolean details) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            Seq<StageData> ret = ui.store().stageData(stageId, details);
            if (!ret.nonEmpty()) {
                throw new NotFoundException(new StringBuilder(15).append("unknown stage: ").append(stageId).toString());
            }
            return ret;
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}")
    public StageData oneAttemptData(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @QueryParam(value="details") @DefaultValue(value="true") boolean details) {
        return (StageData)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            StageData stageData;
            try {
                stageData = ui.store().stageAttempt(stageId, stageAttemptId, details);
            }
            catch (NoSuchElementException noSuchElementException) {
                String string;
                Seq<StageData> all = ui.store().stageData(stageId, ui.store().stageData$default$2());
                if (all.nonEmpty()) {
                    Seq ids = (Seq)all.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.attemptId()), Seq$.MODULE$.canBuildFrom());
                    string = new StringBuilder(47).append("unknown attempt for stage ").append(stageId).append(".  Found attempts: [").append(ids.mkString(",")).append("]").toString();
                } else {
                    string = new StringBuilder(15).append("unknown stage: ").append(stageId).toString();
                }
                String msg = string;
                throw new NotFoundException(msg);
            }
            return stageData;
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskSummary")
    public TaskMetricDistributions taskSummary(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @DefaultValue(value="0.05,0.25,0.5,0.75,0.95") @QueryParam(value="quantiles") String quantileString) {
        return (TaskMetricDistributions)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            double[] quantiles = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])quantileString.split(","))).map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToDouble((double)StagesResource.$anonfun$taskSummary$2(s)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            return (TaskMetricDistributions)ui.store().taskSummary(stageId, stageAttemptId, quantiles).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NotFoundException(new StringBuilder(38).append("No tasks reported metrics for ").append(stageId).append(" / ").append(stageAttemptId).append(" yet.").toString());
            });
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskList")
    public Seq<TaskData> taskList(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="length") int length, @DefaultValue(value="ID") @QueryParam(value="sortBy") TaskSorting sortBy) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$3 -> x$3.store().taskList(stageId, stageAttemptId, offset, length, sortBy));
    }

    public static final /* synthetic */ double $anonfun$taskSummary$2(String s) {
        double d;
        try {
            d = new StringOps(Predef$.MODULE$.augmentString(s)).toDouble();
        }
        catch (NumberFormatException nfe) {
            throw new BadParameterException("quantiles", "double", s);
        }
        return d;
    }

    public StagesResource() {
        ApiRequestContext.$init$(this);
        BaseAppResource.$init$(this);
    }
}

