/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import org.apache.spark.ShuffleDependency;
import org.apache.spark.internal.Logging;
import org.apache.spark.shuffle.sort.PackedRecordPointer;
import org.slf4j.Logger;
import scala.Function0;

public final class SortShuffleManager$
implements Logging {
    public static SortShuffleManager$ MODULE$;
    private final int MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SortShuffleManager$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE() {
        return this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE;
    }

    public boolean canUseSerializedShuffle(ShuffleDependency<?, ?, ?> dependency) {
        boolean bl;
        int shufId = dependency.shuffleId();
        int numPartitions = dependency.partitioner().numPartitions();
        if (!dependency.serializer().supportsRelocationOfSerializedObjects()) {
            this.log().debug(new StringBuilder(102).append("Can't use serialized shuffle for shuffle ").append(shufId).append(" because the serializer, ").append(dependency.serializer().getClass().getName()).append(", does not support object relocation").toString());
            bl = false;
        } else if (dependency.mapSideCombine()) {
            this.log().debug(new StringBuilder(84).append("Can't use serialized shuffle for shuffle ").append(shufId).append(" because we need to do ").append("map-side aggregation").toString());
            bl = false;
        } else if (numPartitions > this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE()) {
            this.log().debug(new StringBuilder(78).append("Can't use serialized shuffle for shuffle ").append(shufId).append(" because it has more than ").append(this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE()).append(" partitions").toString());
            bl = false;
        } else {
            this.log().debug(new StringBuilder(39).append("Can use serialized shuffle for shuffle ").append(shufId).toString());
            bl = true;
        }
        return bl;
    }

    private SortShuffleManager$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE = PackedRecordPointer.MAXIMUM_PARTITION_ID + 1;
    }
}

